DATABASE mwc

MAIN
	DEFINE
		prod		char(4),
		coh3		char(4),
		coh4		char(4),
		coh5		char(4),
		ddk		char(3),
		tool		char(4),
		gcc		char(3),
		gsrc		char(4),
		xtre		char(4),
		mycust		INTEGER,
		myname		LIKE customer.contact,
		myphone		LIKE customer.phone_no,
		mystate		LIKE address.state,
		myproduct	LIKE cprodlst.prod_no

# select customer's by customer number, and get their phone number, state,

	DECLARE cust_curs CURSOR FOR
		SELECT	customer.cust_no, customer.contact,
			customer.phone_no, address.state
		INTO 	mycust, myname, myphone, mystate
		FROM 	customer, address
		WHERE 	address.cust_no = customer.cust_no AND
			address.state IS NOT NULL
		ORDER BY address.state


	START REPORT cust_products

# Now walk though the customer/product table and find out what they have
	FOREACH cust_curs
		DECLARE prod_curs CURSOR FOR
			SELECT cprodlst.prod_no
			INTO myproduct
			FROM cprodlst
			WHERE cprodlst.cust_no = mycust

			LET prod = ""
			LET gcc = ""
			LET gsrc = ""
			LET tool = ""
			LET ddk = ""
			LET coh3 = ""
			LET coh4 = ""
			LET coh5 = ""
			LET xtre = ""
# a product by product comparison. When a product is matched, a string is
# set to a value which will print on the report.

		FOREACH prod_curs
			IF myproduct = 60 THEN LET prod = "COH4" END IF
			IF myproduct = 61 THEN LET prod = "COH4" END IF

			IF myproduct = 62 THEN LET prod = "UPD4" END IF
			IF myproduct = 63 THEN LET prod = "UPD4" END IF

			IF myproduct = 91 THEN LET gcc = "gcc" END IF
			IF myproduct = 92 THEN LET gcc = "gcc" END IF
			IF myproduct = 68 THEN LET gcc = "gcc" END IF
			IF myproduct = 69 THEN LET gcc = "gcc" END IF

			IF myproduct = 85 THEN LET gsrc = "gsrc" END IF
			IF myproduct = 86 THEN LET gsrc = "gsrc" END IF

			IF myproduct = 89 THEN LET coh5  = "coh5" END IF
			IF myproduct = 90 THEN LET coh5  = "coh5" END IF

			IF myproduct = 87 THEN LET coh4  = "coh4" END IF
			IF myproduct = 88 THEN LET coh4  = "coh4" END IF

			IF myproduct = 83 THEN LET xtre  = "xtre" END IF
			IF myproduct = 84 THEN LET xtre  = "xtre" END IF

			IF myproduct = 72 THEN LET coh3  = "coh3" END IF
			IF myproduct = 73 THEN LET coh3  = "coh3" END IF

			IF myproduct = 70 THEN LET tool  = "tool" END IF
			IF myproduct = 71 THEN LET tool  = "tool" END IF

			IF myproduct = 66 THEN LET ddk = "ddk" END IF
			IF myproduct = 67 THEN LET ddk = "ddk" END IF

		END FOREACH


	OUTPUT TO REPORT 
		cust_products (mycust, myname, myphone, mystate, prod, ddk, tool,
				gcc, gsrc, coh3, coh4, coh5, xtre)


	END FOREACH
	FINISH REPORT cust_products


END MAIN

REPORT cust_products (mynumber, cname, cphone, cstate, cprod, cddk, ctool, cgcc, cgsrc,
			ccoh3, ccoh4, ccoh5, cxtree)

	DEFINE 	mynumber INTEGER,
		cname 	LIKE customer.contact,
		cphone	LIKE customer.phone_no,
		cstate	LIKE address.state,
		cprod	CHAR(4),
		cddk	CHAR(3),
		ctool	CHAR(4),
		cgcc	CHAR(3),
		cgsrc	CHAR(4),
		ccoh3	CHAR(4),
		ccoh4	CHAR(4),
		ccoh5	CHAR(4),
		cxtree	CHAR(4)

	OUTPUT
		LEFT MARGIN 0
		RIGHT MARGIN 79
		TOP MARGIN 2
		BOTTOM MARGIN 2
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	FORMAT
	PAGE HEADER
		PRINT	COLUMN 1,  PAGENO USING "Page ####",
			50 SPACES,"Date: ", TODAY
		PRINT	COLUMN 6, "Customer Name and Phone",
			COLUMN 55, "Products"
			SKIP 1 LINE

	ON EVERY ROW
		IF cprod IS NOT NULL THEN
			IF (cgsrc IS NOT NULL) AND (cxtree IS NOT NULL) THEN
				PRINT	COLUMN 1, cname CLIPPED,"(",mynumber USING "<<<<<<",")",
				COLUMN 49, cprod ," ",ccoh3," ",ccoh4," ",ccoh5," ",
					  cddk," ",ctool," ",cgcc," ",cgsrc," ",cxtree
				PRINT COLUMN 1, cphone CLIPPED,"(",cstate CLIPPED,")"
			
				SKIP 1 LINE
			END IF
		END IF

END REPORT
