# Informix 4GL program to update product, shippers and magazines
# tables.
# By Charles Fiterman of Mark Williams 5/17/90

DATABASE mwc

GLOBALS "globals0.4gl"

# open forms and call main menu

MAIN
	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-V,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	CALL base_menu()

	CLEAR SCREEN
END MAIN

#
# Select correct file to process
#
FUNCTION base_menu()
	MENU "BASE MENU"
	COMMAND "Prod" "Product database"
		OPEN FORM prod_form FROM "product"
		CALL prod_menu()
		CLOSE FORM prod_form
	COMMAND "Bad" "Bad media database"
		OPEN FORM bad_disk FROM "bad_disk"
		CALL bad_disk()
		CLOSE FORM bad_disk
	COMMAND "Mag" "Inquiry Source database"
		OPEN FORM mag_form FROM "mag"
		CALL mag_menu()
		CLOSE FORM mag_form
	COMMAND "Ship" "Shipper database"
		OPEN FORM ship_form FROM "shippers"
		CALL ship_menu()
		CLOSE FORM ship_form
	COMMAND "Term" "Terms database"
		OPEN FORM term_form FROM "term"
		CALL term_menu() 
		CLOSE FORM term_form
	COMMAND "Dest" "Dests database"
		OPEN FORM dest_form FROM "dest"
		CALL dest_menu() 
		CLOSE FORM dest_form
	COMMAND	"Frt" "MWC Freight charges"
		OPEN FORM freight_form FROM "freight"
		CALL freight_menu()
		CLOSE FORM freight_form
	COMMAND "Ctrys" "States and Countrys"
		OPEN FORM state_form FROM "state"
		CALL state_menu()
		CLOSE FORM state_form
	COMMAND "Rep" "List good stuff"
		CALL rep_all()

	COMMAND "Exit" "Exit Program"
		EXIT MENU
	END MENU
END FUNCTION

#
# Produce a cribsheet
#
FUNCTION rep_all()
	#
	# Report on all products
	#
	DECLARE rp_curs CURSOR FOR
	 SELECT * FROM product

	START REPORT prod_list

	FOREACH rp_curs INTO p_product.*
		OUTPUT TO REPORT prod_list (p_product.*)
	END FOREACH

	FINISH REPORT prod_list

	CLOSE rp_curs

	RUN "cp prod.lst allprod.lst"

	#
	# Make short list of products
	#
	DECLARE cp_curs CURSOR FOR
	 SELECT * FROM product
	  WHERE nolist IS NULL

	START REPORT prod_list

	FOREACH cp_curs INTO p_product.*
		OUTPUT TO REPORT prod_list (p_product.*)
	END FOREACH

	FINISH REPORT prod_list

	CLOSE cp_curs

	#
	# Report on shippers
	#
	DECLARE rs_curs CURSOR FOR SELECT * FROM shippers

	START REPORT ship_list

	FOREACH rs_curs INTO p_ship.*
		OUTPUT TO REPORT ship_list (p_ship.*)
	END FOREACH

	FINISH REPORT ship_list

	CLOSE rs_curs

	#
	# Report on terms
	#
	DECLARE rm_curs CURSOR FOR SELECT * FROM terms

	START REPORT term_list

	FOREACH rm_curs INTO p_term.*
		OUTPUT TO REPORT term_list(p_term.*)
	END FOREACH

	FINISH REPORT term_list

	CLOSE rm_curs

	#
	# Report on dests
	#
	DECLARE rd_curs CURSOR FOR SELECT * FROM dests

	START REPORT dest_list

	FOREACH rd_curs INTO p_dest.*
		OUTPUT TO REPORT dest_list(p_dest.*)
	END FOREACH

	FINISH REPORT dest_list

	CLOSE rd_curs

	#
	# Report on currently interesting magazines
	#
	DECLARE rg_curs CURSOR FOR
	 SELECT * FROM magazines
	  WHERE cur_ad = 1

	START REPORT mag_list

	FOREACH rg_curs INTO p_mag.*
		OUTPUT TO REPORT mag_list (p_mag.*)
	END FOREACH

	FINISH REPORT mag_list

	CLOSE rg_curs

	RUN "cp mag.lst curmag.lst"

	#
	# Report on all amgazines
	#
	DECLARE rx_curs CURSOR FOR
	 SELECT * FROM magazines

	START REPORT mag_list

	FOREACH rx_curs INTO p_mag.*
		OUTPUT TO REPORT mag_list (p_mag.*)
	END FOREACH

	FINISH REPORT mag_list

	CLOSE rx_curs

	RUN "multirep"
END FUNCTION

#
# Display a message and get a y or n
#
FUNCTION yn(msg)
	DEFINE msg CHAR(50)
	DEFINE ans CHAR(1)

	LABEL loop:
		PROMPT msg CLIPPED, " " FOR ans
		IF ans IS NULL THEN
			RETURN "n"
		END IF
		IF ans = "y" OR ans = "n" THEN
			RETURN ans
		END IF
	GOTO loop
END FUNCTION
