#
# Return authorization system
#
DATABASE mwc

GLOBALS "globals0.4gl"

FUNCTION auth_menu()
	OPEN FORM auth_form FROM "auth"
	DISPLAY FORM auth_form

	LET chosen = FALSE

	MENU "Authorization"
	COMMAND "Add" "Add a new return authorization."
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_auth()
			CALL yn("Do you want to enter another return auth : ")
				RETURNING answer
		END WHILE
		LET chosen = FALSE

	COMMAND "Query" "Search for an authorization"
		CALL query_auth()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify an authorization."
		IF chosen THEN
			CALL change_auth()
		ELSE
			MESSAGE "No authorization has been selected. "
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete an authorization"
		IF chosen THEN
			CALL yn("Are you sure you want to delete this <y/n> ")
				RETURNING answer
			IF answer = "y" THEN
				CALL delete_auth()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "No authorization has been selected. "
			NEXT OPTION "Query"
		END IF

	COMMAND "Report" "Report on authorization"
		CALL auth_report()

	COMMAND "Why" "Report on return reasons"
		CALL why_report()

	COMMAND "Exit" "Leave authorization menu"
		EXIT MENU
	END MENU

	CLOSE FORM auth_form

	CLEAR SCREEN
END FUNCTION

#
# Report on return reasons for 3.1.0
#
FUNCTION why_report()
	DEFINE why CHAR(64)

	LET counter = 0

	DECLARE curs CURSOR FOR
	 SELECT * FROM auth, inv_line
	  WHERE auth.invoice_no = inv_line.invoice_no AND
		inv_line.prod_no > 25

	START REPORT why_rpt

	IF p_auth.other_reason IS NULL THEN
		LET p_auth.other_reason = "."
	END IF

	FOREACH curs INTO p_auth.*, p_line.*
		CASE
		WHEN p_auth.reason = 1
			LET why = "SCSI ", p_auth.other_reason CLIPPED
		WHEN p_auth.reason = 2
			LET why = "ESDI ", p_auth.other_reason CLIPPED
		WHEN p_auth.reason = 3
			LET why = "Small Model ", p_auth.other_reason CLIPPED
		WHEN p_auth.reason = 4
			LET why = "Not Satisfied ", p_auth.other_reason CLIPPED
		OTHERWISE
			LET why = p_auth.other_reason
		END CASE

		OUTPUT TO REPORT why_rpt(why, p_auth.invoice_no)
	END FOREACH

	CLOSE curs

	FINISH REPORT why_rpt
END FUNCTION

REPORT why_rpt(why, i)
	DEFINE why CHAR(64)
	DEFINE i INTEGER

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY why, i

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 5 SPACES,
			"Return Authorization Reason Report",
			5 SPACES, TODAY
		SKIP 2 LINES

	AFTER GROUP OF i
		LET counter = counter + 1

	AFTER GROUP OF why
		PRINT counter USING "#####", 5 SPACES, why
		LET counter = 0
END REPORT

FUNCTION query_auth()
	DEFINE  exist SMALLINT,
		answer CHAR(1)

	CLEAR FORM

	CONSTRUCT query1 ON
		auth_no, invoice_no, contact, auth_date, reason, other_reason
	FROM
		auth_no, invoice_no, contact, auth_date, reason, other_reason

	LET s1 = "SELECT * FROM auth WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE au_curs CURSOR FOR s_1 

	LET exist  = FALSE
	LET chosen = FALSE
	
	FOREACH au_curs INTO p_auth.*
		LET exist = TRUE

		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = p_auth.prod_no

		DISPLAY BY NAME p_auth.*, p_product.prod_name

		IF p_auth.invoice_no <> 0 THEN
			SELECT * INTO p_invoice.* FROM invoice
			 WHERE invoice_no = p_auth.invoice_no

			SELECT * INTO s_address.* FROM address
			 WHERE	cust_no = p_invoice.cust_no AND
				add_type <> "b"

			DISPLAY BY NAME	p_invoice.invoice_no,
					p_invoice.invoice_date,
					p_invoice.ship_date,
					s_address.line1,
					s_address.line2

			DECLARE z_curs CURSOR FOR
			 SELECT * FROM inv_line
			  WHERE invoice_no = p_auth.invoice_no

			LET s1 = NULL
			FOREACH z_curs INTO p_line.*
				IF s1 IS NULL THEN
					LET s1 = p_line.quantity USING "<<<",
						 " of ",
						 p_line.prod_no USING "<<<"
				ELSE
					LET s1 = s1 CLIPPED, ", ", 
						 p_line.quantity USING "<<<",
						 " of ",
						 p_line.prod_no USING "<<<"
				END IF
			END FOREACH

			MESSAGE s1

			CLOSE z_curs
		END IF

		CALL yn("Enter 'y' to select this authorization ") 
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH
	
	CLOSE au_curs

	IF exist = FALSE THEN
		MESSAGE "No authorization found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more authorizations"
		END IF
	END IF
END FUNCTION

FUNCTION change_auth()
	INPUT BY NAME p_auth.return_date THRU p_auth.prod_no
	 WITHOUT DEFAULTS
	AFTER FIELD prod_no
		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = p_auth.prod_no

		IF status = NOTFOUND THEN
			NEXT FIELD prod_no
		END IF

		DISPLAY BY NAME p_product.prod_name
	END INPUT

	UPDATE auth SET auth.* = p_auth.* WHERE p_auth.auth_no = auth.auth_no
END FUNCTION

FUNCTION delete_auth()
	DELETE FROM auth WHERE auth.auth_no = p_auth.auth_no
END FUNCTION

FUNCTION auth_report()
	CLEAR FORM

	CONSTRUCT query1 ON
		auth_no, auth_date, return_date, reason, other_reason
	FROM
		auth_no, auth_date, return_date, reason, other_reason

	LET s1 = "SELECT * FROM auth WHERE ", query1 CLIPPED

	PREPARE s_2 FROM s1

	DECLARE aur_curs CURSOR FOR s_2

	MESSAGE ""

	START REPORT auth_list

	FOREACH aur_curs INTO p_auth.*
		OUTPUT TO REPORT auth_list(p_auth.*)
	END FOREACH

	CLOSE aur_curs

	FINISH REPORT auth_list
END FUNCTION

REPORT auth_list (p_auth)
	DEFINE p_auth RECORD LIKE auth.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_auth.auth_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 15 SPACES,
			"Return Authorization List",
			15 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"auth no   invoice     reason  contact"
		SKIP 2 LINES
	
	 ON EVERY ROW
	 	PRINT	p_auth.auth_no USING "#####", 6 SPACES,
			p_auth.invoice_no USING "######", 5 SPACES,
			p_auth.reason USING "##", 6 SPACES,
			p_auth.contact
END REPORT

FUNCTION enter_auth()
	CLEAR FORM

	CONSTRUCT query1 ON
		contact, invoice_no, invoice_date, ship_date,
		line1, line2
	FROM
		contact, invoice_no, invoice_date, ship_date,
		line1, line2

	CALL crunchcon(query1) RETURNING query1

	LET s1 = "SELECT * FROM customer, invoice, address ",
		 "WHERE customer.cust_no = address.cust_no AND ",
		 "customer.cust_no = invoice.cust_no AND ",
		 "address.add_type <> \"b\" AND ",
		 query1 CLIPPED

	PREPARE s_3 FROM s1

	DECLARE t_curs CURSOR FOR s_3

	LET chosen = FALSE

	FOREACH t_curs INTO p_cust.*, p_invoice.*, s_address.*
		DISPLAY BY NAME	p_cust.contact,
				p_invoice.invoice_no,
				p_invoice.invoice_date,
				p_invoice.ship_date,
				p_cust.phone_no,
				s_address.line1,
				s_address.line2

		CALL yn("Enter 'y' To select this invoice: ")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	IF chosen = TRUE THEN
		LET p_auth.invoice_no = p_invoice.invoice_no
		LET p_auth.contact = p_cust.contact
	ELSE
		CALL yn("No Invoice found. Proceed <y/n> ")
			RETURNING answer
		IF answer <> "y" THEN
			RETURN
		END IF

		LET p_auth.invoice_no = 0	# for no link		
		INPUT BY NAME p_auth.contact
	END IF

	INPUT BY NAME 	p_auth.auth_date, p_auth.return_date,
			p_auth.reason, p_auth.other_reason, p_auth.prod_no
	AFTER FIELD prod_no
		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = p_auth.prod_no

		IF status = NOTFOUND THEN
			NEXT FIELD prod_no
		END IF

		DISPLAY BY NAME p_product.prod_name
	END INPUT

	LET p_auth.auth_no = 0
	INSERT INTO auth VALUES (p_auth.*)

	LET p_auth.auth_no = SQLCA.SQLERRD[2]

	DISPLAY BY NAME p_auth.auth_no

	MESSAGE "Row added"
END FUNCTION
