
/* Randy's Coherent DD developer skeleton, modified by Harry. C. Pulley, IV
 * for hmon and Coherent 4.2
 * Driver Name : mz , Mz
 * filename    : mz.c
 * purpose     : Character Special Device Driver - revision 2
 *             : Major device number 29
 *             :  It will return the single status byte of the
 *	       :  joystick port at 0x201 when read.
 *             :  0 free memory
 *             :  1 total memory
 *             :   (see proc.h for more on 1, 2 and 3)	
 *             :
 * Device      : memquery
 * Copyright   :
 */

/*
 * include files 
 * the header file can include macro's and structs needed inside
 * the Driver, as well as the iocntl.h for the driver that
 * will give a number to each iotcl function and define
 * the data type for passing/receiving parameters.
 */

#include <sys/types.h>
#include <sys/coherent.h>
#include <sys/con.h>
#include <sys/devices.h>
#include <sys/sched.h>
#include <sys/seg.h>
#include <sys/stat.h>
#include <sys/uproc.h>
#include <sys/mmu.h>
#include <sys/mzioctl.h>
#include <sys/io.h>
#include <sys/proc.h>
#include <errno.h>

/*
 * Driver function declarations
 */
static void	mzload();
static void	mzunload();
static void	mzopen();
static void	mzclose();
static void	mzread();
static void	mzwrite();
static int	mzioctl();
static void	mzwatch();
static void	mzblock();
static void	donone();

/*
 * Forward references
 */
/* static void	mzreset();
static int	mzdequeue();
static void	mzstart(); */
static void	mzintr();
/* static void	mzdefer();
static int	mzerror();
static void	mzrecov();
static void	mzdone();
*/
/*
 * Driver Configuration CON struct.
 */
CON
mzcon = {
        DFCHR,                    /* Flags        */
        MZ_MAJOR,                 /* Major Index  */
        mzopen,                   /* Open         */
        mzclose,                  /* Close        */
        donone,                     /* Not Blocking */
        mzread,                   /* Read         */
        donone,                     /* Write        */
        mzioctl,                  /* Ioctl        */
        donone,                     /* Power fail   */
        donone,                     /* Timeout      */
        donone,                     /* Load         */
        donone,                     /* Unload       */
        donone                      /* No Polling   */
};

/*
 * Interrupt Entry Points.
 
void (*mzintf[4])() = {
        mz0intr,
        mz1intr,
        mz2intr,
        mz3intr
};
*/
/*
 * Patchable parameters
 */


/*
 * Register addresses.
 * Registers are Read, Write, Status, Control.
 */


/*
 * Control struct
 */


/* void
 * mzopen( dev, mode )
 * dev_t dev;
 * int mode;
 *
 */
void
mzopen(dev)
dev_t dev;
{
return;
}

/* void
 * mzclose(dev)
 * dev_t dev;
 *
 */
void
mzclose(dev)
dev_t dev;
{
return;
}

/* void
 * mzblock(bp)
 * BUF	*bp;
 * (or nonedev)
 */

/* nonedev */

/* void
 * mzread(dev,iop)
 * dev_t dev;
 * IO * iop;
 */
void
mzread(dev, iop)
dev_t dev;
register IO * iop;
{
int a;
a = 0;

/* maybe this write isn't needed ?? rw */
outb( 0x201, (char)0 );

/* read the port */
a = inb( 0x201 );

/* copy the value to user's location */
ioputc( a, iop );

return;
}

/* void
 * mzwrite(dev,iop)
 * dev_t dev;
 * IO * iop;
 */
void
mzwrite(dev, iop)
dev_t dev;
register IO * iop;
{
return;
}

/* int
 * mzioctl(dev,com,arg)
 * dev_t dev;
 * int com;
 * attr_t * arg;
 */
static int
mzioctl(dev, com, arg)
dev_t dev;
int com;
register  mzattr_t * arg;
{
PROC *myproc, *start;
int i;

/* printf( "mz command: %d\n", com ); */
switch( com )
	{
	case 0: 
		*arg = sysmem.pfree-sysmem.tfree;
		break;
	case 1:
		*arg = sysmem.efree-sysmem.tfree;
		break;
	}	
return( 0 );
}

/* nulldev (Powerfail)
 */

/* void
 * mzwatch()
 */
void
mzwatch()
{
return;
}

/* void
 * mzload(dev)
 * dev_t dev;
 */
void
mzload()
{
return;
}

/*void
 * mzuload(dev)
 * dev_t dev;
 */
void
mzuload()
{
return;
}

void 
donone()
{
return;
}

/* void
 * mzpoll(dev,ev,msec)
 * dev_t dev;
 * int ev;
 * int msec;
 */
static void
mzpoll(dev, ev, msec)
dev_t dev;
int ev;
int msec;
{
return;
}

/* support routines
 *
 */


/**** end of mz.c device driver source code file ****/


