#include <curses.h>
#include <stdlib.h>
#include <poll.h>
#include <sys/types.h>
#include <kernel/const.h>
#include <sys/coh_ps.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#ifdef MZ
#include <sys/mzioctl.h>
#endif

#define PS_DEV "/dev/ps"

#ifdef MZ
#define MZ_DEV "/dev/memquery"
#endif

#define MAX_PROC 128

#define TUNE 5

stMonitor process_table[2][MAX_PROC];

struct lookup
{
	char str[9];
	int label;
};

struct lookup *users, *ttys;

int sleept=1000;

main(argc,argv)
int argc;
char **argv;
{
	int ps_fd, size_read, num_proc[2], current_proc, inputch, count,
		usecs, ssecs, current_page=0, watched_proc_no,
		current_table=0, current_ticks[2], current_input, num_users,
		num_ttys, mz_fd, num_r, num_z, num_l, num_w, num_s;

#ifdef MZ
	mzattr_t zmz, tmz;
#else
	long zmz, tmz;
#endif

	float user, sys, load, load1=0.0, load5=0.0, load20=0.0, mempct;

	unsigned watched_proc;

	WINDOW *mystdscr;

	FILE *infile;

	struct pollfd keypoll[1];

	char inputline[128], *tmpptr;

	infile=fopen("/etc/passwd","r");

	if (infile==NULL)
	{
		fputs("Cannot open /etc/passwd for reading.\n",stderr);

		exit(1);
	}

	count=0;

	while (fgets(inputline,128,infile))
		count++;

	num_users=count;

	users=(struct lookup *)malloc(num_users*sizeof(struct lookup));

	if (users==NULL)
	{
		fputs("Malloc error on users table.\n",stderr);

		exit(1);
	}

	rewind(infile);

	for (current_input=0;current_input<num_users;current_input++)
	{
		fgets(inputline,128,infile);

		tmpptr=strrchr(inputline,'\n');

		if (tmpptr)
			*tmpptr=0;

		tmpptr=strrchr(inputline,'\r');

		if (tmpptr)
			*tmpptr=0;

		sscanf(inputline,"%[^:]%*c%*[^:]%*c%d",users[current_input].str,&(users[current_input].label));
	}

	fclose(infile);

	infile=fopen("/etc/ttys","r");

	if (infile==NULL)
	{
		fputs("Cannot open /etc/ttys for reading.\n",stderr);

		exit(1);
	}

	count=0;

	while (fgets(inputline,128,infile))
		count++;

	num_ttys=count;

	ttys=(struct lookup *)malloc(num_ttys*sizeof(struct lookup));

	if (ttys==NULL)
	{
		fputs("Malloc error on ttys table.\n",stderr);

		exit(1);
	}

	rewind(infile);

	for (current_input=0;current_input<num_ttys;current_input++)
	{
		struct stat ttystat;

		fgets(inputline,128,infile);

		tmpptr=strrchr(inputline,'\n');

		if (tmpptr)
			*tmpptr=0;

		tmpptr=strrchr(inputline,'\r');

		if (tmpptr)
			*tmpptr=0;

		strcpy(ttys[current_input].str,inputline+3);

		strcpy(inputline,"/dev/");
		strcat(inputline,ttys[current_input].str);

		if (stat(inputline,&ttystat)==-1)
			ttys[current_input].label=0;
		else
			ttys[current_input].label=ttystat.st_rdev;
	}

	fclose(infile);

	current_ticks[0]=0;
	current_ticks[1]=0;

	num_proc[0]=0;
	num_proc[1]=0;
	
	keypoll[0].fd=0;

	keypoll[0].events=POLLIN;

	watched_proc=getpid();

	if (argc>1)
	{
		for (count=1;count<argc;count++)
		{
			if (!strcmp(argv[count],"-t"))
				sscanf(argv[++count],"%d",&sleept);
			else
				fprintf(stderr,"Unrecognized option: %s\n",argv[count]);
		}
	}
			
        mystdscr=initscr();

        if (mystdscr==NULL)
        {
                fputs("Error in initscr.\n",stderr);

                exit(1);
        }

        noecho();

        raw();

        nonl();

        keypad(mystdscr,TRUE);

        refresh();

	while (inputch!='q'&&inputch!='Q')
	{
		erase();

#ifdef MZ
		mz_fd=open(MZ_DEV,O_RDONLY);

		if (mz_fd>=0)
		{
			ioctl(mz_fd,0,&zmz);
			ioctl(mz_fd,1,&tmz);

			mempct=100.0*((float)(zmz<<12))/((float)(tmz<<12));

			close(mz_fd);
		}
		else
#endif
		{
			zmz=tmz=0L;

			mempct=0.0;
		}

		ps_fd=open(PS_DEV,O_RDONLY);

		if (ps_fd<0)
		{
			fprintf(stderr,"Unable to open ps device: %s for reading - exiting\n",PS_DEV);

       			nocbreak();

       			echo();

       			nl();

       			refresh();

       			endwin();
	
			exit(1);
		}

		current_ticks[current_table]=times(NULL);

		size_read=read(ps_fd,process_table[current_table],MAX_PROC*sizeof(stMonitor));

		close(ps_fd);
	
		if (size_read==(MAX_PROC*sizeof(stMonitor)))
		{
			fprintf(stderr,"More than %d processes; recompile with higher MAX_PROC - exiting\n",MAX_PROC);

		        nocbreak();

        		echo();

        		nl();

        		refresh();

        		endwin();
	
			exit(2);
		}
	
		num_proc[current_table]=size_read/sizeof(stMonitor);
	
		mvaddstr(3,0,"PID   PPID  Username Ksize User  Sys   %User %Sys  Flag tty     S Command");
	
		user=sys=0.0;

		num_s=num_z=num_w=num_l=num_r=0;

		for (current_proc=0+(current_page*(LINES-4));current_proc<num_proc[current_table];current_proc++)
		{
			int proc;

			float puser, psys;

			char statechar, userstr[9]="?", ttystr[9]="?";

			for (proc=0;proc<num_proc[(current_table)?0:1];proc++)
			{
				if (process_table[current_table][current_proc].p_pid==process_table[(current_table)?0:1][proc].p_pid)
				{
					puser=100.0*((float)(process_table[current_table][current_proc].p_utime-process_table[(current_table)?0:1][proc].p_utime))/(current_ticks[current_table]-current_ticks[(current_table)?0:1]);

					user+=puser;

					psys=100.0*((float)(process_table[current_table][current_proc].p_stime-process_table[(current_table)?0:1][proc].p_stime))/(current_ticks[current_table]-current_ticks[(current_table)?0:1]);

					sys+=psys;

					break;
				}
			}

			if (proc>=num_proc[(current_table)?0:1])
			{
				puser=100.0*((float)process_table[(current_table)?0:1][proc].p_utime)/(current_ticks[current_table]-current_ticks[(current_table)?0:1]);

				user+=puser;

				psys=100.0*((float)process_table[(current_table)?0:1][proc].p_stime)/(current_ticks[current_table]-current_ticks[(current_table)?0:1]);

				sys+=psys;
			}

			switch(process_table[current_table][current_proc].p_state)
			{
			case 1:	statechar='L';
				num_l++;
				break;
			case 2:	statechar='R';
				num_r++;
				break;
			case 3: statechar='Z';
				num_z++;
				break;
			case 4: if (!strcmp(process_table[current_table][current_proc].u_sleep,"wait"))
				{
					statechar='W';
					num_w++;
				}
				else
				{
					statechar='S';
					num_s++;
				}
				break;
			default:statechar=process_table[current_table][current_proc].p_state+'0';
				break;
			}

			if ((current_proc-(current_page*(LINES-4)))>=(LINES-4))
				continue;

			usecs=process_table[current_table][current_proc].p_utime/HZ;
			ssecs=process_table[current_table][current_proc].p_stime/HZ;

			if (process_table[current_table][current_proc].p_pid==watched_proc)
			{
				attron(A_REVERSE);

				watched_proc_no=current_proc;
			}

			for (current_input=0;current_input<num_users;current_input++)
			{
				if (users[current_input].label==process_table[current_table][current_proc].p_uid)
				{
					strcpy(userstr,users[current_input].str);
					break;
				}
			}

			if (process_table[current_table][current_proc].p_ttdev==0)
				strcpy(ttystr,"-------");
			else if (process_table[current_table][current_proc].p_ttdev==65535)
				strcpy(ttystr,"null");
			else
			{
				for (current_input=0;current_input<num_ttys;current_input++)
				{
					if (ttys[current_input].label==process_table[current_table][current_proc].p_ttdev)
					{
						strcpy(ttystr,ttys[current_input].str);
						break;
					}
				}
			}

			mvprintw(current_proc-(current_page*(LINES-4))+4,0,"%5u %5u %-8.8s %5d %02u:%02u %02u:%02u %5.2f %5.2f %4o %-7.7s %c %-9.9s\n",
				process_table[current_table][current_proc].p_pid,
				process_table[current_table][current_proc].p_ppid,
				userstr,
				process_table[current_table][current_proc].rsize,
				usecs/60,usecs%60,
				ssecs/60,ssecs%60,
				puser,psys,
				process_table[current_table][current_proc].p_flags,
				ttystr,
				statechar,
				process_table[current_table][current_proc].u_comm); 
			if (process_table[current_table][current_proc].p_pid==watched_proc)
				attroff(A_REVERSE);
		}

		if (current_ticks[0]>0&&current_ticks[1]>0&&(current_ticks[current_table]-current_ticks[(current_table)?0:1]-(sleept/10)-TUNE)>0)
			load=((float)(current_ticks[current_table]-current_ticks[(current_table)?0:1]-(sleept/10)-TUNE))/10.0+1.0;
		else
			load=(user+sys)/100.0;

		load1=(load1*(6000.0-(sleept/10))+load*(sleept/10))/6000.0;
		load5=(load5*(30000.0-(sleept/10))+load*(sleept/10))/30000.0;
		load20=(load20*(120000.0-(sleept/10))+load*(sleept/10))/120000.0;

		mvprintw(0,0,"Idle:%5.2f%% User:%5.2f%% Sys:%5.2f%% Load: %5.2f Load Avg. 1:%.2f 5:%.2f 20:%.2f",100.0-(user+sys),user,sys,load,load1,load5,load20);

		mvprintw(1,0,"Last PID: %d Total Mem: %ldK Free Mem: %ldK (%5.2f%%)",process_table[current_table][0].p_pid,tmz<<2,zmz<<2,mempct);

		mvprintw(2,0,"#total: %d #running: %d #zombies: %d #locked: %d #waiting: %d #sleeping: %d",num_proc[current_table],num_r,num_z,num_l,num_w,num_s);

		move(watched_proc_no+1,0);

		refresh();

		poll(keypoll,1,sleept);

		if (keypoll[0].revents&POLLIN)
		{
			inputch=getch();

			switch(inputch)
			{
			case '1':
			case '2':
			case '3':
			case '9':	kill(process_table[current_table][watched_proc_no].p_pid,inputch-'0');

					watched_proc=getpid();

					break;
			case 'j':
			case 'J':
			case KEY_DOWN:	if (watched_proc_no+1<num_proc[current_table])
						watched_proc=process_table[current_table][watched_proc_no+1].p_pid;
	
					break;
			case 'k':
			case 'K':
			case KEY_UP:	if (watched_proc_no-1>=0)
						watched_proc=process_table[current_table][watched_proc_no-1].p_pid;
	
					break;
			case KEY_NPAGE:	current_page++;

					break;
			case KEY_PPAGE: if (current_page)
						current_page--;

					break;
			}
		}

		current_table=(current_table)?0:1;
	}

        nocbreak();

        echo();

        nl();

	endwin();
}
