/* RWDOCS */
/* filename	: nedl.c
 * purpose	: data link level support for NE2000/NE1000 Ethernet card
 * 		  under COHERENT 4.x.
 *
 * 		: I have tried to keep the usage of this
 *		  of ne similar to the dos based ec device
 *                driver used in this gendre of KA9Q derived
 *		  networking packages. -RLW
 *
 * author	: Randy Wright
 * Copyright	  ((C)) 1994 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#define	TIMER	10	/* Timeout on transmissions */

#include <stdio.h>
#include <poll.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/neioctl.h>
#include "global.h"
#include "mbuf.h"
#include "enet.h"
#include "iface.h"
#include "nedl.h"
#include "timer.h"
#include "arp.h"
#include "trace.h"


struct ne ne[NE_MAX];		/* Per-controller info */
unsigned nec = 0;		/* number of boards we're using */
static int getneaddr();
extern void dump(), free();
extern int memok(), atoi(), htoi(), makepiston();


#ifdef GCC
/* 
prototype moved to arp.h
extern 
int 
arp_init(unsigned int hwtype,int hwalen, 
	int iptype, int arptype, char * bdcst, int (*format)(), int (*scan)() );
/ * unsigned int hwtype;	/ * ARP Hardware type * /
int hwalen;		/ * Hardware address length * /
int  iptype;		/ * Subnet's protocol ID for IP * /
int arptype;		/ * Subnet's protocol ID for ARP  * /
char * bdcst;		/ * Subnet's broadcast address (if any) * /
int (*format)();	/ * Function to format hardware addresses * /
int (*scan)();		/ * Function to scan addresses in ascii 
*/	
#endif /* GCC */

int ebuffer();
/* Initialize interface. basically we just
 * set up the iface structs. The device driver inits the hardware.
 * contains printf for error reports, sprintf to write name to
 * iface struct.
 * Returns -1 on error, 0 on success.
 */
int
ne_init(interface,bufsize)
struct interface *interface;
unsigned bufsize;	/* Maximum size of receive queue in PACKETS */
{

/* RWDOCE */
	register struct ne *nep;
	register unsigned base;
	int32 dev;
	char ne_name[80];

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	dev = interface->dev;
	nep = &ne[dev];
	base = nep->base; /* not used */
	nep->rcvmax = bufsize;
	nep->iface = interface;

	sprintf(ne_name, "/dev/%s", interface->name );
	if( (nep->fd = open( ne_name, O_RDWR )) < 0 )
		{
		printf( "can't open %s\n", ne_name );
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return -1;
		}

	if(interface->hwaddr == NULLCHAR)
		interface->hwaddr = malloc(EADDR_LEN);

	getneaddr(nep->fd,interface->hwaddr);

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}


/* RWDOCS */
/* Send raw packet (caller provides header)
 * There is no scatter/gather facility on the ne device driver
 * so mbufs are consolodated into a single packet before
 * write to dev. In addition, size of packet is validated
 * and padded if too short for ethernet. Returns -1 on error
 * such as packet too big, bad malloc or write. Returns 0
 * on success. Contains perror and printf.
 *
 */
int
ne_raw(interface,bp)
struct interface *interface;	/* Pointer to interface control block */
struct mbuf *bp;		/* Data field */
{

/* RWDOCE */
	register struct ne *nep; /* our private data */
	int size, 		 /* the length of data in our mbuf */
	eblen;			 /* the length we are writing to ethernet */
	int n, 			 /* number */
	len; 			 /* catbuf's length */
	char * catbuff;		 /* buffer that holds consolodated data */


#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	catbuff = NULL;

	nep = &ne[interface->dev];

	nep->estats.xmit++;
	dump(interface,IF_TRACE_OUT,TRACE_ETHER,bp);

	eblen = size = (int)len_mbuf(bp);

	/* Pad the size out to the minimum, if necessary,
	 * with junk from the last packet (nice security hole here)
	 */
	if(size < (RUNT + 4) )
		size = RUNT + 4;
	size = ((size + 1) & ~1);	/* round size up to next even number */


	nep->size = size;
	if( (catbuff = malloc( size )) == NULL )
		{
		printf( "ne_raw:can't allocate %d bytes\n", size );
		free_p(bp);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return( -1);
		}

	if( (len = ebuffer( catbuff, bp, (int) eblen )) < 0 )
		{
		free_p(bp);
		free( catbuff );
		printf( "ebuf len %d too big\n", len ); fflush(stdout);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return(-1);
		}

	if( len < (RUNT + 4) ) len = (RUNT + 4);


	if( (n = write( nep->fd, catbuff, (len ) )) < (len ) )
		{
		free_p(bp);
		free( catbuff );
		printf( "-bad write to ne:len:%d\n",len ); fflush(stdout);
		perror( "ne_raw: " );
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return(-1);
		}
	free( catbuff );
	free_p(bp);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}

/* RWDOCS */
/* ebuffer validates the data in mbuf chain bp and consolodates the data
 * into the buffer s to maximum data size of l. mbuf.c function
 * dqdata() is used for move.
 */
int
ebuffer( s, bp, l )
char *s;
struct mbuf *bp;
int l;
{

/* RWDOCE */
	unsigned len;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		/* get the length and ensure that it is valid */
	if( l > 1536 ) {
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return( - 1 );
	}
		/* get it into a monolithic buffer */
	len = dqdata(bp,s,l);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return( len );
}

/* RWDOCS */
/* Process any incoming Ethernet packets on the receive queue 
 * This is called from th motor loop. We do a non-blocking poll
 * for input to verify. If there is input, we get it. The hardware
 * and device driver can buffer up to about 40 kb of data on
 * the receive side. Since data can arrive at over 500 kb/sec,
 * we don't want to waste much time processing it.
 *
 * The read call obtains the next packet, not simply a portion of
 * it. We need to read with a buffer size of 1536 bytes.
 *
 * Then we send it over to eproc() which is defined in enet.c. eproc
 * requires an * ifp and * mbuf. So, we need to allocate mbuf
 * for the arriving data. eproc() will demulitplex the data
 * for ip or arp as the case may be.
 *
 * Contains printf, fprintf, dump
 */
void
ne_recv(interface)
struct interface *interface;
{

/* RWDOCE */
	void arp_input();
	int ip_route();
	struct ne *nep;
	struct mbuf *bp;
	int dev, n;
	int tot;
	char rbuf[1536];

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	nep = &ne[interface->dev];
	dev = interface->dev;

		/* validate fd */
	if( nep->fd < 0) {
		printf("ne_recv: bad file descriptor passed for device %d\n",
			dev);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return;
		}
	tot = 0;

	n = read(nep->fd, &rbuf[0], 1536);
		/* check the read */
	if (n == -1)  {
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return;
	} else	{
		/* get our data into an mbuf */
		if( (bp = qdata(&rbuf[0],n) ) == NULLBUF ) {
			fprintf( stderr,
			 "can't allocate mbufs for incoming packets\n");
			fflush( stderr );
			return;
		}
				/* keep up with the stats */
		nep->rcvcnt++;
			/* amount to return */
		tot = (unsigned int) n;
		}

	dump(interface,IF_TRACE_IN,TRACE_ETHER,bp);

	eproc(interface,bp);

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return;
}

/* RWDOCS */
/* get the hardware stats from the device driver.
 * we transfer the stats into a local format. Uses
 * device driver's ioctl.
 */
int
gethwstats( interface )
struct interface * interface;
{

/* RWDOCE */
	struct ne *nep;
	int dev, fd, ioctl();
	struct nestats ns;

	nep = &ne[interface->dev];
	dev = interface->dev;
	fd = nep->fd;  		/* our fd */

		/* constant from neioctl.h */
	ioctl( fd, NEIOCGSTATS, &ns );
	
			/* transfer the stats to local format */
	ne->estats.recv = ns.nestat_ipackets;
	ne->estats.bad = ns.nestat_idiscards;
	ne->estats.over = ns.nestat_idiscards;
	ne->estats.drop = ns.nestat_idiscards;

	ne->estats.xmit = ns.nestat_opackets;
	ne->estats.timeout = ns.nestat_oerrors;
	ne->estats.jam = ns.nestat_collisions;

	return(0);
}

/* RWDOCS */
/* Read Ethernet address from device driver 
 * the device driver gets the address at boot up time
 * and saves a copy. We format it and display it.
 * ne_init also gets and saves a local copy. However,
 * this routine gets a private copy directly from the
 * device driver.
 * printf()s directly to user screen. Uses device driver ioctl
 */
static
int
getneaddr(fd,cp)
register fd;
register char *cp;
{

/* RWDOCE */
	int i, ioctl();
	struct arpcom myac;

		/* constant and arpcom struct from neioctl.h */
	ioctl( fd, NEIOCGFLAGS, &myac );
	printf( "[" );

	for(i = 0; i < 6; i++ )
		{
		printf( "%02x", (myac.ac_enaddr[i] & 0xff) );
			 cp[i] = (myac.ac_enaddr[i] & 0xff );
		if( i < 5 ) printf( ":" );
		}
	printf( "]\n" );

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return(0);
}

/* RWDOCS */
/* Close the Ethernet interface, */
int
ne_stop(interface)
struct interface *interface;
{
/* RWDOCE */
	struct ne *nep;

	nep = &ne[interface->dev];
	close( nep->fd );
	nep->fd = - 1;
	return 0;
}

/* RWDOCS */
/*
 * The usage for this function is about the same as the usage
 * of the ec ethernet controller used in KA9Q. There are unused
 * items in the call, however, the user who has to wade through
 * all the various attach syntaxes ought to get even the
 * the smallest break in learning curve - IMHO. RLW.
 *
 * Attach a NEx000 Ethernet controller to the system.
 * argv[0]: hardware type, must be "ne"
 * argv[1]: I/O address, e.g., "0x300" not used.
 * argv[2]: vector, e.g., "3" , not used.
 * argv[3]: mode, must be "arpa"
 * argv[4]: interface label, e.g., "ne0" device file name.
 * argv[5]: maximum number of packets allowed on receive queue, e.g., "5"
 * argv[6]: maximum transmission unit, bytes, e.g., "1500"
 * 
 * printf()s to screen attach banner and error messages. strcpy()s
 * name to iface. Uses strncmp().
 *
 */


int
ne_attach(argc,argv)
int argc;
char *argv[];
{

/* RWDOCE */
	register struct interface *if_ne;
	extern struct interface *ifaces;
	unsigned dev;

	int ne_init();
	int ne_raw();
	int enet_send();
	int enet_output();
	void ne_recv();
	int ne_stop();
	int pether(),gaether(), strncmp();
	argc=argc;
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	printf( "ne_attach: /dev/%s ", argv[4] );

	arp_init(ARP_ETHER,EADDR_LEN,IP_TYPE,ARP_TYPE,ether_bdcst,pether,gaether);

	if(nec >= NE_MAX){
		printf("Too many Ethernet controllers\n");
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return -1;
	}

	dev = nec++;

	if((if_ne = (struct interface *)calloc(1,sizeof(struct interface))) == NULLIF
	 ||(if_ne->name = malloc((unsigned)strlen(argv[4])+1)) == NULLCHAR){
		printf("ne_attach: no memory!\n");
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return -1;
	}

	strcpy(if_ne->name,argv[4]);
	if_ne->mtu = atoi(argv[6]);
	if_ne->send = enet_send;
	if_ne->output = enet_output;
	if_ne->raw = ne_raw;
	if_ne->recv = ne_recv;
	if_ne->stop = ne_stop;
	if_ne->dev = dev;


	ne[dev].base = htoi(argv[1]);
	ne[dev].vec = htoi(argv[2]);

	if(strncmp(argv[3],"arpa", 4) != 0){
		printf("Mode %s unknown for interface %s\n",
			argv[3],argv[4]);
		free(if_ne->name);
		free((char *)if_ne);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return -1;
	}

	/* Initialize device */
	if(ne_init(if_ne,(unsigned)atoi(argv[5])) != 0){
		free(if_ne->name);
		free((char *)if_ne);
		printf( "init failed\n" );
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return -1;
	}


	if_ne->next = ifaces;
	ifaces = if_ne;

		/* put it on the list of polls for the motor */
	if( (makepiston( ne->fd, ne_recv , NULLFP, NULLFP, if_ne, POLLIN )) == -1)
		{
		printf( "error: cannot put %s on poll list\n",argv[4] );
		return(-1);
		}
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}

/* end of ne.c */
