
                             Installing cohulip


This chapter describes how to install ccoohhuulliipp onto your system.

Installation of ccoohhuulliipp is a three-step process;

11. Decide how you are going to  tie your system into a network -- either by
   modem or by Ethernet, and gather some preliminary information.

22. Unttaarr the  ccoohhuulliipp archive, and  run the installation  script to install
   ccoohhuulliipp onto your system.

33. Modify  some configuration  files by  hand, depending  upon the  type of
   network with which ccoohhuulliipp will be communicating.

None of  these steps is particularly difficult; but  each requires that you
pay attention  to detail.  We  urge you to read  the following descriptions
carefully _b_e_f_o_r_e you begin to install ccoohhuulliipp; if you do not, you may waste
time wrestling with a problem that has already been solved.

                    PPhhaassee OOnnee -- PPrreelliimmiinnaarryy IInnffoorrmmaattiioonn

Before you  begin installation, you need to make  some decisions and gather
some information.

IInnssttaallll HHaarrddwwaarree aanndd DDrriivveerr

If you are  going to use Ethernet, install your  Ethernet card, and add the
nnee device  driver to your COHERENT kernel.   Follow the directions included
with your card and the driver.

If you are  using SLIP, install your modem and  configure your serial port.
For information how  to do this, see the documentation  that came with your
port; and check the entries for aassyy and mmooddeemm in the COHERENT Lexicon.

CChhoooossee TTyyppee ooff NNeettwwoorrkk

First, you  must decide what type of ccoohhuulliipp  will be communicating.  There
are three possibilities:

11. With an Internet provider via modem and SLIP.

22. With a local Ethernet network that has access to the Internet.

33. With  a local  mini-Ethernet network  that does not  have access  to the
   Internet.

The rest  of this chapter  assumes that you  will be working  with only one
type of  network.  It is  possible to configure  ccoohhuulliipp to work  with more
than  one type  of network  simultaneously;  this is  described in  a later
chapter.

OObbttaaiinn aann IIPP AAddddrreessss

An IP address  is a 32-bit number that uniquely  identifies a given machine
(or ``host'') that  is running the suite of TCP/IP  protocols.  As noted in
earlier  in the  chapter on  TCP/IP  basics, sites  send datagrams  to each
other's  ``IP address.''  Thus, before  your machine  can participate  in a
TCP/IP network, it must have its IP number.

If you are using ccoohhuulliipp to  hook your machine into an established Ethernet
network,  you must  talk with  the person who  administers the  network and
obtain an IP number from her.

If you are creating a stand-alone mini-network, you can make up a pseudo-IP
number.  The  only requirements are (1) that the  number does not duplicate
the IP  number on any other  machine on your mini-network;  and (2) that it
does not end in `0' or ``255''.  (These addresses have a special meaning to
TCP/IP, and  selecting one of them for your  pseudo-address will create all
manner of problems.)

If you will be interfacing ccoohhuulliipp  an Internet provider via SLIP, you must
obtain  the IP  number from  your provider.   Internet providers  assign IP
numbers in either  of two ways: either they assign  your system a permanent
IP number, or they assign you  a different IP number every time you log in.
How the number is assigned affects  how you configure and use ccoohhuulliipp; this
is discussed in  more detail below.  Note that if  your provider offers you
the choice of  a permanent address and a floating  address, _a_l_w_a_y_s take the
permanent address.

OObbttaaiinn tthhee DDoommaaiinn-NNaammee SSeerrvveerr IIPP AAddddrreessss

Before  TCP/IP can  send a  datagram to  a remote site,  it must  know that
site's IP  address.  People, however,  usually prefer to  remember sites by
their names; therefore,  one of TCP's major tasks is  to find the IP number
that is  linked to  a given site's  name.  There are  two ways to  do this:
either  by   reading  the  contents  of   file  $NNEETTHHOOMMEE/hhoossttss.nneett,  or  by
interrogating a domain-name server.

A _d_o_m_a_i_n-_n_a_m_e _s_e_r_v_e_r  is a host that has a  large data base of IP addresses
and names, and that you have permission to interrogate.  If you cannot find
the address of the domain-name server, you will be limited to accessing the
systems whose names and IP addresses are listed in file hhoossttss.nneett.

If you  are hooking  into an established  Ethernet network, ask  the system
administrator  for  the  IP address  of  the  domain-name  server for  that
network.  If  you are  accessing the Internet  via SLIP, ask  your Internet
provider for that address.

If you are using a local mini-network, you cannot use a domain-name server.
You must  find the IP address  of every other system  on your mini-network,
and write  it into  file hhoossttss.nneett.  The format of  this file  is discussed
below.  Even  if you have domain-name  service, you may wish  to write into
this file  the addresses of  systems that you contact  frequently, to spare
ccoohhuulliipp the trouble of interrogating the domain-name server.

OObbttaaiinn AAnnootthheerr CCoommppuutteerr

If you are going to run ccoohhuulliipp over a local mini-network, you need another
machine  to talk  to, if  only  to see  that your  installation is  working
correctly.  You may  be able to borrow such a  system -- these machines are
very common now.  If you are at work, you may be able to plug into a TCP/IP
network there.

GGeett tthhee DDiiaalliinngg SSeeqquueennccee

If you are going to access an Internet provider via SLIP, you must find how
to dial into your provider's modem.   You must obtain from the provider the
telephone number to  call; the baud rate, parity, etc.,  for the modem; and
your login  identifier and  password.  Also note  the port into  which your
modem is  plugged, and the command sequence with  which you must initialize
the modem.

You must  also obtain the  exact wording of  each prompt that  ccoohhuulliipp will
encounter as it dials the provider, and what the proper response should be.
The best  way to obtain this  information is to use  the command cckkeerrmmiitt to
dial the  remote provider by hand.  At every  step (initializing the modem,
entering your  login identifier, entering your password,  etc.), write on a
piece of paper what you will send down the serial line, and what you see in
response.  It is important that you write _e_x_a_c_t_l_y what you see and what you
enter.  You  will use  this information to  write a ``dialing  script'' for
ccoohhuulliipp.

                       PPhhaassee TTwwoo -- IInnssttaalllliinngg ccoohhuulliipp

Installing ccoohhuulliipp  requires that you de-archive  the ccoohhuulliipp package, then
run an installation script.

DDee-aarrcchhiivviinngg tthhee FFiilleess

ccoohhuulliipp comes in the form of a compress ttaarr archive.  Move the archive into
a  directory  where  you  store  sources,  e.g., /uussrr/ssrrcc;  then  type  the
following command:

     gtar -xvzf cohulip.tgz

De-archiving the  files should take less than a  minute, depending upon the
speed of your hard disk.

Dearchiving the  files does not affect the  archive ccoohhuullpp.ttggzz itself.  You
may  wish  to  keep this  archive  intact  as  a  backup copy,  should  you
accidentally damage or destroy some ccoohhuulliipp files.

CCoonntteennttss ooff tthhee ccoohhuulliipp PPaacckkaaggee

When  you un-ttaarr  the archive  ccoohhuulliipp.ttggzz, its  contents are  written into
directory  ccoohhuulliipp. This directory  contains the  following sub-directories
and files:

IInnssttaallll.sshh
     This file holds a shell script that automates installation.

ccoohhuulliipp/RREEAADDMMEE
     This file  gives a general  description of ccoohhuulliipp and  how to install
     it.

bbiinn  This  sub-directory holds  the executable  program  nneett, which  is the
     executable program that actually performs networking tasks.

ddoocc  This directory  holds this manual,  both in viewable  and in printable
     (PostScript) version.  It also holds the original K5JB documentation.

hheellpp.ttaarr
     This archive holds help files read by nneett. These files are de-archived
     when you install ccoohhuulliipp onto your system.

nneett.ttaarr
     This  holds   example  configuration  files  that   are  used  by  the
     application nneett. These files are  described in a later chapter of this
     manual.

ssrrcc  This gives the sources for the application nneett.

IInnvvookkiinngg tthhee IInnssttaallllaattiioonn SSccrriipptt

To install ccoohhuulliipp, log in as  the superuser rroooott; then enter the directory
ccoohhuulliipp and invoke the script  IInnssttaallll.sshh. This script performs the task of
installation.

IInnssttaallll.sshh begins its work with the following message:

                              WELCOME TO COHULIP

     This script installs the COHERENT user-level IP package (cohulip) onto your
     system.

     We strongly suggest that you read the document ./doc/install.p *before* you
     attempt to install cohulip onto your system.  If you wish to stop installation
     and review this chapter, answer 'n' to the following question.

     Do you wish to continue installation? [y]


Because you are reading this chapter you, you probably should answer `y' to
this question.  IInnssttaallll.sshh continues with this message:

     We assume that you have read the chapter on cohulip installation, and are
     continuing installation.  Please note that you can interrupt this program
     at any time without damaging your system in any way.  To interrupt
     installation, just type <ctrl-C>.  You may have to type it more than once.
     To resume installation, su to root and execute script Install.sh again.


GGeett HHoommee DDiirreeccttoorryy ffoorr ccoohhuulliipp

After the introductory messages, the first  item of business is to name the
directory into which you want ccoohhuulliipp installed:

     The first step in installation is to select a home directory for cohulip.
     By default, cohulip is installed into directory $NETHOME.  To accept this
     default, simply press <return>.

     Home directory for cohulip: [/usr/net]


To accept  the default  directory /uussrr/nneett,  simply press <rreettuurrnn>.  If you
want to install into another  directory, type it at the prompt.  IInnssttaallll.sshh
then asks you to confirm your choice:

     Install into directory /usr/net? [y]

To accept the  default reply of `y', press <rreettuurrnn>;  if, however, you have
changed your mind or if you  see something wrong with the directory's name,
type `n' to cancel your choice.   IInnssttaallll.sshh will continue to ask you until
you answer `Y' to some directory's name.

Once you have selected a directory for ccoohhuulliipp, IInnssttaallll.sshh then copies some
files and  archives into it,  then processes the archives.   It also copies
the executable nneett into directory /uussrr/bbiinn.

GGeett LLooccaall SSyysstteemm NNaammee

The next step is to name your local system:

     The next step in installation is set your system's name.  Normally, this is
     the name set in the file /etc/uuname, although you can use another name if
     you wish.  Again, to accept the default, simply press <return>.

     Set the system name to _s_y_s_t_e_m_n_a_m_e? [y]


_s_y_s_t_e_m_n_a_m_e is the  name of your system, as set  in the file /eettcc/uuuunnaammee. If
you wish  to use another name,  reply `n' to the  above prompt.  IInnssttaallll.sshh
displays the prompt

     Enter the name of your system:

and waits  for you to type  your system's name.  The  cycle continues until
you have entered and confirmed a name for your system.

GGeett IInntteerrnneett AAddddrreessss

The next step is to enter your system's IP address:

     The next step is to enter your system's IP address.  As the manual states,
     some users are assigned an IP address when they log into their Internet
     provider's machine, and so may not know it at this time.

     Enter your IP address now ? [y]


If  you do  not yet  know your  IP address  -- or if  you are  accessing an
Internet provider that assigns your IP address only when you log in -- type
`n'.  IInnssttaallll.sshh will then skip to the next item of business.

To accept  the default  response of  `y', press <rreettuurrnn>.  When you  do so,
IInnssttaallll.sshh asks:

     Enter your IP address (e.g., 123.456.789.012):

Enter your system's IP address.  IInnssttaallll.sshh then asks you to confirm it:

     Is your IP address _a_d_d_r_e_s_s?

where _a_d_d_r_e_s_s is  the address you typed.  Enter `y'  if _a_d_d_r_e_s_s is correct;
if it is not, type `n' and IInnssttaallll.sshh will try again.

SSLLIIPP IInnffoorrmmaattiioonn

IInnssttaallll.sshh now asks you whether you intend to use SLIP:

     Use a serial port or modem for SLIP? [y]


Press  `n' if  you  are _n_o_t  going  to use  SLIP.  If  you press  <rreettuurrnn>,
IInnssttaallll.sshh assumes  that you are using  SLIP, and proceeds to  ask you some
further questions.  First, it asks you to name the serial port:

     Enter the serial port (e.g., com3fl):

Enter the port.   (This should be the local port,  i.e., the port that ends
with the letter `l'.) IInnssttaallll.sshh then asks you to confirm your entry:

     Serial port is _p_o_r_t? [y]

If you enter `n', IInnssttaallll.sshh tries again.

IInnssttaallll.sshh next asks you to enter the speed of the port:

     Enter the port's speed (e.g., 19200):

Do so.  IInnssttaallll.sshh then asks you to confirm what you typed:

     The serial port's speed is ? [y]

If you type `n' in reply, IInnssttaallll.sshh tries again.

This ends the information you must enter for SLIP.  IInnssttaallll.sshh displays the
name it assigns to the SLIP interface:

     Your SLIP interface is named sl0


EEtthheerrnneett IInnffoorrmmaattiioonn

IInnssttaallll.sshh asks you  whether you are going to use  ccoohhuulliipp with an Ethernet
connection:

     Use an NE1000 or NE2000 ethernet card? [y]


If you  are _n_o_t using  Ethernet, answer `n';  IInnssttaallll.sshh skips to  the next
section.  If you press <rreettuurrnn>,  IInnssttaallll.sshh assumes that you will be using
Ethernet and asks  you to name the device by  which ccoohhuulliipp can access your
Ethernet card:

     Enter the Ethernet card name (e.g., ne0):

Enter  the name  of  the Ethernet  device;  do not  prefix  it with  /ddeevv/.
IInnssttaallll.sshh asks you to confirm your entry:

     Your Ethernet card is named _c_a_r_d? [y]

If you enter `n', IInnssttaallll.sshh tries again.

This ends  the information you must enter  for Ethernet IInnssttaallll.sshh displays
the name it assigns to the Ethernet interface:

     Your Ethernet interface is called 'ne0'


SSeelleecctt tthhee DDeeffaauulltt RRoouuttee

If  you have  indicated that  you  will be  using both  Ethernet and  SLIP,
IInnssttaallll.sshh asks you to select which will be the default route:

     Because you wish to use cohulip with both an Ethernet network and a SLIP
     network, you must select a default route.  This is the interface over which
     packets will be sent when a route cannot be located locally.  This is normally
     the interface that connects to the nearest gateway or router.

     Enter 'sl0' for SLIP or 'ne0' for Ethernet:


As the message states, you must  select which network -- the one you access
by  Ethernet or  the one  you  access via  SLIP --  should receive  data by
default.  Enter  ``sl0'' for  SLIP, or  ``ne0 for Ethernet,  depending upon
which network you prefer.

IInnssttaallll.sshh asks you to confirm your choice:

     Use _r_o_u_t_e as default route?

where _r_o_u_t_e is SLIP or Ethernet.  If you answer `n', IInnssttaallll.sshh asks you to
try again.

When you  confirm your choice,  or if you  selected only SLIP  or Ethernet,
IInnssttaallll.sshh states your system's default route: either

     Your default route is _r_o_u_t_e


DDoommaaiinn-NNaammee SSeerrvveerr

IInnssttaallll.sshh now asks if you wish to use a domain-name server:

     As noted in the installation manual, you can enter the IP address or name
     of the domain-name server (DNS) that is available to your system.  Note that
     you should NOT enter this information if (1) you do not have it, or
     (2) your system does not have a permanently assigned IP address.

     Do you wish to enter the name or address of your domain-name server? [y]


As the message notes, you must take the following into mind when you decide
whether to enter the address of the domain-name server:

-> If you do not know the address, answer `N'.

-> If  you are  using a  local mini-network,  and do not  have access  to a
   domain-name server, answer `N'.

-> If you are using SLIP _a_n_d your Internet provider assigns your IP address
   when you log in, answer `N'.  Do so even if you know the address of your
   Internet  provider's  domain-name  server.   The  reason  for  this  are
   explained below.

-> If you  are using Ethernet  on an established  netowrk and you  know the
   address of that network's domain-name server, answer `Y'.

-> If you  are using  SLIP _a_n_d  your Internet provider  has assigned  you a
   permanent  IP  address  _a_n_d  you  know  the  address  of  your  Internet
   provider's domain-name server, answer `Y'.

If you answer `Y', IInnssttaallll.sshh asks  you to enter the name or address of the
domain-name server:

     Please enter the correct name or dotted-decimal address of your DNS:
     e.g., '192.48.234.1' or 'myserver.com'.
     Enter name or address of your DNS:

Enter either  the address of  your domain-name server, or  its name.  (Note
that if  you enter the  name, you must  put its name and  address into file
$NNEETTHHOOMMEE/hhoossttss.nneett, as described below.) IInnssttaallll.sshh asks you confirm this:

     Your DNS has name or address _i_d_e_n_t_i_f_i_e_r?

where _i_d_e_n_t_i_f_i_e_r  is the name or  address you entered.  If  you answer `n',
IInnssttaallll.sshh asks you to try again.

SSeelleecctt SSeerrvveerrss

IInnssttaallll.sshh now asks you for the servers you wish to start up by default:

     The next step will be to ask you about the servers that you wish to turn on.
     Note that if you turn on a server, cohulip provides that service to people who
     are accessing into your system.  If you do not turn on a given server, you will
     still be able to use that service on other machines.


As  the  message  states, a  _s_e_r_v_e_r  provides  service  to  people who  are
accessing your system; it does not affect what you can do on other systems.
For example, if you decide to ``turn on'' the TELNET server, users on other
systems will  be able to use  the TELNET server to  access your system.  If
you decide  not to do so,  other users will not  be able to do  so, but you
will still be able to use the TELNET client to access other systems.

Note that ``turning on'' a server does not affect how your system performs:
a ccoohhuulliipp  server does not  occupy additional memory.  This  is because all
servers are already compiled into the application nneett; so invoking a server
simply ``turns on'' one of nneett's feature.

IInnssttaallll.sshh  goes through  the following  routine for  four of  its servers.
First, it asks you wish to turn on the server:

     Turn on the server for _s_e_r_v_e_r? [y]

where _s_e_r_v_e_r is the server in question.  To accept the server, simply press
<rreettuurrnn>; IInnssttaallll.sshh displays the following to confirm your choice:

     Turning on server _s_e_r_v_e_r

If you do not want the server, answer `n'.

IInnssttaallll.sshh asks you about four servers: tteellnneett, eecchhoo, ffiinnggeerr, and ffttpp. Note
that the  eecchhoo server  services the  command ppiinngg; if  you select  no other
server, you should select this one,  so that other machines on your network
can at least tell when you are on-line.

FFiinnaall AAccttiioonnss

With those  inquiries, IInnssttaallll.sshh has finished  asking you for information.
It displays the following messages:

     We have created a file called $STARTUP based upon
     the information you have enter.  For the application 'net' to use this
     information, you must invoke it with the following syntax:

          net startup.new

     We have also set the environmental variables NETHOME and NETSPOOL within the
     system-wide profile file '/etc/profile'.  However, this will not take effect
     until you next log in.  The network software needs these variables to locate
     its files.


IInnssttaallll.sshh then gives some information about configuration files:

     The file $NETHOME/hosts.net allows you assign aliases to IP addresses.
     Some examples are included in $NETHOME/hosts.net already.  The file
     $NETHOME/domain.txt is maintained by the domain-name client application
     if you have specified a name server.
     The file $NETHOME/hosts.net allows you assign aliases to IP addresses.
     Some examples are included in $NETHOME/hosts.net already.  The file
     $NETHOME/domain.txt is maintained by the domain-name client application
     if you have specified a name server.

     File $NETHOME/ftpusers controls access to ftp services.  There are examples
     in $NETHOME/ftpusers

     If you find that $NETHOME/startup.new is suitable for your system as
     we have created it, you can change its name to startup.net; it will then
     be automatically executed each time you start net.

     This concludes the installation of cohulip.


As the message states, that message concludes the work of IInnssttaallll.sshh.

AAfftteerr tthhee DDuusstt SSeettttlleess

The following describes what IInnssttaallll.sshh has done to your system.

To  begin, IInnssttaallll.sshh  created directory  $NNEETTHHOOMMEE (default,  /uussrr/nneett). It
copied ccoohhuulliipp's configuration and help files into that directory.

Most importantly,  it built script ssttaarrttuupp.nneeww.  This script holds commands
that reflect  the information you  entered when you  installed ccoohhuulliipp onto
your system.  As you work with  ccoohhuulliipp, you will find yourself copying and
modifying this file rather frequently.  It is described in detail below.

IInnssttaallll.sshh  also created  sub-directory  ffiinnggeerr. If  you  have enabled  the
ffiinnggeerr server,  you must  write description files  for your users  and copy
them into that directory.

Finally,  IInnssttaallll.sshh  copied  the  executable  program nneett  into  directory
/uussrr/bbiinn.

ccoohhuulliipp uses two environmental variables:

NNEETTHHOOMMEE
     This variable names  the directory where nneett's configuration files are
     stored, e.g., the startup scripts, ffiinnggeerr files, and hheellpp files.

NNEETTSSPPOOOOLL
     This names the file into which  nneett writes files that it receives from
     other systems.  This is set to /uussrr/ssppooooll/uuuuccppppuubblliicc.

IInnssttaallll.sshh inserted  these variables into file  /eettcc/pprrooffiillee. Note that you
must log out and log in again before these variables are added to your run-
time environment.

nneett also uses the environmental variable TTZZ. This variable was set when you
installed COHERENT onto your computer; you do not need to worry about it.

nneett requires that its files have the following permissions:

     -r-x--x--x   1 bin      bin     $NETHOME
     -rw-rw-rw-   1 bin      bin     domain.txt
     drwxrwxrwx   2 bin      bin     finger
     -rw-r--r--   1 bin      bin     ftpusers
     -rw-r--r--   1 bin      bin     hosts.net
     -rw-r--r--   1 bin      bin     startup.new

As you can see, all files  should be owned by user and group bbiinn. Note, too
that file  $NNEETTHHOOMMEE/ddoommaaiinn.ttxxtt should be writable by  all users.  This file
is updated automatically  by the domain-name server, so it  must be open to
every user who may use ccoohhuulliipp.

If the permissions  on the ccoohhuulliipp files are not  correct, you can set them
with the following commands:

     chmog 511 bin bin /usr/bin/net
     chmog 644 bin bin $NETHOME/*
     chmog 666 bin bin $NETHOME/domain.txt


               PPhhaassee TThhrreeee -- PPoosstt-IInnssttaallllaattiioonn CCoonnffiigguurraattiioonn

In  some  instances,   you  may  have  to  perform  some  post-installation
configuration to get ccoohhuulliipp up and running.

The following  discusses first Ethernet,  then SLIP.  It  walks you through
the  post-installation configuration  you may  have  to perform  and simple
tests to see if the system is working properly.

CCoonnffiigguurriinngg ccoohhuulliipp ffoorr EEtthheerrnneett

Although Ethernet is a more  sophisticated technology than a serial line --
or perhaps  _b_e_c_a_u_s_e it is  more sophisticated --  setting up ccoohhuulliipp  on an
Ethernet connection  is much  simpler than  establishing it for  SLIP.  The
following describes  the steps  you must  perform to configure  ccoohhuulliipp for
Ethernet.     It    is     adapted    from    mail    by    Bob    Chalmers
(earth@nanguo.cstpl.com.au).

First,  copy /uussrr/nneett/ssttaarrttuupp.nneeww to  /uussrr/nneett/ssttaarrttuupp.nneett. It  should look
like the following:

     # the name of your local host:
     hostname nanguo
     # the IP address of your local host:
     ip address 203.1.96.1
     # attach a TCP session to the Ethernet device:
     attach nx 0 0 arpa ne0 5 1500


     # add the remote site's IP address to the routing
     # table for this session:
     route add 203.1.96.5 ne0


     # IP address of your network's domain-name server (DNS)
     # not present if entered no DNS address:
     domain addserver 123.456.789.012


     # these lines are boilerplate
     ip ttl 32
     tcp mss 1500
     tcp window 1500
     tcp irtt 2000
     eol unix


     # start the servers you selected; this shows them all
     start telnet
     start echo
     start finger
     start ftp

You may wish  to replace line ssttaarrtt tteellnneett with  the line ssttaarrtt tteelluunniixx 2233.
tteelluunniixx is the server that manages  logins; this command hangs it onto port
23, which  is the well-know port  for TELNET.  It is  described in the last
chapter to this manual.

If you are  using a mini-network, invoke TCP/IP on  your other machine.  (A
later section  of this manual  discusses how to  bring up TCP/IP  under MS-
DOS.)

Now, try  ccoohhuulliipp: type  nneett at  your COHERENT prompt.   You will  see some
messages, then see the prompt nneett>.

To see  if the networking is actually working,  try ppiinngging another machine
on your network.   For example, if another system on  your network is named
lleeppaannttoo, try the command:

     ping lepanto

Note that to access another machine by name, you must either have access to
a domain-name  server or  have entered  its name and  IP address  into file
hhoossttss.nneett.  (This file  is described  in another  section of  this manual.)
Otherwise,  you  must use  the  other  system's IP  address  with the  ppiinngg
command, instead of the system's name.

If the  network is  working correctly, you  will see information  from ppiinngg
that describes how long it took to send a datagram to the remote system and
receive  an acknowledgement.   Once  this happens,  you know  that you  can
contact the remote system.  The next  step is to invoke FTP and TELNET, and
start to use your network.  For  details on how to do this, see the chapter
entitled _R_u_n_n_i_n_g _n_e_t, which appears a little later in this manual.

CCoonnnneeccttiinngg ttoo tthhee IInntteerrnneett vviiaa SSLLIIPP

The following describes how to configure ccoohhuulliipp to connect to the Internet
via  an Internet  provider.  Because  of  the complexity  of this  task, it
requires  a   fair  bit  of  post-installation   configuring.   Do  not  be
discouraged if  it does not work  the first time: after  all, SLIP combines
all of the complexity of a network with that of a UUCP link.  This will try
your patience, but  stick with it because the reward  is great: full access
to the Internet and its wealth of information.

The following  instructions, which are  adapted from mail  by Randy Wright,
should help make matters easier for you.

SSttaarrttuupp SSccrriipptt

As  with  configuring  for  Ethernet,  the  first  step  is  to  move  file
$NNEETTHHOOMMEE/ssttaarrttuupp.nneeww to $NNEETTHHOOMMEE/ssttaarrttuupp.nneett.

MMooddeemm CCoonnffiigguurraattiioonn

Earlier in this chapter, we asked  you to write exactly the steps needed to
initialize your  modem and dial  into your provider's system.   We will now
use  that  information to  write  a  script with  which  nneett  can dial  the
provider's system.  If you are familiar with UUCP and its ``chat scripts,''
then writing a  dialing script will be easy for  you; if you are not, well,
you are about to learn how.

A _d_i_a_l_i_n_g  _s_c_r_i_p_t consists of an indefinite number  of pairs of send/expect
strings: nneett sends _s_e_n_d half of the pair to the serial port; and it expects
to see  the _e_x_p_e_c_t  string in  response.  If, in  response to a  given send
string,  it  receives anything  other  than given  the  expect string,  nneett
assumes that something has gone wrong and aborts networking session.

A dialing script must perform the following tasks:

11  Initialize the modem to dial out.

22  Dial the modem.

33  Send your login identifier to the remote system.

44  Send your password to the remote system.

You may also need to capture the IP address that your provider assigns you,
but that will be discussed in the following sub-section.

To initialize  the modem, the first send/expect  pair should read something
like the following:

     ATE1V1Q0S0=0\r OK

In  standard Hayes  notation, the  send string turns  on echoing,  turns on
text-based  messages, and  turns off  dial-in  support.  The  string ``\r''
tells nneett to send a carriage  return at the end of the send string; this is
needed to  flush the send  the string out  to the serial  port.  The expect
string states that you expect the  modem to reply OOKK, which is the standard
modem response.  For details on how you should initialize your modem, check
the documentation that came with it.

The next send/expect string dials the modem:

     ATDT1234567\r ogin:

The  string  AATTDDTT  is the  standard  Hayes  command  to  dial a  Touch-Tone
telephone  line.  ``1234567''  stands  for the  telephone  number to  dial.
ooggiinn: is the  _e_n_d of the string with which  your Internet provider's system
prompts you to log in.  This  prompt will, of course, change from system to
system.

The next  send/expect pair sends  your login identifier  to your provider's
system, and awaits the prompt for your password:

     mylogin\r ssword:

The  send  string _m_y_l_o_g_i_n  stands  for your  actual  login identifier.   As
always, it ends  with the string ``\r''.  The expect  string sssswwoorrdd: is the
_e_n_d of the  prompt for your password.  This prompt  will, of course, change
from system to system.

The final send/expect pair is actually just a send string:

     mypassword\r

where _m_y_p_a_s_s_w_o_r_d  is your password.  Note  that this is not  followed by an
expect string: once nneett has processed the last send or expect string in the
script, it expects to start exchanging SLIP datagrams with your provider.

Thus, the entire script reads as follows:

     ATE1V1Q0S0=0\r OK ATDT1234567\r ogin: mylogin\r ssword: mypassword\r

To make the  script available to nneett, edit file  ssttaarrttuupp.nneett and attach the
script to the  end of the command aattttaacchh. Note  that all of aattttaacchh command,
including the  dialing script, must  appear on one line  within the ssttaarrttuupp
script.  If you are using MicroEMACS to edit ssttaarrttuupp.nneett, do not be alarmed
if the aattttaacchh command extends far past the right margin of your screen.

For  more information  on how  to handle  a modem or  serial port,  see the
entries aassyy  and mmooddeemm in  the COHERENT Lexicon.   For a more  elaborate of
writing such  a script, see  the entry for  ssyyss in the Lexicon,  or see the
tutorial for  UUCP that is  in the front  portion of your  COHERENT manual.
For  a detailed  description of  the  nneett command  aattttaacchh, see  the chapter
_R_u_n_n_i_n_g _n_e_t, which appears later in this manual.

SSeettttiinngg YYoouurr IIPP AAddddrreessss:  PPeerrmmaanneenntt AAddddrreessss

As we  noted at the beginning  of this chapter, your  Internet provider can
give you an IP address in either of two ways:

-> A ``permanent'' IP address, one that is assigned to you alone.

-> A ``floating'' IP address, which is assigned only when you dial in.

If you  have a permanent  IP address, you  gave that address  to IInnssttaallll.sshh
when  you installed  ccoohhuulliipp  onto that  system; and  IInnssttaallll.sshh, in  turn,
copied  it into  ssttaarrttuupp.nneett  in a  form  of the  command  iipp aaddddrreessss.  For
example, if your Internet provider  has assigned your local host IP address
123.456.789, then command

     ip address 123.456.789

should already  be embedded within ssttaarrttuupp.nneett. There  is nothing more that
you need to do.

SSeettttiinngg YYoouurr IIPP AAddddrreessss:  FFllooaattiinngg AAddddrreessss

If,  however, your  Internet provider uses  ``floating'' IP  addresses, the
situation becomes much more complex.

When  an Internet  provider assigns  an IP  number, she  flashes it  on the
screen as the last item of text to be shown before entering SLIP mode.  You
must somehow ``capture'' that address, so that you can type it into nneett. To
do so, you  must add one final ``expect'' string  to the end of the dialing
script that  you added to  the command aattttaacchh,  one that describes  how the
provider displays the IP address.  This forces nneett to display that address,
so you can jot it down and then type it into nneett. (Alas, there is as yet no
automated way to capture this address.)

Unfortunately, there  is no  standard by  which the provider  displays this
information:  it  varies  from  provider  to  provider.  For  example,  one
provider ends her login messages with something like this:

     Your IP address 123.456.789 .....

To ``capture'' this address, add the string

     ...

to the end of your dialing  script.  This tells nneett to expect a string that
ends with ``...'', and to display  it.  When you see this, you can jot down
the IP address.

Remember that  the ``expect''  string must unique  identify the _e_n_d  of the
string that holds the IP address.  You may need to be creative to find such
a string.

Once you  have captured  the IP  address being assigned,  when you  see the
prompt nneett> you must type the command:

     iipp aaddddrreessss _i_p__a_d_d_r_e_s_s

where _i_p__a_d_d_r_e_s_s  is the IP address  that you jotted down.   This tells nneett
the address that has been assigned to you.

DDoommaaiinn-NNaammee SSeerrvveerr AAddddrreessss

Your  Internet provider  normally  will have  a  name server  that you  can
access.  This is needed so you can convert names of hosts into IP addresses
(as  described in  the  previous chapter).   You should  have obtained  the
address of this server as part of your preparation for installing ccoohhuulliipp.

When  you  installed ccoohhuulliipp,  the  program IInnssttaallll.sshh  asked  you for  the
address of your domain-name server.  At  that time, we said that you should
enter the address _o_n_l_y if your  Internet provider had given you a permanent
IP address.  The reason is as  follows: When you address of the domain-name
server, nneett  initializes the domain-name  software with the  IP address for
your system that is current at the present moment.  If you have not yet set
your  IP address,  the  domain-name software  will be  improperly set,  and
domain-name service will not work correctly.

If you have a permanent IP  address, you entered the address of the domain-
name  server when  you installed ccoohhuulliipp.  The program  IInnssttaallll.sshh embedded
this information in file ssttaarrttuupp.nneett in the form of the command

     ddoommaaiinn aaddddsseerrvveerr _i_p__a_d_d_r_e_s_s

where _i_p__a_d_d_r_e_s_s  is the address of your  domain-name server.  This problem
is solved, and you can move on to the next sub-section.

If, however, you use a floating IP address, you must type the command

     ddoommaaiinn aaddddsseerrvveerr _i_p__a_d_d_r_e_s_s

at the  nneett> prompt to set  the IP address of your  name server.  Note that
you must type  this command _a_f_t_e_r you have typed  the command iipp aaddddrreessss to
set your system's IP address, for the reason described above.

If you do  not have access to any name  server, you can still use SLIP, but
you cannot use the Internet's domain-name services.  Thus, you will be able
to access by name only those  sites that are described in files hhoosstt.nneett or
ddoommaaiinn.ttxxtt. These files are described in detail in the next chapter.

AAnn EExxaammppllee LLooggiinn SSeessssiioonn

At this  point, you have  finished your post-installation  configuration of
ccoohhuulliipp, and you are ready to try it out.  The following example, which was
supplied by Robert Chalmers, walks through one such test session.

To begin,  when you use  nneett to dial  into a remote system,  it displays on
your screen your dialing script as it is executed.

To begin, this example uses the following version of ssttaarrttuupp.nneett:

     hostname nanguo
     ip address [203.1.96.1]
     attach asy 0 /dev/asy01l slip sl0 0 1500 9600 AT&F\r \
          OK AT&Q6DT1234567\r ogin: MYLOGIN\r ord: PASSWORD\r
     route add default sl0
     domain addserver [192.160.127.125]
     ip ttl 32
     tcp mss 1500
     tcp window 1500
     tcp irtt 2000
     eol unix
     start telunix 23
     start echo
     start finger
     start ftp

Note that the aattttaacchh command must  appear on one line.  It is broken across
two lines in the above display to make it legible.

As  you can  see, this  user  has a  permanent IP  address; so  this script
automatically sets the IP addresses of  both his local host and the domain-
name server.

When you invoke the command nneett, it logs its actions as follows:

     startup: [/usr/net/startnet.net]
     asy_init: tty name = /dev/asy01l

This shows that nneett is  executing the start-up script ssttaarrttuupp.nneett, and that
it is initializing device aassyy0011ll, as named in the aattttaacchh command.

The next  lines walk through the  dialing script that is  appended onto the
aattttaacchh command.  The first sequence initializes the modem:

     I'm sending  : 'AT&F\r'
     I'm expecting: 'OK'
     AT&F
     OK

The next  lines dial the modem,  and invoke the login  prompt on the remote
system:

     I'm sending  : 'AT&Q6DT1234567\r'
     I'm expecting: 'ogin:'
     AT&Q6DT1234567
     login:

In the above sequence, ``1234567'' stands for the telephone number.

The next lines log you into the system:

     I'm sending : 'MYLOGIN\r'
     I'm expecting: 'ord:'
     MYLOGIN
     Password:
     I'm sending  : 'MYPASSWORD\r'

In   the  above,   ``MYLOGIN''   represents  the   login  identifier,   and
``MYPASSWORD'' represents the password.

At this  point, you  are logged  into the remote  system, and has  begun to
exchange SLIP datagrams with the remote system.

If the  user had had a  floating IP address, his  dialing script would have
had one  more string attached to  it: a string that matched  the end of the
string with  which the  provider displayed his  IP address.  He  would have
jotted it  down; and when he  saw the nneett> prompt, he  would have typed the
commands

     iipp aaddddrreessss _i_p__a_d_d_r_e_s_s
     ddoommaaiinn aaddddsseerrvveerr _i_p__a_d_d_r_e_s_s

in that order.

Perhaps the lesson here is: if you can get a permanent IP address, _g_r_a_b _i_t!

WWrriittiinngg aa SSccrriipptt ttoo IInnvvookkee nneett

If you are using ccoohhuulliipp to access one or more Internet providers via SLIP,
you  may wish  to wrap  the  command nneett  within a  shell script.   This is
because the command  nneett is very limited in how  it can manipulate a serial
port: it can dial out, but it cannot enable or disable a port, or even hang
up the telephone after the nneett  session has concluded.  You can handle such
details in a script.

The following  gives an example of  a shell script called  NNeett. This script
dials two different Internet providers, one called MMCCSS and the other called
SSIISS. Each  has its own startup script  -- called, respectively, ssttaarrttuupp.mmccss
and ssttaarrttuupp.ssiiss.

     #!/bin/sh
     RMODEM=com3fr
     LMODEM=com3fl


     case $1 in
          mcs) TARGET=mcs;;
          sis) TARGET=sis;;
          *)   echo "Usage: Net mcs|sis";
               exit 1;;
     esac


     # disable the port
     echo Disabling port $RMODEM
     /etc/disable $RMODEM


     # invoke "net" for the target network
     net startup.$TARGET


     # reset the modem and port after a "net" session:
     echo Resetting the modem


     # get the modem's attention
     echo "+++" > /dev/$LMODEM
     sleep 2
     echo "+++" > /dev/$LMODEM
     sleep 2


     # hang up the phone
     echo "ath" > /dev/$LMODEM
     sleep 2


     # reload the standard modem settings
     echo "atz" > /dev/$LMODEM
     sleep 2


     # bump modem into high-speed mode; needed with 14.4 modems under COHERENT
     echo "at" > /dev/$LMODEM
     sleep 2


     # re-enable the port
     echo Re-enabling port $RMODEM
     /etc/enable $RMODEM


     # end of Net

Note that you  must have permission to use the  commands eennaabbllee and ddiissaabbllee
before  you  can run  this  script successfully.   For  details, see  their
entries in the Lexicon.

Please note that  with some modems, simply echoing a  string to the modem's
device does  not work.  The following  version of NNeett, which  is taken from
the COHERENT script /eettcc/mmooddeemmiinniitt, should work correctly with such modems:

     #!/bin/sh
     RMODEM=com3fr
     LMODEM=com3fl


     case $1 in
          mcs) TARGET=mcs;;
          sis) TARGET=sis;;
          *)   echo "Usage: Net mcs|sis";
               exit 1;;
     esac


     # disable the port
     echo Disabling port $RMODEM
     /etc/disable $RMODEM


     # invoke "net" for the target network
     net startup.$TARGET


     # reset the modem and port after a "net" session:
     echo Resetting the modem


     # get the modem's attention
     {
       sleep 2
       cat >&1 <<

     +++
       !
     } <$LMODEM


     # hang up the phone
     {
       sleep 3
       cat >&1 <<

     ATH0
       !
     } <$LMODEM


     # reload the standard modem settings
     { stty 9600
       sleep 2
       cat >&1 <<

     ATZ
       !
     } <$LMODEM


     # re-enable the port
     echo Re-enabling port $RMODEM
     /etc/enable $RMODEM


     # end of Net


                            WWhheerree TToo GGoo FFrroomm HHeerree

The next chapter in  this manual describes ccoohhuulliipp's configuration files in
some detail.

The chapter  after that, _R_u_n_n_i_n_g  _n_e_t, summarizes all of  the commands that
the  program  nneett recognizes.   You  may  wish to  use  this  chapter as  a
reference while you run ccoohhuulliipp.

Finally,  the last  chapter  in this  manual,  _A_d_v_a_n_c_e_d _c_o_h_u_l_i_p,  discusses
advanced  topics.   It discusses  elaborate  configuration,  such as  using
ccoohhuulliipp as a firewall between  two networks; and gives extended examples of
FTP session and debugging TCP datagrams.


























