
;;;;;;;;;;;;;;;;;;;
;
;
;  Save and restore
;
;
;;;;;;;;;;;;;;;;;;;

(if nil
    (eval-and-compile (setq byte-compile-warnings nil)))

(defun save-game (filename)
  (if (not (setq filename (car filename)))
      (mprincl "You must supply a filename for the save.")
    (if (file-exists-p filename)
	(delete-file filename))
    (setq numsaves (1+ numsaves))
    (make-save-buffer)
    (save-val "current-room")
    (save-val "computer")
    (save-val "door1")
    (save-val "combination")
    (save-val "visited")
    (save-val "diggables")
    (save-val "key-level")
    (save-val "floppy")
    (save-val "numsaves")
    (save-val "numcmds")
    (save-val "logged-in")
    (save-val "dungeon-mode")
    (save-val "jar")
    (save-val "lastdir")
    (save-val "black")
    (save-val "nomail")
    (save-val "unix-verbs")
    (save-val "hole")
    (save-val "uncompressed")
    (save-val "ethernet")
    (save-val "sauna-level")
    (save-val "room-objects")
    (save-val "room-silents")
    (save-val "inventory")
    (save-val "endgame-question")
    (save-val "endgame")
    (save-val "endgame-questions")
    (save-val "cdroom")
    (save-val "cdpath")
    (save-val "correct-answer")
    (save-val "inbus")
    (if (compile-save-out filename)
	(mprincl "Error saving to file.")
      (do-logfile 'save nil)
      (switch-to-buffer "*dungeon*")
      (princ "")
      (mprincl "Done."))))

(defun make-save-buffer ()
  (switch-to-buffer (get-buffer-create "*save-dungeon*"))
  (erase-buffer))

(defun compile-save-out (filename)
  (let (ferror)
    (setq ferror nil)
    (condition-case nil
	(dun-rot13)
      (error (setq ferror t)))
    (if (not ferror)
	(progn
	  (goto-char (point-min))))
    (condition-case nil
        (write-region 1 (point-max) filename nil 1)
        (error (setq ferror t)))
    (kill-buffer (current-buffer))
    ferror))
    

(defun save-val (varname)
  (let (value)
    (setq varname (intern varname))
    (setq value (eval varname))
    (minsert "(setq ")
    (minsert varname)
    (minsert " ")
    (if (or (listp value)
	    (symbolp value))
	(minsert "'"))
    (if (stringp value)
	(minsert "\""))
    (minsert value)
    (if (stringp value)
	(minsert "\""))
    (minsertl ")")))


(defun restore (args)
  (let (file)
    (if (not (setq file (car args)))
	(mprincl "You must supply a filename.")
      (if (not (load-d file))
	  (mprincl "Could not load restore file.")
	(mprincl "Done.")
	(setq room 0)))))


(defun do-logfile (type how)
  (let (ferror newscore)
    (setq ferror nil)
    (switch-to-buffer (get-buffer-create "*score*"))
    (erase-buffer)
    (condition-case nil
	(insert-file-contents log-file)
      (error (setq ferror t)))
    (unless ferror
	    (goto-char (point-max))
	    (minsert (current-time-string))
	    (minsert " ")
	    (minsert (user-login-name))
	    (minsert " ")
	    (if (eq type 'save)
		(minsert "saved ")
	      (if (= (endgame-score) 110)
		  (minsert "won ")
		(if (not how)
		    (minsert "quit ")
		  (minsert "killed by ")
		  (minsert how)
		  (minsert " "))))
	    (minsert "at ")
	    (minsert (cadr (nth (abs room) rooms)))
	    (minsert ". score: ")
	    (if (> (endgame-score) 0)
		(minsert (setq newscore (+ 90 (endgame-score))))
	      (minsert (setq newscore (reg-score))))
	    (minsert " saves: ")
	    (minsert numsaves)
	    (minsert " commands: ")
	    (minsert numcmds)
	    (minsert "\n")
	    (write-region 1 (point-max) log-file nil 1))
    (kill-buffer (current-buffer))))
