


LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



NAME
     lesskey - specify key bindings for less

SYNOPSIS
     lesskey [-o output] [input]
     lesskey -V

DESCRIPTION
     _L_e_s_s_k_e_y is used to specify a set of key bindings to be  used
     by  _l_e_s_s.  The input file is a text file which describes the
     key bindings, If the input file is "-",  standard  input  is
     read.   If  no  input  file  is specified, $HOME/.lesskey is
     read.  The output file is a binary file  which  is  used  by
     _l_e_s_s.  If  no output file is specified, $HOME/.less is writ-
     ten.  If  the  output  file  already  exists,  _l_e_s_s_k_e_y  will
     overwrite it.

     The input file consists of lines of the form:

          _s_t_r_i_n_g <whitespace> _a_c_t_i_o_n [extra-string] <newline>

     Whitespace is any sequence of  one  or  more  spaces  and/or
     tabs.   The  _s_t_r_i_n_g  is  the command key(s) which invoke the
     action.  The _s_t_r_i_n_g may  be  a  single  command  key,  or  a
     sequence  of  up  to 15 keys.  The _a_c_t_i_o_n is the name of the
     less action, from the list below.   The  characters  in  the
     _s_t_r_i_n_g  may  appear  literally, or be prefixed by a caret to
     indicate a control key.  A  backslash  followed  by  one  to
     three octal digits may be used to specify a character by its
     octal value.  A backslash followed by b, e, n, r or t speci-
     fies  BACKSPACE,  ESCAPE,  NEWLINE,  RETURN  or TAB, respec-
     tively.  A backslash followed by any other  character  indi-
     cates  that  character is to be taken literally.  Characters
     which must be preceded by backslash  include  caret,  space,
     tab  and  the backslash itself.  Blank lines and lines which
     start with a pound sign (#) are ignored.

     An action may be followed by an "extra" string.  When such a
     command  is  entered  while running _l_e_s_s, the action is per-
     formed, and then the extra string is parsed, just as  if  it
     were  typed  in to _l_e_s_s. This feature can be used in certain
     cases to extend the functionality of a command.   For  exam-
     ple, see the "{" and ":t" commands in the example below.

     The -V flag causes _l_e_s_s_k_e_y to print its version  number  and
     immediately exit. Other flags and arguments are ignored.


EXAMPLE
     The following input file describes the set of  default  com-
     mand keys used by less:




                                                                1






LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



          \r        forw-line
          \n        forw-line
          e         forw-line
          j         forw-line
          ^E        forw-line
          ^N        forw-line
          k         back-line
          y         back-line
          ^Y        back-line
          ^K        back-line
          ^P        back-line
          J         forw-line-force
          K         back-line-force
          Y         back-line-force
          d         forw-scroll
          ^D        forw-scroll
          u         back-scroll
          ^U        back-scroll
          \40       forw-screen
          f         forw-screen
          ^F        forw-screen
          ^V        forw-screen
          b         back-screen
          ^B        back-screen
          \ev       back-screen
          z         forw-window
          w         back-window
          F         forw-forever
          R         repaint-flush
          r         repaint
          ^R        repaint
          ^L        repaint
          g         goto-line
          <         goto-line
          \e<       goto-line
          p         percent
          %         percent
          {         forw-bracket {}
          }         back-bracket {}
          (         forw-bracket ()
          )         back-bracket ()
          [         forw-bracket []
          ]         back-bracket []
          \e^F      forw-bracket
          \e^B      back-bracket
          G         goto-end
          \e>       goto-end
          >         goto-end
          =         status
          ^G        status
          :f        status
          /         forw-search



                                                                2






LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



          ?         back-search
          \e/       forw-search *
          \e?       back-search *
          n         repeat-search
          \en       repeat-search-all
          N         reverse-search
          \eN       reverse-search-all
          \u        undo-hilite
          m         set-mark
          '         goto-mark
          ^X^X      goto-mark
          E         examine
          :e        examine
          ^X^V      examine
          :n        next-file
          :p        prev-file
          :x        index-file
          -         toggle-option
          :t        toggle-option t
          s         toggle-option o
          _         display-option
          |         pipe
          v         visual
          !         shell
          +         firstcmd
          H         help
          h         help
          V         version
          q         quit
          :q        quit
          :Q        quit
          ZZ        quit


PRECEDENCE
     Commands specified  by  _l_e_s_s_k_e_y  take  precedence  over  the
     default  commands.  A default command key may be disabled by
     including it in the input file with  the  action  "invalid".
     Alternatively,  a  key may be defined to do nothing by using
     the action "noaction".  "noaction" is similar to  "invalid",
     but  _l_e_s_s  will give an error beep for an "invalid" command,
     but not for a "noaction" command.  In addition, ALL  default
     commands  may be disabled by adding this control line to the
     input file:

     #stop

     This will cause all default commands  to  be  ignored.   The
     #stop  line  should  be the last line in that section of the
     file.  (Another section, introduced by #line-edit, may  fol-
     low the #stop line.)




                                                                3






LESSKEY(1)               USER COMMANDS                 LESSKEY(1)



     Be aware that #stop can be dangerous. Since all default com-
     mands  are  disabled,  you  must provide sufficient commands
     before the #stop line to enable all necessary actions.   For
     example,  failure  to  provide  a "quit" command can lead to
     frustration.


LINE EDITING
     New key bindings may be specified for the line editing  com-
     mands, in a manner similar to the way key bindings for ordi-
     nary commands are specified.  This control  line  marks  the
     beginning of a section of line-editing commands:

     #line-edit

     Following this line is a list of keys and actions,  one  per
     line as in the example below.


EXAMPLE
     The following input file describes the set of default  line-
     editing keys used by less:

          #line-edit
          \t        forw-complete
          \17       back-complete
          \e\t      back-complete
          \14       expand
          ^V        literal
          ^A        literal
          \el       right
          \eh       left
          \eb       word-left
          \ew       word-right
          \ei       insert
          \ex       delete
          \e\b      word-backspace
          \e0       home
          \e$       end
          \ek       up
          \ej       down



SEE ALSO
     less(1)


COPYRIGHT
     Copyright (c) 1984,1985,1989,1994  Mark Nudelman





                                                                4



