.TH getopt "" "Extension" Command
getopt \- parse command options
.PP
.B "set \-\- `getopt optstring"
.B $*`
.PP
.I Getopt
is used to break up options in command lines for easy
parsing by shell procedures and to check for legal options.
Optstring is a string of recognized option letters (see
getopt \- general functions); if a letter is followed by a colon,
the option is expected to have an argument which may or may not be
separated from it by white space. The special option \-\- is used
to delimit the end of the options. If it is used explicitly,
.I getopt
will recognize it; otherwise,
.I getopt
will generate it;
in either case,
.I getopt
will place it at the end of the options.
The positional parameters ($1 $2 ...) of the shell are reset so
that each option is preceded by a \- and is in its own positional
parameter; each option argument is also parsed into its own
positional parameter.
.SH Example
.PP
The following code fragment shows one might process the arguments
for a command that can take the options a or b, as well as the
option o, which requires an argument:
.DS
	set \-\- `getopt abo: $*`
	if [ $? != 0 ]
	then
		echo $USAGE
		exit 2
	fi
	for i in $*
	do
		case $i in
		\-a | \-b) FLAG=$i; shift;;
		\-o)	 OARG=$2; shift 2;;
		\-\-)	 shift; break;;
		esac
	done
.DE
This code will accept any of the following as equivalent:
.DS
	cmd \-aoarg file file
	cmd \-a \-o arg file file
	cmd \-oarg \-a file file
	cmd \-a \-oarg \-\- file file
.DE
.SH "See also"
.PP
sh, general functions
.SH Diagnostics
.PP
Getopt prints an error message on the standard error when it
encounters an option letter not included in optstring.
