/* A.Fongen's "Mailorg" project - rmail compatible mail user interface.

   Module SPLIT - parses through mail file and builds a structure that
   speeds up the handling of each message. SPLIT also contains procedures
   to list the message header information in a tty-type manner,
   procedures to display one particular message, delete/undelete
   a message, reply to a message, send a message etc.

   This module contains the main data structure (the message list), but
   is not the main program.

   Current version: 21.09.90

*/

#include <stdio.h>
#define LINESIZE 120
#define MAXLETTERS 50
#define TEMPBUFSIZE 10000
#define TRUE 1
#define FALSE 0

extern char *getenv();	/* Just to keep Strict silent */
extern char *mktemp();

/* Define structure for list of message information */
#define CALLADDRLEN 80
#define AUTHORLEN 80
#define DATELEN 26
#define SUBJECTLEN 40
struct ldesc {
	int deleted;			/* Status of this message */
	int lines;			/* No. of lines in mess */
	long fptr;			/* Pointer to message in file */
	char calladdr[CALLADDRLEN];	/* Mail address of sender */
	char author[AUTHORLEN];		/* Name of author */
	char date[DATELEN];		/* Date of origin */
	char subject[SUBJECTLEN];	/* Subject of message */
} letters[MAXLETTERS];
struct ldesc *letterptr;


/* note that the letterno is post-incremented, so that it points to the
   next free position in the table. */
int letterno;			/* Number of current message */

char tempbuf[TEMPBUFSIZE];	/* Used to copy messages to tempfile */
char linebuf[LINESIZE];		/* Holds one line of text from the mailfile */
char filename[80];		/* Hold file names */
char mailname[80];		/* Name of current mailbox file */
FILE *mailfile;			/* The mailfile */

char *isolate_letter(letterno)
int letterno;
/* Isolates the text belonging to a message, and writes it onto
   a temporary file. The name of the temporary file is returned */
{
	unsigned len;		/* Length of current message */
	FILE *tempfile;

	/* Compute the size of this message by finding the difference 
	   between to successive messages. Take away three bytes for the
	   line containing "\001\001\n" */
	len = (unsigned)(letters[letterno+1].fptr-letters[letterno].fptr-3);

	strcpy(filename,mktemp("/tmp/moXXXXXX"));
	if ((tempfile = fopen(filename,"w")) == NULL) {
		printf("Could not open temporary file %s\n",filename);
		exit(1);
	}

	/* Now copy this portion of the file, in more steps if necc. */
	fseek(mailfile,letters[letterno].fptr,0);
	while (len > TEMPBUFSIZE) {
		fread(tempbuf,sizeof(char),TEMPBUFSIZE,mailfile);
		fwrite(tempbuf,sizeof(char),TEMPBUFSIZE,tempfile);
		len -= TEMPBUFSIZE;
	}
	fread(tempbuf,sizeof(char),len,mailfile);
	fwrite(tempbuf,sizeof(char),len,tempfile);
	fclose(tempfile);

	return(filename);
}

char *get_parameter(c,prompt)
char c[],prompt;
/* This procedure will extract the parameter following a one-character
   command code in the buffer c. If no parameter is present, prompt
   the user using "prompt" as leading text */
{
	char dummy[10],response[80];
	response[0] = '\0';
	sscanf(c,"%s %s",dummy,response);
	if (response[0] == '\0') {
		printf("%s",prompt);
		scanf("%s",response);
		return(response);
	} else {
		return(response);
	}
}

write_letter(letterno,c)
int letterno;
char c[];
/* Writes the text belonging to a message onto a temporary file. */
{
	unsigned len;		/* Length of current message */
	FILE *tempfile;
	char *filename;

	filename = get_parameter(c,"Write to file: ");
	if (*filename == '\0') return(0);

	/* Compute the size of this message by finding the difference 
	   between to successive messages. Take away three bytes for the
	   line containing "\001\001\n" */
	len = (unsigned)(letters[letterno+1].fptr-letters[letterno].fptr-3);

	if ((tempfile = fopen(filename,"a")) == NULL) {
		printf("Could not open file %s for append\n",filename);
		exit(1);
	}

	/* Now copy this portion of the file, in more steps if necc. */
	fseek(mailfile,letters[letterno].fptr,0);
	while (len > TEMPBUFSIZE) {
		fread(tempbuf,sizeof(char),TEMPBUFSIZE,mailfile);
		fwrite(tempbuf,sizeof(char),TEMPBUFSIZE,tempfile);
		len -= TEMPBUFSIZE;
	}
	fread(tempbuf,sizeof(char),len,mailfile);
	fwrite(tempbuf,sizeof(char),len,tempfile);
	fclose(tempfile);
}

save_letter(letterno,c)
int letterno;
char c[];
/* Isolates the text belonging to a message, and writes it onto
   a temporary file. The name of the temporary file is returned */
{
	unsigned len;		/* Length of current message */
	FILE *tempfile;
	char *filename;

	filename = get_parameter(c,"Save to mbox: ");
	if (*filename == '\0') return(0);

	/* Compute the size of this message by finding the difference 
	   between to successive messages. Keep the
	   line containing "\001\001\n" */
	len = (unsigned)(letters[letterno+1].fptr-letters[letterno].fptr);

	if ((tempfile = fopen(filename,"a")) == NULL) {
		printf("Could not open temporary file %s\n",filename);
		exit(1);
	}

	/* Now copy this portion of the file, in more steps if necc. */
	fseek(mailfile,letters[letterno].fptr,0);
	while (len > TEMPBUFSIZE) {
		fread(tempbuf,sizeof(char),TEMPBUFSIZE,mailfile);
		fwrite(tempbuf,sizeof(char),TEMPBUFSIZE,tempfile);
		len -= TEMPBUFSIZE;
	}
	fread(tempbuf,sizeof(char),len,mailfile);
	fwrite(tempbuf,sizeof(char),len,tempfile);
	fclose(tempfile);
	letters[letterno].deleted = TRUE;
}

void display_letter(letterno)
/* This procedure invokes the pager on a temporary file after the
   procedure Isolate_letter has written onto a temporary file. The
   name of the temporary file is returned from Isolate_letter */
int letterno;
{
	char pagername[80];	/* Holds name of pager program */
	char *envptr,*fname;	/* Points to environment entry */

	fname = isolate_letter(letterno); /* write it onto file */
	/* The pager should be "scat" by default, otherwise 
	   set by environment */
	if ((envptr = getenv("PAGER")) == NULL)
		strcpy(pagername,"/bin/scat");
	else
		strcpy(pagername,envptr);
	strcat(pagername," ");
	strcat(pagername,fname);
	system(pagername);
	unlink(fname);
}

void debug(str)
char str[];
{
	printf("%s",str); 
}

void parse_calladdr(letterptr,parsestr)
struct ldesc *letterptr;
char parsestr[];
/* The From: line in the message header comes (as far as I know) 
   in one of two forms:  "calladdr (name)" or "name <calladr>"
   The task of this procedure to split these components into
   lineptr->author and lineptr->calladdr. In the first form, we
   assume that the "(" is the leftmost paranthesis, and in the
   second form we assume that the "<" is the rightmost one. We 
   examine the second form first. 

   This code works, but is somewhat sloppy, especially with respect
   to handling of errors. */

{
	int i,form,left=0,right=0;
	for (i=0; parsestr[i] != '\0'; i++) {
		if (parsestr[i] == '(') {
			left = i;
			form = 1;	/* Indicates first form */
		} else if (parsestr[i] == '<') {
			left = i;
			form = 2;	/* Indicates second form */
		} else if ((parsestr[i] == '>') || (parsestr[i] == ')'))
			right = i;
	}
	/* Make string termination marks */
	parsestr[left] = '\0'; parsestr[right] = '\0';
	if (form == 1) {
		strcpy(letterptr->calladdr,parsestr);
		strcpy(letterptr->author,&parsestr[left+1]);
	} else {
		strcpy(letterptr->author,parsestr);
		strcpy(letterptr->calladdr,&parsestr[left+1]);
	}
}

void display_header_line(i)
int i;
{
	letterptr = &letters[i];
	printf("%s%2d  %12.12s  %-18.18s %-35.35s(%3d)\n",
		letterptr->deleted ? "*" : " ",
		i,
		letterptr->date,
		letterptr->author,
		letterptr->subject,
		letterptr->lines);
}
void display_headers()
/* This procedure lists a summary of all available messages, one on each
   line. It assumes that the strucure "letters" and "letterno" is 
   properly set up in advance. */
{
int i;
	for (i=0; i<letterno; i++) {
		display_header_line(i);
	}
	printf("------\n");
}

int switch_mailbox(c)
char c[];
{
	char *mbox;
	mbox = get_parameter(c,"Switch to mbox: ");
	if (*mbox == '\0') return;
	letterno = split(mbox);
	if (!letterno) {
		printf("No messages in mailbox\n");
		exit(0);
	}
	display_headers();
	return(letterno);
}
			
int split(mbox)	/* Returns number of messages found */
char *mbox;
{
	int i; char *envptr;
	int startnew = 1;	/* Indicates new message in mail file */

	letterno = 0;
	letterptr = &letters[letterno++]; /* Used for abbrev. addressing */
	letterptr->fptr = 0L; /* First message start at beginning of file */
	letterptr->lines = 0;
	letterptr->deleted = FALSE;
	strcpy(letterptr->subject,"No subject");

	if (strcmp(mbox,"MAIL") == 0) {
		/* Name of mail file is in the variable MAIL */
		if ((envptr = getenv("MAIL")) == NULL) {
			fprintf(stderr,"Environment variable MAIL not set\n");
			return(0);
		}
	} else /* mbox is a filename */
		envptr = mbox;

	/* Save tempfile name for update purposes */
	strcpy(mailname,envptr);

	if ((mailfile = fopen(envptr,"r")) == 0) {
		fprintf(stderr,"Could not open mail file\n");
		return(0);
	}

	/* Build a structure for splitting the mail file */
	while (fgets(linebuf,LINESIZE,mailfile) != 0) {
		letterptr->lines++;	/* Count lines in message */
		if ((linebuf[0] == '\001') && (linebuf[1] == '\001')) {
			letterptr->lines--;/* Don't count the separation line */
			letterptr = &letters[letterno++];
			if (letterno >= MAXLETTERS)
			{	fprintf(stderr,"Ran out of table space!\n");
				exit(1);
			}
			/* By assigning fptr at this point, there will
			   be a dummy entry after the last message, so
			   that the size of the last message may be
			   computed. */
			letterptr->fptr = ftell(mailfile);
			strcpy(letterptr->subject,"No subject");
			letterptr->deleted = FALSE;
			letterptr->lines = 0;
#ifdef DEBUG
			printf("\nLetter no.%d\n",letterno);
#endif
			startnew = 1;	/* Indicates start of new mess. */
		} else	if (startnew == 1) {
				linebuf[strlen(linebuf)-1] = '\0';
				if (strncmp(linebuf,"From:",5) == 0) {
#ifdef DEBUG
					debug(&linebuf[6]);
#endif
					parse_calladdr(letterptr,&linebuf[6]);
				} else if (strncmp(linebuf,"Date:",5) == 0) {
#ifdef DEBUG
					debug(&linebuf[6]);
#endif
					i = strlen(&linebuf[6])+1;
					i = (i > DATELEN) ? DATELEN : i;
					strncpy(letterptr->date,&linebuf[6],i);
				} else if (strncmp(linebuf,"Subject:",8) == 0) {
#ifdef DEBUG
					debug(&linebuf[9]);
#endif
					i = strlen(&linebuf[9])+1;
					i = (i > SUBJECTLEN ? SUBJECTLEN : i);
				strncpy(letterptr->subject,&linebuf[9],i);
					startnew = 0;
				}
			} 
	}
	letters[letterno-1].deleted = TRUE; /* To make update_mailbox work */
	letterno -= 1;	/* letterno now contains number of messages */
	return(letterno); 
}

void update_mailbox()
/* This procedure compresses the current mailbox file, by physically
   removing all deleted letters. A temprorary file is used for this
   purpose, until it is copied over the original mailbox file */
{
	FILE *mailfile2;
	int i,delflag;	
	long low,high,len;
	char *mailname2;

	mailname2 = mktemp("/tmp/moXXXXXX");
	if ((mailfile2 = fopen(mailname2,"w")) == NULL) {
		printf("Could not open temporary file\n");
		return;
	}
	/* Now search for contigous regions of data to copy */
	delflag = TRUE;
	for (i = 0; i <= letterno; i++) {
		if (delflag) {
			if (!letters[i].deleted) {
				low = letters[i].fptr;
				delflag = FALSE;
			}
		} else {
			if (letters[i].deleted) {
				high = letters[i].fptr;
				delflag = TRUE;

		/* Check for the special case that no letters are deleted.
		   In this case, just close and exit */
			if ((low == 0L) && (i == letterno)) {
				printf("Mailbox has not been altered\n");
				fclose(mailfile2);
				return;
			}
		/* Now copy this portion of the file, in more steps if necc. */
		fseek(mailfile,low,0);
		len = high - low;
		while (len > TEMPBUFSIZE) {
			fread(tempbuf,sizeof(char),TEMPBUFSIZE,mailfile);
			fwrite(tempbuf,sizeof(char),TEMPBUFSIZE,mailfile2);
			len -= TEMPBUFSIZE;
		}
		fread(tempbuf,sizeof(char),(unsigned) len,mailfile);
		fwrite(tempbuf,sizeof(char),(unsigned) len,mailfile2);
			}
		}
	}
	fclose(mailfile2);
	sprintf(tempbuf,"/bin/cp %s %s", mailname2, mailname);
#ifdef DEBUG
	printf("%s\n",tempbuf);
#endif
	system(tempbuf);
	unlink(mailname2);
}
			
		



char *letter_calladdr(lno)
int lno;
{
	return(letters[lno].calladdr);
}

char *letter_subject(lno)
int lno;
{
	return(letters[lno].subject);
}
	
delete_letter(lno)
int lno;
{
	letters[lno].deleted = TRUE;
}

undelete_letter(lno)
int lno;
{
	letters[lno].deleted = FALSE;
}

close_files()
{
	fclose(mailfile);
}


	
	
