#include <X11/copyright.h>

/* $XConsortium: TemplateP.h,v 1.4 89/07/21 01:41:48 kit Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */

#ifndef _CrwinP_h
#define _CrwinP_h

#include "crwin.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRCrwinResource "CrwinResource"

typedef struct {
/* private: */
	int	dummy;
} CrwinClassPart;

typedef struct _CrwinClassRec {
    CoreClassPart	core_class;
    CrwinClassPart	crwin_class;
} CrwinClassRec;

extern CrwinClassRec crwinClassRec;

typedef struct {
	/* resources */
	XFontStruct	*font_info;
	String		table;
	Pixel		window_background;
	Pixel		text_color;
	Pixel		selected_window;
	Pixel		normal_messages;
	Pixel		error_messages;
	Pixel		hilight_foreground;
	Pixel		hilight_background;
	Pixel		insert_cursor_color;
	Pixel		overtype_cursor_color;

/* private: */
	/***********************************************/
	/*   Need  to  keep  track  of size of window  */
	/*   allocated  so  if  window  is resized to  */
	/*   be  larger  than what we have we need to  */
	/*   allocate a new window.		       */
	/***********************************************/
	int	win_width_allocated;
	int	win_height_allocated;

	/***********************************************/
	/*   Graphics context for the window.	       */
	/***********************************************/
	GC	gc;

	int	x, y;		/* Cursor position.			*/
	char	cursor_char;	/* Character under cursor.		*/
	int	cursor_bg;	/* Normal background color of character */
				/* under cursor.			*/
	int	insert_cursor;	/* TRUE if insert mode cursor.		*/
				/* FALSE if overtype mode cursor.	*/
	/***********************************************/
	/*   Following  are  computed  from  the font  */
	/*   information  to  avoid repeated calls to  */
	/*   X XTextWidth().			       */
	/***********************************************/
	int	char_width;
	int	char_height;
	
	ref_t	*push_ref;	/* Pushback buffer for keyboard.*/
	
	int	first_sizing;	/* If TRUE dont need to erase lower row/col */
				/* on first resizing.			*/
} CrwinPart;

typedef struct _CrwinRec {
    CorePart		core;
    CrwinPart		crwin;
} CrwinRec;

#endif /* _CrwinP_h */
