/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *    This is the terminal description file for NCSA telnet         *
 *    emulating a vt102.  This is a very useful program, but        *
 *    some of the keyboard mappings are decidely odd, and probably  *
 *    differ from a "real" vt102, though I don't have one available *
 *    for comparison.  						    *
 *                                                                  *
 *    Add the following line to /etc/termcap:                       *
 *                                                                  *
 *        telnet|NCSA telnet emulating vt102:tc=vt102:              *
 *                                                                  *
 *    (or use crisp/utils/termcap [P Fox])                          *
 *                                                                  *
 *    Telnet should be configured to send ^H rather than ^?         *
 *    for the backspace key.  Include the following line            *
 *    in CONFIG.TEL:                                                *
 *                                                                  *
 *        erase=backspace                                           *
 *                                                                  *
 *    Unfortunately, the <Home> key also sends ^H, so it cannot     *
 *    be independently recognized, and will behave like another     *
 *    backspace key.  But if the backspace key sends ^?, it         *
 *    doesn't seem to work properly on the command line (though     *
 *    it works elsewhere).  This configuration is not ideal,        *
 *    but seems to be the best compromise.                          *
 *								    *
 *    The standard version of NCSA telnet sends the string	    *
 *    "\x1Aexit\r\n" when <F9> is pressed.  This may be useful	    *
 *    under VMS, but its disasterous on a Unix system -- if you	    *
 *    have job control, it will suspend the editor and then try to  *
 *    log you out.  I've patched our telnet binary to send the      *
 *    string "\x1BWombat" instead.  The key map defined here        *
 *    reflects that patch.  It will still work for the unpatched    *
 *    version -- just don't touch <F9>, whatever you do.	    *
 *								    *
 *    Warren Jones                                                  *
 *    April 26, 1991                                                *
 *                                                                  *
 ********************************************************************/

# include   "tty.h"

void
main()
{
      /***********************************************/
      /*   Set   characters   used   for   extended  */
      /*   graphics support when drawing windows.    */
      /***********************************************/
      set_term_characters(
            "\x1B(0l\x1B(B",     /* Top left of window.			     */
            "\x1B(0k\x1B(B",     /* Top right of window.		     */
            "\x1B(0m\x1B(B",     /* Bottom left of window.		     */
            "\x1B(0j\x1B(B",     /* Bottom right of window.		     */
            "\x1B(0x\x1B(B",     /* Vertical bar for window sides.	     */
            "\x1B(0q\x1B(B",     /* Top and bottom horizontal bar for window.*/
            '+',                 /* Top join.				     */
            '+',                 /* Bottom join.			     */
            '+',                 /* Window 4-way intersection.		     */
            '+',                 /* Left hand join.			     */
            '+'                  /* Right hand join.			     */
            );

      /***********************************************/
      /*   Define   escape   sequences   used   for  */
      /*   special optimisations on output.	     */
      /***********************************************/
      set_term_features(
            NULL,       /* Sequence to clear 'n' spaces.	     */
                        /* ("\x1B[%dX" almost works, but	     */
                        /* doesn't preserve standout mode,	     */
                        /* so help menus don't look right.)	     */
            NULL,       /* Sequence to print characters with top     */
                        /* bit set.				     */
            NULL,       /* Insert-mode cursor.			     */
            NULL,       /* Overwrite-mode cursor.		     */
            NULL,       /* Insert-mode cursor (on virtual space).    */
            NULL,       /* Overwrite-mode cursor (on virtual space). */
            NULL,       /* Print ESCAPE character graphically.	     */
            NULL,       /* Escape sequence to repeat last character. */
            FALSE,      /* ESC [0m resets color.		     */
            FALSE,      /* Terminal supports color.		     */
            "\x1B[%dC"  /* Sequence to move cursor on same line.     */
            );

      /***********************************************/
      /*   Define  keyboard  layout  for  non-ascii  */
      /*   characters.  These  can only be used for  */
      /*   the console).			     */
      /***********************************************/
      set_term_keyboard(
         F1_F12, quote_list(
            	"\x1BOP", "\x1BOQ", "\x1BOR", "\x1BOS", "\x1BOm",
                        "\x1BOl", NULL, "\x1BOv", NULL, "\x1BOM"),
                                                
          /***********************************************/
          /*   Only  F1-F6,  F8  and F10 are available.  */
          /*   F7  returns  the  same code as the "Del"  */
          /*   key,  so  only  one  F7  or  Del) can be  */
          /*   recognized   --   I   chose   "Del".  F9  */
          /*   returns  a  sequence including ^Z, which  */
          /*   will  suspend  the  editor  -- don't use  */
          /*   this  key  whatever you do. Can't detect  */
          /*   CTRL-Function  key  combinations.  Can't  */
          /*   detect SHFT-Function key combinations.	 */
          /***********************************************/
   
         ALT_A_Z, quote_list(
            		"\x1Ba", "\x1Bb",   "\x1Bc",  "\x1Bd",  "\x1Be",
                        "\x1Bf", "\x1Bg",   "\x1Bh",  "\x1Bi",  "\x1Bj",
                        "\x1Bk", "\x1Bl",   "\x1Bm",  "\x1Bn",  "\x1Bo",
                        "\x1Bp", "\x1Bq",   "\x1Br",  "\x1Bs",  "\x1Bt",
                        "\x1Bu", "\x1Bv",   "\x1Bw",  "\x1Bx",  "\x1By",
                        "\x1Bz"),

         ALT_0_9, quote_list(
            		"\x1B1", "\x1B2", "\x1B3", "\x1B4", "\x1B5",
                        "\x1B6", "\x1B7", "\x1B8", "\x1B9", "\x1B0"),

         KEYPAD_0_9, quote_list(
            		NULL,		/* Ins         */
                        "\x1BOt\x1BOr", /* End         */
                        "\x1BOB",       /* Down Arrow  */
                        "\x1BOt\x1BOx", /* PgDn        */
                        "\x1BOD",       /* Left Arrow  */
                        NULL,		/* 5 (Null)    */
                        "\x1BOC",       /* Right Arrow */
                        NULL,		/* Dont recognize Home key */
                        "\x1BOA",       /* Up Arrow    */
                        "\x1BOu\x1BOx", /* PgUp        */
                        "\x1BOn"        /* Del         */
                        ),
        /**********************************************************/
	/* Only a few keypad keys send anything when combined     */
	/* with <Ctrl>.  Ctrl-Home seems to lock up the terminal. */
        /**********************************************************/
        CTRL_KEYPAD_0_9, quote_list(
			NULL,
			NULL,
			NULL,
                        "\x1BOt\x1BOw",  /* Ctrl-PgDn   */
			NULL,
			NULL,
			NULL,
			NULL,
			NULL,
                        "\x1BOu\x1BOw"  /* Ctrl-PgUp   */
			)
         );

      assign_to_key("#127", "backspace");
}

