/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *                                                                  *
 *    Please See COPYLEFT notice.                                   *
 *                                                                  *
 ********************************************************************/

# include	"crisp.h"

/****************************************************************************
/*		Display an ASCII chart.
/****************************************************************************/

void
ascii()
{
	select_list("ASCII Chart", "", 3, 
	   quote_list(
"Hex Chart",	"ascii_chart 16", "ASCII Chart",
"Octal Chart",	"ascii_chart 8",  "ASCII Chart",
"Decimal Chart","ascii_chart 10", "ASCII Chart"), 
		SEL_CENTER);
}
void
ascii_chart(int radix)
{
	int	buf,
		win,
		curbuf,
		curwin,
		ch;
	list l;
	string name, fmt, str;
	
	curbuf = inq_buffer();
	curwin = inq_window();
	
	fmt = radix == 8 ? "%03o" :
	      radix == 10 ? "%3d" : "%02x";
			
	sprintf(name, "Ascii Chart (%s)", 
		radix == 16 ? "Hex" :
		radix == 10 ? "Decimal" : "Octal");
	buf = create_buffer(name, NULL, 1);
	set_buffer(buf);
	l = quote_list(
		"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", 
		"BS ", "HT ", "NL ", "VT ", "NP ", "CR ", "SO ", "SI ", 
		"DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", 
		"CAN", "EM ", "SUB", "ESC", "FS ", "GS ", "RS ", "US ");
		
	for (ch = 0; ch < ' '; ++ ch) {
		sprintf(str, fmt, ch);
		insert(str);
		insert(" ");
		insert(l[ch]);
		insert("| ");
		if ((ch & 7) == 7)
			insert("\n");
		}
	while (ch < 0x80) {
		if (ch == '%')
			sprintf(str, fmt + "  %% | ", ch);
		else
			sprintf(str, fmt + "  %c | ", ch, ch);
		insert(str);
		if ((ch & 7) == 7)
			insert("\n");
		++ ch;
		}
	win = sized_window(17, radix == 8 ? 71 : radix == 10 ? 71 : 63, "");
	select_buffer(buf, win, SEL_CENTER);
	delete_buffer(buf);
	set_buffer(curbuf);
	set_window(curwin);
	attach_buffer(curbuf);
}
