/****************************************************************/
/*								*/
/*	XChess V2.7: Utilities					*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "ch.h"			/* Def. des Schachspiels */

/****************************************************************/
/*	Brett ausgeben						*/
/****************************************************************/

void	brett_aus(dat,ret)

SPDAT	*dat;					/* Spieldaten	*/
char	*ret[];					/* Antworten	*/
{
	BYTE		i,j;			/* Zaehler 	*/
	BYTE		fig;			/* Figur	*/
	char		c;			/* Zeichen fuer Figur	*/
	char 		str[STRLEN];		/* String fuer Figur	*/
	static 	char	figtab[]=".bbslttdkk";
						/* Figurtabelle	*/

	for(j=7;j!=0xff;j--)			/* ausgeben	*/
	{
		ret[zaehler][0]=0;		/* beenden	*/

		for(i=0;i<8;i++)
		{
			fig=dat->brett[(j+RAND)*ZLEN+i+RAND];
			c=figtab[fig&(~(SCH | WEI))];	/* Figur o. Farbe */

			if(_istsch(fig))
				c += 'A'-'a';	/* gross machen	*/

			sprintf(str,"%c ",c);	/* Antwort herstellen	*/
			strcat(ret[zaehler],str);
		}

		zaehler++;
	}
}

/****************************************************************/
/*	Informationen ausgeben					*/
/****************************************************************/

void	info_aus(dat,ret)

SPDAT	*dat;					/* Spieldaten	*/
char	*ret[];					/* Antworten	*/
{
	SPDAT datc;				/* Spieldaten	*/

	eff_stufe(dat);				/* Stufe einstellen	*/
	sprintf(ret[zaehler++],

	"%c",dat->farbe==WEI?'w':'s');		/* Farbe am Zug		*/

	sprintf(ret[zaehler++],
	"%d",dat->zuege);			/* Anz. der Zuege	*/

	sprintf(ret[zaehler++],			/* Bewertung		*/
	"%ld",bewerte(dat,(BYTE)0));

	sprintf(ret[zaehler++],"%ld",varianten);	/* Anz. d. Var.	*/

	sprintf(ret[zaehler++],"%ld",			/* Var. / Sek.	*/
	varianten/((long)zeit>0 ? (long)zeit:1L));

	sprintf(ret[zaehler++],"%ld",			/* Var. / Sek.	*/
	varprosek/(long)(compzuege > 0 ?		/* gesamt	*/
	(compzuege<=50 ? compzuege:50):1));

	sprintf(ret[zaehler++],"%d",stufe);		/* Spielstufe	*/

	sprintf(ret[zaehler++],"%d",dat->minstufe);	/* Rechentiefen	*/
	sprintf(ret[zaehler++],"%d",dat->maxstufe);

	sprintf(ret[zaehler++],"%d",mode);		/* Modus	*/

	if(!hole_zurueck(&datc,dat->zuege-1))		/* holen	*/
	{
		sprintf(ret[zaehler++],"%s",		/* letzter Zug	*/
		wandle(_apos(dat->lzug),_npos(dat->lzug)));
	}
	else
	{
		WORD komb[2];				/* Kombination	*/

		komb[0]=dat->lzug;			/* eintragen	*/
		komb[1]=(WORD)0;			/* beenden	*/

		sprintf(ret[zaehler++],"%s",		/* letzter Zug	*/
		kombination(&datc,komb));		/* ausgeben	*/
	}
}

/****************************************************************/
/*	Zugliste ausgeben					*/
/****************************************************************/

void	zugliste_aus(dat,modus,ret)

SPDAT	*dat;					/* Spieldaten	*/
int	modus;					/* 1: +Bew.	*/
char	*ret[];					/* Antworten	*/
{
	int	i= -1;				/* Zaehler 	*/

	while(dat->zlist[++i])			/* alle Zuege durch	*/
	if(modus)				/* mit Bewertung	*/
		sprintf(ret[zaehler++],"%s = %ld",
		wandle(_apos(dat->zlist[i]),_npos(dat->zlist[i])),
		dat->blist[i]);
						/* kopieren	*/
	else					/* ohne Bewertung	*/
		sprintf(ret[zaehler++],"%s",
		wandle(_apos(dat->zlist[i]),_npos(dat->zlist[i])));
						/* kopieren	*/

	sprintf(ret[zaehler++],"(%d)",i);
}

/****************************************************************/
/*	Zug/Positionsangabe umwandeln				*/
/****************************************************************/
/*	Falls posa == 0 : Positionsstring			*/
/****************************************************************/

char *wandle(posa,posn)

BYTE	posa,posn;				/* Positionen		*/
{
	static 	char 	str[STRLEN];		/* String mit Pos/Zug 	*/
	BYTE    	xposa,yposa;		/* Koordinaten	alt 	*/
	BYTE    	xposn,yposn;		/* Koordinaten	neu 	*/

	if(posa==(BYTE)0 && posn==(BYTE)0)	/* Kein Zug ?		*/
		return("----");

	xposa=_xpos(posa);			/* alte Koordinaten holen */
	yposa=_ypos(posa);

	if(posn!=(BYTE)0)
	{
		xposn=_xpos(posn);		/* neue Koordinaten holen */
		yposn=_ypos(posn);

		sprintf(str,"%c%c%c%c",		/* aufbereiten	*/
		xposa+'a',yposa+'1',
		xposn+'a',yposn+'1');
	}
	else
		sprintf(str,"%c%c",		/* aufbereiten	*/
		xposa+'a',yposa+'1');

	return(str);
}

/****************************************************************/
/*	Zug/Positionsangabe inveres umwandeln			*/
/****************************************************************/
/*	Return: Zug/Position oder 0 bei Fehler			*/
/****************************************************************/

WORD wandle_inv(str)

char 	*str;				/* String mit Zug/Position	*/
{
	WORD	zug=0;			/* Zug/Position	*/
	int 	i,j;			/* Zaehler	*/
	char	c;			/* aktuelles Zeichen in str	*/
	WORD	teil[4];		/* Teile des Zugs	*/

	for(i=0,j=0;str[i] != 0;i++)	/* String durchgehen		*/
	{
		c=str[i];

		if(c==' ' || c=='-' || c=='x' || c=='_' || c=='+')
			continue;
		else switch(j)
		{
		case 0:
		case 2:
			if(c>='a' && c<='h')
				teil[j++] = c-'a';
			else if(c>='A' && c<='H')
				teil[j++] = c-'A';
			else
				return((WORD)0);	/* Fehler	*/
			break;

		case 1:
		case 3:
			if(c>='1' && c<='8')
				teil[j++] = c-'1';
			else
				return((WORD)0);	/* Fehler	*/
			break;

		default:
			return((WORD)0);	/* Fehler	*/
		}
	}

	if(j==2 || j==4)			/* korrekt ?	*/
		zug |= teil[0]+RAND+(8+2*RAND)*(RAND+teil[1]);

	if(j==4)				/* korrekt ?	*/
		zug |= (teil[2]+RAND+(8+2*RAND)*(RAND+teil[3])) << 8;

	return(zug);
}

/****************************************************************/
/*	Figur in internes Format				*/
/****************************************************************/
/*	Return: Figur oder 0 bei Fehler 			*/
/****************************************************************/

BYTE wandle_fig(c)

char c;					/* Figur	*/
{
	char c2;
	BYTE fig;			/* internes Format	*/

	c2=c;
	if(isupper(c))        		/* klein machen	*/
		c2=tolower(c);

	switch(c2)			/* umwandeln	*/
	{
	case 'b':
		fig=BAU;
		break;

	case 's':
		fig=SPR;
		break;

	case 'l':
		fig=LAE;
		break;

	case 't':
		fig=TUR;
		break;

	case 'd':
		fig=DAM;
		break;

	case 'k':
		fig=KOE;
		break;

	case '.':
		fig=LEE;
		break;

	default:
 		return(0);			/* Fehler	*/
	}

	if(isupper(c))
		fig|=SCH;
	else
		fig|=WEI;

	return(fig);
}

/****************************************************************/
/*	Kombination erstellen					*/
/****************************************************************/
/*	Return:	Kombinationsstring				*/
/****************************************************************/

char *kombination(dat,zugkomb)

SPDAT 	*dat;					/* Spieldaten		*/
WORD	zugkomb[];				/* Zugkombination 	*/
{
	SPDAT		copy;			/* Kopie der Spieldaten	*/
	SPDAT		*cdat;			/* Zeiger auf Kopie	*/
	WORD		zug;
	static char	str[STRLEN];		/* String		*/
	int		i;

	str[0]=0;				/* loeschen		*/

	cdat= &copy;				/* Zeiger bestimmen	*/

	if(dat == (SPDAT *)0)
		init(cdat,1);
	else
	{
		for(i=0;i<GROE;i++)		/* kopieren		*/
			cdat->brett[i]=dat->brett[i];

		cdat->wkpos	= dat->wkpos;
		cdat->skpos	= dat->skpos;
		cdat->farbe	= dat->farbe;
		cdat->lzug      = dat->lzug;
		cdat->zuege	= dat->zuege;
	}

	i=0;
	while((zug=zugkomb[i])!=(WORD)0 && i<MAXTIEFE)	
						/* Ende ?		*/
	{
		cdat->minstufe=spdat.minstufe;	/* damit Koenigsbedro.	*/
		cdat->maxstufe=spdat.maxstufe;	/* ueberprueft wird	*/

		if(!zug_test(cdat,zugkomb[i]))	/* illegaler Zug ?	*/
			break;

		sprintf(str+strlen(str),"%s%c",	/* String aufbereiten	*/
		wandle(_apos(zug),(BYTE)0),
		_istlee(cdat->brett[_npos(zug)]) ? '-':'x');

		sprintf(str+strlen(str),"%s",
		wandle(_npos(zug),(BYTE)0));

		ziehe(cdat,zugkomb[i++]);	/* ziehen		*/

		if(cdat->farbe==WEI)
			if(bedrohung(cdat,cdat->wkpos))
				strcat(str,"+");/* wei. Koenig bedroht	*/

		if(cdat->farbe==SCH)
			if(bedrohung(cdat,cdat->skpos))
				strcat(str,"+");/* schw. Koenig bedroht	*/

		strcat(str," ");		/* Trennzeichen		*/
	}

	str[strlen(str)-1]=0;			/* beenden		*/

	return(str);
}
