/****************************************************************/
/*								*/
/*	XChess V2.7: Status					*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "ch.h"			/* Def. des Schachspiels */
#include "ph.h"			/* Spielphase		 */

/****************************************************************/
/*	Status bestimmen					*/
/****************************************************************/

void	status_aus(dat,ret)

SPDAT 	*dat;				/* Spieldaten		*/
char	*ret[];				/* Antworten		*/
{
	int	anz;			/* Zaehler		*/
	char	bed;			/* Bedrohung		*/
	int 	i;

	eff_stufe(dat);			/* Phasenerkennung	*/

	/*--- Test auf 3-fache Wiederholung --------------------*/

	for(i=dat->zuege;i>=0;i--)	/* Wdh. finden		*/
		if(archiv[i]->wdh != -1)
		if(archiv[archiv[i]->wdh]->wdh!= -1)
			break;		/* gefunden		*/

	if(i > -1)			/* 3-fache Wiederholung	*/
	{
		sprintf(ret[zaehler++],"3");
		return;
	}

	/*--- Test, ob Koenige fehlen ---------------------------*/

	if(dat->wkpos==(BYTE)0 && dat->skpos==(BYTE)0)
	{
		strcpy(ret[zaehler++],"r");	/* Remis 		*/
		return;
	}
	else if(dat->wkpos==(BYTE)0)
	{
		strcpy(ret[zaehler++],"mw");	/* Weiss ist matt	*/
		return;
	}
	else if(dat->skpos==(BYTE)0)
	{
		strcpy(ret[zaehler++],"ms");	/* Schwarz ist matt	*/
		return;
	}

	/*--- Spielphase auf Remis untersuchen -----------------*/

	if(phase==REMIS)
	{
		strcpy(ret[zaehler++],"r");
		return;
	}

	/*--- Test auf Matt und Patt und Schach ----------------*/

	anz=zugliste(dat,(BYTE)0);	/* Zuege bestimmen	*/

	if(dat->farbe==WEI && bedrohung(dat,dat->wkpos))
		bed='w';
	else if(dat->farbe==SCH && bedrohung(dat,dat->skpos))
		bed='s';
	else
		bed='\0';

	if(!anz)			/* Matt oder Patt ?	*/
	{
		if(bed=='\0')		/* Patt ?		*/
			strcpy(ret[zaehler++],"p");

		else			/* Matt 		*/
			sprintf(ret[zaehler++],"m%c",bed);
	}
	else				/* nur Schach oder nix	*/
		sprintf(ret[zaehler++],"%c",bed);
}
