/****************************************************************/
/*								*/
/*	XChess V2.7: Zug ausfuehren				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include "ch.h"			/* Def. des Schachspiels */

/****************************************************************/
/*	Zug ausfuehren						*/
/****************************************************************/
/*	Return:	1: es wurde Rochiert oder e.p. geschl.		*/
/****************************************************************/

int	ziehe(dat,zug)

SPDAT	*dat;				/* Spieldaten 	*/
WORD	zug;				/* auszuf. Zug	*/
{
	BYTE	afig;			/* alte Figur	*/
	BYTE	npos,apos;		/* neue und alte Pos.	*/
	int	epro=0;			/* falls ep. od. Roch.	*/

					/* Status des letzten Zuges:	*/
	schlag=0;			/* falls 1 wurde geschlagen	*/
					/* oder befoerdert		*/
	gabel=0;			/* Bauernspiess oder		*/
					/* Springergabel		*/

	npos=_npos(zug);		/* Pos. berechnen	*/
	apos=_apos(zug);

	afig=dat->brett[apos];		/* alte Figur holen	*/

	switch(_figur(afig))   		/* Umwandlungen ?	*/
	{
	case BAU:			/* Befoerderung		*/
		if(_istspz(dat->brett[npos+ZLEN]))
		{
			afig=DAM|WEI;
			schlag=1;
		}
		else if(_istspz(dat->brett[npos-ZLEN]))
		{
			afig=DAM|SCH;
			schlag=1;
		}
					/* schlagen en passant	*/
		else if(_istlee(dat->brett[npos]))
			switch((short)npos-(short)apos)
			{
			case 13:	/* rechts loeschen	*/
			case -11:
				dat->brett[apos+1]=LEE;
				schlag=1;
				epro=1;
				break;

			case 11:	/* links loeschen	*/
			case -13:
				dat->brett[apos-1]=LEE;
				schlag=1;
				epro=1;
				break;
			}

		switch((short)npos-(short)apos)
		{
		case 12:	/* Bauernspiess	weiss ?	*/
			if(_istnsch(dat->brett[npos+13]) &&
			  !_istbau(dat->brett[npos+13]) &&
			   _istnsch(dat->brett[npos+11]) &&
			  !_istbau(dat->brett[npos+11]))
				gabel=1;
			break;

		case -12:	/* Bauernspiess	schwarz ?*/
			if(_istnwei(dat->brett[npos-13]) &&
			  !_istbau(dat->brett[npos-13]) &&
			   _istnwei(dat->brett[npos-11]) &&
			  !_istbau(dat->brett[npos-11]))
				gabel=1;
			break;
		}
		break;

	case XBAU:			/* Spezialfig. normal	*/
		afig=BAU | _farbe(afig);
		switch((short)npos-(short)apos)
		{
		case 12:	/* Bauernspiess	weiss ?	*/
			if(_istnsch(dat->brett[npos+13]) &&
			  !_istbau(dat->brett[npos+13]) &&
			   _istnsch(dat->brett[npos+11]) &&
			  !_istbau(dat->brett[npos+11]))
				gabel=1;
			break;

		case -12:	/* Bauernspiess	schwarz ?*/
			if(_istnwei(dat->brett[npos-13]) &&
			  !_istbau(dat->brett[npos-13]) &&
			   _istnwei(dat->brett[npos-11]) &&
			  !_istbau(dat->brett[npos-11]))
				gabel=1;
			break;
		}
		break;

	case XTUR:
		afig=TUR | _farbe(afig);
		break;

	case XKOE:
		afig=KOE | _farbe(afig);

		if((short)npos-(short)apos==2)	/* kurze Rochade	*/
		{
			epro=1;
			dat->brett[apos+1]=TUR | _farbe(afig);
			dat->brett[npos+1]=LEE;
		}
		if((short)npos-(short)apos==-2)	/* lange Rochade	*/
		{
			epro=1;
			dat->brett[apos-1]=TUR | _farbe(afig);
			dat->brett[npos-2]=LEE;
		}

	case KOE:				/* Koenigspositionen	*/
		if(_istwei(afig))
			dat->wkpos=npos;
		else
			dat->skpos=npos;
		break;
	}

	if(!_istlee(dat->brett[npos]))		/* schlagen ?		*/
	{
		schlag=1;
		if(_istkoe(dat->brett[npos]))	/* Koenig geschlagen ? 	*/
						/* (theor., d.h. matt)	*/
		{
			if(_istwei(dat->brett[npos]))
				dat->wkpos=(BYTE)0;	/* loeschen	*/
			else
				dat->skpos=(BYTE)0;	/* loeschen	*/
		}
	}
	dat->brett[apos]=LEE;			/* loeschen		*/
	dat->brett[npos]=afig;			/* neu setzen		*/
	dat->farbe=dat->farbe==WEI ? SCH:WEI;	/* Farbe aendern	*/
	dat->lzug=zug;				/* letzter Zug		*/
	dat->zuege++;				/* ein Zug mehr		*/

	return(epro);
}

/****************************************************************/
/*	Zug testen						*/
/****************************************************************/
/*	Return: 1: Zug moeglich,    0: nicht mgl.		*/
/****************************************************************/

int	zug_test(dat,zug)

SPDAT 	*dat;				/* Spieldaten		*/
WORD 	zug;				/* zu testender Zug	*/
{
	int 	anz;			/* Anzahl der Zuege	*/

	if(dat->zuege+5 >= MAXSP)	/* Grenze erreicht	*/
		return(0);		/* +5 ist Sicherheit	*/

	anz=zugliste(dat,_apos(zug));	/* Liste holen		*/

	while(--anz>=0)			/* alle testen		*/
		if(zug==dat->zlist[anz])
			return(1);

	return(0);                	/* nicht gefunden	*/
}
