/****************************************************************/
/*								*/
/*	XChess V2.7: Zugliste					*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include "ch.h"			/* Def. des Schachspiels */

static void add();
static void zugliste2();

/****************************************************************/
/*	Zugliste erstellen					*/
/****************************************************************/
/*	Return:	Anzahl der Zuege				*/
/****************************************************************/

int	zugliste(dat,pos)

SPDAT	*dat;				/* Spieldaten	*/
BYTE	pos;				/* Position	*/
{
	int	 nr=0;			/* Anzahl der Zuege	*/
	register int	i,j;		/* Zaehler		*/

	dat->zlist[0]=0;		/* loeschen			*/

	if(pos)                      	/* nur ein Feld ?		*/
		zugliste2(dat,pos,&nr);
	else
	{
		if(dat->farbe==SCH)	/* Schwarz von unten nach oben	*/
		for(j=0;j<8;j++)	/* alle Felder durchgehen	*/
		for(i=0;i<8;i++)
			if(!_istlee(dat->brett[pos=
			(BYTE)((j+RAND)*ZLEN+i+RAND)]))
				zugliste2(dat,pos,&nr);

		if(dat->farbe==WEI)	/* Weiss von oben nach unten	*/
		for(j=7;j>=0;j--)	/* alle Felder durchgehen	*/
		for(i=0;i<8;i++)
			if(!_istlee(dat->brett[pos=
			(BYTE)((j+RAND)*ZLEN+i+RAND)]))
				zugliste2(dat,pos,&nr);
	}

	return(nr);
}

static	void	zugliste2(dat,posa,nr)

SPDAT		*dat;			/* Spieldaten		*/
register BYTE	posa;			/* alte Position	*/
int 		*nr;            	/* Zugzaehler		*/
{
	static short wzuege[][12] =	/* Weisse Zuege		*/
	{
		{0,0},
		/* Bauerzuege		*/
		{2,11,13,12,0},
		/* X Bauerzuege 	*/
		{2,11,13,12,24,0},
		/* Springerzuege	*/
		{0,14,25,23,10,-14,-25,-23,-10,0},
		/* Laeuferzuege 	*/
		{1,13,11,-13,-11,0},
		/* Turmzuege 		*/
		{1,1,12,-1,-12,0},
		/* X Turmzuege	 	*/
		{1,1,12,-1,-12,0},
		/* Damenzuege 		*/
		{1,1,13,12,11,-1,-13,-12,-11,0},
		/* Koenigzuege 		*/
		{0,1,13,12,11,-1,-13,-12,-11,0},
		/* X Koenigzuege 	*/
		{3,2,-2,1,13,12,11,-1,-13,-12,-11,0}
	};

	static short szuege[][12] =	/* Schwarze Zuege	*/
	{
		{0,0},
		/* Bauerzuege		*/
		{2,-11,-13,-12,0},
		/* X Bauerzuege 	*/
		{2,-11,-13,-12,-24,0},
		/* Springerzuege	*/
		{0,14,25,23,10,-14,-25,-23,-10,0},
		/* Laeuferzuege 	*/
		{1,13,11,-13,-11,0},
		/* Turmzuege 		*/
		{1,1,12,-1,-12,0},
		/* X Turmzuege	 	*/
		{1,1,12,-1,-12,0},
		/* Damenzuege 		*/
		{1,1,13,12,11,-1,-13,-12,-11,0},
		/* Koenigzuege 		*/
		{0,1,13,12,11,-1,-13,-12,-11,0},
		/* X Koenigzuege 	*/
		{3,2,-2,1,13,12,11,-1,-13,-12,-11,0}
	};

	short	(*zuege)[12];		/* effektive Zugliste	*/

	/* ^ alle Zuege fuer RAND = 2	*/

	register BYTE	fig;			/* Figur		*/
	register BYTE	k;			/* Zaehler		*/
	register BYTE	posn;			/* neue Position	*/
	register short	zug;			/* aktueller Zug	*/

	fig=dat->brett[posa];			/* Figur holen	*/

	if(_farbe(fig) != dat->farbe)		/* falsche Farbe ? */
		return;

	if(dat->farbe == WEI)			/* eff. Zugl. best.*/
		zuege=wzuege;
	else
		zuege=szuege;

	switch(zuege[_figur(fig)][0])
	{
	case 0:				/* keine Wiederholung	*/
		for(k=1;zug=zuege[_figur(fig)][k];k++)
					/* alle Zuege durchg.	*/
		{
			posn=(BYTE)((short)posa+zug);

			if(!(dat->farbe & _farbe(dat->brett[posn])))
				add(dat,nr,posa,posn);
					/* Zug anhaengen	*/
		}
		break;
	case 1:				/* wiederholen		*/
		for(k=1;zug=zuege[_figur(fig)][k];k++)
					/* alle Zuege durchg.	*/
		{
			posn=(BYTE)((short)posa+zug);

			while(_istlee(dat->brett[posn]))
			{
				add(dat,nr,posa,posn);
					/* Zug anhaengen	*/
				posn= (BYTE)((short)posn+zug);
			}

			if(!(dat->farbe&_farbe(dat->brett[posn])))
				add(dat,nr,posa,posn);
					/* Zug anhaengen	*/
		}
		break;
	case 2:				/* Bauer		*/
		for(k=1;zug=zuege[_figur(fig)][k];k++)
					/* alle Zuege durchg.	*/
		{
			posn=(BYTE)((short)posa+zug);
			if(k<=2)	/* nur schlagen		*/
			{
			if(_istlee(dat->brett[posn]))
			/* Feld leer, schlagen nur e.p. mgl.	*/
			{
			int nb,f2,bz;

			nb =  		/* Figur neben Bauer	*/
				(short)_npos(dat->lzug)
				- (short)posa==1 ||
				(short)_npos(dat->lzug)
				- (short)posa==-1
				;
			f2 =  		/* letzter Zug 2 Felder	*/
				(short)_apos(dat->lzug)
				- (short)_npos(dat->lzug)==24 ||
				(short)_apos(dat->lzug)
				- (short)_npos(dat->lzug)==-24
				;
			bz =	     /* letzter zu Bauer	*/
				_istbau(dat->brett[_npos(dat->lzug)])
				;
			if(!(nb && f2 && bz))
			/* nicht e.p., also Abbruch		*/
				continue;
			}
			}
			else		/* nicht schlagen	*/
			if(!_istlee(dat->brett[posn]))
				break;

			if(!(dat->farbe & _farbe(dat->brett[posn])))
				add(dat,nr,posa,posn);
					/* Zug anhaengen	*/
		}
		break;
	case 3:				/* X Koenig		*/
		for(k=1;zug=zuege[_figur(fig)][k];k++)
					/* alle Zuege durchg.	*/
		{
			posn=(BYTE)((short)posa+zug);

			if(k==1)	/* Rochade rechts	*/
			{
				if(!_istlee(dat->brett[posa+1]))
					continue;
				if(!_istxtur(dat->brett[posa+3]))
					continue;
				if(bedrohung(dat,posa+1))
					continue;
				if(bedrohung(dat,posa))
					continue;
			}

			if(k==2)	/* Rochade links	*/
			{
				if(!_istlee(dat->brett[posa-1]))
					continue;
				if(!_istlee(dat->brett[posa-3]))
					continue;
				if(!_istxtur(dat->brett[posa-4]))
					continue;
				if(bedrohung(dat,posa-1))
					continue;
				if(bedrohung(dat,posa))
					continue;
			}

			if(!(dat->farbe & _farbe(dat->brett[posn])))
				add(dat,nr,posa,posn);
					/* Zug anhaengen	*/
		}
		break;
	}
}

static 	void	add(dat,nr,posa,posn)

SPDAT	*dat;				/* Spieldaten	*/
int	*nr;				/* Anzahl der eingetragen Zuege	*/
BYTE	posa,posn;			/* alte und neue Position	*/
{
	/* Bedrohung ueberpruefen bis minimale Rechentiefe		*/
	if((mode&16) || /* Bedrohung immer ueberpruefen ? 		*/
	(spdat.maxstufe-dat->maxstufe < spdat.minstufe))
	/* ^ Falsche Berechnung beim Vorsortieren, daher dort mode|=16	*/
	{
		BYTE figa,fign,pos;
		/* zieht Koenig selbst ? */
		if(posa==dat->wkpos || posa==dat->skpos)
			pos=posn;
		else if(dat->farbe==WEI)
			pos=dat->wkpos;
		else
			pos=dat->skpos;

		figa=dat->brett[posa];		/* retten		*/
		fign=dat->brett[posn];

		dat->brett[posa]=LEE;		/* ziehen		*/
		dat->brett[posn]=figa;

		if(bedrohung(dat,pos))
		{
			dat->brett[posa]=figa;	/* zuruecknehmen	*/
			dat->brett[posn]=fign;
			return;			/* Koenig bedroht	*/
		}

		dat->brett[posa]=figa;		/* zuruecknehmen	*/
		dat->brett[posn]=fign;
	}

	dat->zlist[(*nr)++]= posa+((WORD)posn<<8);	/* eintragen	*/
	dat->zlist[*nr]= 0;				/* beenden	*/
}

/****************************************************************/
/*	Zugliste sortieren					*/
/****************************************************************/
/*	Return:	Anzahl der Zuege				*/
/****************************************************************/

int	sortliste(dat,stufe)

SPDAT	*dat;				/* Spieldaten		*/
int	stufe;				/* Vorsortierstufe	*/
{
	int	anz;			/* Anzahl der Zuege	*/
	int	minc,maxc;		/* Kopien der Stufen	*/
	int	modec;			/* Kopie des Modus	*/
	int	i,j;            	/* Zaehler		*/
	long	bew;                   	/* Bewertung		*/
	WORD	zug;			/* Zug			*/
	WORD	bzug[MAXTIEFE];		/* beste Kombination	*/

	minc=dat->minstufe;		/* Stufen retten	*/
	maxc=dat->maxstufe;
	modec=mode;

	dat->minstufe=stufe;	/* Sortierstufen	*/
	dat->maxstufe=stufe;
	mode |= 16;		/* Koenigsbedr. immer Ueberpruefen	*/

	comp_zug(dat,dat->farbe==WEI ? MATT:-MATT,bzug);

	if(beende)			/* Beenden ?		*/
		return(0);

	dat->minstufe=minc;		/* wieder herstellen	*/
	dat->maxstufe=maxc;
	mode=modec;

	for(anz=0;dat->zlist[anz]!=(WORD)0;anz++)/* Anzahl bestimmen	*/
		;

	for(i=0  ;i<anz-1;i++)			/* sortieren		*/
	for(j=i+1;j<anz  ;j++)
		if(dat->farbe==WEI ?
		dat->blist[i]<dat->blist[j] : dat->blist[i]>dat->blist[j])
		{
			bew		=dat->blist[i];
			dat->blist[i]	=dat->blist[j];
			dat->blist[j]	=bew;
			zug		=dat->zlist[i];
			dat->zlist[i]	=dat->zlist[j];
			dat->zlist[j]	=zug;
		}

	return(anz);
}
