/****************************************************************/
/*								*/
/*	XChess V2.7: Initialisierungen				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include "ch.h"			/* Def. des Schachspiels */
#include <string.h>
#include <stdio.h>      	/* Standart IO */

extern	long	time();
extern	void	exit();
extern	char	*malloc();
extern	char	*memcpy();
extern	void	free();
extern	void	srand();

/****************************************************************/
/*	Initialisierungen					*/
/****************************************************************/

void	init(dat,modus)

SPDAT 	*dat;		/* Spieldaten	*/
int	modus;		/* 1=initialisieren, sonst nur loeschen	*/
{
	static 	first=1;
	BYTE	i,j;		/* Zaehler 	*/

	static BYTE initbrett[8][8] =
	{
XTUR+WEI,SPR +WEI,LAE +WEI,DAM +WEI,XKOE+WEI,LAE +WEI,SPR +WEI,XTUR+WEI,
XBAU+WEI,XBAU+WEI,XBAU+WEI,XBAU+WEI,XBAU+WEI,XBAU+WEI,XBAU+WEI,XBAU+WEI,
LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,
LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,
LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,
LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,LEE     ,
XBAU+SCH,XBAU+SCH,XBAU+SCH,XBAU+SCH,XBAU+SCH,XBAU+SCH,XBAU+SCH,XBAU+SCH,
XTUR+SCH,SPR +SCH,LAE +SCH,DAM +SCH,XKOE+SCH,LAE +SCH,SPR +SCH,XTUR+SCH,
	};

	if(first)		/* nur einmal ausfuehren	*/
	{
		srand((unsigned)time((long *)0));
					/* Zufallsgenerator	*/
		for(i=0;i<MAXSP;i++)	/* loeschen		*/
			archiv[i]=(ARCHIV *)0;

		load_open();		/* Eroeffnungen laden	*/
		first=0;
	}

	for(i=0;i<GROE;i++)	/* Brett mit Spezialfiguren besetzen */
		dat->brett[i]=SPZ;

	if(modus==1)			/* Initialisieren ?	*/
	{
		for(j=0;j<8;j++)		/* aufbauen	*/
			for(i=0;i<8;i++)
				dat->brett[(j+RAND)*(8+2*RAND)+i+RAND]=
				initbrett[j][i];

		dat->wkpos=2*ZLEN+RAND+4;	/* Koenigspsoitionen	*/
		dat->skpos=(2+7)*ZLEN+RAND+4;
	}
	else					/* Brett loeschen	*/
	{
		for(j=0;j<8;j++)
			for(i=0;i<8;i++)
				dat->brett[(j+RAND)*(8+2*RAND)+i+RAND]=LEE;

		noop=0;		/* Bib. schliessen	*/

		dat->wkpos=(BYTE)0;	/* Koenigspsoitionen	*/
		dat->skpos=(BYTE)0;
	}

	dat->farbe 	=WEI;			/* Weiss beginnt	*/
	dat->lzug  	=(WORD)0;		/* letzter Zug		*/
	dat->zuege	=0;			/* Kein Zug bis jetzt	*/
	dat->wert	=bewerte(dat,(BYTE)0);	/* Bewerten		*/
	dat->vorher	=(SPDAT *)0;		/* kein Datensatz davor	*/

	if(dat==&spdat)
	{
		varprosek=0L;			/* Varianten pro Sekunde*/
		varianten=0L;			/* Varianten gesamt	*/
		zeit=0L;			/* Rechenzeit		*/
		compzuege=0;			/* Computerzuege	*/
		noop=OPTRYS;			/* Eroeffnungen zulassen*/

		for(i=0;i<MAXSP;i++)		/* Speicher freigeben	*/
			if(archiv[i]!=(ARCHIV *)0)
			{
				free(archiv[i]);
				archiv[i]=(ARCHIV *)0;
			}

		archiviere(&spdat);		/* archivieren 		*/
	}
}

/************************************************************************/
/*      Eroeffnungen laden                                              */
/************************************************************************/

void	load_open()

{
	FILE 	*fp;          		/* Filepointer 		*/
	char 	str[200*5];             /* String zum einlesen	*/
	char	str2[5];		/* String mit einem Zug	*/
	WORD	open[200];		/* Array mit Eroeffnung	*/
	BYTE	farbe;	/* Farbe fuer die die Eroeffnung gilt	*/
	int i,j;

	if((fp=fopen("chess.op","r"))==(FILE *)0)         /* oeffnen	*/
		exit(1);                                /* Fehler 	*/

	opnr=0;                         /* noch keine Eroeffnung 	*/

	while(feof(fp)==0 && opnr < MAXOP)		/* Ende ?	*/
        {
		fgets(str,999,fp);      /* einlesen 	*/

                i=0;
		while(str[i]!='#' && str[i]!='\n' && str[i]!=0)
			i++;

		str[i]=0;               /* beenden 	*/

		if(!strlen(str))	/* Leerzeile  ?	*/
			continue;

		farbe=(BYTE)0;

		i=0;j=0;
		while(i<strlen(str))
                {
			if(str[i]==' ' || str[i]==TAB || str[i]==';'
			|| str[i]==',' || str[i]=='.' || str[i]==':')
			{
				i++;
				continue;
			}

			if(str[i]=='W')		/* Komb. fuer Weiss ?	*/
			{
				farbe |= WEI;
				i++;
				continue;
			}

			if(str[i]=='B')		/* Komb. fuer Schwarz ?	*/
			{
				farbe |= SCH;
				i++;
				continue;
			}

			strncpy(str2,str+i,4);		/* Zug holen	*/
			str2[4]=0;			/* beenden	*/

			open[j]=wandle_inv(str2);	/* umwandeln	*/
			if(open[j]==(WORD)0)      	/* Fehler ? 	*/
                		open[j]=wandle_inv("a1a1");
						/* unmoeglicher Zug	*/

			j++;
			i += 4;			/* naechster Zug	*/
		}

		open[j]=(WORD)0;			/* beenden	*/

		op[opnr]=(WORD *)malloc((unsigned)sizeof(WORD)*(j+1));
		if(op[opnr]==(WORD *)0)		/* Fataler Fehler	*/
			exit(1);

		op_fa[opnr]=farbe;
		memcpy((char *)op[opnr++],(char *)open,
		(int)sizeof(WORD)*(j+1));/* kopieren	*/
	}

	fclose(fp);                		   	/* schliessen 	*/

	for(i=opnr;i<MAXOP;i++)				/* loeschen	*/
		op[i]=(WORD *)0;
}
