/****************************************************************/
/*								*/
/*	XChess V2.7: Computerzug				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

#include "ch.h"			/* Def. des Schachspiels 	*/

#ifdef	ANALYSE
static void monitor();
#endif

/****************************************************************/
/*	Computerzug bestimmen					*/
/****************************************************************/
/*	Return:	Bewertung des Zugs				*/
/****************************************************************/

long	comp_zug(dat,erw,bzug)

SPDAT 	*dat;					/* Spieldaten		*/
long	erw;					/* Erwartungswert	*/
WORD	bzug[];					/* beste Zugkombination */ 
{
	SPDAT		copy;			/* Kopie der Spieldaten	*/
	SPDAT		*cdat;			/* Zeiger auf Kopie	*/
	WORD		bzugliste[MAXZUG][MAXTIEFE];
						/* Liste der Zugkomb.	*/
	long		wert,maxwert;		/* Bewertung 		*/
	int		anz=0,best=0;		/* Zaehler, bester Zug	*/
	register	i,j,k;			/* Zaehler		*/
	WORD		azug=0,nzug;		/* alter und neuer Zug	*/

	if(mode&4 && dat->minstufe >= 2)	/* Vorsortieren ?	*/
		anz=sortliste(dat,dat->minstufe-1);
	else
		anz=zugliste(dat,(BYTE)0);

	if(!anz)
	{
		/* MATT */
		if(dat->farbe==WEI)
			if(bedrohung(dat,dat->wkpos)||dat->wkpos==(BYTE)0)
				return(-MATT);

		if(dat->farbe==SCH)
			if(bedrohung(dat,dat->skpos)||dat->skpos==(BYTE)0)
				return(MATT);

		/* PATT */
		return(0L);		/* unentschieden	*/
	}

	cdat= &copy;			/* Zeiger bestimmen	*/

	maxwert=dat->farbe==WEI?-2*MATT:2*MATT;/* min. Bewertung	*/
	/* 2 * matt damit mindestens ein Zug bei sicherem Matt aus-	*/
	/* gegeben wird.						*/

	for(i=0;i<anz;i++)		/* alle Zuege durchgehen	*/
	{
		/* alles wichtige kopieren	*/

		if(azug)		/* nur Veraenderungen kopieren	*/
		{
			BYTE ap,np;

			ap=_apos(azug);
			np=_npos(azug);

			cdat->brett[ap] = dat->brett[ap];
			cdat->brett[np] = dat->brett[np];
		}
		else			/* 1. Kopie ?	*/
			for(j=0;j<GROE;j++)
				cdat->brett[j]=dat->brett[j];

		cdat->wkpos	=dat->wkpos;
		cdat->skpos	=dat->skpos;
		cdat->farbe	=dat->farbe;
		cdat->lzug      =dat->lzug;
		cdat->zuege	=dat->zuege;
		cdat->minstufe	=dat->minstufe-1;	/* Stufe weniger*/
		cdat->maxstufe	=dat->maxstufe-1;
		cdat->vorher	=dat;			/* letzter Zug	*/

		/**** Bewertungs-Algorithmus ***/

		if(!ziehe(cdat,nzug=dat->zlist[i]))	/* ziehe	*/
		{				/* Differenz bewerten	*/
			long	add;

			add = -bewerte(dat,_apos(nzug));

			if(!_istlee(dat->brett[_npos(nzug)]))
							/* geschl. ?	*/
				add -= bewerte(dat,_npos(nzug));

			add += bewerte(cdat,_npos(nzug));

			azug=nzug;		/* Zug merken		*/

			add = (add*(20L+(long)cdat->maxstufe))/20L;
			/* ^ addiert fuer jede Stufe 5 % des Wertes.	*/
			/* Dient dazu, dass gute Zuege zuerst		*/
			/* ausgefuehrt werden.				*/

			cdat->wert = dat->wert + add;
		}
		else				/* komplett bewerten	*/
		{
			azug=(WORD)0;
			cdat->wert = bewerte(cdat,(BYTE)0);
		}

		/**** STUFE ERHOEHEN fuer spezielle Zuege	****/

 		if(cdat->minstufe <= 0)	/* 1 oder 2 Stufen erweitern ?	*/
		{
		if(cdat->maxstufe > 0)
		{
			if(schlag)	/* geschlagen oder Befoerderung	*/
				cdat->minstufe++; /* eine Stufe mehr	*/
			if(gabel)	/* Gabel oder Spiess gefunden 	*/
				cdat->minstufe+=2; /* 2 Stufen mehr	*/
		}
		}
		else if(cdat->minstufe <= 1) /* 1 Stufe erweitern ? 	*/
		{
		if(cdat->maxstufe > 1)
			if(gabel)	/* Gabel oder Spiess gefunden 	*/
				cdat->minstufe++; /* 1 Stufe mehr	*/
		}

		/**** ENDE STUFE ERHOEHEN fuer spezielle Zuege	****/

		if(mode & 128)			/* einfache Analyse ?	*/
			bzugliste[i][1]=(WORD)0;/* loeschen		*/

		if((&spdat==dat || &spdat==dat->vorher) /* 1. oder 2. Zug */
		&& (dat->maxstufe != dat->minstufe)) /* nicht Vorsortierung */
		{					/* 3fache Wdh ?	*/
			for(j=spdat.zuege;j>=0;j--)	/* Wdh. finden	*/
			if(archiv[j]->wdh != -1)
			{
				for(k=0;k<GROE;k++)
					if(cdat->brett[k]!=archiv[j]->brett[k])
						break;

				if(k==GROE)
					break;	/* gefunden		*/
			}

			if(j > -1)		/* 3-fache Wiederholung	*/
				wert=0L;	/* Remis		*/
			else
				wert=comp_zug(cdat,maxwert,&bzugliste[i][1]);
		}
		else if(cdat->minstufe<=0)	/* Keine Stufe weiter ?	*/
		{
			varianten++;	  	/* Eine Variante mehr	*/
			wert=cdat->wert		/* Keine Stufe weiter	*/
			+(rand()&0x7)-4;	/* Zufallskomponente 	*/
		}
		else				/* Eine Stufe weiter	*/
			wert=comp_zug(cdat,maxwert,&bzugliste[i][1]);

		dat->blist[i]=wert;		/* Bewertungsliste	*/

		/**** ENDE Bewertungs-Algorithmus ****/

		/**** MINIMAX-Algorithmus ****/

		if(beende)			/* beenden ?		*/
			break;
		else if(dat->farbe==WEI)  	/* beste Bew. best.	*/
		{
			if(maxwert<wert)
			{
			maxwert=wert;
			best=i;

			/* Bester Zug bis jetzt	*/
			if(dat == &spdat)
				best_so_far=nzug;

#ifdef	ANALYSE		/* Monitorfunktion: einfache Analyse	*/
			if(mode & 128 && dat == &spdat)
			{
				char str[STRLEN];

				bzugliste[i][0]=nzug;
				strcpy(str,kombination(dat,bzugliste[i]));
				sprintf(str+strlen(str)," %ld",maxwert);
				ANALYSE(str);
			}				/* ausgeben	*/
#endif
			}
		}
		else
		{
			if(maxwert>wert)
			{
			maxwert=wert;
			best=i;

			/* Bester Zug bis jetzt	*/
			if(dat == &spdat)
				best_so_far=nzug;

#ifdef	ANALYSE		/* Monitorfunktion: einfache Analyse	*/
			if(mode & 128 && dat == &spdat)
			{
				char str[STRLEN];

				bzugliste[i][0]=nzug;
				strcpy(str,kombination(dat,bzugliste[i]));
				sprintf(str+strlen(str)," %ld",maxwert);
				ANALYSE(str);
			}				/* ausgeben	*/
#endif
			}
		}

		/**** Ende MINIMAX ****/

		/**** ALPHA-BETA - Abschneidung	****/

		if(wert >= erw && dat->farbe==WEI && mode&2)
		{
#ifdef	ANALYSE
			if(mode & 1)	/* Monitorfunktion	*/
				monitor(cdat,wert,"Abbruch");
#endif
			break;
		}
		else if(wert <= erw && dat->farbe==SCH && mode&2)
		{
#ifdef	ANALYSE
			if(mode & 1)	/* Monitorfunktion	*/
				monitor(cdat,wert,"Abbruch");
#endif
			break;
		}

		/**** Ende ALPHA-BETA - Algorithmus	****/

#ifdef	ANALYSE
		if(mode & 1)
			monitor(cdat,wert,"");	/* Monitorfunktion	*/
#endif
	}

	if(beende)			/* Beenden ?	*/
		if(dat == &spdat)	/* Bester Zug	*/
			dat->bzug=best_so_far;

	dat->bzug = dat->zlist[best];		/* besten Zug eintragen	*/

#ifdef	ANALYSE		/* Monitorfunktion: einfache Analyse	*/
	if(mode & 128)	/* einfache Analyse ?	*/
	{
		bzug[i=0]=dat->bzug;			/* merken	*/
		while(bzugliste[best][++i]!=(WORD)0)
			bzug[i]=bzugliste[best][i];	/* kopieren	*/
		bzug[i]=(WORD)0;			/* beenden	*/
	}
#endif

	return(maxwert);			/* beste Bewertung	*/
}

#ifdef	ANALYSE
static void monitor(dat,wert,text)

SPDAT 	*dat;
long	wert;
char	*text;
{
	SPDAT 	*ptr;		/* vorheriger Datensatz	*/
	int 	i=0;      	/* Zaehler		*/
	SPDAT	*ptrlist[20];	/* Liste mit allen Pointern	*/
	char	str[STRLEN];	/* String		*/

	ptr=dat;		/* letzte Daten		*/
	str[0]=0;		/* loeschen		*/

	while(ptr->vorher != (SPDAT *)0) /* zum Anf.	*/
	{
		ptrlist[i++]=ptr;
		ptr= ptr->vorher;
	}

	while(--i>=0)		/* String erstellen	*/
	{
		sprintf(str+strlen(str),"%s%c",
		wandle(_apos(ptrlist[i]->lzug),(BYTE)0),
		_istlee(ptrlist[i]->vorher->
		brett[_npos(ptrlist[i]->lzug)]) ? '-':'x');

		sprintf(str+strlen(str),"%s ",
		wandle(_npos(ptrlist[i]->lzug),(BYTE)0));
	}

puts(str);
	printf(/*str+strlen(str),*/" %ld %s",wert,text);
puts("");
	/*ANALYSE(str);		/* ausgeben		*/
}
#endif
