/****************************************************************/
/*								*/
/*	Includefile fuer XChess	V2.7				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/****************************************************************/

/* Diverse Definitionen	*/

#define MAXOP		5000			/* Max. Eroeffnungszahl	*/
#define	OPTRYS		10			/* Zugriffsversuche	*/
#define	MAXSP		200			/* Max. Zuganzahl	*/
#define MAXTIEFE	10			/* Max. Rechentiefe	*/
#define STRLEN		81			/* Laenge von Strings	*/
#define	RAND		2			/* Offset vom Spielfeld */
#define ZLEN		12			/* Zeilenlaenge		*/
#define GROE		144			/* Spielfeldgroesse =	*/
						/* (8+2*RAND)^2		*/
#define MAXZUG		200			/* Max. Zugmgl. in zlist*/
#define MATT		1000000L		/* schlechteste Bew.	*/
#define TAB		(char)9			/* Tabulator		*/

typedef	unsigned char	BYTE;			/* sinnvolle Typen 	*/
typedef unsigned short	WORD;
typedef unsigned long	LWORD;

typedef struct spieldaten			/* Spieldatenstruktur 	*/
{
	BYTE	brett[GROE];			/* Spielfeld 		*/
	BYTE	wkpos,skpos;			/* Koenigsposition	*/
	WORD	zlist[MAXZUG];			/* Zugliste		*/
	long	blist[MAXZUG];			/* Bewertungsliste	*/
	WORD	bzug;				/* beste Zugfolge	*/
	WORD	lzug;				/* letzter Zug		*/
	int	zuege;				/* Anz. der Zuege	*/
	BYTE	farbe;				/* Farbe am Zug		*/
	long	wert;				/* Wert der Stellung	*/
	int	minstufe,maxstufe;		/* Spielstufe		*/
	struct	spieldaten *vorher;		/* Ptr auf Zug davor 	*/
} SPDAT;

typedef struct archivdaten			/* Spieldatenstruktur 	*/
{                                               /* zur Speicherung	*/
	BYTE	brett[GROE];			/* Spielfeld 		*/
	BYTE	wkpos,skpos;			/* Koenigsposition	*/
	WORD	lzug;				/* letzter Zug		*/
	BYTE	farbe;				/* Farbe am Zug		*/
	int	wdh;				/* Wiederholung		*/
} ARCHIV;

/* Figuren	*/

#define LEE	0				/* Leeres Feld	*/
#define BAU	1				/* Bauer	*/
#define XBAU	2				/* nicht bewegt	*/
#define SPR	3				/* Springer	*/
#define LAE	4				/* Laeufer	*/
#define TUR	5				/* Turm		*/
#define XTUR	6				/* nicht bewegt	*/
#define DAM	7				/* Dame		*/
#define KOE	8				/* Koenig	*/
#define XKOE	9				/* nicht bewegt	*/

/* Farben	*/

#define WEI	16				/* Weiss	*/
#define SCH	32				/* Schwarz	*/

#define SPZ	WEI+SCH				/* Spezialfigur fuer	*/
						/* die Raender		*/
/* Testmakros	*/

#define _istwei(x)	((x)&WEI)		/* Test auf Weiss	*/
#define _istsch(x)	((x)&SCH)            	/* Test auf Schwarz	*/
#define _istnwei(x)	(_istwei(x)&&!_istsch(x))/* Test auf nur Weiss	*/
#define _istnsch(x)	(_istsch(x)&&!_istwei(x))/* Test auf nur Schwarz*/
#define _farbe(x)	((x)&(WEI|SCH))		/* Farbe einer Figur	*/
#define _figur(x)	((x)&0xf)		/* Figur ohne Farbe	*/

#define _istlee(x)	(!(x))			/* Test auf leeres Feld	*/
#define _istbau(x)	(_figur(x)==BAU||_figur(x)==XBAU)
						/* Test auf Bauer	*/
#define _istxbau(x)	(_figur(x)==XBAU)	/* Test auf unb. Bauer	*/
#define _istplbau(x)	(_figur(x)==PLBAU)	/* Test auf pas. Bauer	*/
#define _istprbau(x)	(_figur(x)==PRBAU)	/* Test auf pas. Bauer	*/
#define _istspr(x)	(_figur(x)==SPR)	/* Test auf Springer	*/
#define _istlae(x)	(_figur(x)==LAE)	/* Test auf Laeufer	*/
#define _isttur(x)	(_figur(x)==TUR||_figur(x)==XTUR)
						/* Test auf Turm	*/
#define _istxtur(x)	(_figur(x)==XTUR)	/* Test auf unb. Turm	*/
#define _istdam(x)	(_figur(x)==DAM)	/* Test auf Dame	*/
#define _istkoe(x)	(_figur(x)==KOE||_figur(x)==XKOE)
						/* Test auf Koenig	*/
#define _istxkoe(x)	(_figur(x)==XKOE)	/* Test auf unb. Koenig	*/
#define _istspz(x)	((x)==SPZ)		/* Test auf Spezialfig. */

/* Zug -> Positionen	*/

#define _apos(x)	(BYTE)((x)&0xff)	/* alte Position	*/
/*#define _npos(x)	*((BYTE*)&(x)+1)	/* neue Position	*/
#define	_npos(x)	(BYTE)((x)>>8)		/* neue Position	*/

/* Positionen -> Koordianten	*/

#define _xpos(x)	(BYTE)((x)%ZLEN-RAND)	/* x-Koordinate	*/
#define _ypos(x)	(BYTE)((x)/ZLEN-RAND)	/* y-Koordinate	*/

/* Analysefunktion	*/

#define ANALYSE(x)	ad_analyse(x)

/* externe Variable	*/

extern 	int	opnr;			/* Anzahl der Eroeff.		*/
extern	int	testopnr;		/* Eroeffnungsnummer zum testen */
extern	WORD	*op[];			/* Eroeffnungen			*/
extern	BYTE	op_fa[MAXOP];		/* Farbe fuer die Eroeff. gilt	*/
extern	int	noop;			/* 1:Keine Bibliothek		*/
extern	SPDAT	spdat;			/* Spieldaten			*/
extern	ARCHIV	*archiv[];		/* Archivdaten			*/
extern	int	phase;			/* Spielphase			*/
extern	int	zaehler;		/* Antwortzaehler		*/
extern	int	compzuege;		/* Computerzuege		*/
extern	long	varianten;		/* Variantenzaehler		*/
extern	long	zeit;			/* Dauer des letzten Zuges	*/
extern	long	varprosek;		/* Varianten pro Sek.		*/
extern	int	mode;			/* Modus			*/
extern	int	stufe;			/* Spielstufe			*/
extern	int	beende;			/* Falls 1 Denkvorgang beenden	*/
extern	WORD	best_so_far;		/* Bester Zug bis jetzt		*/
extern	int	maxtiefe[],mintiefe[];	/* Rechentiefe			*/
					/* Status des letzten Zuges:	*/
extern	int	schlag;			/* falls 1 wurde geschlagen	*/
					/* oder befoerdert		*/
extern	int	gabel;			/* Bauernspiess oder		*/
					/* Springergabel falls 1	*/

/* externe Funktionen	*/

extern  char	*wandle();			/* int. Format in String */
extern	char	*kombination();			/* Kombination in String */
extern	WORD	wandle_inv();			/* String in int. Form.  */
extern	BYTE	wandle_fig();			/* Figur in int. Form.   */
extern	long	bewerte();			/* Zug bewerten		 */
extern	long	comp_zug();			/* Computer Zug		 */
extern	WORD	bib_zug();			/* Zug aus Bibliothek	 */
extern	int	zugliste();			/* Zugliste		 */
extern	int	sortliste();			/* Zugliste sortiert	 */
extern	int	ziehe();			/* Zug ausfuehren	 */
extern	int	zug_test();			/* Zug testen		 */
extern	int	save_game();			/* Speichern		 */
extern	int	load_game();			/* Laden		 */
extern	int	bedrohung();			/* Bedrohung testen	 */
extern	int	hole_zurueck();			/* Zurueckholen		 */
extern	int 	bib_test();			/* Bibliothek testen	 */

extern	void	brett_aus();			/* Brett ausgeben	 */
extern	void	info_aus();			/* Info ausgeben	 */
extern	void	zugliste_aus();			/* Zugliste ausgeben	 */
extern	void	status_aus();			/* Status ausgeben	 */
extern	void	archiviere();			/* Archivieren		 */
extern	void	eff_stufe();			/* Stufe einstellen	 */
extern	void	init();				/* Initialisieren	 */
extern	void	load_open();			/* Eroeffnungen laden	 */
