/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Windows					*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "ad.h"

/****************************************************************/
/*	info ausgeben						*/
/****************************************************************/

void	ad_info()

{
	char	str[STRLEN];		/* String		*/
	int 	l=2;			/* Zeile		*/
	int 	nr=0;			/* Ausgabe Nummer	*/
	char	c;

	schach("info",ptr);		/* ausfuehren		*/

	win=newwin(15,35,4,3);		/* neues Window		*/
	box(win,0,0);			/* mit Rahmen		*/

	farbe=ptr[nr][0];		/* FARBE		*/
	sprintf(str,"%s%s",info[0],ptr[nr++][0]=='w'?white:black);
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[1],ptr[nr++]);	/* ZUEGE	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[2],ptr[nr++]);	/* WERTUNG	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[3],ptr[nr++]);	/* VARIANTEN	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[4],ptr[nr++]);	/* VAR/SEK	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[5],ptr[nr++]);	/* DURCHSCHNITT	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%d",info[6],atoi(ptr[nr++])+1);	/* STUFE*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[7],ptr[nr++]);	/* TIEFE MIN	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	sprintf(str,"%s%s",info[8],ptr[nr++]);	/* TIEFE MAX	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	nr++;			/* MODE wird nicht benoetigt	*/

	sprintf(str,"%s%s",info[9],ptr[nr++]);	/* LETZTER ZUG	*/
	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,str);		/* ausgeben		*/

	wmove(win,l++,2);		/* positionieren	*/
	waddstr(win,press_key);		/* TASTE		*/
	wrefresh(win);			/* ausgeben		*/
	move(23,79);
	refresh();

	ad_read(0,&c,1);		/* auf Taste warten	*/

	delwin(win);			/* Fenster aus		*/
	win=(WINDOW *)0;
	touchwin(stdscr);
}

/****************************************************************/
/*	Filenamen/Gegnernamen einlesen				*/
/****************************************************************/

char 	*ad_name(mode)

char	mode;	/* f = Filename		g = Gegner	*/
{
	char 	str[STRLEN];		/* String		*/
	static	char s[STRLEN];		/* Return-String	*/
	char 	c;			/* Zeichen		*/
	int 	i=0;

	if(mode!='g' && mode !='f')	/* Fehler ?		*/
		return("");

	win=newwin(3,60,10,10);		/* neues Window		*/
	box(win,0,0);			/* mit Rahmen		*/
	wmove(win,1,1);
	waddstr(win,mode=='f' ? enter:opponent);
	wmove(win,1,1+strlen(mode=='f' ? enter:opponent));

	str[i]=0;			/* loeschen		*/

        do
	{
		wrefresh(win);		/* ausgeben		*/
		ad_read(0,&c,1);	/* Zeichen einlesen	*/

		if(c=='\b' && i>0)	/* Backspace	*/
		{
			waddstr(win,"\b \b");
			str[--i]=0;
		}

		if(c==127)		/* Delete	*/
			while(i>0)
			{
				waddstr(win,"\b \b");
				str[--i]=0;
			}

		if(isprint(c) &&
		(mode == 'f' ? i<5 : i<57-strlen(opponent))
		&& c!='/' && c!='.' && c!=' ')
		{
			waddch(win,(int)c);	/* ausgeben	*/
			str[i]=c;
			str[++i]=0;
		}
	}
	while(c!='\n' && c!=(char)13);
	
	wrefresh(win);			/* ausgeben		*/
	delwin(win);			/* Fenster aus		*/
	win=(WINDOW *)0;

	move(23,79);
	touchwin(stdscr);
	wnoutrefresh(stdscr);
	if(setupwin != (WINDOW *)0)
	{
		touchwin(setupwin);
		wnoutrefresh(setupwin);
	}
	doupdate();

	if(mode=='f')
	{
		sprintf(s,"training/%s.",ad_id(getlogin()));
					/* Pfad dazu		*/
		strcat(s,str);
	}
	else
		strcpy(s,str);		/* ohne Pfad		*/

	return(s);
}

/****************************************************************/
/*	Fehlermeldung						*/
/****************************************************************/

void	ad_error(s)

char 	*s;
{
	char str[STRLEN];		/* String		*/
	char c;

	if(curses)			/* Curses an ?		*/
	{
		if(s[0]==0)		/* externer Fehler ?	*/
			sprintf(str,"%s%s",error,sys_errlist[errno]);
		else			/* interner Fehler ?	*/
			sprintf(str,"%s%s",error,s);

		win=newwin(3,60,10,10);	/* neues Window		*/
		box(win,0,0);		/* mit Rahmen		*/
		wmove(win,1,1);
		waddstr(win,str);
		wmove(win,1,59-strlen(press_key));
		waddstr(win,press_key);

		refresh();
		wrefresh(win);		/* ausgeben		*/
		move(23,79);
		refresh();

		ad_read(0,&c,1);		/* auf Taste warten	*/

		delwin(win);		/* Fenster aus		*/
		win=(WINDOW *)0;

		move(23,79);
		touchwin(stdscr);
		wnoutrefresh(stdscr);
		if(setupwin != (WINDOW *)0)
		{
			touchwin(setupwin);
			wnoutrefresh(setupwin);
		}
		doupdate();
	}
	else
		fprintf(stderr,"%s: %s\n",pname,sys_errlist[errno]);
}

/****************************************************************/
/*	Meldung							*/
/****************************************************************/

void	ad_msg(s)

char 	*s;
{
	int 	i;

	win=newwin(2,80,22,0);	/* neues Window		*/
	wmove(win,0,0);
	for(i=0;i<80;i++)	/* Linie		*/
		waddch(win,(int)'-');

	wmove(win,1,39-strlen(s)/2);
	waddstr(win,s);

	refresh();
	wrefresh(win);		/* ausgeben		*/
	move(23,79);
	refresh();

	delwin(win);		/* Fenster aus		*/
	win=(WINDOW *)0;

	move(23,79);
	touchwin(stdscr);
	wnoutrefresh(stdscr);
	if(setupwin != (WINDOW *)0)
	{
		touchwin(setupwin);
		wnoutrefresh(setupwin);
	}
}

/****************************************************************/
/*	Sicherheitsabfrage					*/
/****************************************************************/
/*	Return: 0-nein    1-ja					*/
/****************************************************************/

int	ad_sure(mode)

char	mode;	/* s = Sicher ?		a = Aufgeben ?		*/
{
	char 	c;			/* Zeichen		*/
	char	*str;

	if(mode=='s')
		str=sure;
	else if(mode=='a')
		str=give_up;
	else
		return(0);

	win=newwin(3,60,10,10);		/* neues Window		*/
	box(win,0,0);			/* mit Rahmen		*/
	wmove(win,1,1+(58-strlen(str+2))/2);
	waddstr(win,str+2);

	wrefresh(win);			/* ausgeben		*/
	move(23,79);
	refresh();

	do
	{
		ad_read(0,&c,1);	/* auf Taste warten	*/

		if(isupper(c))		/* klein machen		*/
			c=tolower(c);

		if(c!=str[0] && c!=str[1])
			beep();
	}
	while(c!=str[0] && c!=str[1]);

	delwin(win);			/* Fenster aus		*/
	win=(WINDOW *)0;

	move(23,79);
	touchwin(stdscr);
	wnoutrefresh(stdscr);
	if(setupwin != (WINDOW *)0)
	{
		touchwin(setupwin);
		wnoutrefresh(setupwin);
	}
	doupdate();

	if(c==str[0])			/* ja ?			*/
		return(1);
	else				/* nein ?		*/
		return(0);
}


