/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Turnierspiel gegen Computer		*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include "ad.h"

/****************************************************************/
/*	Turnierspiel gegen Computer				*/
/****************************************************************/

void	ad_tc_game()

{
	char 	ch;		/* Eingabe			*/
	char	s[STRLEN];	/* String			*/
	int	ret;		/* return von domenu		*/

	/* Pfad zum Speichern	*/
	sprintf(stdname,"save/%s",wei==0 ? ad_id(getlogin()):
	ad_id(gegner));
	sprintf(stdname+strlen(stdname),".%s", sch==0 ?
	ad_id(getlogin()):ad_id(gegner));

	ad_lock();
	sprintf(s,"load %s",stdname);
	schach(s,ptr);		/* Laden		*/
	ad_unlock();

	schach("info",ptr);	/* Info holen		*/
	modus = atoi(ptr[9]);	/* merken		*/
	farbe = ptr[0][0];
	level = atoi(ptr[6]);

	old_moves = atoi(ptr[1]);	/* Anzahl der Zuege	*/

	ad_menu();		/* Menue ausgeben	*/
	ad_brett();		/* Brett aufbauen	*/
	refresh();		/* ausgeben		*/

	while(1)
	{
		/*--- Spielendeueberpruefung ---------------------------*/
		if(ende)		/* Spiel zu Ende ?	*/
		{
			switch(ende)
			{
			case W_AUFG:	/* Weiss gibt auf	*/
			case W_MATT: 	/* Weiss ist matt	*/
				mvaddstr(2,MPOS,press_key);
				move(23,79);
				refresh();
				ad_read(0,&ch,1);/* einlesen	*/
				ad_remove();
				ad_addscore('B');/* Score 	*/
				break;

			case S_AUFG:	/* Schwarz gibt auf	*/
			case S_MATT: 	/* Schwarz ist matt	*/
				mvaddstr(2,MPOS,press_key);
				move(23,79);
				refresh();
				ad_read(0,&ch,1);/* einlesen	*/
				ad_remove();
				ad_addscore('W');/* Score 	*/
				break;

			case PATT:	/* Unentschieden	*/
				mvaddstr(2,MPOS,press_key);
				move(23,79);
				refresh();
				ad_read(0,&ch,1);/* einlesen	*/
				ad_remove();
				ad_addscore('-');/* Score 	*/
				break;
			}

			break;		/* Ende 		*/
		}
		/*--- Computer -----------------------------------------*/
		else if((farbe=='w' && W_IS_OPP())
		     || (farbe=='s' && B_IS_OPP()))
		{	/* Computerzug	*/
			int	x;

			mvaddstr(2,MPOS,thinking);/* Status ausgeben	*/
			move(23,79);
			refresh();

			schach("comp",ptr);	/* Zug holen	*/

			ad_brett();		/* Brett aufbauen	*/

			schach("info",ptr);	/* Info holen	*/
			farbe=ptr[0][0];	/* Farbe am Zug	*/

			move(2,MPOS);		/* Meldung loeschen	*/
			for(x=stdscr->_curx;x<79;x++)	/* loeschen	*/
				mvaddch(stdscr->_cury,x,(int)' ');
		}
		else
		/*--- Spieler ------------------------------------------*/
		{
			ad_read(0,&ch,1);	/* einlesen	*/

			if(isupper(ch))		/* gross ?	*/
				ch=tolower(ch);

			ad_flush();	/* restliche Zeichen wegwerfen	*/

			ret=ad_domenu(ch);	/* auswerten		*/

			if(ret==0)		/* Ende ?		*/
			{
				schach("info",ptr);	/* Info holen	*/

				if(atoi(ptr[1]) != old_moves)
				{		/* veraendert ?		*/
					ad_lock();
					sprintf(s,"save %s",stdname);
					schach(s,ptr);	/* Speichern	*/
					ad_unlock();
				}
				break;
			}
			else if(ret==2)		/* Aufgeben ?		*/
				if(ad_sure('a'))
				{
					move(3,MPOS);

					addstr(wei==0 ? w_up:b_up);
					ende = wei==0 ? W_AUFG:S_AUFG;
				}
		}

		/*--- alles ausgeben -----------------------------------*/

		move(23,79);		/* Cursor weg		*/
		refresh();		/* ausgeben		*/
	}

	stdname[0]='\0';	/* Kein Standardname	*/
}
