/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Spielmenue				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include "ad.h"

/****************************************************************/
/*	Spielmenue						*/
/****************************************************************/

void	ad_game()

{
	char	s[STRLEN];	/* String		*/

	if(!UEBUNG())	/* Spiel gegen sich selbst ?	*/
	{
		strcpy(s,ad_id(gegner));
		if(!strcmp(s,ad_id(getlogin())))
			return;
	}

	if(!UEBUNG() && !strcmp(ad_id(gegner),"?"))
	{			/* Existiert Gegner ?	*/
		ad_error(no_user);
		return;
	}

	ad_game_screen();	/* Bildaufbau		*/

	ad_new();		/* neues Spiel		*/

	if(UEBUNG())		/* Training ?		*/
		ad_tr_game();
	else if(TURNGEG())	/* Turnier gegen Gegner ?	*/
		ad_tu_game();
	else			/* Turnier gegen Computer ?	*/
		ad_tc_game();
}

/****************************************************************/
/*	Menueeingabe						*/
/****************************************************************/
/*	Return:	1: ok		0: Ende				*/
/*	        2: Aufgeben					*/
/****************************************************************/

int	ad_domenu(ch)

char 	ch;
{
	if(ch<='h' && ch>='a' && !ende &&	/*** ziehen	***/
	((farbe=='w' && W_IS_USER()) || (farbe=='s' && B_IS_USER())))
		ad_zug(ch);
	else if(ch==menu[0][0])			/*** Level	***/
	{
		char str[STRLEN];

		if(TURNIER())			/* Turnierspiel	*/
			ad_error(not_allowed);
		else
		{
			level++;
			if(level >=10)
				level=0;
			ad_menu();

			sprintf(str,"stufe %d",level);
			schach(str,ptr);
		}
	}
	else if(ch==menu[1][0])			/*** Weiss	***/
	{
		if(TURNIER())		/* Turnierspiel ?	*/
			ad_error(not_allowed);
		else
		{
			wei= W_IS_USER();
			ad_menu();
		}
	}
	else if(ch==menu[2][0])			/*** Schwarz	***/
	{
		if(TURNIER())		/* Turnierspiel ?	*/
			ad_error(not_allowed);
		else
		{
			sch= B_IS_USER();
			ad_menu();
		}
	}
	else if(ch==menu[3][0])			/*** Analyse	***/
	{
		char	str[STRLEN];

		if(TURNGEG())			/* ext. Gegner	*/
			ad_error(not_allowed);
		else
		{
			schach("info",ptr);	/* Info hol.	*/
			modus=atoi(ptr[9]);	/* Modus	*/
			modus ^= 128;		/* aendern	*/
			sprintf(str,"modus %d",modus);
			schach(str,ptr);	/* setzen	*/
			if(!(modus & 128))	/* aus ?	*/
			ad_analyse("   a    b    c    d    e    f    g    h");
			ad_menu();
		}
	}
	else if(ch==menu[4][0])			/*** Setup	***/
		ad_setup();
	else if(ch==menu[5][0])			/*** Zurueck	***/
		ad_zurueck();
	else if(ch==menu[6][0])			/*** Info	***/
		ad_info();
	else if(ch==menu[7][0])			/*** Neustart	***/
	{
		return(2);
	}
	else if(ch==menu[8][0])	/*** ende	***/
	{
		if(ad_sure('s'))
			return(0);
	}
#ifdef EXT_ANALYSE					/* gesperrt !	*/
	else if(ch==(char)26)			/*** ausf. Analyse ***/
	{					/* ^ Z		*/
		char	str[STRLEN];

		schach("info",ptr);		/* Info hol.	*/
		modus=atoi(ptr[9]);		/* Modus	*/
		modus ^= 1;			/* aendern	*/
		sprintf(str,"modus %d",modus);
		schach(str,ptr);		/* setzen	*/
		if(!(modus & 1))		/* aus ?	*/
			ad_analyse("   a    b    c    d    e    f    g    h");
	}
#endif
	else if(ch!=' ')			/* Space wird ignoriert	*/
		beep();				/*** Fehler	***/

	return(1);
}
