/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Hauptprogramm				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include "ad.h"

char	*pname;			/* Prgname: argv[0] 		*/
char	*cwd;			/* Working Directory 		*/
char	stdname[STRLEN]="";	/* Standardname fuers Speichern	*/
char	def[STRLEN]=LANG;	/* Definitionen			*/
int	lock=0;			/* Falls 1: Lock erworben	*/
int	curses=0;		/* Falls 1: Curses an		*/
int	inter;			/* Falls 1: Es war ein Interrupt*/
int	break_pid= -1;		/* Prozessid des Unterbrechers	*/
WINDOW	*win=(WINDOW *)0;	/* Subwindow			*/
WINDOW	*setupwin=(WINDOW *)0;	/* Setup-Subwindow		*/

char	farbe;			/* w=weiss,s=schwarz		*/
int	wei;			/* 0=Spieler			*/
int	sch;			/* 1=Computer oder Gegener	*/
char	gegner[STRLEN];		/* Spielgegner (leer:Computer)	*/
int	level;			/* Spielstufe			*/
int	ende;			/* 1:Matt oder Patt		*/
int	modus;			/* eingestellter Modus		*/
char	ant[PTR][81];		/* Antworten			*/
char	*ptr[PTR];		/* Pointer auf Antw.		*/

int	old_moves;	/* Anzahl der Zuege bei Spielbeginn	*/
/* ^ Wird benoetigt, um festzustellen, ob beim Verlassen	*/
/* eines Turnierspieles gegen den Computer (regulaer oder	*/
/* durch Interrupt) Speichern noetig ist			*/

extern	void	exit();
extern	int	umask();

/****************************************************************/
/*	Hauptprogramm						*/
/****************************************************************/

int	main(argc,argv,envp)

int 	argc;
char 	*argv[];
char 	*envp[];
{
	extern 	char 	*optarg;
	extern 	int  	optind,opterr;
	char		c;
	char		str[STRLEN];
	int		testop=0;	/* Falls 1: Eroeffungen testen	*/
	int		expire=0;	/* Falls 1: Expire		*/
	int		i;

	umask(077);			/* Filecreationmask	*/

	pname=argv[0];			/* Programmname 	*/

	for(i=0;i<PTR;i++)		/* Pointer setzen 	*/
		ptr[i]= &ant[i][0];

	cwd=getcwd((char *)0,STRLEN);	/* Directory retten 	*/

	if(chdir(WORKDIR)== -1)		/* Directory aendern	*/
	{
		fprintf(stderr,
		"%s: unknown path %s\n",pname,WORKDIR);
		exit(1);
	}

	/* Optionen einlesen *******************************************/

	opterr=1;
	while((c=(char)getopt(argc,argv,"etd:"))!=EOF)
		switch(c)
		{
		case 'd':		/* andere Sprache 		*/
			strcpy(def,optarg);
			break;

		case 't':		/* Eroeffungsbibliothek testen	*/
			testop=1;
			break;

		case 'e':		/* Expire	*/
			expire=1;
			break;

		default:
		case '?':		/* Fehler 	*/
			opterr++;
			break;
		}

	if(opterr>1)			/* falsche Optionen */
	{
		fprintf(stderr,
		"usage: %s [-t] [-e] [-d file]\n",pname);
		ad_deinit();
		exit(1);
	}
	
	/* Ende Optionen einlesen **************************************/

	if(testop)			/* Eroeffungen testen	*/
	{
		schach("testbib",ptr);

		if(ptr[0][0]=='?')		/* Fehler ?		*/
		{
			fprintf(stderr,
	"%s: error in chess.op (see error.op for more information)\n",pname);
			ad_deinit();
			exit(1);
		}
		else
			fprintf(stderr,"%s: no errors in chess.op\n",pname);

	}
	else if(expire)			/* Expire ?	*/
	{
		ad_expire();
	}
	else	/* Normales Spiel	*/
	{
		ad_init();			/* initialsieren	*/

		ad_admin();			/* Administrationsmenue	*/

		ad_deinit();			/* deinitialsieren	*/
	}

	return(0);			/* alles ok		*/
}
