/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	File Locking				*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <fcntl.h>
#include "ad.h"

extern	unsigned	sleep();

/****************************************************************/
/*	File locken						*/
/****************************************************************/

void	ad_lock()

{
	int	fd;
	char	str[STRLEN];

	if(!TURNGEG())				/* Computer = Gegner ?	*/
		return;				/* Kein lock noetig	*/

	sprintf(str,"%s.lock",stdname);		/* Pfad aufbereiten	*/
	
	while(1)
	{
		fd=open(str,O_WRONLY | O_CREAT | O_EXCL,0664);	/* Lock holen */

		if(fd!=-1)				/* nicht locked ? */
			break;

		sleep((unsigned)2);
	}
	
	close(fd);					/* schliessen */

	lock=1;
}

/****************************************************************/
/*	File unlocken						*/
/****************************************************************/

void	ad_unlock()

{
	char str[STRLEN];	/* String fuer Pfad- und Dateinamen */
	
	if(!TURNGEG())		/* Computer = Gegner ?	*/
		return;		/* Kein lock noetig	*/

	sprintf(str,"%s.lock",stdname);		/* Pfad aufbereiten	*/
	if(unlink(str) == -1)			/* loeschen		*/
		ad_error("");

	lock=0;
}

/****************************************************************/
/*	Score locken						*/
/****************************************************************/

void	ad_locksc()

{
	int	fd;
	static	char	*str="score.lock";
	
	while(1)
	{
		fd=open(str,O_WRONLY | O_CREAT | O_EXCL,0664);	/* Lock holen */

		if(fd!=-1)				/* nicht locked ? */
			break;

		sleep((unsigned)2);
	}
	
	close(fd);					/* schliessen */

	lock=1;
}

/****************************************************************/
/*	Score unlocken						*/
/****************************************************************/

void	ad_unlocksc()

{
	if(unlink("score.lock") == -1)		/* loeschen		*/
		ad_error("");

	lock=0;
}

