/****************************************************************/
/*								*/
/*	XChess V2.7 Adapter: Curses				*/
/*								*/
/*	(c) 1991 by Marc Laukien				*/
/*								*/
/*	Programmteil:	Laden & Speichern & Neustart		*/
/*								*/
/****************************************************************/

#include <curses.h>
#include <stdio.h>
#include <string.h>
#include "ad.h"

/****************************************************************/
/*	Programm Laden						*/
/****************************************************************/

void	ad_load()

{
	char 	str[STRLEN];
	char	*s;

	if(TURNIER())	/* Turnierspiel ?	*/
	{
		ad_error(not_allowed);
		return;
	}

	s=ad_name('f');
	if(s[strlen(s)-1] != '/')
	if(ad_sure('s'))
	{
		sprintf(str,"load %s",s);
		schach(str,ptr);

		if(ptr[0][0]=='?')	/* Fehler ?	*/
			ad_error("");
		else
		{
			ad_brett();

			schach("info",ptr);/* Info hol.	*/
			farbe=ptr[0][0];/* Farbe am Zug	*/
			if(farbe=='w')	/* Farbe einst.	*/
			{
				wei=0;
				sch=1;
			}
			else
			{
				sch=0;
				wei=1;
			}
			level=atoi(ptr[6]);/* Spielstufe*/
			modus=atoi(ptr[9]);/* Modus	*/
			ad_menu();
		}
	}
}

/****************************************************************/
/*	Programm speichern					*/
/****************************************************************/

void	ad_save()

{
	char 	str[STRLEN];
	char	*s;

	if(TURNIER())	/* Turnierspiel ?	*/
	{
		ad_error(not_allowed);
		return;
	}

	s=ad_name('f');
	if(s[strlen(s)-1] != '/')
	{
		sprintf(str,"save %s",s);
		schach(str,ptr);
		if(ptr[0][0]=='?')	/* Fehler ?	*/
		ad_error("");
	}
}

/****************************************************************/
/*	Zurueck							*/
/****************************************************************/

void	ad_zurueck()

{
	if(TURNIER())	/* Turnierspiel ?	*/
	{
		ad_error(not_allowed);
		return;
	}

	schach("zurueck",ptr);
	ad_brett();
	schach("info",ptr);/* Info hol.	*/
	farbe=ptr[0][0];/* Farbe am Zug	*/

	if(farbe=='w')	/* Farbe einst.	*/
	{
		wei=0;
		sch=1;
	}
	else
	{
		sch=0;
		wei=1;
	}
	level=atoi(ptr[6]);	/* Spielstufe	*/
	ad_menu();
}
