
#ifndef __CYBERGL_PROTOS__
#define __CYBERGL_PROTOS__

GLvoid    *glCCreateContext         (GLvoid);
GLvoid     glCDeleteContext         (GLvoid *context);
GLvoid     glCMakeCurrentContext    (GLvoid *context);
GLvoid    *glCGetCurrentContext     (GLvoid);
GLboolean  glCAttachContext         (GLvoid *drawArea, GLvoid *context, GLbitfield cap);
GLvoid     glCSwapBuffers           (GLvoid);

GLvoid     glAccum                  (GLenum op, GLfloat value);
GLvoid     glAlphaFunc              (GLenum func, GLclampf ref);
GLvoid     glBegin                  (GLenum mode);
GLvoid     glEnd                    (GLvoid);
GLvoid     glBitmap                 (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
GLvoid     glBlendFunc              (GLenum src, GLenum dst);
GLvoid     glCallList               (GLuint n);
GLvoid     glCallLists              (GLsizei n, GLenum type, const GLvoid *lists);
GLvoid     glClear                  (GLbitfield mask);
GLvoid     glClearAccum             (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
GLvoid     glClearColor             (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
GLvoid     glClearDepth             (GLclampd depth);
GLvoid     glClearIndex             (GLfloat c);
GLvoid     glClearStencil           (GLint s);
GLvoid     glClipPlane              (GLenum plane, const GLdouble *equation);
GLvoid     glColor3b                (GLbyte red, GLbyte green, GLbyte blue);
GLvoid     glColor3d                (GLdouble red, GLdouble green, GLdouble blue);
GLvoid     glColor3f                (GLfloat red, GLfloat green, GLfloat blue);
GLvoid     glColor3i                (GLint red, GLint green, GLint blue);
GLvoid     glColor3s                (GLshort red, GLshort green, GLshort blue);
GLvoid     glColor3ub               (GLubyte red, GLubyte green, GLubyte blue);
GLvoid     glColor3ui               (GLuint red, GLuint green, GLuint blue);
GLvoid     glColor3us               (GLushort red, GLushort green, GLushort blue);
GLvoid     glColor4b                (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
GLvoid     glColor4d                (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
GLvoid     glColor4f                (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
GLvoid     glColor4i                (GLint red, GLint green, GLint blue, GLint alpha);
GLvoid     glColor4s                (GLshort red, GLshort green, GLshort blue, GLshort alpha);
GLvoid     glColor4ub               (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
GLvoid     glColor4ui               (GLuint red, GLuint green, GLuint blue, GLuint alpha);
GLvoid     glColor4us               (GLushort red, GLushort green, GLushort blue, GLushort alpha);
GLvoid     glColor3bv               (const GLbyte *v);
GLvoid     glColor3dv               (const GLdouble *v);
GLvoid     glColor3fv               (const GLfloat *v);
GLvoid     glColor3iv               (const GLint *v);
GLvoid     glColor3sv               (const GLshort *v);
GLvoid     glColor3ubv              (const GLubyte *v);
GLvoid     glColor3uiv              (const GLuint *v);
GLvoid     glColor3usv              (const GLushort *v);
GLvoid     glColor4bv               (const GLbyte *v);
GLvoid     glColor4dv               (const GLdouble *v);
GLvoid     glColor4fv               (const GLfloat *v);
GLvoid     glColor4iv               (const GLint *v);
GLvoid     glColor4sv               (const GLshort *v);
GLvoid     glColor4ubv              (const GLubyte *v);
GLvoid     glColor4uiv              (const GLuint *v);
GLvoid     glColor4usv              (const GLushort *v);
GLvoid     glColorMask              (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
GLvoid     glColorMaterial          (GLenum face, GLenum mode);
GLvoid     glCopyPixels             (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
GLvoid     glCullFace               (GLenum mode);
GLvoid     glDeleteLists            (GLuint list, GLsizei range);
GLvoid     glDepthFunc              (GLenum func);
GLvoid     glDepthMask              (GLboolean flag);
GLvoid     glDepthRange             (GLclampd zNear, GLclampd zFar);
GLvoid     glDrawBuffer             (GLenum mode);
GLvoid     glDrawPixels             (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *data);
GLvoid     glEdgeFlag               (GLboolean flag);
GLvoid     glEdgeFlagv              (const GLboolean *flag);
GLvoid     glEnable                 (GLenum cap);
GLvoid     glDisable                (GLenum cap);
GLvoid     glEvalCoord1d            (GLdouble u);
GLvoid     glEvalCoord1f            (GLfloat u);
GLvoid     glEvalCoord2d            (GLdouble u, GLdouble v);
GLvoid     glEvalCoord2f            (GLfloat u, GLfloat v);
GLvoid     glEvalCoord1dv           (const GLdouble *u);
GLvoid     glEvalCoord1fv           (const GLfloat *u);
GLvoid     glEvalCoord2dv           (const GLdouble *u);
GLvoid     glEvalCoord2fv           (const GLfloat *u);
GLvoid     glEvalMesh1              (GLenum mode, GLint i1, GLint i2);
GLvoid     glEvalMesh2              (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
GLvoid     glEvalPoint1             (GLint i);
GLvoid     glEvalPoint2             (GLint i, GLint j);
GLvoid     glFeedbackBuffer         (GLsizei size, GLenum type, GLfloat *buffer);
GLvoid     glFinish                 (GLvoid);
GLvoid     glFlush                  (GLvoid);
GLvoid     glFogf                   (GLenum pname, GLfloat param);
GLvoid     glFogi                   (GLenum pname, GLint param);
GLvoid     glFogfv                  (GLenum pname, const GLfloat *params);
GLvoid     glFogiv                  (GLenum pname, const GLint *params);
GLvoid     glFrontFace              (GLenum mode);
GLvoid     glFrustum                (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLuint     glGenLists               (GLsizei range);
GLvoid     glGetBooleanv            (GLenum pname, GLboolean *params);
GLvoid     glGetDoublev             (GLenum pname, GLdouble *params);
GLvoid     glGetFloatv              (GLenum pname, GLfloat *params);
GLvoid     glGetIntegerv            (GLenum pname, GLint *params);
GLvoid     glGetClipPlane           (GLenum plane, GLdouble *equation);
GLenum     glGetError               (GLvoid);
GLvoid     glGetLightfv             (GLenum light, GLenum pname, GLfloat *params);
GLvoid     glGetLightiv             (GLenum light, GLenum pname, GLint *params);
GLvoid     glGetMapdv               (GLenum target, GLenum query, GLdouble *v);
GLvoid     glGetMapfv               (GLenum target, GLenum query, GLfloat *v);
GLvoid     glGetMapiv               (GLenum target, GLenum query, GLint *v);
GLvoid     glGetMaterialfv          (GLenum face, GLenum pname, GLfloat *params);
GLvoid     glGetMaterialiv          (GLenum face, GLenum pname, GLint *params);
GLvoid     glGetPixelMapfv          (GLenum map, GLfloat *values);
GLvoid     glGetPixelMapuiv         (GLenum map, GLuint *values);
GLvoid     glGetPixelMapusv         (GLenum map, GLushort *values);
GLvoid     glGetPolygonStipple      (GLubyte *mask);
GLubyte   *glGetString              (GLenum name);
GLvoid     glGetTexEnvfv            (GLenum target, GLenum pname, GLfloat *params);
GLvoid     glGetTexEnviv            (GLenum target, GLenum pname, GLint *params);
GLvoid     glGetTexGendv            (GLenum coord, GLenum pname, GLdouble *params);
GLvoid     glGetTexGenfv            (GLenum coord, GLenum pname, GLfloat *params);
GLvoid     glGetTexGeniv            (GLenum coord, GLenum pname, GLint *params);
GLvoid     glGetTexImage            (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
GLvoid     glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
GLvoid     glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
GLvoid     glGetTexParameterfv      (GLenum target, GLenum pname, GLfloat *params);
GLvoid     glGetTexParameteriv      (GLenum target, GLenum pname, GLint *params);
GLvoid     glHint                   (GLenum target, GLenum mode);
GLvoid     glIndexd                 (GLdouble c);
GLvoid     glIndexf                 (GLfloat c);
GLvoid     glIndexi                 (GLint c);
GLvoid     glIndexs                 (GLshort c);
GLvoid     glIndexdv                (const GLdouble *c);
GLvoid     glIndexfv                (const GLfloat *c);
GLvoid     glIndexiv                (const GLint *c);
GLvoid     glIndexsv                (const GLshort *c);
GLvoid     glIndexMask              (GLuint mask);
GLvoid     glInitNames              (GLvoid);
GLboolean  glIsEnabled              (GLenum cap);
GLboolean  glIsList                 (GLuint list);
GLvoid     glLightf                 (GLenum light, GLenum pname, GLfloat param);
GLvoid     glLighti                 (GLenum light, GLenum pname, GLint param);
GLvoid     glLightfv                (GLenum light, GLenum pname, const GLfloat *params);
GLvoid     glLightiv                (GLenum light, GLenum pname, const GLint *params);
GLvoid     glLightModelf            (GLenum pname, GLfloat param);
GLvoid     glLightModeli            (GLenum pname, GLint param);
GLvoid     glLightModelfv           (GLenum pname, const GLfloat *params);
GLvoid     glLightModeliv           (GLenum pname, const GLint *params);
GLvoid     glLineStipple            (GLint factor, GLushort pattern);
GLvoid     glLineWidth              (GLfloat width);
GLvoid     glListBase               (GLuint base);
GLvoid     glLoadIdentity           (GLvoid);
GLvoid     glLoadMatrixd            (const GLdouble *m);
GLvoid     glLoadMatrixf            (const GLfloat *m);
GLvoid     glLoadName               (GLuint name);
GLvoid     glLogicOp                (GLenum opcode);
GLvoid     glMap1d                  (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
GLvoid     glMap1f                  (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
GLvoid     glMap2d                  (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
GLvoid     glMap2f                  (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
GLvoid     glMapGrid1d              (GLint un, GLdouble u1, GLdouble u2);
GLvoid     glMapGrid1f              (GLint un, GLfloat u1, GLfloat u2);
GLvoid     glMapGrid2d              (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
GLvoid     glMapGrid2f              (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
GLvoid     glMaterialf              (GLenum face, GLenum pname, GLfloat param);
GLvoid     glMateriali              (GLenum face, GLenum pname, GLint param);
GLvoid     glMaterialfv             (GLenum face, GLenum pname, const GLfloat *params);
GLvoid     glMaterialiv             (GLenum face, GLenum pname, const GLint *params);
GLvoid     glMatrixMode             (GLenum mode);
GLvoid     glMultMatrixd            (const GLdouble *m);
GLvoid     glMultMatrixf            (const GLfloat *m);
GLvoid     glNewList                (GLuint n, GLenum mode);
GLvoid     glEndList                (GLvoid);
GLvoid     glNormal3b               (GLbyte nx, GLbyte ny, GLbyte nz);
GLvoid     glNormal3d               (GLdouble nx, GLdouble ny, GLdouble nz);
GLvoid     glNormal3f               (GLfloat nx, GLfloat ny, GLfloat nz);
GLvoid     glNormal3i               (GLint nx, GLint ny, GLint nz);
GLvoid     glNormal3s               (GLshort nx, GLshort ny, GLshort nz);
GLvoid     glNormal3bv              (const GLbyte *v);
GLvoid     glNormal3dv              (const GLdouble *v);
GLvoid     glNormal3fv              (const GLfloat *v);
GLvoid     glNormal3iv              (const GLint *v);
GLvoid     glNormal3sv              (const GLshort *v);
GLvoid     glOrtho                  (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLvoid     glPassThrough            (GLfloat token);
GLvoid     glPixelMapfv             (GLenum map, GLsizei mapsize, const GLfloat *values);
GLvoid     glPixelMapuiv            (GLenum map, GLsizei mapsize, const GLuint *values);
GLvoid     glPixelMapusv            (GLenum map, GLsizei mapsize, const GLushort *values);
GLvoid     glPixelStoref            (GLenum pname, GLfloat param);
GLvoid     glPixelStorei            (GLenum pname, GLint param);
GLvoid     glPixelTransferf         (GLenum pname, GLfloat param);
GLvoid     glPixelTransferi         (GLenum pname, GLint param);
GLvoid     glPixelZoom              (GLfloat xfactor, GLfloat yfactor);
GLvoid     glPointSize              (GLfloat size);
GLvoid     glPolygonMode            (GLenum face, GLenum mode);
GLvoid     glPolygonStipple         (const GLubyte *mask);
GLvoid     glPushAttrib             (GLbitfield mask);
GLvoid     glPopAttrib              (GLvoid);
GLvoid     glPushMatrix             (GLvoid);
GLvoid     glPopMatrix              (GLvoid);
GLvoid     glPushName               (GLuint name);
GLvoid     glPopName                (GLvoid);
GLvoid     glRasterPos2d            (GLdouble x, GLdouble y);
GLvoid     glRasterPos2f            (GLfloat x, GLfloat y);
GLvoid     glRasterPos2i            (GLint x, GLint y);
GLvoid     glRasterPos2s            (GLshort x, GLshort y);
GLvoid     glRasterPos3d            (GLdouble x, GLdouble y, GLdouble z);
GLvoid     glRasterPos3f            (GLfloat x, GLfloat y, GLfloat z);
GLvoid     glRasterPos3i            (GLint x, GLint y, GLint z);
GLvoid     glRasterPos3s            (GLshort x, GLshort y, GLshort z);
GLvoid     glRasterPos4d            (GLdouble x, GLdouble y, GLdouble r, GLdouble w);
GLvoid     glRasterPos4f            (GLfloat x, GLfloat y, GLfloat r, GLfloat w);
GLvoid     glRasterPos4i            (GLint x, GLint y, GLint r, GLint w);
GLvoid     glRasterPos4s            (GLshort x, GLshort y, GLshort r, GLshort w);
GLvoid     glRasterPos2dv           (const GLdouble *v);
GLvoid     glRasterPos2fv           (const GLfloat *v);
GLvoid     glRasterPos2iv           (const GLint *v);
GLvoid     glRasterPos2sv           (const GLshort *v);
GLvoid     glRasterPos3dv           (const GLdouble *v);
GLvoid     glRasterPos3fv           (const GLfloat *v);
GLvoid     glRasterPos3iv           (const GLint *v);
GLvoid     glRasterPos3sv           (const GLshort *v);
GLvoid     glRasterPos4dv           (const GLdouble *v);
GLvoid     glRasterPos4fv           (const GLfloat *v);
GLvoid     glRasterPos4iv           (const GLint *v);
GLvoid     glRasterPos4sv           (const GLshort *v);
GLvoid     glReadPixels             (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
GLvoid     glReadBuffer             (GLenum src);
GLvoid     glRectd                  (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
GLvoid     glRectf                  (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
GLvoid     glRecti                  (GLint x1, GLint y1, GLint x2, GLint y2);
GLvoid     glRects                  (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
GLvoid     glRectdv                 (const GLdouble *v1, const GLdouble *v2);
GLvoid     glRectfv                 (const GLfloat *v1, const GLfloat *v2);
GLvoid     glRectiv                 (const GLint *v1, const GLint *v2);
GLvoid     glRectsv                 (const GLshort *v1, const GLshort *v2);
GLint      glRenderMode             (GLenum mode);
GLvoid     glRotated                (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
GLvoid     glRotatef                (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
GLvoid     glScaled                 (GLdouble x, GLdouble y, GLdouble z);
GLvoid     glScalef                 (GLfloat x, GLfloat y, GLfloat z);
GLvoid     glScissor                (GLint x, GLint y, GLsizei width, GLsizei height);
GLvoid     glSelectBuffer           (GLsizei size, GLuint *buffer);
GLvoid     glShadeModel             (GLenum mode);
GLvoid     glStencilFunc            (GLenum func, GLint ref, GLuint mask);
GLvoid     glStencilMask            (GLuint mask);
GLvoid     glStencilOp              (GLenum fail, GLenum zfail, GLenum zpass);
GLvoid     glTexCoord1d             (GLdouble s);
GLvoid     glTexCoord1f             (GLfloat s);
GLvoid     glTexCoord1i             (GLint s);
GLvoid     glTexCoord1s             (GLshort s);
GLvoid     glTexCoord2d             (GLdouble s, GLdouble t);
GLvoid     glTexCoord2f             (GLfloat s, GLfloat t);
GLvoid     glTexCoord2i             (GLint s, GLint t);
GLvoid     glTexCoord2s             (GLshort s, GLshort t);
GLvoid     glTexCoord3d             (GLdouble s, GLdouble t, GLdouble r);
GLvoid     glTexCoord3f             (GLfloat s, GLfloat t, GLfloat r);
GLvoid     glTexCoord3i             (GLint s, GLint t, GLint r);
GLvoid     glTexCoord3s             (GLshort s, GLshort t, GLshort r);
GLvoid     glTexCoord4d             (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
GLvoid     glTexCoord4f             (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
GLvoid     glTexCoord4i             (GLint s, GLint t, GLint r, GLint q);
GLvoid     glTexCoord4s             (GLshort s, GLshort t, GLshort r, GLshort q);
GLvoid     glTexCoord1dv            (const GLdouble *v);
GLvoid     glTexCoord1fv            (const GLfloat *v);
GLvoid     glTexCoord1iv            (const GLint *v);
GLvoid     glTexCoord1sv            (const GLshort *v);
GLvoid     glTexCoord2dv            (const GLdouble *v);
GLvoid     glTexCoord2fv            (const GLfloat *v);
GLvoid     glTexCoord2iv            (const GLint *v);
GLvoid     glTexCoord2sv            (const GLshort *v);
GLvoid     glTexCoord3dv            (const GLdouble *v);
GLvoid     glTexCoord3fv            (const GLfloat *v);
GLvoid     glTexCoord3iv            (const GLint *v);
GLvoid     glTexCoord3sv            (const GLshort *v);
GLvoid     glTexCoord4dv            (const GLdouble *v);
GLvoid     glTexCoord4fv            (const GLfloat *v);
GLvoid     glTexCoord4iv            (const GLint *v);
GLvoid     glTexCoord4sv            (const GLshort *v);
GLvoid     glTexEnvf                (GLenum target, GLenum pname, GLfloat param);
GLvoid     glTexEnvi                (GLenum target, GLenum pname, GLint param);
GLvoid     glTexEnvfv               (GLenum target, GLenum pname, const GLfloat *params);
GLvoid     glTexEnviv               (GLenum target, GLenum pname, const GLint *params);
GLvoid     glTexGend                (GLenum coord, GLenum pname, GLdouble param);
GLvoid     glTexGenf                (GLenum coord, GLenum pname, GLfloat param);
GLvoid     glTexGeni                (GLenum coord, GLenum pname, GLint param);
GLvoid     glTexGendv               (GLenum coord, GLenum pname, const GLdouble *params);
GLvoid     glTexGenfv               (GLenum coord, GLenum pname, const GLfloat *params);
GLvoid     glTexGeniv               (GLenum coord, GLenum pname, const GLint *params);
GLvoid     glTexImage1D             (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
GLvoid     glTexImage2D             (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
GLvoid     glTexParameterf          (GLenum target, GLenum pname, GLfloat param);
GLvoid     glTexParameteri          (GLenum target, GLenum pname, GLint param);
GLvoid     glTexParameterfv         (GLenum target, GLenum pname, const GLfloat *params);
GLvoid     glTexParameteriv         (GLenum target, GLenum pname, const GLint *params);
GLvoid     glTranslated             (GLdouble x, GLdouble y, GLdouble z);
GLvoid     glTranslatef             (GLfloat x, GLfloat y, GLfloat z);
GLvoid     glVertex2d               (GLdouble x, GLdouble y);
GLvoid     glVertex2f               (GLfloat x, GLfloat y);
GLvoid     glVertex2i               (GLint x, GLint y);
GLvoid     glVertex2s               (GLshort x, GLshort y);
GLvoid     glVertex3d               (GLdouble x, GLdouble y, GLdouble z);
GLvoid     glVertex3f               (GLfloat x, GLfloat y, GLfloat z);
GLvoid     glVertex3i               (GLint x, GLint y, GLint z);
GLvoid     glVertex3s               (GLshort x, GLshort y, GLshort z);
GLvoid     glVertex4d               (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
GLvoid     glVertex4f               (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
GLvoid     glVertex4i               (GLint x, GLint y, GLint z, GLint w);
GLvoid     glVertex4s               (GLshort x, GLshort y, GLshort z, GLshort w);
GLvoid     glVertex2dv              (const GLdouble *v);
GLvoid     glVertex2fv              (const GLfloat *v);
GLvoid     glVertex2iv              (const GLint *v);
GLvoid     glVertex2sv              (const GLshort *v);
GLvoid     glVertex3dv              (const GLdouble *v);
GLvoid     glVertex3fv              (const GLfloat *v);
GLvoid     glVertex3iv              (const GLint *v);
GLvoid     glVertex3sv              (const GLshort *v);
GLvoid     glVertex4dv              (const GLdouble *v);
GLvoid     glVertex4fv              (const GLfloat *v);
GLvoid     glVertex4iv              (const GLint *v);
GLvoid     glVertex4sv              (const GLshort *v);
GLvoid     glViewport               (GLint x, GLint y, GLsizei width, GLsizei height);

GLvoid     gluLookAt                (GLdouble eyex, GLdouble eyey, GLdouble eyez, GLdouble centerx, GLdouble centery, GLdouble centerz, GLdouble upx, GLdouble upy, GLdouble upz);
GLvoid     gluOrtho2D               (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top);
GLvoid     gluPerspective           (GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar);
GLvoid     gluPickMatrix            (GLdouble x, GLdouble y, GLdouble width, GLdouble height);

#endif
