
; Audio output driver
; Supports either 8-bit mono or 14-bit mono output


PaulaOutput_MixAheadFrames	= 3			; Number of frames which the mixer should mix ahead
PaulaOutput_RefreshRate_PAL	= 4992		; Refresh rate of the current screenmode, in Hz, multiplied by 100



PaulaOutput_AudioBufferSizeLog2	= 12
PaulaOutput_AudioBufferSize	= (1<<PaulaOutput_AudioBufferSizeLog2)

PaulaOutput_CustomChipFrequency_PAL = 3546895

ciaa = $bfe001


PaulaOutput_Mode_8BitMono = 0
PaulaOutput_Mode_14BitMono = 1


	include	hardware/custom.i
	include	hardware/dmabits.i
	include	hardware/intbits.i
	include	hardware/cia.i


	section	code,code

;------------------------------------------------------------------------------
; Silence & setup audio hardware 
;
; a0	mix routine
; a1	mix state
; d0.w	replay period
; d1	mode (PaulaOutput_Mode_*)

PaulaOutput_Init

	move.l	a0,PaulaOutput_MixRoutine
	move.l	a1,PaulaOutput_MixState
	move.w	d0,PaulaOutput_ReplayPeriod
	move.b	d1,PaulaOutput_Mode
	
	sf	PaulaOutput_MixActive

	bsr	PaulaOutput_InitAudioReplay
	bsr.s	PaulaOutput_SetupAudioHardware
	bsr	PaulaOutput_Mix
	rts

;------------------------------------------------------------------------------
; Begin playback

PaulaOutput_Start
	st	PaulaOutput_MixActive
	bra	PaulaOutput_StartAudioHardware

;------------------------------------------------------------------------------
; Stop playback & silence audio hardware

PaulaOutput_ShutDown
	sf	PaulaOutput_MixActive
	bra	PaulaOutput_KillAudioHardware

;------------------------------------------------------------------------------
; VertB callback - call this routine every vblank to drive the audio mixer

PaulaOutput_VertBCallback
	tst.b	PaulaOutput_MixActive
	beq.s	.nMix
	move.l	d3,-(sp)
	move.l	d2,-(sp)

	move.l	PaulaOutput_PlayPosition,d0
	move.l	PaulaOutput_PlayPosition+4,d1
	move.l	PaulaOutput_SamplesPerVBlank,d2
	move.l	PaulaOutput_SamplesPerVBlank+4,d3
	add.l	d3,d1
	addx.l	d2,d0
	move.l	d0,PaulaOutput_PlayPosition
	move.l	d1,PaulaOutput_PlayPosition+4

	bsr	PaulaOutput_Mix
	
	move.l	(sp)+,d2
	move.l	(sp)+,d3
.nMix
	rts

;------------------------------------------------------------------------------

PaulaOutput_SetupAudioHardware

	move.l	a5,-(sp)
	move.l	#$dff000,a5

; Mute audio

	moveq	#0,d0
	move.w	d0,aud0+ac_vol(a5)
	move.w	d0,aud1+ac_vol(a5)
	move.w	d0,aud2+ac_vol(a5)
	move.w	d0,aud3+ac_vol(a5)

	or.b	#CIAF_LED,ciaa+ciapra

	move.w	#$ff,adkcon(a5)

; Set audio to play extremely quickly from an empty sample buffer

	lea	PaulaOutput_ZeroAudioSample,a0
	move.l	a0,aud0+ac_ptr(a5)
	move.l	a0,aud1+ac_ptr(a5)
	move.l	a0,aud2+ac_ptr(a5)
	move.l	a0,aud3+ac_ptr(a5)

	moveq	#2,d0
	move.w	d0,aud0+ac_len(a5)
	move.w	d0,aud1+ac_len(a5)
	move.w	d0,aud2+ac_len(a5)
	move.w	d0,aud3+ac_len(a5)

	moveq	#124,d0
	move.w	d0,aud0+ac_per(a5)
	move.w	d0,aud1+ac_per(a5)
	move.w	d0,aud2+ac_per(a5)
	move.w	d0,aud3+ac_per(a5)

; Enable audio DMA

	move.w	#DMAF_SETCLR|DMAF_AUD0|DMAF_AUD1|DMAF_AUD2|DMAF_AUD3,dmacon(a5)

; Wait for the audio change to take effect. this is not the
; world's most robust method to do so but it will work reasonably well.

	move.l	#3*1000*1000/50,d1
.wait
	move.b	$bfe001,d0	
	subq.l	#1,d1
	bne.s	.wait

; Disable audio DMA

	move.w	#DMAF_AUD0|DMAF_AUD1|DMAF_AUD2|DMAF_AUD3,dmacon(a5)

; Setup new audio buffers

	lea		PaulaOutput_AudioChipBuffers,a0
	move.l	a0,a1
	moveq	#64,d0
	move.l	d0,d1
	cmp.b	#PaulaOutput_Mode_14BitMono,PaulaOutput_Mode
	bne.s	.singleBuffer
	add.l	#PaulaOutput_AudioBufferSize,a1
	moveq	#1,d1
.singleBuffer

	move.w	d0,aud0+ac_vol(a5)
	move.w	PaulaOutput_ReplayPeriod,aud0+ac_per(a5)
	move.w	#PaulaOutput_AudioBufferSize/2,aud0+ac_len(a5)
	move.l	a0,aud0+ac_ptr(a5)

	move.w	d0,aud1+ac_vol(a5)
	move.w	PaulaOutput_ReplayPeriod,aud1+ac_per(a5)
	move.w	#PaulaOutput_AudioBufferSize/2,aud1+ac_len(a5)
	move.l	a0,aud1+ac_ptr(a5)

	move.w	d1,aud2+ac_vol(a5)
	move.w	PaulaOutput_ReplayPeriod,aud2+ac_per(a5)
	move.w	#PaulaOutput_AudioBufferSize/2,aud2+ac_len(a5)
	move.l	a1,aud2+ac_ptr(a5)

	move.w	d1,aud3+ac_vol(a5)
	move.w	PaulaOutput_ReplayPeriod,aud3+ac_per(a5)
	move.w	#PaulaOutput_AudioBufferSize/2,aud3+ac_len(a5)
	move.l	a1,aud3+ac_ptr(a5)

	move.l	(sp)+,a5
	rts

;------------------------------------------------------------------------------

PaulaOutput_StartAudioHardware

	move.l	a5,-(sp)
	move.l	#$dff000,a5

; Enable audio DMA

	move.w	#DMAF_SETCLR|DMAF_AUD0|DMAF_AUD1|DMAF_AUD2|DMAF_AUD3,dmacon(a5)

	move.l	(sp)+,a5
	rts

;------------------------------------------------------------------------------

PaulaOutput_KillAudioHardware

	move.l	a5,-(sp)
	move.l	#$dff000,a5

; Disable audio DMA

	move.w	#DMAF_AUD0|DMAF_AUD1|DMAF_AUD2|DMAF_AUD3,dmacon(a5)

; Silence all channels

	moveq	#0,d0
	move.w	d0,aud0+ac_vol(a5)
	move.w	d0,aud1+ac_vol(a5)
	move.w	d0,aud2+ac_vol(a5)
	move.w	d0,aud3+ac_vol(a5)

	move.l	(sp)+,a5
	rts

;------------------------------------------------------------------------------

PaulaOutput_InitAudioReplay
	fmove.l	#PaulaOutput_CustomChipFrequency_PAL,fp0
	fdiv.w	PaulaOutput_ReplayPeriod,fp0
	fdiv.l	#PaulaOutput_RefreshRate_PAL,fp0
	fmul.l	#100,fp0
	fmul.l	#65536,fp0
	fmove.l	fp0,d0
	swap	d0
	moveq	#0,d1
	move.w	d0,d1
	clr.w	d0
	move.l	d1,PaulaOutput_SamplesPerVBlank
	move.l	d0,PaulaOutput_SamplesPerVBlank+4
	clr.l	PaulaOutput_PlayPosition
	clr.l	PaulaOutput_PlayPosition+4
	clr.l	PaulaOutput_MixPosition
	rts

;------------------------------------------------------------------------------

PaulaOutput_Mix
	movem.l	d2/a4/a5,-(sp)
	move.l	PaulaOutput_PlayPosition,d0
	move.l	PaulaOutput_MixPosition,d1
	move.l	PaulaOutput_SamplesPerVBlank,d2
	mulu.l	#PaulaOutput_MixAheadFrames,d2
	add.l	d2,d0
	add.l	#$f,d0
	and.b	#$f0,d0

	cmp.l	d0,d1
	bge.s	.noMix

.mixSampleRun

	move.l	d1,d2
	add.l	#PaulaOutput_AudioBufferSize,d2
	and.l	#-PaulaOutput_AudioBufferSize,d2
	cmp.l	d0,d2
	blo.s	.clampAgainstBufferEnd
	move.l	d0,d2
.clampAgainstBufferEnd

	sub.l	d1,d2

	movem.l	d0-d2,-(sp)

	move.l	d1,d0
	and.l	#PaulaOutput_AudioBufferSize-1,d0
	lea	PaulaOutput_AudioChipBuffers,a0
	add.l	d0,a0
	move.l	d2,d0
	move.l	a0,a1
	add.l	#PaulaOutput_AudioBufferSize,a1
	move.l	PaulaOutput_MixRoutine,a5
	move.l	PaulaOutput_MixState,a4
	jsr	(a5)

	movem.l	(sp)+,d0-d2

	add.l	d2,d1

	cmp.l	d0,d1
	blt.s	.mixSampleRun

	move.l	d1,PaulaOutput_MixPosition
.noMix
	movem.l	(sp)+,d2/a4/a5
	rts


	section	bss,bss

PaulaOutput_ReplayPeriod ds.w	1
PaulaOutput_MixActive	ds.b	1
PaulaOutput_Mode		ds.b	1

PaulaOutput_SamplesPerVBlank	ds.l 2
PaulaOutput_PlayPosition	ds.l	2
PaulaOutput_MixPosition	ds.l	1
PaulaOutput_MixRoutine ds.l	1
PaulaOutput_MixState	ds.l 1

	section	data_c,data_c

PaulaOutput_ZeroAudioSample
	dc.w	0,0

	section	bss_c,bss_c

PaulaOutput_AudioChipBuffers
	ds.b	PaulaOutput_AudioBufferSize*2
