/* compleximage.c - program to show the use of a complex Intuition Image.
**
** compiled with:
** lc -b1 -cfist -v -y compleximage.c
** blink FROM LIB:c.o compleximage.o TO compleximage LIB LIB:lc.lib LIB:amiga.lib
*/

#define INTUI_V36_NAMES_ONLY

#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/intuitionbase.h>

#include <clib/exec_protos.h>
#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>

#include <stdio.h>

#ifdef LATTICE
int CXBRK(void)    { return(0); }  /* Disable Lattice CTRL/C handling */
int chkabort(void) { return(0); }  /* really */
#endif

struct IntuitionBase *IntuitionBase = NULL;

#define MYIMAGE_LEFT    (0)
#define MYIMAGE_TOP     (0)
#define MYIMAGE_WIDTH   (24)
#define MYIMAGE_HEIGHT  (10)
#define MYIMAGE_DEPTH   (2)

/* This is the image data.  It is a two bitplane open rectangle which
** is 24 pixels wide and 10 high.  Make sure that it is in CHIP memory,
** or allocate a block of chip memory with a call like:
**
**     AllocMem(data_size,MEMF_CHIP)
**
** and copy the data to that block.  See the Exec chapter on
** Memory Allocation for more information on AllocMem().
*/
UWORD __chip myImageData[] =
    {
    /* first bitplane of data,
    ** open rectangle.
    */
    0xFFFF, 0xFF00,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xC000, 0x0300,
    0xFFFF, 0xFF00,

    /* second bitplane of data,
    ** filled rectangle to appear within open rectangle.
    */
    0x0000, 0x0000,
    0x0000, 0x0000,
    0x0000, 0x0000,
    0x00FF, 0x0000,
    0x00FF, 0x0000,
    0x00FF, 0x0000,
    0x00FF, 0x0000,
    0x0000, 0x0000,
    0x0000, 0x0000,
    0x0000, 0x0000,
    };

/* used to get the "new look" on a custom screen */
UWORD pens[] = { ~0 };


/*
** main routine. Open required library and window and draw the images.
** This routine opens a very simple window with no IDCMP.  See the
** chapters on "Windows" and "Input and Output Methods" for more info.
** Free all resources when done.
*/
VOID main(int argc, char *argv[])
{
struct Screen *scr;
struct Window *win;
struct Image myImage;

IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",37);
if (IntuitionBase != NULL)
    {
    if (NULL != (scr = OpenScreenTags(NULL,
                        SA_Depth,       4,
                        SA_Pens,        &pens,
                        TAG_END)))
        {
        if (NULL != (win = OpenWindowTags(NULL,
                            WA_RMBTrap,      TRUE,
                            WA_CustomScreen, scr,
                            TAG_END)))
            {
            myImage.LeftEdge    = MYIMAGE_LEFT;
            myImage.TopEdge     = MYIMAGE_TOP;
            myImage.Width       = MYIMAGE_WIDTH;
            myImage.Height      = MYIMAGE_HEIGHT;
            myImage.Depth       = MYIMAGE_DEPTH;
            myImage.ImageData   = myImageData;
            myImage.PlanePick   = 0x3;              /* use first two bitplanes */
            myImage.PlaneOnOff  = 0x0;              /* clear all unused planes  */
            myImage.NextImage   = NULL;

            /* Draw the image into the first two bitplanes */
            DrawImage(win->RPort,&myImage,10,10);

            /* Draw the same image at a new location */
            DrawImage(win->RPort,&myImage,100,10);

            /* Change the image to use the second and fourth bitplanes,
            ** PlanePick is 1010 binary or 0xA,
            ** and draw it again at a different location
            */
            myImage.PlanePick = 0xA;
            DrawImage(win->RPort,&myImage,10,50);

            /* Now set all the bits in the first bitplane with PlaneOnOff.
            ** This will make all the bits set in the second bitplane
            ** appear as color 3 (0011 binary), all the bits set in the
            ** fourth bitplane appear as color 9 (1001 binary) and all
            ** other pixels will be color 1 (0001 binary.  If there were
            ** any points in the image where both bits were set, they
            ** would appear as color 11 (1011 binary).
            ** Draw the image at a different location.
            */
            myImage.PlaneOnOff = 0x1;
            DrawImage(win->RPort,&myImage,100,50);

            /* Wait a bit, then quit.
            ** In a real application, this would be an event loop, like the
            ** one described in the Intuition Input and Output Methods chapter.
            */
            Delay(200);

            CloseWindow(win);
            }
        CloseScreen(scr);
        }
    CloseLibrary((struct Library *)IntuitionBase);
    }
}
