;
; HAM_playfield.asm
;
; The following example code generates a six-bitplane display with
; hold-and-modify mode turned on. All 32 color registers are loaded
; with black to prove that the colors are being generated by
; hold-and-modify. The equates are the usual and are not repeated here.

;  First, set up the control registers.
;
        LEA     CUSTOM,a0               ; Point a0 at custom chips
        MOVE.W  #$6A00,BPLCON0(a0)      ; Six bitplanes, hold-and-modify mode
        MOVE.W  #0,BPLCON1(a0)          ; Horizontal scroll = 0
        MOVE.W  #0,BPL1MOD(a0)          ; Modulo for odd bitplanes = 0
        MOVE.W  #0,BPL2MOD(a0)          ; Ditto for even bitplanes
        MOVE.W  #$0038,DDFSTRT(a0)      ; Set data-fetch start
        MOVE.W  #$00D0,DDFSTOP(a0)      ; Set data-fetch stop
        MOVE.W  #$2C81,DIWSTRT(a0)      ; Set display window start
        MOVE.W  #$F4C1,DIWSTOP(a0)      ; Set display window stop
;
;  Set all color registers = black to prove that hold-and-modify mode is working.
;
        MOVE.W  #32,d0                  ; Initialize counter
        LEA     CUSTOM+COLOR00,a1       ; Point a1 at first color register
CREGLOOP:
        MOVE.W  #$0000,(a1)+            ; Write black to a color register
        DBRA    d0,CREGLOOP             ; Decrement counter and loop til done...
;
;  Fill six bitplanes with an easily recognizable pattern.
;
;  NOTE:  This is just for example use.  Normally these bitplanes would
;         need to be allocated from the system MEMF_CHIP memory pool.
;
        MOVE.W  #2000,d0                ; 2000 longwords per bitplane
        MOVE.L  #$21000,a1              ; Point a1 at bitplane 1
        MOVE.L  #$23000,a2              ; Point a2 at bitplane 2
        MOVE.L  #$25000,a3              ; Point a3 at bitplane 3
        MOVE.L  #$27000,a4              ; Point a4 at bitplane 4
        MOVE.L  #$29000,a5              ; Point a5 at bitplane 5
        MOVE.L  #$2B000,a6              ; Point a6 at bitplane 6
FPLLOOP:
        MOVE.L  #$55555555,(a1)+        ; Fill bitplane 1 with $55555555
        MOVE.L  #$33333333,(a2)+        ; Fill bitplane 2 with $33333333
        MOVE.L  #$0F0F0F0F,(a3)+        ; Fill bitplane 3 with $0F0F0F0F
        MOVE.L  #$00FF00FF,(a4)+        ; Fill bitplane 4 with $00FF00FF
        MOVE.L  #$CF3CF3CF,(a5)+        ; Fill bitplane 5 with $CF3CF3CF
        MOVE.L  #$3CF3CF3C,(a6)+        ; Fill bitplane 6 with $3CF3CF3C
        DBRA    d0,FPLLOOP              ; Decrement counter and loop til done...
;
;  Set up a Copper list at $20000.
;
;  NOTE:  As with the bitplanes, the copper list location should be allocated
;         from the system MEMF_CHIP memory pool.
;
        MOVE.L  #$20000,a1              ; Point a1 at Copper list destination
        LEA     COPPERL(pc),a2          ; Point a2 at Copper list image
CLOOP:  MOVE.L  (a2),(a1)+              ; Move a long word...
        CMPI.L  #$FFFFFFFE,(a2)+        ; Check for end of Copper list
        BNE     CLOOP                   ; Loop until entire Copper list moved
;
;  Point Copper at Copper list.
;
        MOVE.L  #$20000,COP1LCH(a0)     ; Load Copper jump register
        MOVE.W  COPJMP1(a0),d0          ; Force load into Copper P.C.
;
;  Start DMA.
;
        MOVE.W  #$8380,DMACON(a0)       ; Enable bitplane and Copper DMA

        BRA     .....next stuff to do.....
;
;  Copper list for six bitplanes.  Bitplane 1 is at $21000; 2 is at $23000;
;  3 is at $25000; 4 is at $27000; 5 is at $29000; 6 is at $2B000.
;
;  NOTE:  These bitplane addresses are for example purposes only.
;         See note above.
;
COPPERL:
        DC.W    BPL1PTH,$0002   ; Bitplane 1 pointer = $21000
        DC.W    BPL1PTL,$1000
        DC.W    BPL2PTH,$0002   ; Bitplane 2 pointer = $23000
        DC.W    BPL2PTL,$3000
        DC.W    BPL3PTH,$0002   ; Bitplane 3 pointer = $25000
        DC.W    BPL3PTL,$5000
        DC.W    BPL4PTH,$0002   ; Bitplane 4 pointer = $27000
        DC.W    BPL4PTL,$7000
        DC.W    BPL5PTH,$0002   ; Bitplane 5 pointer = $29000
        DC.W    BPL5PTL,$9000
        DC.W    BPL6PTH,$0002   ; Bitplane 6 pointer = $2B000
        DC.W    BPL6PTL,$B000
        DC.W    $FFFF,$FFFE     ; Wait for the impossible, i.e., quit
