;******************************************************************************
;*
;* COPYRIGHT: Unless otherwise noted, all files are Copyright (c) 1992-1996
;* Amiga International.  All rights reserved.
;*
;* DISCLAIMER: This software is provided "as is".  No representations or
;* warranties are made with respect to the accuracy, reliability, performance,
;* currentness, or operation of this software, and all use is at your own risk.
;* Neither Amiga International nor the authors assume any responsibility or liability
;* whatsoever with respect to your use of this software.
;*
;******************************************************************************
;* classinit.asm
;* Library routines for a DataTypes class

;---------------------------------------------------------------------------

        NOLIST

        INCLUDE "exec/types.i"
        INCLUDE "exec/libraries.i"
        INCLUDE "exec/lists.i"
        INCLUDE "exec/alerts.i"
        INCLUDE "exec/initializers.i"
        INCLUDE "exec/resident.i"
        INCLUDE "libraries/dos.i"

        INCLUDE "bmp_rev.i"
        INCLUDE "classbase.i"

        LIST

;---------------------------------------------------------------------------

	SECTION	text,code

;---------------------------------------------------------------------------

	XREF	_LibInit
	XREF	_LibOpen
	XREF	_LibClose
	XREF	_LibExpunge

	XREF	_ObtainBMPEngine

        XREF    ENDCODE

;---------------------------------------------------------------------------

        XDEF    LibReserved

;---------------------------------------------------------------------------

; First executable location, must return an error to the caller
Start:
        moveq   #-1,d0
        rts

;-----------------------------------------------------------------------

ROMTAG:
        DC.W    RTC_MATCHWORD           ; UWORD RT_MATCHWORD
        DC.L    ROMTAG                  ; APTR  RT_MATCHTAG
        DC.L    ENDCODE                 ; APTR  RT_ENDSKIP
        DC.B    RTF_AUTOINIT            ; UBYTE RT_FLAGS
        DC.B    VERSION                 ; UBYTE RT_VERSION
        DC.B    NT_LIBRARY              ; UBYTE RT_TYPE
        DC.B    0                       ; BYTE  RT_PRI
        DC.L    LibName                 ; APTR  RT_NAME
        DC.L    LibId                   ; APTR  RT_IDSTRING
        DC.L    LibInitTable            ; APTR  RT_INIT

LibName DC.B 'bmp.datatype',0
LibId   VSTRING

        CNOP    0,4

LibInitTable:
        DC.L    ClassBase_SIZEOF
        DC.L    LibFuncTable
        DC.L    LibDataTable
        DC.L    _LibInit

V_DEF	MACRO
	DC.W	\1+(*-LibFuncTable)
	ENDM

LibFuncTable:
	DC.W	-1
        V_DEF	_LibOpen
        V_DEF	_LibClose
        V_DEF	_LibExpunge
        V_DEF	LibReserved

	V_DEF	_ObtainBMPEngine

        DC.W   -1

LibDataTable:
        INITBYTE   LN_TYPE,NT_LIBRARY
        INITLONG   LN_NAME,LibName
        INITBYTE   LIB_FLAGS,(LIBF_SUMUSED!LIBF_CHANGED)
        INITWORD   LIB_VERSION,VERSION
        INITWORD   LIB_REVISION,REVISION
        INITLONG   LIB_IDSTRING,LibId
        DC.W       0

        CNOP    0,4

;-----------------------------------------------------------------------

LibReserved:
        moveq   #0,d0
        rts

;-----------------------------------------------------------------------

        END
