/***********************************************************************
 *                                                                     *
 *                            COPYRIGHTS                               *
 *                                                                     *
 *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.   *
 *                                                                     *
 **********************************************************************/

/* ez.c */

#include <exec/types.h>
#include <intuition/intuition.h>

/* lc -L -iVINCLUDE: -iINCLATTICE: ez	*/

/*
 * test by passing text string, gadget string, (string) args
 *	example:
 *	ez "Please insert volume %s|in any drive." Retry|Cancel MyVol
 *
 * NOTE: This program converts '|' separators in the body text format
 * string you provide to '\n', which is the (new) proper line
 * separator.
 */

struct IntuitionBase	*IntuitionBase;
APTR			GfxBase;

struct EasyStruct myezreq = {
    sizeof (struct EasyStruct), 0,
    "EasyRequest Test Program",
    "Usage: \"ez <text string> <gadget string> <arg1> <arg2> ...\"\n\
where <text string> has '|' separators at line breaks,\n\
and <gadget text> has '|' separators between gadgets.\n\
The <argN> parameters are for 'printf-style'\n'%%' commands in the strings.",
    "I understand.|I'll figure it out someday."
};

struct EasyStruct argezreq = {
    sizeof (struct EasyStruct), 0,
    "From the Command Line",
    "Test Line",
    "Gadgets",
};

void changeToNewline();

main( argc, argv )
UBYTE	**argv;
{
    ULONG	idcmp = DISKINSERTED;
    int		retval;
    struct Window	*reqwindow;
    struct Window	*BuildEasyRequest();

    IntuitionBase = (struct IntuitionBase *)
	    OpenLibrary("intuition.library", 33 );
    GfxBase = (APTR) OpenLibrary("graphics.library", 33 );

    if ( IntuitionBase && GfxBase )
    {
	if ( argc < 2 )
	{
#if 1
	    reqwindow = BuildEasyRequest( NULL, &myezreq, 0L, 50 );
	    while ( (retval=SysReqHandler( reqwindow, NULL, TRUE ) ) == -2 )
	    {
		;
	    }
	    FreeSysRequest( reqwindow );
#else
	    retval = EasyRequest( NULL, &myezreq, NULL, 50 );
#endif
	}
	else
	{
	    argezreq.es_TextFormat = argv[ 1 ];
	    changeToNewline( argezreq.es_TextFormat );
	    if ( argc >= 3 ) argezreq.es_GadgetFormat = argv[ 2 ];
	    retval = EasyRequestArgs( NULL, &argezreq, &idcmp, argv+3 );
	}

	printf( "AFR returned %lx\n", retval );
    }
    else
    {
	puts( "can't open Intuition." );
    }
}

/* 
 * convert '|' in text format string to newlines
 */
void
changeToNewline( c )
UBYTE	*c;
{
    while ( *c != '\0' )
    {
	if ( *c == '|' )
	{
	    *c = '\n';
	}
	c++;
    }
}

struct Window	*
BuildEasyRequest( w, ez, idcmp, arg1 )
struct Window	*w;
struct EasyStruct *ez;
ULONG		idcmp;
int		arg1;
{
    struct Window	*BuildEasyRequestArgs();

    return ( BuildEasyRequestArgs( w, ez, idcmp, &arg1 ) );
}

EasyRequest( w, ez, ip, args )
struct Window	*w;
struct EasyStruct *ez;
ULONG		*ip;
int	args;
{
    printf("args at %lx\n", &args );
    return ( EasyRequestArgs( w, ez, ip, &args ) );
}
