
   /***********************************************************************
   *                                                                      *
   *                            COPYRIGHTS                                *
   *                                                                      *
   *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.    *
   *                                                                      *
   ***********************************************************************/

#include "app.h"

/* An input expression to match any RAWKEY event with the
  * CAPSLOCK qualifier bit set
 */
IX myix = {
   IX_VERSION,             /* required                           */
   NULL,                   /* matches any class */

   0,           /* Code: won't care                     */
   0,           /* CodeMask: 0 means don't care about Code   */

   0,   /* qualifier I am interested in            */
   0,   /* and it's the only qualifier of interest   */
   0                       /* synonyms irrelevant                  */
};

BOOL setupLeftyMouse(void);
void myaction(struct CxMsg *,CxObj *);

BOOL setupLeftyMouse()
{
   CxObj   *filter;

   filter = CxFilter(NULL);
   if (!filter)
      return(0);

   SetFilterIX(filter, &myix);

   /** DEBUG **/
   D( AttachCxObj(filter, CxDebug( 0xDEADFACE)) );

   AttachCxObj(filter, CxCustom( myaction, 0L));

   if (CxObjError(filter))
   {
      D( printf("nocapslock: filter error %lx\n", CxObjError(filter) ) );
      DeleteCxObjAll(filter);
      return(0);
   }

   AttachCxObj(broker, filter);

   return(TRUE);
}
void myaction(cxm,co)
register struct CxMsg *cxm;
CxObj *co;
{
   register struct InputEvent *ie;
   ULONG temp;

   D( kprintf("action\n") );

   /* i KNOW that all messages getting this far are CXM_IEVENT   */
   ie = (struct InputEvent *) CxMsgData(cxm);

   if(ie->ie_Class == IECLASS_RAWMOUSE)
   {
      temp=ie->ie_Code & 0x7f;
      if(temp == IECODE_LBUTTON)
      {
         ie->ie_Code &= ~IECODE_LBUTTON;
         ie->ie_Code |= IECODE_RBUTTON;
      } else
         if(temp == IECODE_RBUTTON)
         {
            ie->ie_Code &= ~IECODE_RBUTTON;
            ie->ie_Code |= IECODE_LBUTTON;
         }
   }

   if( ! (ie->ie_Qualifier & IEQUALIFIER_LEFTBUTTON)&&
   (ie->ie_Qualifier & IEQUALIFIER_RBUTTON) )
   {
      if(ie->ie_Qualifier & IEQUALIFIER_RBUTTON)
      {
         ie->ie_Qualifier &= ~IEQUALIFIER_RBUTTON;
         ie->ie_Qualifier &= IEQUALIFIER_LEFTBUTTON;
      } else
         if(ie->ie_Qualifier & IEQUALIFIER_LEFTBUTTON)
         {
            ie->ie_Qualifier &= ~IEQUALIFIER_LEFTBUTTON;
            ie->ie_Qualifier &= IEQUALIFIER_RBUTTON;
         }
   }
}
