bersetzungsrichtlinien fr Spezialausdrcke in
Amiga- und CDTV-Dokumentationen

(Der Erluterungstext ist in Englisch gehalten, damit er auch fr
auslndische Softwareanbieter anwendbar ist.)

----
Guidelines for German translations of Amiga documentation

Version 9, 1.10.1992
by Dr. Peter Kittel, Commodore Frankfurt, Germany




This document is intended to help you make your German documentation for
your Amiga products consistant with the documentation Commodore provides
with its products. You should strictly follow these guidelines. Otherwise,
the user may be confused by several manuals talking about the same subject
in totally different ways.
For the same reason, these guidelines should be followed by authors of
computer books or magazine articles.

Though here more Amiga specific terms are covered, most of these
guidelines are also applicable for documentation for Commodore
MS-DOS PC's.

1. Part One is a simple vocabulary list where you will find many
Amiga-specific and general computer terms. You will not find terms
you can directly take from any normal English-German dictionary
that have no special or differing meaning in the computer world.

2. Part Two is a special glossary for CDTV. It has certain similarities
with Amiga, but also some significant differences. This part is not
only a vocabulary, but also comes with explanations of the terms and
when to use which of them. These explanations are in German.

3. Part Three is a collection of some general rules and hints for the German
language and documentation.




This document is provided "as is" and is subject to change. It reflects the
current status of the project.






First part: Vocabulary

American                     German
-------------------------------------------------------------------
# (number)                   Nr.
3-prong power plug           Schutzkontaktstecker, Schukostecker
@ (at sign)                  a) letter: "Klammeraffe", "geschweiftes a",
                             b) meaning at: an, bei
AC                           Wechselspannung
AC adapter                   Netzteil
AC outlet                    Netzsteckdose
accelerator board            Beschleunigerkarte
action gadget                Aktionssymbol
activity light               Kontrollampe
add-on                       Zusatz
alarm (clock)                Wecker
alert                        Warnmeldung
allocate, to                 reservieren
ampersand                    kaufmnnisches Und
animation                    Animation
argument (of a command)      Argument
array                        Feld (-variable)
array subscript              Feldindex
aspect (vert. or horiz.)     Bildlage
aspect ratio                 Bildseitenverhltnis
assembly (language)          Assembler
assign, to                   zuweisen
At sign                      "At"-Zeichen, "Klammeraffe"
autoboot                     Autoboot
autoconfig, to               autokonfigurieren
AutoScroll                   Auto-Rollen
average current              Betriebsstrom
back                         Hintergrund
back gadget                  Hintergrundsymbol
backdrop window              Hintergrundfenster
backfilled                   ausgefllt
backslash                    Schrgstrich rckwrts
backspace key                Rcktaste
backup                       Sicherungskopie
bail arm                     Bgel (mit Andruckrollen)
bail roller                  Andruckrollen
bank, banks (of memory)      (Speicher-)Bank, Bnke
batch file                   Befehlsdatei, Skript
battery-backed-up real-time clock
                             batteriegepufferte Echtzeituhr
baud rate                    Baudrate
BBS                          Mailbox
beep, to                     piepsen
bezel                        Blende
binary                       a) file: ausfhrbares Programm,
                             b) else: binr
bit plane                    Bitplane (Speicherebene)
bitmap                       Bitmap
block statement              a) Anweisungsblock,
                             b) Blocksteueranweisung
bob                          Bob
bold                         fett (precise: halbfett)
boldface                     Fettdruck
boolean operation            boolsche Operation
boot, to                     (neu)starten (booten)
boot block                   Boot-Block
box (graphics)               Feld, Rahmen
bridge slot                  Brckensteckplatz
bridgeboard                  Brckenkarte
brush                        Pinsel
buffer                       Pufferspeicher
bus                          Bus
button                       a) mouse: Taste (never: Knopf!),
                             b) the physical device: Knopf,
                             c) sort of gadget: Feld
bypass, to                   umgehen
cache                        der Cache (schneller Pufferspeicher)
calculator                   Taschenrechner
call                         Aufruf
cancel, to                   abbrechen
canvas                       Zeichenflche
Caps Lock key                Taste "Nur Grobuchstaben"
caret sign (^)               Pfeilzeichen
carriage return              Wagenrcklauf
character chart              Zeichensatztabelle
check box                    Auswahlfeld
check spelling               Rechtschreibkontrolle
checkmark                    Hkchen
CHIP RAM                     Chip-RAM
circuitry                    Elektronik
clear, to                    lschen
CLI                          CLI (Befehlszeileneingabe)
click, to                    whlen (mit der Maus), klicken
clipboard                    Zwischenspeicher, Clipboard
clock                        a) time: Uhr,
                             b) processor: Takt
clock speed                  Taktfrequenz
close gadget                 Schliesymbol
close, to                    schlieen
code (program)               Programm (-Text)
coiled cable                 Spiralkabel
color cycling                Farbzyklus
column                       Spalte
command line                 Befehlszeile
command template             Befehlsschablone
compatible with              kompatibel zu
complement, to               invertieren
composite video signal       Composite-Videosignal
compress, to                 komprimieren
component                    a) electronics: Bauteil,
                             b) else: Komponente
component side (of a PCB)    Bestckungsseite
connector                    a) general: Anschlu,
                             b) male: Stecker,
                             c) female cable: Kupplung,
                             d) female at the box: Buchse
contiguous                   zusammenhngend
continuous paper             Endlospapier
control character            Steuerzeichen
control, to                  steuern
controller                   a) for peripheral: Controller,
                             b) joystick/game controller: Joystick
copy-protected               kopiergeschtzt
corrupt                      defekt
CPU                          CPU, Prozessor
"crash" (of software)        "Absturz" (eines Programms)
create, to (some struct)     anlegen
cursor                       a) text/CLI: Cursor (Schreibmarke),
                             b) mouse: Pfeil
custom chip                  Spezialchip, Customchip
customize, to                individualisieren
cut, to                      lschen, ausschneiden
cycle gadget                 Blttersymbol
d-type connector             Submin-D-Steckverbinder (-Stecker, -Buchse,...)
daisy chain ...              in Reihe, in Serie
daisy wheel printer          Typenraddrucker
data encoding (disk)         Schreibverfahren
data reduction               Datenkompression
database                     Datenbank
daughterboard                Tochterplatine
DB-25 connector              25poliger Submin-D-Stecker/Kupplung/Buchse
DC                           Gleichspannung
deactivate, to               inaktivieren
dead key                     Akzenttaste
deadlock                     Blockade
debugging                    Fehlersuche
declare, to                  deklarieren
default                      Standard, Vorgabe, Ersatzwert
default tool (of an icon)    Standardprogramm
delete key                   Lschtaste
delete, to                   lschen
delete protected             lschgeschtzt
delimiter                    Trennzeichen
desiccant                    feuchteabsorbierend
destination                  Ziel
device                       Gert, logisches Gert
device driver                Gertetreiber (-programm)
DIP switch                   DIP-Schalter
directive                    Anweisung
directory                    Verzeichnis, Schublade (never: Ordner!)
disc                         Disc (nur lesbar, z. B. CD)
disk                         a) Floppy: Diskette,
                             b) HD: Festplatte,
                             c) general: Disk
disk drive                   ...-Laufwerk
disk gauge                   Disk-Fllanzeige
disk swap                    Diskwechsel
display                      Anzeige, Monitoranzeige
display mode                 Anzeigemodus
dithering                    Schattierung
document                     Dokument
done                         beendet
dot matrix printer           Matrixdrucker
double click                 aktivieren, Doppelklick, zweimal klicken
double precision             doppelte Genauigkeit
double space                 a) zweizeilig (for small lpi),
                             b) gesperrte Schrift (for small cpi)
draft (quality)              normal, Entwurf, Entwurfsqualitt
drag bar                     Ziehleiste
drag, to                     ziehen
drawer                       Schublade (Unterverzeichnis) (never: Ordner!)
drive                        Laufwerk
drive bay                    Laufwerksschacht
drive door                   Laufwerksklappe
driver                       Treiber (-programm)
dual-port RAM                Dual-Port-RAM (Kommunikationsspeicher)
dummy ...                    Pseudo-... (Behelfs-...)
edge card connector          Kartenstecker
edit, to                     edieren (bearbeiten)
edit protected               nderungsgeschtzt
eject, to                    auswerfen
enable, to                   aktivieren, zulassen, ermglichen
enter key                    Eingabetaste
environment                  Umgebung
escape sequence              Escape-Sequenz
etched (monitor surface)     getzt
event                        Ereignis
event trapping               Ereignissteuerung
executable                   ausfhrbares Programm
exit                         Ende
expanded memory (MS-DOS)     Ausbauspeicher
expansion board              Erweiterungskarte
expression (numeric, logic)  Ausdruck
extended memory (MS-DOS)     Erweiterungsspeicher
Extra-Halfbright             Extra-Halfbright
faceplate                    Blende
factory-set default          Werkseinstellung
fail, to                     milingen, fehlschlagen
fan                          Lfter
fanfold paper                Endlospapier
FAST RAM                     Fast-RAM
female connector             a) on case: Buchse,
                             b) on cable: Kupplung
field                        Feld
file                         Datei
file header                  Dateikopf
filecard                     Festplattenkarte
filename extension           Dateinamenserweiterung, Suffix
filerequester                Dateiauswahlfenster
filing system                Dateisystem
final print quality          Schnschrift
flicker                      Flimmern
floating point               Fliekomma
floppy                       Diskette, Floppy
flush (buffers)              (Puffer) entleeren
font                         Zeichensatz
form                         Formular
form factor                  a) chip: Gehuseart,
                             b) card: Kartenabmessungen
form feed                    Seitenvorschub
format, to                   formatieren
fractional portion           Nachkommastellen
frame                        a) graphic: Rahmen,
                             b) video: Bild (Einzelbild)
front                        Vordergrund
front gadget                 Vordergrundsymbol
gadget                       Symbol, sometimes: Feld
genlock                      Genlock
ghost gadget                 Geistersymbol
ghost title                  Geistertitel
graphics                     Grafik (always with f!)
grid                         Gitter, Raster
grinded (monitor surface)    aufgerauht
ground                       Masse
GUI                          grafische Benutzeroberflche
handle                       Angriffspunkt (Griff)
handler                      Handler (Ein-/Ausgabeprogramm)
handshaking                  Handshaking (Protokoll)
harddisk                     Festplatte
hardware                     Hardware
header                       Kopfzeile
heap                         Arbeitsspeicher
help                         Hilfe
hide, to                     verbergen
highlight, to                hervorheben, markieren
Hold And Modify              Hold And Modify
hook vector                  Hook-Vektor
host                         Host-Rechner, Gastrechner
hot key                      Tastenbefehl
I/O                          Ein-/Ausgabe, E/A (I/O)
icon                         Piktogramm
id                           Kennung
idle                         im Ruhezustand
indent, to                   einrcken
initialize (a disk), to      formatieren
ink jet printer              Tintenstrahldrucker
insert page break, to        Seitenwechsel einfgen
insert, to                   einfgen
install, to                  a) Software package: installieren,
                             b) mechanically: einbauen, einsetzen
integer                      ganze Zahl, Ganzzahl
interface                    a) Schnittstelle,
                             b) if separate device: Interface
interference                 Strung
interlace                    Zeilensprung (-verfahren) (Interlace)
interleave factor            Interleave-Faktor (Sektorversatz)
interrupt                    Interrupt (Unterbrechung)
interrupt level              Interrupt-Ebene
invalid                      ungltig
invoke                       aufrufen
italic(s)                    kursiv
joystick                     Joystick
jump table                   Sprungleiste
jumper                       Jumper (Kurzschlustecker)
justify                      Randausgleich
kB                           KB  (uppercase K = 1024)
key                          a) keyboard: Taste,
                             b) disk block no.: Block,
                             c) music score: Tonart,
                             d) video overlaying: stanzen,
                             e) database and else: Schlssel
key map                      Tastaturbelegung
key word                     Schlsselwort
keyboard                     Tastatur
keyboard shortcut            Tastaturkurzbefehl
keypad                       Tastenfeld, Tastenblock
keystroke                    Tastenanschlag
KHz                          kHz (lowercase k = 1000)
Kickstart disk               Kickstart-Diskette
kit                          Einbausatz
label                        a) program, script: Marke, Sprungmarke
                             b) diskette: Aufkleber, Etikett
label, to                    benennen
launch, to (a program)       (ein Programm) starten
layout                       Layout, (Seiten-) Gestaltung
leave out, to                auslagern
left mouse button            linke Maustaste, Whltaste
library (of functions)       (Funktions-) Bibliothek
light pen                    Lichtgriffel
line                         a) text: Zeile,
                             b) graphics: Linie
line feed                    Zeilenvorschub
load, to                     laden
lock (AmigaDOS)              Lock (Zugriffsreservierung)
lock, to                     verriegeln, sperren
log                          a) log in, to: anmelden,
                             b) log, to: protokollieren,
                             c) noun: Protokoll
loop                         Schleife
low-level format, to         physisch formatieren
lubricant                    Schmiermittel
macro                        das Makro
main board                   Hauptplatine
male connector               Stecker
margin                       Rand
mark (RS 232)                Bitwert 1 (Mark)
math coprocessor             numerischer Coprozessor
memory                       Speicher
memory meter                 Speicherplatzanzeige
menu                         Men
menu bar                     Menleiste
menu button                  Mentaste
menu item                    Menpunkt
menu shortcut                Tastaturabkrzung fr Menpunkt
mode                         Modus
monochrome                   monochrom
motherboard                  Hauptplatine
mount, to                    a) AmigaDOS: anmelden,
                             b) UNIX: eingliedern,
                             c) mechanically: montieren, befestigen,
                                              anschrauben
mountlist entry              Eintrag in Mountlist-Datei
mouse                        Maus
mouse ball                   Mauskugel
mouse button                 Maustaste (never: Mausknopf!)
mousepad                     Mausmatte
multiple choice              Mehrfachauswahl
nested (loop/statement)      verschachtelt
no. (abbrev. for number)     Nr. (No.)
noise                        a) random sound: Rauschen,
                             b) interferences: Strungen
non-recoverable              nicht behebbar
non-removable                nicht auswechselbar
notification                 Notifikation
numeric keypad               Zehnertastatur
ok                           ok
onboard ...                  ... auf Hauptplatine
online help                  integrierte Hilfsfunktion
open, to                     ffnen (program: starten)
operating mode               Betriebsart
operating system             Betriebssystem
option                       Option (but menu option: Menpunkt)
overscan                     Randbereich, Overscan
package (of chips)           (Chip-) Gehuse
parent directory             Mutterverzeichnis, bergeordnetes Verzeichnis,
                                bergeordnete Schublade
parity                       Paritt
partition                    Partition
password                     Pawort
paste, to                    einfgen
patch, to                    korrigieren
path                         Pfad (Suchpfad)
pattern matching (AmigaDOS)  (AmigaDOS-) Namensmuster
PCB                          Platine
peak-to-peak (voltage)       Vss (Volt Spitze-Spitze)
peripherals                  a) in-box: Erweiterung, Ergnzung,
                             b) external: Peripheriegert
persistance (monitor)        Nachleuchtdauer
Philips screwdriver          Kreuzschlitzschraubenzieher
phoneme                      Phonem (Sprachlaut)
phono plug                   Cinch-Stecker
phosphor etching             Einbrennen des Phosphors
pin                          Pin, Stift
pitch                        a) display, printer: Zeichendichte,
                             b) monitor: Punktdichte,
                             c) sound: Tonhhe
pixel                        Bildpunkt
plain                        normal
point size (font)            Schriftgre in Punkt, Schriftgrad
point, to                    zeigen
pointer                      a) graphic: Zeiger, Pfeil,
                             b) program: Adrezeiger
port                         a) electrical: Anschlu, Schnittstelle,
                             b) software (like ARexx): der Port
power                        a) mains voltage: Netz,
                             b) low voltage: Stromversorgung
power connector              Stromversorgungsstecker
power light/LED              Netzkontrolleuchte
power supply                 a) connect to mains voltage: Netzteil,
                             b) inside box: Stromversorgung
power supply cord            Netzkabel
power switch                 Netzschalter
power-up message             Einschaltmeldung
preamble                     Prambel
preferences                  Voreinsteller (-Programm)
prefix                       Prfix
prepare, to (disk, card)     einrichten
preset                       Voreinstellung, Vorgabe
preview                      Vorschau
print, to                    drucken
printer                      Drucker
process, to                  verarbeiten
project                      Projekt (im Sinne von Programmdaten)
prompt                       Eingabeaufforderung
  at the shell prompt           hinter der Eingabeaufforderung
protect tab                  Schreibschutz
public screen                Public-Schirm, ffentlicher Schirm
pull down menu               Abrollmen
put away, to (Workbench)     zurcklegen
quartz                       Quarz
queue                        Warteschlange
quit, to                     beenden
radio button                 Druckknopfsymbol
RAM                          das RAM, der Arbeitsspeicher
random access file           Direktzugriffsdatei
RCA jack                     Cinch-Buchse
RCA plug                     Cinch-Stecker
reboot, to                   neustarten
read protected               lesegeschtzt
record                       Datensatz
recoverable RAM disk         resetfeste RAM-Disk
redirect, to                 umleiten
redisplay                    Neuanzeige
redo                         nochmal
reentrant                    wiedereintrittsfhig (reentrant)
relabel, to                  umbenennen
rename, to                   umbenennen
replace, to                  ersetzem
requester                    Dialogfenster (Kommunikationsfenster)
reset, to                    rcksetzen
resident                     resident
resource                     Betriebsmittel, Ressource
restore, to                  wiederherstellen
return code                  Rckgabecode
return key                   Eingabetaste
reverse                      a) graphic: invers,
                             b) video player: rckwrts
RF                           Hochfrequenz, HF
ribbon (for printer)         Farbband
ribbon cable                 Flachkabel, Flachbandkabel
right mouse button           rechte Maustaste, Mentaste
robot voice                  Computerstimme
root (directory)             Hauptverzeichnis
root block                   Root-Block
row                          Zeile
run a program, to            ein Programm starten, aufrufen
run time                     Laufzeit
save, to                     speichern
scale, to                    skalieren
scan                         Suchlauf, Prflauf
scan, to                     untersuchen
schematics                   Schaltplne
screen                       Bildschirm
script file                  Befehlsdatei (Skript(datei))
scroll arrow                 Rollpfeil
scroll bar                   Rollbalken
scroll box                   Rollbox
scroll gadget                Rollsymbol
scroll, to                   rollen (durchrollen)
search path                  Suchpfad
select, to                   whlen, auswhlen
selected option              gewhlte Funktion (Option, gewhlter Punkt)
selected window              gewhltes (aktives) Fenster
selection gadget             Auswahlsymbol
serial device                serielle Schnittstelle
session                      Computersitzung
setup, to                    konfigurieren
shading                      Schattierung
shell                        a) AmigaDOS: die Shell,
                             b) connector: Buchse
shift key                    Umschalttaste (Shift-Taste)
shut down, to                herunterfahren
shutter                      Verschlu
silicon                      Silizium
single precision             einfache Genauigkeit
single sheet                 Einzelblatt
single space                 einzeilig
sizing gadget                Grensymbol
skip, to                     berspringen
slash                        Schrgstrich
slider                       Schieberegler
slider bar                   Schiebereglerknopf
slider gadget                Schiebereglersymbol
slot                         Steckplatz
socket                       a) for IC's: Sockel
                             b) else: Steckplatz
software                     Software
sound sample                 digitalisierte Sounddaten
source code                  Programm-Quelltext
source disk                  Quelldisk(ette)
space                        a) character: Leerzeichen, Leertaste,
                             b) RS232: Nullbit, Bitwert 0 (Space)
space bar                    Leertaste
spacing (of lines)           Zeilendichte
spell checker                Rechtschreibberprfung
spreadsheet                  Tabellenkalkulation
sprite                       das Sprite
stack                        Stapelspeicher (Stack)
stack size                   Stack-Gre
startup-sequence             Datei "Startup-Sequence"
static levels                statische Aufladung
stencil                      Maske
stop                         Stopp
storage                      Speicher
string                       Zeichenkette
string gadget                Texteingabefeld
style                        Schriftattribut
sub-d connector              Submin-D-Steckverbinder (-Stecker, -Buchse,...)
subdirectory                 Unterverzeichnis, Schublade (never: Ordner!)
submenu                      Untermen
subscript                    a) noun: Index,
                             b) verb: tiefstellen
superscript                  a) noun: Exponent,
                             b) verb: hochstellen
surge (current)              Anlaufstrom
swap (of disks)              Diskwechsel
symbol character/key         Sonderzeichen/-taste
TAB key                      Tabulatortaste
tab, tab stop                Tabulator
tape (magnetic)              Magnetband
task                         der Task
television encoder           Fernsehmodulator
termination power            Abschluspannung
termination resistors/pack   Abschluwiderstnde
text gadget                  Texteingabefeld
thermal transfer printer     Thermotransferdrucker
thesaurus                    Synonymwrterbuch (Thesaurus)
threshold value              Schwellwert
tilt and swivel base         Dreh-/Kippfu
time-out                     Zeitlimit, Zeitberschreitung
timer                        a) for events: Zeitgeber,
                             b) clock generator: Taktgenerator,
                             c) switching mains: Schaltuhr
timing                       Timing
title bar                    Titelleiste
toggle, to                   umschalten, wechseln
token                        das Token
tool                         Programm, Dienstprogramm
Tool Type                    Merkmal
top margin                   oberer Rand
track                        Spur
transition (of screens)      berblendung
transmission error           bertragungsfehler
trashcan                     Papierkorb
trouble-shooting             Fehlerbehandlung
TTL level                    TTL-Pegel
turboboard                   Beschleunigerkarte
tutorial                     bung
underline, to                unterstreichen
underscore (noun)            Unterstrich
undo                         rckgngig (machen)
unique                       unverwechselbar
unit                         Einheit (Laufwerk)
update, to                   aktualisieren
usage (command template)     Aufruf
user                         Benutzer
user-startup                 Datei "User-Startup"
utility                      Hilfsprogramm
Uxx location (on board)      Steckplatz Uxx (auf der Platine)
validate, to                 validieren
validated                    gltig
ventilation                  Belftung, Lftung
verify, to                   berprfen
videodisk                    Videodisk
visitor window               Besuchsfenster
voltage surges or drops      Spannungsschwankungen
volume                       a) disk: Datentrger,
                             b) sound: Lautstrke,
                             c) else: Volumen
wait state                   Wartezyklus
wait-pointer                 Wartezeiger
wall outlet                  Netzsteckdose
wildcard character           Jokerzeichen
window                       Fenster
wipe (screen transition)     berblendung
wire                         Draht, Ader
word wrap                    Wortumbruch
work, to (running ok)        funktionieren
work disk                    Arbeitsdiskette
workbench                    Workbench (Arbeitstisch)
Workbench disk               Workbench-Diskette
write protection             Schreibschutz
write-protected              schreibgeschtzt
XOR                          Exklusiv-ODER
zoom gadget                  Zoom-Symbol







Second part: CDTV Glossary

Glossary to be considered during development of applications

The following glossary defines terms that should be used by developers
when they create CDTV titles. These terms have to be used as part of
application texts or text-related presentations or in documentations
for the mentioned issues.

The terms are sorted alphabetically. They appear in the left column
with the chosen definition, as far as the term is suited to be used
in a user documentation. If there is a note to use another term
instead and not this term, then the referred other term is to be
used. In the middle column you have the english term for reference.
This column is also the sort criterion, to get an easy English-German
reference. The right column with the explanations is in German.


German           American        Explanation
----------------------------------------------------------------------------
Taste "A"        "A" button      Auch "Auswahltaste" oder "Aktionstaste"
                                    verwendbar
Netzkabel        ac powercord    "Netzkabel" verwenden
Zubehr          accessories     CDTV-Zusatzausstattung, die nicht zur
                                    Grundausstattung gehrt (z. B. Joystick,
                                    Tastatur etc.)
Aktion           action          Benutzeraktion
aktivieren       activate        nicht interaktiven Proze starten,
                                    z. B. Demo starten (nicht in der
                                    Bedeutung von Strom einschalten)
Animation        animated        Grafik zur Simulation von
                                    Bewegung
Anwendung        application     Bevorzugtes Synonym fr Titel
Pfeil            arrow           Richtungstasten auf der Fernbedienung
                                    und, falls vorhanden, auf der Tastatur
                                    (nach oben, unten, rechts oder links,
                                    verwenden).
Audio-Player     audio player    "CD-Audio-Player" verwenden
Taste "B"        "B" button      Rechte Taste auf der Fernbedienung;
                                    Rckkehr zu oder Sicherung einer 
                                    vorherigen Auswahl oder Ebene.
starten          begin           Anwendung starten. Fr
                                    Audio "abspielen" verwenden. 
Lesezeichen      bookmark        Der Benutzer mchte Informationen,
                                    abspeichern, z. B. Status oder
                                    Highscore eines Spiels,
                                    bzw. eine Anwendung merkt sich den 
                                    augenblicklichen Zustand einer Auswahl
                                    oder Position.
starten          boot            "Starten" oder "Neustart" verwenden
blttern         browse          durch eine Anwendung bewegen
                                    (nicht linear)
Taste            button          Dient zum Aktivieren; befindet sich auf
                                    der Fernbedienung oder anderen Fern-
                                    steuer-Zubehrteilen; wird im Deutschen
                                    im Gegensatz zum Englischen unverndert
                                    auch bei Tasten auf der schreibma-
                                    schinenartigen Tastatur oder einer
                                    Musik-CDTV-Klaviatur verwendet. Ein auf
                                    dem Bildschirm erscheinender "Druck-
                                    knopf" sollte immer als "Symbol" ange-
                                    sprochen werden.
CD-Cartridge     caddie          Einschubkassette, in der die CD in
                                    den CDTV-Player eingelegt wird.
CD               cd              Fr Audio-Discs "CD-Audio" und fr
                                    Titel "CDTV-Disc" verwenden
CD-Audio-Disc    cd-audio disc   Compact-Disc (nur mit Audio)
CDTV-Player      CDTV            Commodore Dynamic Total Vision. CDTV 
                                    alleine nur als Adjektiv, nicht als 
                                    Substantiv verwenden. "CDTV-Player" 
                                    ist korrekt. "Das CDTV" ist falsch.
CDTV-Disc        CDTV disc       Spezifische Compact-Disc fr CDTV.
                                    Dagegen sind Disks der allgemeine
                                    Begriff fr andere Speichermedien
                                    wie z. B. Disketten.
CDTV-Player      CDTV player     Das CDTV-System
Kanal            channel         wie Fernseh- oder Audiokanal
                                    (Stereo rechts und links)
Auswahl          choice          Auswahlmglichkeit fr Benutzer
auswhlen        choose          "Auswhlen" verwenden
Zahl lschen     clear number    vom Benutzer eingegebene Zahl lschen
Bildschirm       clear screen    vom Benutzer vorgenommene Auswahl
   lschen                          lschen
klicken          click           fr Tasten stattdessen grundstzlich
                                    "Drcken" verwenden
Compact-Disc     compact disc    "CD-Audio-Disc"/"CDTV-Disc" verwenden
kompatibel       compatible      Passendes Zubehr fr CDTV-Player, o. a.
                                    andere Gerte, die mit CDTV-Discs 
                                    betrieben werden.
Composite-Signal composite       Einer der Video-Ausgnge des CDTV-
                    video signal    Players.
Farb-Video-      composite       Buchse auf der Rckseite des CDTV-
   Buchse           video port      Players, an die ein Kabel fr TV,
                                    Monitor oder VCR angeschlossen wird.
Monitor          computer        Alternativ zu TV (Anzeigeeinheit).
                    monitor         Bei Verwendung mit Fernsehempfnger
                                    "TV" verwenden
Konfiguration    configuration   CDTV-Player und Zubehr, die fr 
                                    eine bestimmte Anwendung erforderlich
                                    sind
anschlieen/     connect/        anschlieen...lsen; gilt nur
   Verbindung       disconnect      fr Hardware
   lsen
Bedienfeld       Control         Bedienfeld auf der Vorderseite des
                 panel              CDTV-Players, auf dem sich die CD-
                                    Steuerungstasten (Play/Stop) befinden
Abdeckung        cover           Abdeckung, die den Einschub fr die
                                    Sicherungsspeicherkarte schtzt
Cursor           cursor          "Zeiger" verwenden
blttern         cycle (to)      Auswhlen in einer Schleife aus einer
                                    groen Anzahl von Optionen
Daten            data            Informationselemente (uninterpretiert)
Standardwerte/   default         vordefinierte Angaben; der Benutzer
   -einstellungen                   kann die Angaben berschreiben
Einheit          device          "Zubehr verwenden
Pfeiltasten      direction       Pfeilkombination der Tasten links,
                    button          rechts, oben, unten auf der Fern-
                                    bedienung
Verzeichnis      directory       diesen Begriff vermeiden
Disc             disc            Feine Unterscheidung in der Schreib-
                                    weise: Eine "Disc" kann nur gelesen
                                    werden, whrend eine "Disk" gelesen und
                                    beschrieben werden kann.
Disk             disk            jedes Medium mit Lese- und Schreib-
                                 zugriff (Diskette/Festplatte)
Laufwerk         disk drive      Einheit zum Lesen von Disks
Diskette         diskette        seltener auch "Floppy-Disk" verwendbar
Anzeigefeld      display panel   Zeit- und Spurangaben auf der Vorder-
                                    seite des CDTV-Players
Abschlu         done            der Benutzer hat die Auswahl
                                    abgeschlossen
Schublade        drawer          Diesen Begriff vermeiden.
Ausfahren        eject           die CD-Cartridge oder die Sicherungs-
                                    speicherkarte fhrt aus
Abgelaufene      elapsed         Abgelaufene Zeit seit dem
   Zeit             time            Start
Musik-           electronic      Musikzubehr;
   Tastatur         keyboard        Piano-Keyboard
Eingabe          enter           Die Auswahl eines Benutzers ausfhren
                                    oder Benutzereingaben (z. B. eine
                                    Nummer) annehmen. (In wenigen Monaten
                                    wird auf der Fernbedienung "ENTER"
                                    durch "OK" ersetzt.)
Eingabetaste     enter button    Diesen Begriff vermeiden. "Taste OK"
                                    verwenden.
Escape           escape          Diesen Begriff vermeiden
Taste "Esc"      escape button   Diesen Begriff vermeiden. Diese Taste
                                    sollte als Hilfetaste definiert werden.
                                    (In wenigen Monaten wird auf der Fern-
                                    bedienung "ESC" durch "?" ersetzt.)
Ende              exit           Eine Ebene in einer Menstruktur
                                    zurckgehen oder einen bestimmten
                                    Betriebsmodus verlassen.
Externes          external       Einheit, die an einen CDTV-Player
   Gerte            device         angeschlossen ist. ("Zubehr" wre der
                                    bevorzugte Begriff.)
Schneller         fast           Schnelldurchlauf durch eine CD oder
   Suchlauf          forward        einen CDTV-Titel
Datei             file           Organisierte Ansammlung von
                                    Information
Feuertaste        fire           Taste auf dem Joystick. Taste A auf
                     button         der Fernbedienung (im Joystick-Modus);
                                    Auswahl eines hervorgehobenen Symbols
                                    oder Auslsetaste im Computerspiel.
Blinken           flash          (o. a. Blitzen) flackernde Objektfarbe,
                                    Anzeigeleuchte Ein/Aus oder zwischen
                                    verschiedenen Farben wechseln
Diskette          floppy disk    Speichermedium mit Lese-/Schreibzugriff
                                    in einem Floppy-Laufwerk
Disketten-        floppy disk    CDTV-Zubehr, mit dem Disketten gelesen
   laufwerk          drive          und beschrieben werden knnen
formatieren       format         Diskette vorbereiten, anschlieend
                                    knnen Daten auf ihr gespeichert werden
Genlock           genlock        CDTV-Zubehr, mit dem Videobilder mit
                                    CDTV-Bildern berlagert werden knnen
Grafik            graphics       Bildhafte Informationsdarstellung
Guru              guru           fr CDTV nicht von Bedeutung, da alle
                                    Fehler abgefangen werden sollten.
Kopfhrer         headphone      CDTV-Zubehr zum individuellen Hren
Hilfe             help           detaillierte Hilfsinformationen auf
                                    Benutzeranforderung; im allgemeinen
                                    erfolgt der Zugriff ber die Taste
                                    Esc oder ?.
Hilfetaste       help button     Taste auf der Fernbedienung, mit der
                                    Hilfsinformationen angefordert werden
                                    knnen. Die Hilfetaste wird zur Zeit
                                    mit "ESCAPE" bezeichnet. Im Laufe der
                                    nchsten Monate wird "?" eingefhrt.
Hilfebildschirm  help screen     Informationsanzeige zu einer Anwendung
                                    nach Bettigen der Hilfetaste
markieren        highlight       ausgewhlte Punkte und Optionen invers
                                    darstellen oder in einer Umrahmung
                                    oder in einer anderen Weise hervor-
                                    heben. Erst "markiert" der Benutzer
                                    eine Auswahl mit den Pfeiltasten,
                                    dann "whlt" er sie mit der Taste A
                                    (Auswahltaste) "aus".
drcken          hit             Bei Tasten immer "Drcken" verwenden.
verbinden        hook-up         "Anschlieen" verwenden
Hot-Link         hot-link        Verbinden eines Worts oder einer Phrase
                                    mit jedem Vorkommen des/der Worts/
                                    Phrase in einer Anwendung. Es kann auch
                                    der Begriff "Hot-Word" verwendet werden
Hypercard        hypercard       diesen Begriff vermeiden
Hyperlink        hyperlink       "Hot-Link" verwenden
Hypertext        hypertext       "Hot-Word" verwenden
Symbol           icon            Grafische Darstellung eines Auswahl-
                                    punktes fr den Benutzer, z. B. das
                                    Abbruchsymbol. Bei Disk-, Programm-
                                    oder Datei-Icons dagegen "Piktogramm"
                                    verwenden
Information      information     Daten in einer Form, die ihnen eine
                                    Bedeutung gibt
IR (Infrarot)    infrared        der Teil des Lichtspektrums, der von
                                    der Fernbedienung ausgestrahlt wird.
                                    Abkrzung als IR ist mglich.
Eingabe          input           "Aktion" verwenden
einlegen         insert          die CD in die CD-Cartridge oder die
   einrasten                        Cartridge in den CDTV-Player legen,
                                    bzw. die Sicherungsspeicherkarte im
                                    Steckplatz einrasten.
Anleitung        instruction     Erluterung fr den Benutzer
interaktiv       interactive     der Benutzer kann den Ablauf eines
                                    Titels beeinflussen oder steuern
Invers-Anzeige   inverse video   Gegenstzliche Negativ- und Positiv-
                                    darstellung, "Markieren" verwenden
IR               IR              Abkrzung fr "Infrarot"
Menpunkt        item            Auswahlpunkt in einem Men oder
                                    siehe auch 'Symbol'
Eintrag          item            Auswahlelement in einer Liste;
                                    siehe auch Symbol
Cinch-Buchse     jack            Anschlutyp fr Audio
CD-Box           jewel case      Plastik-Box, in der CD-Audio oder CDTV-
                                    Discs versandt werden knnen
Joystick         joy stick       CDTV-Zubehr als Fernbedienung fr 
                                    Computer-Spiele; auch Modusauswahl
                                    fr die CDTV-Standardfernbedienung
springen         jump            zu anderer Aktion, anderem Bildschirm,
                                    anderem Symbol etc. wechseln
Taste            key             "Tasten" auf der optionalen Schreib-
                                    maschinen- bzw. der Musik-Tastatur.
Name             label           eindeutiger Name
Querformat       landscape       waagerechtes Format; die Grafik wird im
                                    Querformat dargestellt
linke           left select      Taste "A" auf der Fernbedienung; auch
   Auswahltaste    button           "Auswahltaste" verwendbar.
Lektion         lesson           "Anleitung" verwenden
Anzeige         light            verschiedenfarbige Anzeige; grn
                                    meldet die Anlage betriebsbereit,
                                    gelb meldet Zugriffe auf die Platten
Verknpfen      link             Querverweis auf nichtaufeinander-
                                    folgende Bilder oder Wrter
Schleife        loop             eine Folge von Befehlen ausfhren und
                                    die gleiche Folge mehrmals wiederholen
Main-Audio-     main audio       play/stop, vorwrts und rckwrts etc.,
   Control         control          die Steuerung befindet sich auf der
                                    Vorderseite des CDTV-Players im Bedien-
                                    feld (im Gegensatz zur Fernbedienung)
Haupt-          main power       Ein-/Aus-Schalter auf der Vorderseite
   netzschalter    button           des CDTV-Players (im Gegensatz zur
                                    Fernbedienung)
Speicher        memory           diesen Begriff und nicht RAM verwenden
Men            menu             Anzeige verfgbarer Auswahlpunkte
MIDI            MIDI             Musical Instrument Digital Interface;
                                    ein Standard zur Verbindung von elek-
                                    tronischen Musikinstrumenten bzw. zum
                                    Anschlu an andere Einheiten, z. B.
                                    einen CDTV-Player.
MIDI In-        MIDI in...       Buchse an der Rckseite des CDTV-
   Out-Anschlu    out              Players zum Anschlu elektronischer
                   port             Musikinstrumente.
Modem           modem            CDTV-Zubehrteil zur Kommunikation
                                    ber Telefon mit anderen Computer-
                                    systemen
Monitor         monitor          Alternative zum Fernsehempfnger zur
                                    Anzeige von CDTV-Titeln;
Maus            mouse            CDTV-Zubehr zum Bewegen und zur
                                    Auswahl von Symbolen/Piktogrammen auf
                                    dem Bildschirm
NTSC            NTSC             USA-Fernsehnorm.
                                    CDTV-Player arbeiten mit PAL- und
                                    NTSC-Systemen. Die Standard NTSC-Auf-
                                    lsung betrgt 320x200; 320x400
                                    (interlaced); 640x200; 640x400
                                    (interlaced). Diesen Begriff nicht in
                                    der Benutzerdokumentation verwenden.
Taste OK        OK button        Taste auf der Fernbedienung, mit der
                                    ein Benutzerbefehl ausgefhrt oder
                                    eine Benutzerangabe angenommen wird.
                                    In wenigen Monaten wird die Taste
                                    "ENTER" durch die Taste "OK"
                                    ersetzt.
Ausgabe         output           Jedes Signal aus dem CDTV-Player,
                                    z. B. Signal an einen Drucker oder
                                    ein MIDI-Instrument.
Anzeige         panel            "Steueranzeige" verwenden
PAL-System      PAL              Europischer TV-Standard. CDTV-
                                    Player arbeiten mit PAL- und NTSC-
                                    Fernsehempfngern. Die Standardauf-
                                    lsung fr PAL-Systeme liegt bei
                                    320x256; 320x512 (interlaced); 640x256;
                                    640x512 (interlaced). Diesen Begriff
                                    nicht in der Benutzerdokumentation
                                    verwenden.
Parallel-       parallel         Druckertyp, der an den CDTV-Player
   drucker         printer          angeschlossen werden kann.
Unterbrechen    pause            Unterbrechen einer Anwendung ohne
                                    Abbruch. Die Anwendung kann jederzeit
                                    an dieser Stelle fortgesetzt werden.
Sicherungs-     personal         Batteriebetriebene Sicherungsspeicher-
   speicherkarte   memory           karte, die in einen Steckplatz auf
                   card             der Vorderseite des CDTV-Players ein-
                                    gesetzt werden kann. Sie wird zum 
                                    Speichern von Informationen verwendet.
Bild            picture          Bild auf dem TV-Bildschirm,
                                 (z. B. Uhrsymbol)
Abspielen       play             CD-Audio beginnen/starten und, in
                                    einigen Fllen, einen CDTV-Titel
                                    abspielen
Player          player           "CD-Audio-Player" oder "CDTV-Player"
                                    verwenden
Zeiger          pointer          Positionsanzeige im TV-Bild, z. B. Pfeil
                                    oder anderes Symbol
Buchsen         ports            Buchsen am CDTV-Player zum
                                    Anschlu von Zubehrteilen
Netzkabel       powercord        Kabel zur Netzsteckdose
Netzschalter    power button     Taste Ein/Aus auf der Fernbedienung
                                    bzw. dem CDTV-Player
Vorein-          preferences     Einstellungen zur Zeit, Zentrieren von
   stellungen                       Bildern und Angabe zur Landessprache
drcken         press            gilt fr alle Tasten
vorheriger      previous         Bild vor der aktuellen Anzeige
   Bildschirm      screen
Drucker         printer          CDTV-Zubehrteil
Programm        program          "Anwendung" oder "Titel" verwenden
                                    ("Titel" bevorzugt)
Drcken         push             gilt fr alle Tasten
RAM             RAM              "Speicher" verwenden
Zufalls-        randomize        Musikstcke (Spuren) knnen in einer
   taste           button           zuflligen Reihenfolge abgespielt
                                    werden; die Reihenfolge kann nicht vom
                                    Benutzer ausgewhlt werden
Re-Initia-      reboot           "Neustart" verwenden
   lisierung
Fernbedienung    remote          Tasteneinheit, ber die mit Hilfe von
                    controller      Infrarotsignalen Anweisungen an den
                                    CDTV-Player weitergegeben werden
                                    knnen.
weitere          remote          Weitere Tasten auf der Fernbedienung
   Fernbedie-       "other"         neben "A" und "B" und den Pfeiltasten,
   nungstasten      buttons         z. B. "Help", "Play/Pause"
Wiederholen      repeat          Zurck an den Anfang eines Ablaufs,
                                    der abgeschlossen wurde, und diesen
                                    Ablauf wiederholen.
Zurck           reset           Anfangseinstellung wiederherstellen;
                                    einen Titel neu starten
Neustart         restart         den Start mit den Anfangseinstellung
                                    wiederholen
laden            retrieve        laden aus dem Speicher, von der Dis-
                                    kette oder Sicherungsspeicherkarte
bersicht        review          Optionen in einem Men anzeigen lassen,
                                    bzw. vorherige Schritte oder Auswahl-
                                    punkte darstellen
HF-Modulator     rf converter    Umsetzen von CDTV- in TV-Signale
                                    ber Fernbedienung, falls das TV
                                    an den HF-Anschlu des Players
                                    angeschlossen ist.
HF-Signal-        rf signals     ein Video-Anschlu des CDTV-Players
   buchse            port
RGB-Signal-       rgb signals    ein Video-Anschlu des CDTV-Players
   buchse            port
S-VHS-Buchse      s video        ein Video-Anschlu des CDTV-Players;
                     signals        auch als "Super VHS" bezeichnet
                     port
Bildschirm        screen         Bildschirminhalt
Bildschirm        screen        "Bildschirmabschaltung" verwenden
   lschen           blanker
Bildschirm-       screen         eine Funktion, die verhindert, da ein
   schoner           saver          statisches Bild ber lange Zeit auf
                                    einem Bildschirm angezeigt wird und
                                    diesen evtl. einbrennt.
blttern          scroll         durch eine Liste blttern
suchen            search         Informationen auf Basis ausgewhlter
                                    Kriterien suchen
auswhlen         select         Aus verfgbaren Optionen auswhlen.
                                    Der Benutzer "markiert" seine Auswahl
                                    mit den Pfeiltasten und whlt dann mit
                                    der Taste "A" "aus".
Auswahltaste      select         Gewhlte Option anzeigen/aktivieren,
                     button         auf der Fernbedienung linke oder
                                    A-Taste
selbstablaufend   self-running   nicht interaktiv
Reihenfolge       sequence       Reihenfolge; z. B. alphabetisch oder
                                    chronologisch
Serieller         serial         Druckertyp, der an den CDTV-Player
   Drucker           printer        angeschlossen werden kann
setzen (auf)      set (to)       mit einem bestimmten Wert definieren
Rckwrts ...     skip backward  "weitergehen" verwenden, "springen"
   vorwrts          forward        verwenden, wenn zu einer ganz anderen
   springen                         bzw. zur nchsten Aktion gewechselt
                                    werden soll.
Sicherungs-       Smart card    "Sicherungsspeicherkarte" verwenden
   karte
Software          Software      "Titel" (bevorzugt) oder "Anwendung"
                                    verwenden
starten           start          beginnen
Eingangs-         startup-       Start-CDTV-Anzeige, bevor eine CD
   bildschirm        screen         eingelegt wird
Stereoanlage      stereo         externes Sound-System
Stereo-Ausgang    stereo         Audio-Ausgang des CDTV-Players:
   unterbrechen      stop           aktuelle Funktion anhalten;
                                    Gegenteil von Aktivieren
umschalten        switch         physisches Umschalten (Ein/Aus),
                                    oder z. B. in einen anderen Bildschirm
                                    springen
Symbol            symbol         grafische Illustration einer Option,
                                    die der Benutzer auswhlen kann
                                    (z. B. Spur-Reihenfolge).
Fernsehempfnger  Television     "TV" verwenden
Titel             title          CDTV-Anwendung
Wechseln          toggle         Auswahl zwischen zwei Positionen oder
                                    Optionen
Spur              track          Teilbereich auf einer CD-Audio-Disc;
                                    eine Spur enthlt z. B. Musik
Spursegment       track segment  Teil einer Spur
Trackball         trackball      Steuereinheit, deren Kugel mit der
                     controller     Hand gerollt werden kann, der Zeiger
                                    wird dabei ber den Bildschirm bewegt
Lerntext          tutorial       "Anleitung" verwenden
Fernseh-          TV             Fernsehempfnger; Anzeigeeinheit fr
   empfnger                        den CDTV-Player
Bildschirm        TV screen      Teil des TV, auf dem CDTV-
                                    Informationen angezeigt werden
Benutzer          user           Benutzer eines CDTV-Players
Lautstrke        volume         gilt nur fr Audio; erhhen und
                                    verringern
Kabel-Maus        wired mouse   "Maus" verwenden





Third part: Some general rules

1. When translating any text, be sure you have someone who knows
about the subject AND has the German language as his/her mother
tongue. Otherwise, you risk those funny translations that appear
on the computer magazine humor pages. At the very least, have
someone whose native language is German proofread the manuscript
for sense in its final stage.

2. When writing German text, use a text system (keyboard and
printer) that is able to produce all the needed special characters
(see below). If you're employing a typesetter, make sure the firm
is aware of the special characters being transmitted. A reader may
be insulted to see his own language crippled by an American-only
text system or printer. To assure this you must use full eight-bit
ASCII every time. You MUST NOT cancel the MSB (Most Significant Bit).
In Germany we have seven special characters: six "umlauts" that are
simply the vowels a, o and u (and their uppercase counterparts)
with two dots on top (, , , , , ). The seventh is the sharp s
(or sz), shaped like the Greek lowercase beta (). All these
characters are available in the Amiga character set (use keymap d
by calling "setmap d"), so there is no excuse to not using them.
The seven characters mentioned are normal letters for us Germans,
but in the special characters there are differences, too. For
example, our paragraph sign () looks quite different than the
American one (). If you're using the American one, at least
explain what it is somewhere in the documentation (or better yet,
use the German sign). Please also note that the "number sign" #
and the "at sign" @ are totally unknown in this meaning in Germany.
For "number", you may use the abbreviation "Nr.", but not the
# sign alone.

3. If no German umlauts are available at all, they can be replaced
by the normal vowel plus an e: =ae, =oe, =ue.
With capital letters, it depends:
a) within a word that is completely in capitals: =AE
b) at start of a word starting with an uppercase: =Ae
If the sharp s () isn't available, or appears within a word
completely in capitals, it is to be replaced by ss or SS.
(After all, avoid all these substitutions by any means!
It looks very unprofessional.)
Exception: Replacing "" by "SS" in completely uppercase words
is a MUST, no choice!

4. Umlauts have also to be sorted, and NOT after their ASCII
value! Official strategy is to sort them identically to their
normal vowel counterparts, so  sorts like A.
 sorts like ss.

5. There are other German speaking countries besides Germany:
Austria and Switzerland. Especially the latter has some own
features. They have own keymaps to make mixing with their
other languages French and Italian easier. They DON'T USE
uppercase umlauts! In Switzerland, all uppercase umlauts
are replaced by the normal vowel plus e:  --> Ae (or AE).
The sharp  is also ALWAYS replaced by double ss.
And also the number format differs in Switzerland: Where we
write 2.345.300,5 in Germany, they write 2'345'300,5.

6. Remember date and time format in Germany: dd.mm.yy, hh:mm:ss
always 24 hour! ("A.m." and "p.m." are totally unknown here!)
Also the number separators are just the other way round as in
English: in German, a long figure looks like 2.345.678,91  .

7. Some special remarks about numerical factors: There is a
convention for the letter k (and only for this) that it is
written in lowercase (normal) when it stands for a factor of
exactly 1000, as in kHz. But we write it as uppercase when
the factor 1024 is meant, like in KBytes. (This does not
apply for other letters like m/M where m stands for milli
and M for Mega.)
Also it probably will become a convention that a single,
uppercase "B" stands for Byte(s), whereas you have to write
"Bit(s)", if single bits are counted.

8. DO NOT use American rules for hyphenation. Especially the
German language consists of rather long words, so there is no
way to get around hyphenation (or it will look really ugly).
You MUST do it. Don't trust your text system for this - it may
be totally wrong because of strongly differing hyphenation
rules (e.g. in German you almost never are allowed to hyphenate
between an s and a t). You may be better off using a nationalized
version of your word processor (MS-Word German, in my experience,
is very trustworthy). Naturally, this goes for the spell checker
as well - disable it if you don't have a nationalized version.
And also then, German spell checkers can cover only far fewer
cases than American ones because of the complexer grammar of
German language.

9. Abbreviations: Only with a dot at the end, NOT with other
characters like slash. Likewise, alternatives are always indicated
by a slash: 12/24 Stunden. So, Software may be abbreviated as SW
(in this case even without a dot), but never as S/W.
Please follow the german rule to put a space inbetween a two-letter
abbreviation: d. h., z. B., z. Z., ...

10. You know in German you must write nouns together or at
least bind them together via hyphens. This sometimes leads
to ugly combinations like "der MPS-1230-Drucker". But this
can be solved easily by rearranging some words: "der Drucker
MPS 1230". This is possible and preferable on most occasions.
Other eample: instead of "der 68000-Prozessor" better write:
"der Prozessor 68000".
On other occasions you hardly can avoid long chains of words:
"das 880-KB-Floppylaufwerk". But you MUST use the hyphens!

11. A general hint: If you do something that is similar to parts
of normal Commodore shipments then look into the German
Commodore User Manuals in the appropriate chapters and try to
say it in similar words. Please do not confuse a user by naming
things totally different from the starter's manual he is
supposed to have read first. Mainly refer to the Glossary
section of the German 2.0 manual.

12. Many computer specific words are not translated at all but
taken directly as foreign words. Please add in this case an
explanation of the term on the first use/appearance.

13. There are several words where no German translation exists
at all. In these cases at least follow German rules of conju-
gation for verbs:
to PEEK   --> PEEKen, PEEKte, gePEEKt (NOT: gePEEKed)
to POKE   --> POKEn, POKEte, gePOKEt
to sample --> samplen, samplete, gesamplet (NOT: gesampled)
to edit   --> edieren, edierte, ediert (NOT: editiert)
Some proposals for choice of genus for imported nouns (though
for some of these also exist translations):
der: Amiga, Cache, Chip, Chunk, Cursor, Drive, Hunk, Interrupt,
     Joystick, Kickstart, Port, Printer, Record, Task, Track
die: Bank, CPU, Floppy, Workbench
das: Directory, EPROM, File, Flag, Gadget, Gate-Array, IC,
     Interface, Memory, Modem, PROM, Prompt, RAM, ROM, Sprite,
     Utility

14. When a manual with command line examples is set in a
proportional font, one should be very clear to show where
spaces are to insert in the command line and where not.
Better use multiple spaces to avoid confusing the reader:
   search   >to-file   file   "search text"

15. Please note that the paper formats in Europe differ strongly
from those in USA. There simply is no "Standard Three-Ring Binder".
Manuals that come as binder are in most cases in DIN A5 format
with a 2-ring binding. In few cases also binders in DIN A4 format
are used, that also may come with 4-ring binding, where all the
hole distances are the same as in the case of the 2-ring binding.

16. If you use standard icons or gadget images for certain items,
please note that also here exist regional differences.
If you e.g. show a world globe, this will appear in Europe in
a way that Europe is visible on it and not America, as is the case
for most of the american software.
Also the simple hammer picture of the OS, that serves as default icon
for tools, shows a hammer that's totally non-standard in Germany,
only used by such specialists like shoemakers. The standard hammer
here is the simple, plain form, and this is also better recognized
here.
A last example is a power plug and a wall outlet. They differ
strongly from country to country. So be cautious not to use some
imagery that perhaps doesn't get understood or in worst case gets
misunderstood.

17. Some idioms in German and some special cases:
As in English, Software runs "under" an operating system, "luft unter
einem Betriebssystem", not "in" it.
In German, something is "kompatibel zu" something, not "mit" something.
In German, use always "Grafik", don't write "Graphik" or "Graphic".
Definition of "Disk": We chose this for German as the general term
for floppy disks and harddisks, all that is writable. So the
workbench menu item "Disk formatieren" is applicable on both.
But when you explicitly talk about floppies of e.g. a shipped new
software version, then you should refer to them as "Disketten".
In contrast, we use "Disc" also in German for not-writable
CDTV CD's.
Files are stored "auf einer Disk" and "auf einer Partition" (the latter
is treated like an independent disk), but "in Verzeichnissen"
(directories) and "in Schubladen" (drawers).
The english word "release" has no really well fitted german
equivalent. In most cases you may use "Version", but there are
special cases, where in English you have both "version" and "release"
with different meanings. Then you better concatenate both into
a general "Version" information.
Avoid the german word "installieren". This is only acceptable when
dealing with really complex things, like a whole new operating
system or a hardware addition that also needs software drivers.
In most cases, words like "einsetzen", "einbauen" (mechanically)
or "kopieren" (software) are to be preferred.
Avoid the german verb "ablaufen" for programs as translation of
"to run". Programs just "laufen". There's also the noun "Ablauf",
this is more rare, but less critical. Also when prompting a user
"to run" a program, don't use "ausfhren" in German. Only the computer
(or microprocessor) does this, not the user. Use "starten" or
"aufrufen" instead.
Don't always translate the english "to move" with "bewegen". This
has in German more the meaning of gradual, longer lasting movements.
This is ok e.g. for a normal cursor key. But if an operation happens
instantaneously, e.g. cursor to end of line, then you better use
"stellen" or "(um)setzen". Also, when files are moved to a different
drawer, use "verlegen".
The english "at the prompt" should be translated as "hinter der
Eingabeaufforderung", not as "an der Eingabeaufforderung".
The english "load from disk" should be translated as "von Disk
laden", not as "ab Disk laden".
The english "string" always translates to "Zeichenkette", not
"Zeichenfolge".
Computer mice and keyboards have "Tasten", not "Knpfe".
In German, you always use "Tabulatoren", never "Tabulatorstopps".
Amiga files you find in "(Unter-)Verzeichnissen" or "Schubladen", but
never in "Ordnern"!

18. Please avoid typical english comma rules in German! E.g. the
sentence "After installation of the hardware, all should work."
MUST NOT have a comma in its german translation: "Nach Einbau der
Hardware sollte alles funktionieren."

19. Here a little list of terms where you should avoid the english
word totally and only use the translation:
File --> Datei
Script --> Skript
Drawer --> Schublade (NEVER use "Ordner"!)
Directory --> Verzeichnis
Subdirectory --> Unterverzeichnis (NEVER use "Ordner"!)
Icon --> Piktogramm
Menu --> Men
Gadget --> Symbol
Window --> Fenster
Screen --> Schirm
Requester --> Dialogfenster
Boot --> Start, Neustart
Mouse --> Maus

20. Menus: For the german version of the Amiga menu system, we have
decided to take a different approach for the casing of menu items.
If a menu item together with the menu title gives some meaningful
sentence, then the menu item starts with a lowercase letter (if it's
not a noun, of course). Example: "Projekt / speichern"
Also, when a menu item has an ellipsis appended (those three dots,
indicating the opening of a requester for details), we insert a
space before these dots in German. Example: "Projekt / ffnen ..."

21. If there remain any questions about correct german spelling,
you should always refer to the "Duden". This is what "Webster"
is for USA, the highest authority in these issues. The "Duden"
has sort of legal authority. There exists a number of volumes
of the Duden, the most important one is "Rechtschreibung".

