
/* Include file generated by Toolmaker V1.13 */

#include "capture_tm_text.h"	/* Toolmaker text header file */

/* TMScreenInfo structure */
 
struct TMScreenInfo
  {
  struct Screen *Screen;	/* pointer to Screen structure */
  struct TagItem *MoreTags;	/* pointer to additional tag array */
  struct VisualInfo *VisualInfo;	/* pointer to VisualInfo structure */
  APTR UserData;
  };

/* TMWindowInfo structure */
 
struct TMWindowInfo
  {
  struct Window *Window;	/* pointer to Window structure */
  struct TagItem *MoreTags;	/* pointer to additional tag array */
  struct IntuiMessage *GT_IMsg;	/* pointer to last gadtools IntuiMessage */
  struct Menu *Menu;	/* pointer to Menu structure */
  struct Requester Requester;	/* Requester structure for DISABLE/ENABLE */
  UBYTE DisableCount;	/* Count for nested DISABLE/ENABLEs */
  ULONG Flags;	/* TMWF_ flags */
  struct Gadget *FirstGadget;	/* pointer to first gadget */
  struct Gadget *ContextGadget;	/* pointer to context gadget */
  APTR UserData;
  };

/* TMGadgetInfo structure */
 
struct TMGadgetInfo
  {
  struct Gadget *Gadget;
  struct TagItem *MoreTags;
  APTR UserData;
  };

/* TMData structure */
 
struct TMData
  {
  ULONG Size;	/* Size of TMData structure */
  struct MsgPort *WindowMsgPort;	/* pointer to window message port */
  LONG ReturnCode;	/* Return code for exit() */
  struct FileRequester *FileRequester;	/* ASL file requester pointer */
  struct FontRequester *FontRequester;	/* ASL font requester pointer */
  struct TMScreenInfo TMScreenInfo[1];	/* TMScreenInfo structure array */
  struct TMGadgetInfo TMGadgetInfo_CAPTUREM[5];	/* TMGadgetInfo structure array */
  struct TMWindowInfo TMWindowInfo[1];	/* TMWindowInfo structure array */
  APTR UserData;
  };

/* Function Prototypes */
 
struct TMData *TM_Open(ULONG *);
VOID TM_Close(struct TMData *);
LONG TM_Request(struct Window *, UBYTE *, UBYTE *, UBYTE *, ULONG *, APTR, ...);
VOID TM_EventLoop(struct TMData *);
BOOL OpenScreen_Workbench(struct TMData *);
VOID CloseScreen_Workbench(struct TMData *);
BOOL OpenWindow_CAPTUREM(struct TMData *);
VOID CloseWindow_CAPTUREM(struct TMData *);
VOID DisableWindow_CAPTUREM(struct TMData *);
VOID EnableWindow_CAPTUREM(struct TMData *);
BOOL Window_CAPTUREM_MENUPICK(struct TMData *, struct IntuiMessage *);
VOID Window_CAPTUREM_REFRESHWINDOW(struct TMData *, struct IntuiMessage *);
BOOL Window_CAPTUREM_GADGETDOWN(struct TMData *, struct IntuiMessage *);
BOOL Window_CAPTUREM_GADGETUP(struct TMData *, struct IntuiMessage *);
BOOL Window_CAPTUREM_CLOSEWINDOW(struct TMData *, struct IntuiMessage *);

/* Library pointers */
 
extern struct Library *SysBase;
extern struct Library *DOSBase;
extern struct Library *IntuitionBase;
extern struct Library *GadToolsBase;
extern struct Library *UtilityBase;
extern struct Library *AslBase;

/* Constants */
 
#define OPENFILE	0	/* For open file requester */
#define SAVEFILE	1	/* For save file requester */

#define TMWF_OPENED	0x00000001	/* Window opened flag */
#define TMWF_DISABLED	0x00000002	/* Window disabled flag */

#define TMERR_OK	0
#define TMERR_MEMORY	1
#define TMERR_MSGPORT	2

/* Screen pointer */
 
#define screen_Workbench	TMData->TMScreenInfo[0].Screen	/* Default public screen pointer */

/* Window, Menu, and Gadget pointers */
 
#define window_CAPTUREM	TMData->TMWindowInfo[0].Window	/* Window pointer */
#define menu_CAPTUREM	TMData->TMWindowInfo[0].Menu	/* Menu pointer */
#define gadget_CLEAR	TMData->TMGadgetInfo_CAPTUREM[0].Gadget	/* Gadget pointer */
#define gadget_SEND	TMData->TMGadgetInfo_CAPTUREM[1].Gadget	/* Gadget pointer */
#define gadget_SAVE	TMData->TMGadgetInfo_CAPTUREM[2].Gadget	/* Gadget pointer */
#define gadget_LOAD	TMData->TMGadgetInfo_CAPTUREM[3].Gadget	/* Gadget pointer */
#define gadget_BYTESINB	TMData->TMGadgetInfo_CAPTUREM[4].Gadget	/* Gadget pointer */

/* Gadget IDs */
 
#define ID_CLEAR	1	/* Gadget ID */
#define ID_SEND	2	/* Gadget ID */
#define ID_SAVE	3	/* Gadget ID */
#define ID_LOAD	4	/* Gadget ID */
#define ID_BYTESINB	5	/* Gadget ID */

/* Menu, item, and subitem IDs */
 
#define MENU_PROJECT	0	/* Menu number */
#define ITEM_CLEAR	0	/* Item number */
#define ITEM_LOAD	1	/* Item number */
#define ITEM_SAVE	2	/* Item number */
#define ITEM_ABOUT	4	/* Item number */
#define ITEM_QUIT	6	/* Item number */
#define MENU_SETTINGS	1	/* Menu number */
#define ITEM_SETOUTPU	0	/* Item number */
#define ITEM_SETINPUT	1	/* Item number */

/* ScreenInfo pointers */
 
#define ScreenInfo_Workbench	TMData->TMScreenInfo[0]	/* TMScreenInfo structure pointer */

/* WindowInfo pointers */
 
#define WindowInfo_CAPTUREM	TMData->TMWindowInfo[0]	/* TMWindowInfo structure pointer */

/* GadgetInfo pointers */
 
#define GadgetInfo_CLEAR	TMData->TMGadgetInfo_CAPTUREM[0]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_SEND	TMData->TMGadgetInfo_CAPTUREM[1]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_SAVE	TMData->TMGadgetInfo_CAPTUREM[2]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_LOAD	TMData->TMGadgetInfo_CAPTUREM[3]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_BYTESINB	TMData->TMGadgetInfo_CAPTUREM[4]	/* TMGadgetInfo structure pointer */

/* NewMenu UserData structures */
 
extern TMOBJECTDATA tmobjectdata_CLEAR;	/* CLEAR */
extern TMOBJECTDATA tmobjectdata_LOAD;	/* LOAD */
extern TMOBJECTDATA tmobjectdata_SAVE;	/* SAVE */
extern TMOBJECTDATA tmobjectdata_ABOUT;	/* ABOUT */
extern TMOBJECTDATA tmobjectdata_QUIT;	/* QUIT */
extern TMOBJECTDATA tmobjectdata_SETOUTPU;	/* SETOUTPU */
extern TMOBJECTDATA tmobjectdata_SETINPUT;	/* SETINPUT */

/* NewGadget UserData structures */
 
extern TMOBJECTDATA tmobjectdata_CLEAR;	/* CLEAR */
extern TMOBJECTDATA tmobjectdata_SEND;	/* SEND */
extern TMOBJECTDATA tmobjectdata_SAVE;	/* SAVE */
extern TMOBJECTDATA tmobjectdata_LOAD;	/* LOAD */
extern TMOBJECTDATA tmobjectdata_BYTESINB;	/* BYTESINB */

