
/* Code generated by Toolmaker V1.13 */

/* Includes */

#include <stdlib.h>
#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <exec/memory.h>
#include <graphics/view.h>
#include <graphics/displayinfo.h>

#include "capture.h"

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/gadtools_protos.h>

/* Pragma includes for register parameters */

#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/gadtools_pragmas.h>

/* static function prototypes */

static BOOL TM_WindowSignal(struct TMData *);
static VOID TM_RemoveWindow(struct TMWindowInfo *);
static BOOL WindowIDCMP_CAPTUREM(struct TMData *, struct IntuiMessage *);

/* Mouse pointer data for disabled window */

#ifdef _DCC    /* For DICE compatibiliity */
__chip UWORD WaitPointer[36] =
#else
UWORD __chip WaitPointer[36] =
#endif
  {
  0x0000, 0x0000,
  0x0400, 0x07C0,
  0x0000, 0x07C0,
  0x0100, 0x0380,
  0x0000, 0x07E0,
  0x07C0, 0x1FF8,
  0x1FF0, 0x3FEC,
  0x3FF8, 0x7FDE,
  0x3FF8, 0x7FBE,
  0x7FFC, 0xFF7F,
  0x7EFC, 0xFFFF,
  0x7FFC, 0xFFFF,
  0x3FF8, 0x7FFE,
  0x3FF8, 0x7FFE,
  0x1FF0, 0x3FFC,
  0x07C0, 0x1FF8,
  0x0000, 0x07E0,
  0x0000, 0x0000,
  };

/* Screen data */

/* Window data */

struct NewMenu newmenu_CAPTUREM[] =
  {
  {NM_TITLE, (UBYTE *)MENUTEXT_PROJECT,	NULL,	0,	0,	NULL},	/* Project */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_CLEAR,	NULL,	0,	0,	(APTR) &tmobjectdata_CLEAR},	/* Clear */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_LOAD,	(UBYTE *)"L",	0,	0,	(APTR) &tmobjectdata_LOAD},	/* Load... */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SAVE,	(UBYTE *)"S",	0,	0,	(APTR) &tmobjectdata_SAVE},	/* Save... */
  {NM_ITEM,  NM_BARLABEL,	NULL,	0,	0,	NULL},	/* --- */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_ABOUT,	NULL,	0,	0,	(APTR) &tmobjectdata_ABOUT},	/* About... */
  {NM_ITEM,  NM_BARLABEL,	NULL,	0,	0,	NULL},	/* --- */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_QUIT,	(UBYTE *)"Q",	0,	0,	(APTR) &tmobjectdata_QUIT},	/* Quit */
  {NM_TITLE, (UBYTE *)MENUTEXT_SETTINGS,	NULL,	0,	0,	NULL},	/* Settings */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SETOUTPU,	(UBYTE *)"1",	0,	0,	(APTR) &tmobjectdata_SETOUTPU},	/* Set Output Link... */
  {NM_ITEM,  (UBYTE *)ITEMTEXT_SETINPUT,	(UBYTE *)"2",	0,	0,	(APTR) &tmobjectdata_SETINPUT},	/* Set Input Link... */
  {NM_END,   NULL,	NULL,	0,	0,	NULL}
  };


/* Font data */

struct TextAttr topaz8 =
  {
  (STRPTR)"topaz.font",	/* ta_Name */
  8,	/* ta_YSize */
  FS_NORMAL,	/* ta_Style */
  0x0	/* ta_Flags */
  };

/****** capture_tm.c/TM_Request *****************************
*
*   NAME
*	TM_Request -- display a message in a system requester.
*
*   SYNOPSIS
*	num = TM_Request(Window, Title, TextFormat, GadgetFormat,
*	                 IDCMP_ptr, Arg1, Arg2, ...)
*
*	LONG TM_Request(struct Window *, UBYTE *, UBYTE *, UBYTE *,
*	                ULONG *, APTR, ...);
*
*   FUNCTION
*	Calls EasyRequestArgs to display a message in a system
*	requester without having to fill in an EasyStruct structure.
*	This function uses a varargs calling convention.
*
*	EasyRequestArgs has the capability to display more than one
*	gadget by separating the GadgetText with the '|' character.
*	Also printf style formatting may be used in the TextFormat
*	and GadgetFormat strings.  The formatting arguments should
*	be added first for the TextFormat, then for the GadgetFormat.
*
*   INPUTS
*	Window = pointer to window (passed to EasyRequestArgs()).
*	Title = title bar string (passed to EasyRequestArgs()).
*	TextFormat = body text (passed to EasyRequestArgs()).
*	GadgetFormat = gadget text (passed to EasyRequestArgs()).
*	IDCMP_ptr = IDCMP value (passed to EasyRequestArgs()).
*	Args = arguments (passed to EasyRequestArgs()).
*
*   RESULT
*	num = gadget number returned by EasyRequestArgs().
*
*   EXAMPLE
*	To display a requester with two choices:
*
*	result = TM_Request(NULL, "Question", "Are you sure?",
*	                    "OK|Cancel", NULL, NULL);
*
*   NOTES
*	The intuition library must be open before calling this
*	function.
*
*   BUGS
*
*   SEE ALSO
*	intuition.library/EasyRequestArgs()
*
**************************************************************
*
*/
LONG TM_Request(struct Window *Window, UBYTE *Title, UBYTE *TextFormat, UBYTE *GadgetFormat, ULONG *IDCMP_ptr, APTR Arg1, ...)
  {
  struct EasyStruct es;

  es.es_StructSize = sizeof(struct EasyStruct);
  es.es_Flags = 0;
  es.es_Title = Title;
  es.es_TextFormat = TextFormat;
  es.es_GadgetFormat = GadgetFormat;

  return(EasyRequestArgs(Window, &es, IDCMP_ptr, &Arg1));
  }

/****** capture_tm.c/TM_Open *****************************
*
*   NAME
*	TM_Open -- initialize user-interface data.
*
*   SYNOPSIS
*	TMData = TM_Open(ErrorCode)
*
*	struct TMData *TM_Open(ULONG *error);
*
*   FUNCTION
*	Creates an initializes a TMData structure.  This
*	includes allocating memory for a TMData structure,
*	creating a message port for window IDCMP messages,
*	and opening any fonts on disk.
*
*   INPUTS
*	error = pointer to ULONG to store an error number.
*	        Error numbers are defined in the _tm.h file.
*
*   RESULT
*	TMData = pointer to an initialized TMData structure
*	         or NULL if an error occurred.
*
*   EXAMPLE
*	if(!(TMData = TM_Open(&error)))
*	  {
*	  switch(error)
*	    {
*	    case TMERR_MEMORY:
*	      TM_Request(NULL, "Error", "Out of memory", "Abort", NULL, NULL);
*	      break;
*	    case TMERR_MSGPORT:
*	      TM_Request(NULL, "Error", "Error creating\nmessage port", "Abort", NULL, NULL);
*	      break;
*	    }
*	  CleanExit(NULL, RETURN_FAIL);
*	  }
*
*   NOTES
*	The intuition and gadtools libraries must be open before
*	calling this function.  If any fonts other than topaz 8
*	and topaz 9 are used, the diskfont and graphics libraries
*	must also be open.
*
*   BUGS
*
*   SEE ALSO
*	TM_Close()
*
**************************************************************
*
*/
struct TMData *TM_Open(ULONG *error)
  {
  struct TMData *tmdata;

  if(tmdata = AllocMem(sizeof(struct TMData), MEMF_CLEAR))
    {
    tmdata->Size = sizeof(struct TMData);

    if(tmdata->WindowMsgPort = CreateMsgPort())
      {
      *error = TMERR_OK;
      return(tmdata);
      }
    else
      {
      *error = TMERR_MSGPORT;
      }
    FreeMem(tmdata, sizeof(struct TMData));
    }
  else
    {
    *error = TMERR_MEMORY;
    }

  return(NULL);
  }

/****** capture_tm.c/TM_Close *****************************
*
*   NAME
*	TM_Close -- frees user-interface data.
*
*   SYNOPSIS
*	TM_Close(TMData)
*
*	VOID TM_Close(struct TMData *TMData);
*
*   FUNCTION
*	Frees resources allocated by TM_Open().
*
*   INPUTS
*	TMData = pointer to TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	if(TMData) TM_Close(TMData);
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	TM_Open()
*
**************************************************************
*
*/
VOID TM_Close(struct TMData *TMData)
  {
  if(TMData)
    {
    if(TMData->WindowMsgPort) DeleteMsgPort(TMData->WindowMsgPort);
    FreeMem(TMData, TMData->Size);
    }
  }

/****** capture_tm.c/TM_EventLoop *****************************
*
*   NAME
*	TM_EventLoop -- waits for all events.
*
*   SYNOPSIS
*	TM_EventLoop(TMData)
*
*	VOID TM_EventLoop(struct TMData *);
*
*   FUNCTION
*	Waits for any events to signal program.  All IDCMP, ARexx,
*	and a user signal messages received are sent to the
*	appropriate signal function.  A return value of TRUE from
*	any of the signal functions will terminate the loop.
*
*   INPUTS
*	TMData = pointer to TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	TM_EventLoop(TMData);
*
*   NOTES
*	An event signal must be set up before calling TM_EventLoop.
*	Either a window must be open, the SimpleRexx option selected,
*	or a user signal set up.
*
*   BUGS
*
*   SEE ALSO
*	TM_WindowSignal(), TM_ARexxSignal(), exec.library/Wait()
*
**************************************************************
*
*/
VOID TM_EventLoop(struct TMData *TMData)
  {
  BOOL done=FALSE, result;
  ULONG windowsignal, signals;

  windowsignal = 1L << TMData->WindowMsgPort->mp_SigBit;

  while(!done)
    {
    signals = Wait(windowsignal | SIGBREAKF_CTRL_E);

    if (signals & windowsignal)
      {
      if(result = TM_WindowSignal(TMData)) done = result;
      }

		if (signals & SIGBREAKF_CTRL_E)
		{	HandleMidi( TMData );
		}
	}
}

/****** capture_tm.c/OpenScreen_Workbench *****************************
*
*   NAME
*	OpenScreen_Workbench -- Use the default public screen.
*
*   SYNOPSIS
*	success = OpenScreen_Workbench(TMData)
*
*	BOOL OpenScreen_Workbench(struct TMData *);
*
*   FUNCTION
*	Locks the default public screen and gets its visual info.  If the
*	screen was already locked, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!(OpenScreen_Workbench(TMData)))
*	  {
*	  TM_Request(NULL, "Error", "Error opening screen", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseScreen_Workbench()
*
**************************************************************
*
*/
BOOL OpenScreen_Workbench(struct TMData *TMData)
  {
  if(ScreenInfo_Workbench.Screen)
    {
    ScreenToFront(ScreenInfo_Workbench.Screen);
    return(TRUE);
    }
  else
    {
    if(ScreenInfo_Workbench.Screen = LockPubScreen(NULL))
      {
      if(ScreenInfo_Workbench.VisualInfo = GetVisualInfo(ScreenInfo_Workbench.Screen, TAG_DONE))
        {
        return(TRUE);
        }
      UnlockPubScreen(NULL, ScreenInfo_Workbench.Screen);
      }
    }

  return(FALSE);
  }

/****** capture_tm.c/CloseScreen_Workbench *****************************
*
*   NAME
*	CloseScreen_Workbench -- Free the default public screen.
*
*   SYNOPSIS
*	CloseScreen_Workbench(TMData)
*
*	VOID CloseScreen_Workbench(struct TMData *);
*
*   FUNCTION
*	Unlocks the default public screen and frees the visual info.
*	It's ok to re-close a screen that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*	CloseScreen_Workbench(TMData);
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenScreen_Workbench()
*
**************************************************************
*
*/
VOID CloseScreen_Workbench(struct TMData *TMData)
  {
  if(ScreenInfo_Workbench.VisualInfo)
    {
    FreeVisualInfo(ScreenInfo_Workbench.VisualInfo);
    ScreenInfo_Workbench.VisualInfo = NULL;
    }
  if(ScreenInfo_Workbench.Screen)
    {
    UnlockPubScreen(NULL, ScreenInfo_Workbench.Screen);
    ScreenInfo_Workbench.Screen = NULL;
    }
  }

/****** capture_tm.c/OpenWindow_CAPTUREM *****************************
*
*   NAME
*	OpenWindow_CAPTUREM -- Open window "CAPTUREM".
*
*   SYNOPSIS
*	success = OpenWindow_CAPTUREM(TMData)
*
*	BOOL OpenWindow_CAPTUREM(struct TMData *);
*
*   FUNCTION
*	Opens the window with label "CAPTUREM"
*	along with any gadgets it contains.  If the window was already
*	open, it will be brought to front.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*	success = TRUE if command was successfully completed.
*	          FALSE if not.
*
*   EXAMPLE
*	if(!OpenWindow_CAPTUREM(TMData))
*	  {
*	  TMRequest(NULL, "Error", "Error opening window", "Abort", NULL, NULL);
*	  CleanExit(TMData, RETURN_FAIL);
*	  }
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	CloseWindow_CAPTUREM()
*
**************************************************************
*
*/
BOOL OpenWindow_CAPTUREM(struct TMData *TMData)
  {
  ULONG lasttag;
  struct NewGadget ng;

  if(WindowInfo_CAPTUREM.Window)
    {
    WindowToFront(WindowInfo_CAPTUREM.Window);
    ActivateWindow(WindowInfo_CAPTUREM.Window);
    return(TRUE);
    }
  else
    {
    WindowInfo_CAPTUREM.FirstGadget = NULL;
    WindowInfo_CAPTUREM.ContextGadget = CreateContext(&WindowInfo_CAPTUREM.FirstGadget);

    ng.ng_VisualInfo = ScreenInfo_Workbench.VisualInfo;

    ng.ng_LeftEdge = 248;
    ng.ng_TopEdge = 19+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 76;
    ng.ng_Height = 16;
    ng.ng_Flags = PLACETEXT_IN;
    ng.ng_TextAttr = &topaz8;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_CLEAR;	/* Clear */
    ng.ng_GadgetID = ID_CLEAR;
    ng.ng_UserData = (APTR) &tmobjectdata_CLEAR;
    lasttag = GadgetInfo_CLEAR.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_CLEAR.Gadget = CreateGadget(BUTTON_KIND, WindowInfo_CAPTUREM.ContextGadget, &ng,
		lasttag, GadgetInfo_CLEAR.MoreTags);

    ng.ng_LeftEdge = 168;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_SEND;	/* Send */
    ng.ng_GadgetID = ID_SEND;
    ng.ng_UserData = (APTR) &tmobjectdata_SEND;
    lasttag = GadgetInfo_SEND.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_SEND.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_CLEAR.Gadget, &ng,
		lasttag, GadgetInfo_SEND.MoreTags);

    ng.ng_LeftEdge = 88;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_SAVE;	/* Save... */
    ng.ng_GadgetID = ID_SAVE;
    ng.ng_UserData = (APTR) &tmobjectdata_SAVE;
    lasttag = GadgetInfo_SAVE.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_SAVE.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_SEND.Gadget, &ng,
		lasttag, GadgetInfo_SAVE.MoreTags);

    ng.ng_LeftEdge = 8;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_LOAD;	/* Load... */
    ng.ng_GadgetID = ID_LOAD;
    ng.ng_UserData = (APTR) &tmobjectdata_LOAD;
    lasttag = GadgetInfo_LOAD.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_LOAD.Gadget = CreateGadget(BUTTON_KIND, GadgetInfo_SAVE.Gadget, &ng,
		lasttag, GadgetInfo_LOAD.MoreTags);

    ng.ng_LeftEdge = 208;
    ng.ng_TopEdge = 3+ScreenInfo_Workbench.Screen->BarHeight;
    ng.ng_Width = 116;
    ng.ng_Height = 14;
    ng.ng_Flags = PLACETEXT_LEFT;
    ng.ng_GadgetText = (UBYTE *)GADGETTEXT_BYTESINB;	/* Bytes in Buffer */
    ng.ng_GadgetID = 0;
    ng.ng_UserData = NULL;
    lasttag = GadgetInfo_BYTESINB.MoreTags ? TAG_MORE : TAG_DONE;
    GadgetInfo_BYTESINB.Gadget = CreateGadget(NUMBER_KIND, GadgetInfo_LOAD.Gadget, &ng,
		GTNM_Border, TRUE,
		lasttag, GadgetInfo_BYTESINB.MoreTags);

    if(GadgetInfo_BYTESINB.Gadget)
      {
      lasttag = WindowInfo_CAPTUREM.MoreTags ? TAG_MORE : TAG_DONE;

      if((WindowInfo_CAPTUREM.Window = OpenWindowTags(NULL,
		WA_PubScreen, ScreenInfo_Workbench.Screen,
		WA_Title, WINDOWTEXT_CAPTUREM,	/* MIDI Capture */
		WA_IDCMP, NULL,
		WA_Gadgets, WindowInfo_CAPTUREM.FirstGadget,
		WA_Left, 157,
		WA_Top, 88,
		WA_InnerWidth, 324,
		WA_InnerHeight, 37,
		WA_DragBar, TRUE,
		WA_CloseGadget, TRUE,
		WA_DepthGadget, TRUE,
		WA_Activate, TRUE,
		WA_SimpleRefresh, TRUE,
		lasttag, WindowInfo_CAPTUREM.MoreTags)))
        {
        if((WindowInfo_CAPTUREM.Menu = CreateMenus(newmenu_CAPTUREM, TAG_DONE)))
          {
          if((LayoutMenus(WindowInfo_CAPTUREM.Menu, ScreenInfo_Workbench.VisualInfo, TAG_DONE)))
            {
            if((SetMenuStrip(WindowInfo_CAPTUREM.Window, WindowInfo_CAPTUREM.Menu)))
              {
              WindowInfo_CAPTUREM.Window->UserPort = TMData->WindowMsgPort;
              ModifyIDCMP(WindowInfo_CAPTUREM.Window,
			IDCMP_REFRESHWINDOW |
			BUTTONIDCMP |
			IDCMP_GADGETDOWN |
			IDCMP_GADGETUP |
			IDCMP_MENUPICK |
			IDCMP_CLOSEWINDOW);
              GT_RefreshWindow(WindowInfo_CAPTUREM.Window, NULL);
              WindowInfo_CAPTUREM.Flags |= TMWF_OPENED;
              return(TRUE);
              }
            }
          FreeMenus(WindowInfo_CAPTUREM.Menu);
          }
        CloseWindow(WindowInfo_CAPTUREM.Window);
        }
      FreeGadgets(WindowInfo_CAPTUREM.FirstGadget);
      }
    }
  return(FALSE);
  }

/****** capture_tm.c/CloseWindow_CAPTUREM *****************************
*
*   NAME
*	CloseWindow_CAPTUREM -- Close window "CAPTUREM".
*
*   SYNOPSIS
*	CloseWindow_CAPTUREM(TMData)
*
*	VOID CloseWindow_CAPTUREM(struct TMData *);
*
*   FUNCTION
*	Closes the window with label "CAPTUREM"
*	and frees its resources.  It's ok to re-close a window
*	that is already closed.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	OpenWindow_CAPTUREM()
*
**************************************************************
*
*/
VOID CloseWindow_CAPTUREM(struct TMData *TMData)
  {
  TM_RemoveWindow(&WindowInfo_CAPTUREM);
  }

/****** capture_tm.c/DisableWindow_CAPTUREM *****************************
*
*   NAME
*	DisableWindow_CAPTUREM -- disable input to window "CAPTUREM".
*
*   SYNOPSIS
*	DisableWindow_CAPTUREM(TMData)
*
*	VOID DisableWindow_CAPTUREM(struct TMData *);
*
*   FUNCTION
*	Disables all input to window with label "CAPTUREM"
*	and changes its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	EnableWindow_CAPTUREM()
*
**************************************************************
*
*/
VOID DisableWindow_CAPTUREM(struct TMData *TMData)
  {
  if((WindowInfo_CAPTUREM.DisableCount == 0) && (WindowInfo_CAPTUREM.Flags & TMWF_OPENED))
    {
    InitRequester(&WindowInfo_CAPTUREM.Requester);
    if(Request(&WindowInfo_CAPTUREM.Requester, WindowInfo_CAPTUREM.Window))
      {
      WindowInfo_CAPTUREM.Flags |= TMWF_DISABLED;
      SetPointer(WindowInfo_CAPTUREM.Window, WaitPointer, 16, 16, -6, 0);
      }
    }
  WindowInfo_CAPTUREM.DisableCount++;
  }

/****** capture_tm.c/EnableWindow_CAPTUREM *****************************
*
*   NAME
*	EnableWindow_CAPTUREM -- enable input to window "CAPTUREM".
*
*   SYNOPSIS
*	EnableWindow_CAPTUREM(TMData)
*
*	VOID EnableWindow_CAPTUREM(struct TMData *);
*
*   FUNCTION
*	Enables input to window with label "CAPTUREM"
*	and clears its mouse pointer.
*
*   INPUTS
*	TMData = pointer to the TMData structure returned by TM_Open.
*
*   RESULT
*
*   EXAMPLE
*
*   NOTES
*
*   BUGS
*
*   SEE ALSO
*	DisableWindow_CAPTUREM()
*
**************************************************************
*
*/
VOID EnableWindow_CAPTUREM(struct TMData *TMData)
  {
  WindowInfo_CAPTUREM.DisableCount--;
  if((WindowInfo_CAPTUREM.DisableCount == 0) && (WindowInfo_CAPTUREM.Flags & (TMWF_DISABLED | TMWF_OPENED)))
    {
    EndRequest(&WindowInfo_CAPTUREM.Requester, WindowInfo_CAPTUREM.Window);
    WindowInfo_CAPTUREM.Flags &= ~TMWF_DISABLED;
    ClearPointer(WindowInfo_CAPTUREM.Window);
    }
  }

/* *********************************************************** */
/* Static functions (available only to functions in this file) */
/* *********************************************************** */

static BOOL TM_WindowSignal(struct TMData *TMData)
  {
  BOOL done=FALSE;
  BOOL result;
  struct IntuiMessage *imessage;

  while(imessage = GT_GetIMsg(TMData->WindowMsgPort))
    {
    if(imessage->IDCMPWindow == WindowInfo_CAPTUREM.Window)
      {
      WindowInfo_CAPTUREM.GT_IMsg = imessage;
      if(result = WindowIDCMP_CAPTUREM(TMData, imessage)) done = result;
      if(WindowInfo_CAPTUREM.GT_IMsg)
        {
        GT_ReplyIMsg(WindowInfo_CAPTUREM.GT_IMsg);
        WindowInfo_CAPTUREM.GT_IMsg = NULL;
        }
      }
    }

  return(done);
  }

static BOOL WindowIDCMP_CAPTUREM(struct TMData *TMData, struct IntuiMessage *imessage)
  {
  BOOL done=FALSE;
  BOOL result;

  switch(imessage->Class)
    {
    case IDCMP_REFRESHWINDOW:	/* Always refresh */
      GT_BeginRefresh(WindowInfo_CAPTUREM.Window);
      Window_CAPTUREM_REFRESHWINDOW(TMData, imessage);
      GT_EndRefresh(WindowInfo_CAPTUREM.Window, TRUE);
      break;

    case IDCMP_MENUPICK:
      if(result = Window_CAPTUREM_MENUPICK(TMData, imessage)) done = result;
      break;

    case IDCMP_GADGETDOWN:
      if(result = Window_CAPTUREM_GADGETDOWN(TMData, imessage)) done = result;
      break;

    case IDCMP_GADGETUP:
      if(result = Window_CAPTUREM_GADGETUP(TMData, imessage)) done = result;
      break;

    case IDCMP_CLOSEWINDOW:
      if(result = Window_CAPTUREM_CLOSEWINDOW(TMData, imessage)) done = result;
      break;

    }

  return(done);
  }

static VOID TM_RemoveWindow(struct TMWindowInfo *TMWindowInfo)
  {
  struct IntuiMessage *imessage;
  struct Node *succ;

  if(TMWindowInfo->Window)
    {
    if(TMWindowInfo->Menu)
      {
      ClearMenuStrip(TMWindowInfo->Window);
      FreeMenus(TMWindowInfo->Menu);
      TMWindowInfo->Menu = NULL;
      }

    if(TMWindowInfo->GT_IMsg)
      {
      GT_ReplyIMsg(TMWindowInfo->GT_IMsg);
      TMWindowInfo->GT_IMsg = NULL;
      }

    if(TMWindowInfo->Window->UserPort)
      {
      Forbid();
      imessage = (struct IntuiMessage *) TMWindowInfo->Window->UserPort->mp_MsgList.lh_Head;
      while(succ = imessage->ExecMessage.mn_Node.ln_Succ)
        {
        if(imessage->IDCMPWindow == TMWindowInfo->Window)
          {
          Remove((struct Node *) imessage);
          ReplyMsg((struct Message *) imessage);
          }
        imessage = (struct IntuiMessage *) succ;
        }
      TMWindowInfo->Window->UserPort = NULL;
      ModifyIDCMP(TMWindowInfo->Window, 0L);
      Permit();
      }

    CloseWindow(TMWindowInfo->Window);
    TMWindowInfo->Window = NULL;
    TMWindowInfo->Flags = 0;
    }

  if(TMWindowInfo->FirstGadget)
    {
    FreeGadgets(TMWindowInfo->FirstGadget);
    TMWindowInfo->FirstGadget = NULL;
    }
  }

