/*
 * Uncycle.c - C. Scheppner  01/87
 *
 *   Disables cycling chunks (CRNGs) of DPaint pic by killing active
 *      bit and setting RNG_NORATE (36) for cycle rate
 *   This can also be accomplished with DPaint, by reloading the
 *      pic, setting the cycle speed for each to the lowest position,
 *      and re-saving the pic
 *   (Default DPaint CRNG chunks are Active with rate 0xAAA)
 *
 *   LINKAGE INFO:
 *     Compile with -v flag on LC2
 *     Link with AStartup.obj ... LIBRARY Amiga.lib, LC.lib
 */

#include <exec/types.h>
#include <libraries/dos.h>
#include <libraries/dosextens.h>
#include <workbench/startup.h>

extern struct WBStartup *WBenchMsg;

struct FileLock *startLock, *newLock;
BOOL fromWB;

/* For wbStdio rtns */
extern LONG stdin, stdout, stderr;  /* in Astartup.obj */
char conSpec[] = "CON:0/40/640/140/";
BOOL wbHasStdio = NULL;

#define BUFSIZ 400

main(argc, argv)
int argc;
char **argv;
   {
   LONG            file, rLen;
   struct WBArg    *arg;  
   char            *filename;
   char  buf[BUFSIZ], *bp;
   int k;

   fromWB = (argc==0) ? TRUE : FALSE;

   if(argc>1)                 /* Passed filename via command line  */
      {
      filename = argv[1];
      }
   else if ((argc==0)&&(WBenchMsg->sm_NumArgs > 1))
      {                        /* Passed filename via  WorkBench */
      arg = WBenchMsg->sm_ArgList;
      arg++;
      filename   = (char *)arg->wa_Name;
      newLock    = (struct FileLock *)arg->wa_Lock;
      startLock  = (struct FileLock *)CurrentDir(newLock);
      }
   else if (argc==1)           /* From CLI but no filename */
      cleanexit("Usage: requires ILBM filename");
   else                        /* From WB but no filename */
      cleanexit(
         "Usage:\nClick ONCE on this Icon\nSHIFT and DoubleClick on Pic");


   if(!(file = Open(filename, MODE_OLDFILE)))
      cleanexit("Picture file not found");

   rLen = Read(file,buf,BUFSIZ);
   for(k=0, bp=&buf[0]; k<BUFSIZ-12; k++,bp++)
      {
      if((bp[0]=='C')&&(bp[1]=='R')&&(bp[2]=='N')&&(bp[3]=='G'))
         {
         bp[10]  = 0x00; /* Rate RNG_NORATE (36) */
         bp[11]  = 0x24;
         bp[13] &= 0xFE; /* Clear active bit */
         }
      }
   Seek(file,0,OFFSET_BEGINING);
   Write(file,buf,rLen);
   Close(file);
   cleanup();
   }


cleanexit(s)
   char  *s;
   {
   if (*s)
      {
      if ((fromWB)&&(! wbHasStdio))  wbHasStdio = openStdio(conSpec);

      if ((!fromWB)||(wbHasStdio))
         {
         Write(stdout,s,strlen(s));
         Write(stdout,"\n",1);
         }
      if (wbHasStdio)
         {
         Write(stdout,"\nPRESS RETURN TO EXIT\n",22);
         while (getchar() != '\n');
         }
      }
   if (wbHasStdio) closeStdio();
   cleanup();
   exit();
   }

cleanup()
   {
   if(newLock != startLock)  CurrentDir(startLock);
   }

strlen(s)
char *s;
   {
   int i = 0;
   while(*s++) i++;
   return(i);
   }




/* wbStdio.c --- Open an Amiga stdio window under workbench
 *               For use with AStartup.obj
 */

openStdio(conspec)
char *conspec;
   {
   LONG wfile;
   struct Process *proc;
   struct FileHandle *handle;

   if (wbHasStdio)  return(1);

   if (!(wfile = Open(conspec,MODE_NEWFILE)))  return(0);
   stdin  = wfile;
   stdout = wfile;
   stderr = wfile;
   handle = (struct FileHandle *)(wfile << 2);
   proc = (struct Process *)FindTask(NULL);

   proc->pr_ConsoleTask = (APTR)(handle->fh_Type);
   proc->pr_CIS = (BPTR)stdin;
   proc->pr_COS = (BPTR)stdout;
   return(1);
   }

closeStdio()
   {
   struct Process *proc;
   struct FileHandle *handle;

   if (! wbHasStdio) return(0);

   if (stdin > 0)  Close(stdin);
   stdin  = -1;
   stdout = -1;
   stderr = -1;
   handle = (struct FileHandle *)(stdin << 2);
   proc = (struct Process *)FindTask(NULL);
   proc->pr_ConsoleTask = NULL;
   proc->pr_CIS = NULL;
   proc->pr_COS = NULL;
   wbHasStdio = NULL;
   }

