/*

Copyright (c) 1992 Commodore-Amiga, Inc.

This example is provided in electronic form by Commodore-Amiga, Inc. for
use with the "Amiga ROM Kernel Reference Manual: Libraries", 3rd Edition,
published by Addison-Wesley (ISBN 0-201-56774-1).

The "Amiga ROM Kernel Reference Manual: Libraries" contains additional
information on the correct usage of the techniques and operating system
functions presented in these examples.  The source and executable code
of these examples may only be distributed in free electronic form, via
bulletin board or as part of a fully non-commercial and freely
redistributable diskette.  Both the source and executable code (including
comments) must be included, without modification, in any copy.  This
example may not be published in printed form or distributed with any
commercial product.  However, the programming techniques and support
routines set forth in these examples may be used in the development
of original executable software products for Commodore Amiga computers.

All other rights reserved.

This example is provided "as-is" and is subject to change; no
warranties are made.  All use is at your own risk. No liability or
responsibility is assumed.

*/

/*
**  Constants for a two plane worm.
*/

#define WRMCOUNT 24                  /* My Worm Sequence constants. */
#define WRMRINGX 14
#define WRMRINGY 0
#define WRMWIDTH 64
#define WRMHEIGHT 26
#define WRMDEPTH 2
#define WRMWWIDTH ((WRMWIDTH + 15) / 16)

SHORT WrmTimes[WRMCOUNT] =
	{
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
	};

SHORT WrmYTranses[WRMCOUNT] =
	{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	};

SHORT WrmXTranses[WRMCOUNT] =
	{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	};

/* APTR WrmCRoutines[WRMCOUNT] */
WORD (*WrmCRoutines[WRMCOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	};

UWORD chip WrmImage[WRMCOUNT][WRMWWIDTH * WRMHEIGHT * WRMDEPTH] =
	{
	/*----- bitmap Worm-A w = 64, h = 32 ------ */
		{
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0100,   0x0000,   0x0000, 
		0x0000,   0x0100,   0x0000,   0x0000, 
		0x0000,   0x0100,   0x0000,   0x0000, 
		0x0000,   0x0100,   0x0000,   0x0000, 
		0x0000,   0x0100,   0x0000,   0x0000, 
		0x294A,   0x5280,   0x0000,   0x0000, 
		0x77BD,   0xEF40,   0x0000,   0x0000, 
		0x2529,   0x4A40,   0x0000,   0x0000, 
		0x4E73,   0x9CC0,   0x0000,   0x0000, 
		0x39CE,   0x7380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0100,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x318C,   0x6300,   0x0000,   0x0000, 
		0x7BDE,   0xF780,   0x0000,   0x0000, 
		0x7BDE,   0xF780,   0x0000,   0x0000, 
		0x318C,   0x6300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-B w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0040,   0x0000,   0x0000, 
		0x0000,   0x0040,   0x0000,   0x0000, 
		0x0005,   0x0040,   0x0000,   0x0000, 
		0x00AE,   0xD080,   0x0000,   0x0000, 
		0x0BD4,   0xEA80,   0x0000,   0x0000, 
		0x1C99,   0x4F40,   0x0000,   0x0000, 
		0x0937,   0x9A40,   0x0000,   0x0000, 
		0x12E0,   0x74C0,   0x0000,   0x0000, 
		0x0E00,   0x0380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0040,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0006,   0x0000,   0x0000,   0x0000, 
		0x00CF,   0x6000,   0x0000,   0x0000, 
		0x0DEF,   0xF300,   0x0000,   0x0000, 
		0x1FE6,   0xF780,   0x0000,   0x0000, 
		0x1EC0,   0x6780,   0x0000,   0x0000, 
		0x0C00,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-C w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0020,   0x0000,   0x0000, 
		0x0000,   0x0020,   0x0000,   0x0000, 
		0x0002,   0x8020,   0x0000,   0x0000, 
		0x002F,   0x6840,   0x0000,   0x0000, 
		0x02F2,   0x7680,   0x0000,   0x0000, 
		0x0724,   0xA740,   0x0000,   0x0000, 
		0x024F,   0xCA40,   0x0000,   0x0000, 
		0x04F8,   0x3CC0,   0x0000,   0x0000, 
		0x0380,   0x0380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0020,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0003,   0x0000,   0x0000,   0x0000, 
		0x0037,   0xB000,   0x0000,   0x0000, 
		0x037F,   0xFB00,   0x0000,   0x0000, 
		0x07FB,   0x7F80,   0x0000,   0x0000, 
		0x07B0,   0x3780,   0x0000,   0x0000, 
		0x0300,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-D w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0001,   0x4000,   0x0000,   0x0000, 
		0x0003,   0xA800,   0x0000,   0x0000, 
		0x0009,   0x7410,   0x0000,   0x0000, 
		0x001E,   0x2410,   0x0000,   0x0000, 
		0x00A9,   0xCEE0,   0x0000,   0x0000, 
		0x01D3,   0x3F40,   0x0000,   0x0000, 
		0x009E,   0x0240,   0x0000,   0x0000, 
		0x0130,   0x04C0,   0x0000,   0x0000, 
		0x00E0,   0x0380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0001,   0x8000,   0x0000,   0x0000, 
		0x0003,   0xF000,   0x0000,   0x0000, 
		0x000F,   0xF810,   0x0000,   0x0000, 
		0x001D,   0xF800,   0x0000,   0x0000, 
		0x00DE,   0x3300,   0x0000,   0x0000, 
		0x01EC,   0x0780,   0x0000,   0x0000, 
		0x01E0,   0x0780,   0x0000,   0x0000, 
		0x00C0,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-E w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xA000,   0x0000,   0x0000, 
		0x0001,   0xD000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0005,   0x3400,   0x0000,   0x0000, 
		0x000E,   0xFA00,   0x0000,   0x0000, 
		0x0004,   0x9208,   0x0000,   0x0000, 
		0x0029,   0xA688,   0x0000,   0x0000, 
		0x0077,   0x1F70,   0x0000,   0x0000, 
		0x0024,   0x0240,   0x0000,   0x0000, 
		0x004C,   0x04C0,   0x0000,   0x0000, 
		0x0038,   0x0380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0006,   0xD800,   0x0000,   0x0000, 
		0x000F,   0x3C00,   0x0000,   0x0000, 
		0x000F,   0x3C08,   0x0000,   0x0000, 
		0x0036,   0x1B00,   0x0000,   0x0000, 
		0x0078,   0x0780,   0x0000,   0x0000, 
		0x0078,   0x0780,   0x0000,   0x0000, 
		0x0030,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-F w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x5000,   0x0000,   0x0000, 
		0x0000,   0xE800,   0x0000,   0x0000, 
		0x0000,   0x4800,   0x0000,   0x0000, 
		0x0000,   0x9800,   0x0000,   0x0000, 
		0x0002,   0xFA00,   0x0000,   0x0000, 
		0x0007,   0x5D00,   0x0000,   0x0000, 
		0x0002,   0x4900,   0x0000,   0x0000, 
		0x0004,   0xD308,   0x0000,   0x0000, 
		0x000B,   0x8E88,   0x0000,   0x0000, 
		0x001D,   0x0770,   0x0000,   0x0000, 
		0x0009,   0x0240,   0x0000,   0x0000, 
		0x0013,   0x04C0,   0x0000,   0x0000, 
		0x000E,   0x0380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0003,   0x0C00,   0x0000,   0x0000, 
		0x0007,   0x9E00,   0x0000,   0x0000, 
		0x0007,   0x9E00,   0x0000,   0x0000, 
		0x0003,   0x0C08,   0x0000,   0x0000, 
		0x000C,   0x0300,   0x0000,   0x0000, 
		0x001E,   0x0780,   0x0000,   0x0000, 
		0x001E,   0x0780,   0x0000,   0x0000, 
		0x000C,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-G w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x2800,   0x0000,   0x0000, 
		0x0000,   0x7400,   0x0000,   0x0000, 
		0x0000,   0x2400,   0x0000,   0x0000, 
		0x0000,   0x4C00,   0x0000,   0x0000, 
		0x0000,   0xBA00,   0x0000,   0x0000, 
		0x0001,   0xDD00,   0x0000,   0x0000, 
		0x0000,   0x8900,   0x0000,   0x0000, 
		0x0001,   0x3300,   0x0000,   0x0000, 
		0x0000,   0xEE00,   0x0000,   0x0000, 
		0x0002,   0x8280,   0x0000,   0x0000, 
		0x0007,   0x477C,   0x0000,   0x0000, 
		0x0002,   0x4240,   0x0000,   0x0000, 
		0x0004,   0xC4C0,   0x0000,   0x0000, 
		0x0003,   0x8380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xCC00,   0x0000,   0x0000, 
		0x0001,   0xFE00,   0x0000,   0x0000, 
		0x0001,   0xFE00,   0x0000,   0x0000, 
		0x0000,   0xCC00,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0003,   0x0300,   0x0000,   0x0000, 
		0x0007,   0x8784,   0x0000,   0x0000, 
		0x0007,   0x8780,   0x0000,   0x0000, 
		0x0003,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-H w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1400,   0x0000,   0x0000, 
		0x0000,   0x3A00,   0x0000,   0x0000, 
		0x0000,   0x1200,   0x0000,   0x0000, 
		0x0000,   0x2600,   0x0000,   0x0000, 
		0x0000,   0x1C00,   0x0000,   0x0000, 
		0x0000,   0x5500,   0x0000,   0x0000, 
		0x0000,   0xEE80,   0x0000,   0x0000, 
		0x0000,   0x4480,   0x0000,   0x0000, 
		0x0000,   0x9980,   0x0000,   0x0000, 
		0x0000,   0x7700,   0x0000,   0x0000, 
		0x0000,   0xA290,   0x0000,   0x0000, 
		0x0001,   0xD768,   0x0000,   0x0000, 
		0x0000,   0x9244,   0x0000,   0x0000, 
		0x0001,   0x34C0,   0x0000,   0x0000, 
		0x0000,   0xE380,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1800,   0x0000,   0x0000, 
		0x0000,   0x3C00,   0x0000,   0x0000, 
		0x0000,   0x3C00,   0x0000,   0x0000, 
		0x0000,   0x1800,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x6600,   0x0000,   0x0000, 
		0x0000,   0xFF00,   0x0000,   0x0000, 
		0x0000,   0xFF00,   0x0000,   0x0000, 
		0x0000,   0x6600,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC300,   0x0000,   0x0000, 
		0x0001,   0xE780,   0x0000,   0x0000, 
		0x0001,   0xE784,   0x0000,   0x0000, 
		0x0000,   0xC300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-I w = 64, h = 32 ------ */
	{ 
	/*------ plane # 0: --------*/
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x2800,   0x0000,   0x0000, 
	0x0000,   0x7400,   0x0000,   0x0000, 
	0x0000,   0x2400,   0x0000,   0x0000, 
	0x0000,   0x4C00,   0x0000,   0x0000, 
	0x0000,   0x3A80,   0x0000,   0x0000, 
	0x0000,   0x5740,   0x0000,   0x0000, 
	0x0000,   0xEA40,   0x0000,   0x0000, 
	0x0000,   0x4CC6,   0x0000,   0x0000, 
	0x0000,   0x9BAD,   0x0000,   0x0000, 
	0x0000,   0x7075,   0x0000,   0x0000, 
	0x0000,   0xA024,   0x0000,   0x0000, 
	0x0001,   0xD04C,   0x0000,   0x0000, 
	0x0000,   0x9038,   0x0000,   0x0000, 
	0x0001,   0x3000,   0x0000,   0x0000, 
	0x0000,   0xE000,   0x0000,   0x0000,

	/*------ plane # 1: --------*/
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000, 
	0x0000,   0x3000,   0x0000,   0x0000, 
	0x0000,   0x7800,   0x0000,   0x0000, 
	0x0000,   0x7800,   0x0000,   0x0000, 
	0x0000,   0x3000,   0x0000,   0x0000, 
	0x0000,   0x0300,   0x0000,   0x0000, 
	0x0000,   0x6780,   0x0000,   0x0000, 
	0x0000,   0xF780,   0x0000,   0x0000, 
	0x0000,   0xF300,   0x0000,   0x0000, 
	0x0000,   0x6030,   0x0000,   0x0000, 
	0x0000,   0x0079,   0x0000,   0x0000, 
	0x0000,   0xC078,   0x0000,   0x0000, 
	0x0001,   0xE030,   0x0000,   0x0000, 
	0x0001,   0xE000,   0x0000,   0x0000, 
	0x0000,   0xC000,   0x0000,   0x0000, 
	0x0000,   0x0000,   0x0000,   0x0000
	},

	/*----- bitmap Worm-J w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x2800,   0x0000,   0x0000, 
		0x0000,   0x7400,   0x0000,   0x0000, 
		0x0000,   0x2680,   0x0000,   0x0000, 
		0x0000,   0x4F46,   0x0000,   0x0000, 
		0x0000,   0x3A69,   0x0000,   0x0000, 
		0x0000,   0x54F5,   0x0000,   0x0000, 
		0x0000,   0xE3A4,   0x0000,   0x0000, 
		0x0000,   0x404C,   0x0000,   0x0000, 
		0x0000,   0x9038,   0x0000,   0x0000, 
		0x0000,   0x7000,   0x0000,   0x0000, 
		0x0000,   0xA000,   0x0000,   0x0000, 
		0x0001,   0xD000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0001,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x7B00,   0x0000,   0x0000, 
		0x0000,   0x3780,   0x0000,   0x0000, 
		0x0000,   0x07B0,   0x0000,   0x0000, 
		0x0000,   0x6379,   0x0000,   0x0000, 
		0x0000,   0xF078,   0x0000,   0x0000, 
		0x0000,   0xF030,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-K w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0001,   0x8000,   0x0000, 
		0x0000,   0x294A,   0x4000,   0x0000, 
		0x0000,   0x77BD,   0x4000,   0x0000, 
		0x0000,   0x2529,   0x4000,   0x0000, 
		0x0000,   0x4E73,   0x0000,   0x0000, 
		0x0000,   0x39CE,   0x0000,   0x0000, 
		0x0000,   0x5000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000, 
		0x0000,   0x4000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0000,   0x7000,   0x0000,   0x0000, 
		0x0000,   0xA000,   0x0000,   0x0000, 
		0x0001,   0xD000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0001,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x318C,   0x0000,   0x0000, 
		0x0000,   0x7BDE,   0x0000,   0x0000, 
		0x0000,   0x7BDE,   0x4000,   0x0000, 
		0x0000,   0x318C,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-L w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x001C,   0x0000,   0x0000, 
		0x0000,   0x002A,   0x0000,   0x0000, 
		0x0000,   0x0075,   0x0000,   0x0000, 
		0x0000,   0x0024,   0x0000,   0x0000, 
		0x0000,   0x004C,   0x0000,   0x0000, 
		0x0000,   0x02B8,   0x0000,   0x0000, 
		0x0000,   0x0740,   0x0000,   0x0000, 
		0x0000,   0x0240,   0x0000,   0x0000, 
		0x0000,   0x04C0,   0x0000,   0x0000, 
		0x0000,   0x2B80,   0x0000,   0x0000, 
		0x0000,   0x7400,   0x0000,   0x0000, 
		0x0000,   0x2400,   0x0000,   0x0000, 
		0x0000,   0x4C00,   0x0000,   0x0000, 
		0x0000,   0x3800,   0x0000,   0x0000, 
		0x0000,   0x5000,   0x0000,   0x0000, 
		0x0000,   0xE800,   0x0000,   0x0000, 
		0x0000,   0x4800,   0x0000,   0x0000, 
		0x0000,   0x9800,   0x0000,   0x0000, 
		0x0000,   0x7000,   0x0000,   0x0000, 
		0x0000,   0xA000,   0x0000,   0x0000, 
		0x0001,   0xD000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0001,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0030,   0x0000,   0x0000, 
		0x0000,   0x0079,   0x0000,   0x0000, 
		0x0000,   0x0078,   0x0000,   0x0000, 
		0x0000,   0x0030,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-M w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x3A00,   0x0000,   0x0000, 
		0x0000,   0x3A00,   0x0000,   0x0000, 
		0x0000,   0x1D00,   0x0000,   0x0000, 
		0x0000,   0x0900,   0x0000,   0x0000, 
		0x0000,   0x1300,   0x0000,   0x0000, 
		0x0000,   0x0E00,   0x0000,   0x0000, 
		0x0000,   0x1400,   0x0000,   0x0000, 
		0x0000,   0x3A00,   0x0000,   0x0000, 
		0x0000,   0x1200,   0x0000,   0x0000, 
		0x0000,   0x2600,   0x0000,   0x0000, 
		0x0000,   0x1C00,   0x0000,   0x0000, 
		0x0000,   0x2800,   0x0000,   0x0000, 
		0x0000,   0x7400,   0x0000,   0x0000, 
		0x0000,   0x2400,   0x0000,   0x0000, 
		0x0000,   0x4C00,   0x0000,   0x0000, 
		0x0000,   0x3800,   0x0000,   0x0000, 
		0x0000,   0x5000,   0x0000,   0x0000, 
		0x0000,   0xE800,   0x0000,   0x0000, 
		0x0000,   0x4800,   0x0000,   0x0000, 
		0x0000,   0x9800,   0x0000,   0x0000, 
		0x0000,   0x7000,   0x0000,   0x0000, 
		0x0000,   0xA000,   0x0000,   0x0000, 
		0x0001,   0xD000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0001,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0200,   0x0000,   0x0000, 
		0x0000,   0x0C00,   0x0000,   0x0000, 
		0x0000,   0x1E00,   0x0000,   0x0000, 
		0x0000,   0x1E00,   0x0000,   0x0000, 
		0x0000,   0x0C00,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1800,   0x0000,   0x0000, 
		0x0000,   0x3C00,   0x0000,   0x0000, 
		0x0000,   0x3C00,   0x0000,   0x0000, 
		0x0000,   0x1800,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x7800,   0x0000,   0x0000, 
		0x0000,   0x3000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0xF000,   0x0000,   0x0000, 
		0x0000,   0x6000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-N w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0E00,   0x0000,   0x0000, 
		0x0000,   0x1000,   0x0000,   0x0000, 
		0x0000,   0x0E80,   0x0000,   0x0000, 
		0x0000,   0x0740,   0x0000,   0x0000, 
		0x0000,   0x0240,   0x0000,   0x0000, 
		0x0000,   0x04C0,   0x0000,   0x0000, 
		0x0000,   0x0380,   0x0000,   0x0000, 
		0x0000,   0x0500,   0x0000,   0x0000, 
		0x0000,   0x0E80,   0x0000,   0x0000, 
		0x0000,   0x0480,   0x0000,   0x0000, 
		0x0000,   0x0980,   0x0000,   0x0000, 
		0x0000,   0x0700,   0x0000,   0x0000, 
		0x0000,   0x0A00,   0x0000,   0x0000, 
		0x0000,   0x1D00,   0x0000,   0x0000, 
		0x0000,   0x0900,   0x0000,   0x0000, 
		0x0000,   0x1300,   0x0000,   0x0000, 
		0x0000,   0x0E00,   0x0000,   0x0000, 
		0x0000,   0x1400,   0x0000,   0x0000, 
		0x0000,   0x3A00,   0x0000,   0x0000, 
		0x0000,   0x1200,   0x0000,   0x0000, 
		0x0000,   0x2600,   0x0000,   0x0000, 
		0x0000,   0xBC00,   0x0000,   0x0000, 
		0x0001,   0xD000,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0001,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0200,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0600,   0x0000,   0x0000, 
		0x0000,   0x0F00,   0x0000,   0x0000, 
		0x0000,   0x0F00,   0x0000,   0x0000, 
		0x0000,   0x0600,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0C00,   0x0000,   0x0000, 
		0x0000,   0x1E00,   0x0000,   0x0000, 
		0x0000,   0x1E00,   0x0000,   0x0000, 
		0x0000,   0x0C00,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1800,   0x0000,   0x0000, 
		0x0000,   0x3C00,   0x0000,   0x0000, 
		0x0000,   0x3C00,   0x0000,   0x0000, 
		0x0000,   0x1800,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-O w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1C00,   0x0000,   0x0000, 
		0x0000,   0x2000,   0x0000,   0x0000, 
		0x0000,   0x2140,   0x0000,   0x0000, 
		0x0000,   0x1FA0,   0x0000,   0x0000, 
		0x0000,   0x0120,   0x0000,   0x0000, 
		0x0000,   0x0260,   0x0000,   0x0000, 
		0x0000,   0x01C0,   0x0000,   0x0000, 
		0x0000,   0x0280,   0x0000,   0x0000, 
		0x0000,   0x0740,   0x0000,   0x0000, 
		0x0000,   0x0240,   0x0000,   0x0000, 
		0x0000,   0x04C0,   0x0000,   0x0000, 
		0x0000,   0x0380,   0x0000,   0x0000, 
		0x0000,   0x0500,   0x0000,   0x0000, 
		0x0000,   0x0E80,   0x0000,   0x0000, 
		0x0000,   0x0480,   0x0000,   0x0000, 
		0x0000,   0x0980,   0x0000,   0x0000, 
		0x0000,   0x0700,   0x0000,   0x0000, 
		0x0000,   0x0A00,   0x0000,   0x0000, 
		0x0000,   0x1D00,   0x0000,   0x0000, 
		0x0000,   0x0900,   0x0000,   0x0000, 
		0x0000,   0xB300,   0x0000,   0x0000, 
		0x0001,   0xDE00,   0x0000,   0x0000, 
		0x0000,   0x9000,   0x0000,   0x0000, 
		0x0001,   0x3000,   0x0000,   0x0000, 
		0x0000,   0xE000,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0400,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0180,   0x0000,   0x0000, 
		0x0000,   0x03C0,   0x0000,   0x0000, 
		0x0000,   0x03C0,   0x0000,   0x0000, 
		0x0000,   0x0180,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0600,   0x0000,   0x0000, 
		0x0000,   0x0F00,   0x0000,   0x0000, 
		0x0000,   0x0F00,   0x0000,   0x0000, 
		0x0000,   0x0600,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0C00,   0x0000,   0x0000, 
		0x0000,   0x1E00,   0x0000,   0x0000, 
		0x0000,   0x1E00,   0x0000,   0x0000, 
		0x0000,   0xCC00,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0001,   0xE000,   0x0000,   0x0000, 
		0x0000,   0xC000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-P w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1000,   0x0000,   0x0000, 
		0x0000,   0x1000,   0x0000,   0x0000, 
		0x0000,   0x1000,   0x0000,   0x0000, 
		0x0000,   0x08A0,   0x0000,   0x0000, 
		0x0000,   0x07D0,   0x0000,   0x0000, 
		0x0000,   0x0090,   0x0000,   0x0000, 
		0x0000,   0x0130,   0x0000,   0x0000, 
		0x0000,   0x00E0,   0x0000,   0x0000, 
		0x0000,   0x0140,   0x0000,   0x0000, 
		0x0000,   0x03A0,   0x0000,   0x0000, 
		0x0000,   0x0120,   0x0000,   0x0000, 
		0x0000,   0x0260,   0x0000,   0x0000, 
		0x0000,   0x01C0,   0x0000,   0x0000, 
		0x0000,   0x0280,   0x0000,   0x0000, 
		0x0000,   0x0740,   0x0000,   0x0000, 
		0x0000,   0x0240,   0x0000,   0x0000, 
		0x0000,   0x04C0,   0x0000,   0x0000, 
		0x0000,   0x0380,   0x0000,   0x0000, 
		0x0000,   0xA500,   0x0000,   0x0000, 
		0x0001,   0xDE80,   0x0000,   0x0000, 
		0x0000,   0x9480,   0x0000,   0x0000, 
		0x0001,   0x3980,   0x0000,   0x0000, 
		0x0000,   0xE700,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x00C0,   0x0000,   0x0000, 
		0x0000,   0x01E0,   0x0000,   0x0000, 
		0x0000,   0x01E0,   0x0000,   0x0000, 
		0x0000,   0x00C0,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0180,   0x0000,   0x0000, 
		0x0000,   0x03C0,   0x0000,   0x0000, 
		0x0000,   0x03C0,   0x0000,   0x0000, 
		0x0000,   0x0180,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0780,   0x0000,   0x0000, 
		0x0000,   0x0300,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC600,   0x0000,   0x0000, 
		0x0001,   0xEF00,   0x0000,   0x0000, 
		0x0001,   0xEF00,   0x0000,   0x0000, 
		0x0000,   0xC600,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-Q w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1C28,   0x0000,   0x0000, 
		0x0000,   0x03F4,   0x0000,   0x0000, 
		0x0000,   0x0024,   0x0000,   0x0000, 
		0x0000,   0x004C,   0x0000,   0x0000, 
		0x0000,   0x0038,   0x0000,   0x0000, 
		0x0000,   0x0050,   0x0000,   0x0000, 
		0x0000,   0x00E8,   0x0000,   0x0000, 
		0x0000,   0x0048,   0x0000,   0x0000, 
		0x0000,   0x0098,   0x0000,   0x0000, 
		0x0000,   0x0070,   0x0000,   0x0000, 
		0x0000,   0x00A0,   0x0000,   0x0000, 
		0x0000,   0x01D0,   0x0000,   0x0000, 
		0x0000,   0x0090,   0x0000,   0x0000, 
		0x0000,   0x0130,   0x0000,   0x0000, 
		0x0000,   0xA5E0,   0x0000,   0x0000, 
		0x0001,   0xDE80,   0x0000,   0x0000, 
		0x0000,   0x9480,   0x0000,   0x0000, 
		0x0001,   0x3980,   0x0000,   0x0000, 
		0x0000,   0xE700,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x1030,   0x0000,   0x0000, 
		0x0000,   0x0078,   0x0000,   0x0000, 
		0x0000,   0x0078,   0x0000,   0x0000, 
		0x0000,   0x0030,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0060,   0x0000,   0x0000, 
		0x0000,   0x00F0,   0x0000,   0x0000, 
		0x0000,   0x00F0,   0x0000,   0x0000, 
		0x0000,   0x0060,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x00C0,   0x0000,   0x0000, 
		0x0000,   0x01E0,   0x0000,   0x0000, 
		0x0000,   0x01E0,   0x0000,   0x0000, 
		0x0000,   0x00C0,   0x0000,   0x0000, 
		0x0000,   0xC600,   0x0000,   0x0000, 
		0x0001,   0xEF00,   0x0000,   0x0000, 
		0x0001,   0xEF00,   0x0000,   0x0000, 
		0x0000,   0xC600,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-R w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0014,   0x0000,   0x0000, 
		0x0000,   0x01FA,   0x0000,   0x0000, 
		0x0000,   0x0612,   0x0000,   0x0000, 
		0x0000,   0x0426,   0x0000,   0x0000, 
		0x0000,   0x001C,   0x0000,   0x0000, 
		0x0000,   0x0028,   0x0000,   0x0000, 
		0x0000,   0x0074,   0x0000,   0x0000, 
		0x0000,   0x0024,   0x0000,   0x0000, 
		0x0000,   0x004C,   0x0000,   0x0000, 
		0x0000,   0x0038,   0x0000,   0x0000, 
		0x0000,   0x0050,   0x0000,   0x0000, 
		0x0000,   0x00E8,   0x0000,   0x0000, 
		0x0000,   0x0048,   0x0000,   0x0000, 
		0x0000,   0xA598,   0x0000,   0x0000, 
		0x0001,   0xDEF0,   0x0000,   0x0000, 
		0x0000,   0x9480,   0x0000,   0x0000, 
		0x0001,   0x3980,   0x0000,   0x0000, 
		0x0000,   0xE700,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0018,   0x0000,   0x0000, 
		0x0000,   0x003C,   0x0000,   0x0000, 
		0x0000,   0x003C,   0x0000,   0x0000, 
		0x0000,   0x0418,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0030,   0x0000,   0x0000, 
		0x0000,   0x0078,   0x0000,   0x0000, 
		0x0000,   0x0078,   0x0000,   0x0000, 
		0x0000,   0x0030,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0060,   0x0000,   0x0000, 
		0x0000,   0x00F0,   0x0000,   0x0000, 
		0x0000,   0x00F0,   0x0000,   0x0000, 
		0x0000,   0xC660,   0x0000,   0x0000, 
		0x0001,   0xEF00,   0x0000,   0x0000, 
		0x0001,   0xEF00,   0x0000,   0x0000, 
		0x0000,   0xC600,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-S w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x03EA,   0x0000,   0x0000, 
		0x0000,   0x041D,   0x0000,   0x0000, 
		0x0000,   0x0009,   0x0000,   0x0000, 
		0x0000,   0x0013,   0x0000,   0x0000, 
		0x0000,   0x000E,   0x0000,   0x0000, 
		0x0000,   0x0014,   0x0000,   0x0000, 
		0x0000,   0x003A,   0x0000,   0x0000, 
		0x0000,   0x0012,   0x0000,   0x0000, 
		0x0000,   0x0026,   0x0000,   0x0000, 
		0x0000,   0x001C,   0x0000,   0x0000, 
		0x0000,   0xA528,   0x0000,   0x0000, 
		0x0001,   0xDEF4,   0x0000,   0x0000, 
		0x0000,   0x94A4,   0x0000,   0x0000, 
		0x0001,   0x39CC,   0x0000,   0x0000, 
		0x0000,   0xE738,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x000C,   0x0000,   0x0000, 
		0x0000,   0x041E,   0x0000,   0x0000, 
		0x0000,   0x001E,   0x0000,   0x0000, 
		0x0000,   0x000C,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0018,   0x0000,   0x0000, 
		0x0000,   0x003C,   0x0000,   0x0000, 
		0x0000,   0x003C,   0x0000,   0x0000, 
		0x0000,   0x0018,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC630,   0x0000,   0x0000, 
		0x0001,   0xEF78,   0x0000,   0x0000, 
		0x0001,   0xEF78,   0x0000,   0x0000, 
		0x0000,   0xC630,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-T w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0080,   0x0000,   0x0000, 
		0x0000,   0x0040,   0x0000,   0x0000, 
		0x0000,   0x0032,   0x8000,   0x0000, 
		0x0000,   0x000F,   0x4000,   0x0000, 
		0x0000,   0x0002,   0x4000,   0x0000, 
		0x0000,   0x0004,   0xC000,   0x0000, 
		0x0000,   0x0003,   0x8000,   0x0000, 
		0x0000,   0x0005,   0x0000,   0x0000, 
		0x0000,   0x000E,   0x8000,   0x0000, 
		0x0000,   0x0004,   0x8000,   0x0000, 
		0x0000,   0x0009,   0x8000,   0x0000, 
		0x0000,   0xA52F,   0x0000,   0x0000, 
		0x0001,   0xDEF4,   0x0000,   0x0000, 
		0x0000,   0x94A4,   0x0000,   0x0000, 
		0x0001,   0x39CC,   0x0000,   0x0000, 
		0x0000,   0xE738,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0080,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0003,   0x0000,   0x0000, 
		0x0000,   0x0007,   0x8000,   0x0000, 
		0x0000,   0x0007,   0x8000,   0x0000, 
		0x0000,   0x0003,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0006,   0x0000,   0x0000, 
		0x0000,   0x000F,   0x0000,   0x0000, 
		0x0000,   0x000F,   0x0000,   0x0000, 
		0x0000,   0x0006,   0x0000,   0x0000, 
		0x0000,   0xC630,   0x0000,   0x0000, 
		0x0001,   0xEF78,   0x0000,   0x0000, 
		0x0001,   0xEF78,   0x0000,   0x0000, 
		0x0000,   0xC630,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-U w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0010,   0x0000,   0x0000, 
		0x0000,   0x0010,   0x0000,   0x0000, 
		0x0000,   0x0010,   0x0000,   0x0000, 
		0x0000,   0x0008,   0x0000,   0x0000, 
		0x0000,   0x0005,   0x4000,   0x0000, 
		0x0000,   0x0007,   0xA000,   0x0000, 
		0x0000,   0x0001,   0x2000,   0x0000, 
		0x0000,   0x0002,   0x6000,   0x0000, 
		0x0000,   0x0001,   0xC000,   0x0000, 
		0x0000,   0x0002,   0x8000,   0x0000, 
		0x0000,   0x0007,   0x4000,   0x0000, 
		0x0000,   0x0002,   0x4000,   0x0000, 
		0x0000,   0xA52C,   0xC000,   0x0000, 
		0x0001,   0xDEF7,   0x8000,   0x0000, 
		0x0000,   0x94A4,   0x0000,   0x0000, 
		0x0001,   0x39CC,   0x0000,   0x0000, 
		0x0000,   0xE738,   0x0000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0010,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0001,   0x8000,   0x0000, 
		0x0000,   0x0003,   0xC000,   0x0000, 
		0x0000,   0x0003,   0xC000,   0x0000, 
		0x0000,   0x0001,   0x8000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0003,   0x0000,   0x0000, 
		0x0000,   0x0007,   0x8000,   0x0000, 
		0x0000,   0x0007,   0x8000,   0x0000, 
		0x0000,   0xC633,   0x0000,   0x0000, 
		0x0001,   0xEF78,   0x0000,   0x0000, 
		0x0001,   0xEF78,   0x0000,   0x0000, 
		0x0000,   0xC630,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-V w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0008,   0x0000,   0x0000, 
		0x0000,   0x0004,   0x0000,   0x0000, 
		0x0000,   0x0002,   0x0000,   0x0000, 
		0x0000,   0x0001,   0x0000,   0x0000, 
		0x0000,   0x0000,   0xA000,   0x0000, 
		0x0000,   0x0001,   0xD000,   0x0000, 
		0x0000,   0x0000,   0x9000,   0x0000, 
		0x0000,   0x0001,   0x3000,   0x0000, 
		0x0000,   0x0000,   0xE000,   0x0000, 
		0x0000,   0xA529,   0x4000,   0x0000, 
		0x0001,   0xDEF7,   0xA000,   0x0000, 
		0x0000,   0x94A5,   0x2000,   0x0000, 
		0x0001,   0x39CE,   0x6000,   0x0000, 
		0x0000,   0xE739,   0xC000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0008,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0xC000,   0x0000, 
		0x0000,   0x0001,   0xE000,   0x0000, 
		0x0000,   0x0001,   0xE000,   0x0000, 
		0x0000,   0x0000,   0xC000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC631,   0x8000,   0x0000, 
		0x0001,   0xEF7B,   0xC000,   0x0000, 
		0x0001,   0xEF7B,   0xC000,   0x0000, 
		0x0000,   0xC631,   0x8000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-W w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0003,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x8000,   0x0000, 
		0x0000,   0x0000,   0x4000,   0x0000, 
		0x0000,   0x0000,   0x2800,   0x0000, 
		0x0000,   0x0000,   0x7400,   0x0000, 
		0x0000,   0x0000,   0x2400,   0x0000, 
		0x0000,   0x0000,   0x4C00,   0x0000, 
		0x0000,   0xA529,   0x7800,   0x0000, 
		0x0001,   0xDEF7,   0xA000,   0x0000, 
		0x0000,   0x94A5,   0x2000,   0x0000, 
		0x0001,   0x39CE,   0x6000,   0x0000, 
		0x0000,   0xE739,   0xC000,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0002,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x3000,   0x0000, 
		0x0000,   0x0000,   0x7800,   0x0000, 
		0x0000,   0x0000,   0x7800,   0x0000, 
		0x0000,   0x0000,   0x3000,   0x0000, 
		0x0000,   0xC631,   0x8000,   0x0000, 
		0x0001,   0xEF7B,   0xC000,   0x0000, 
		0x0001,   0xEF7B,   0xC000,   0x0000, 
		0x0000,   0xC631,   0x8000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		},

	/*----- bitmap Worm-X w = 64, h = 32 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0800,   0x0000, 
		0x0000,   0x0000,   0x0800,   0x0000, 
		0x0000,   0x0000,   0x0400,   0x0000, 
		0x0000,   0x0000,   0x0400,   0x0000, 
		0x0000,   0x0000,   0x0400,   0x0000, 
		0x0000,   0xA529,   0x4A00,   0x0000, 
		0x0001,   0xDEF7,   0xBD00,   0x0000, 
		0x0000,   0x94A5,   0x2900,   0x0000, 
		0x0001,   0x39CE,   0x7300,   0x0000, 
		0x0000,   0xE739,   0xCE00,   0x0000,

		/*------ plane # 1: --------*/
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0800,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000, 
		0x0000,   0xC631,   0x8C00,   0x0000, 
		0x0001,   0xEF7B,   0xDE00,   0x0000, 
		0x0001,   0xEF7B,   0xDE00,   0x0000, 
		0x0000,   0xC631,   0x8C00,   0x0000, 
		0x0000,   0x0000,   0x0000,   0x0000
		}
	};

/*
 * Constants for a two plane walking man.
 * four in trunk (head/torso) sequence.
 * eight in each leg sequence. (one leg starts at zero, other at four)
 * eight in each arm sequence. (one arm starts at zero, other at four)
 */

#define MANRINGY		-1
#define MANRINGX		36
#define MANHEIGHT		62
#define MANWIDTH		46

#define MANTCOUNT		4
#define MANTHEIGHT		34
#define MANTWIDTH		9
#define MANTDEPTH		2
#define MANTWWIDTH		((MANTWIDTH + 15) / 16)

#define MANACOUNT		8
#define MANAHEIGHT		22
#define MANAWIDTH		24
#define MANADEPTH		2
#define MANAWWIDTH		((MANAWIDTH + 15) / 16)

#define MANLCOUNT		8
#define MANLHEIGHT		30
#define MANLWIDTH		26
#define MANLDEPTH		2
#define MANLWWIDTH		((MANLWIDTH + 15) / 16)

SHORT manTTimes[MANTCOUNT] = { 1, 1, 1, 1 };
SHORT manTYTranses[MANTCOUNT] = { 6<<ANFS, 6<<ANFS, 3<<ANFS, 0<<ANFS };
SHORT manTXTranses[MANTCOUNT] = { 0<<ANFS,11<<ANFS,16<<ANFS,26<<ANFS };

/* APTR manTCRoutines[MANTCOUNT] */
WORD (*manTCRoutines[MANTCOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL
	};

UWORD chip manTImage[MANTCOUNT][MANTWWIDTH * MANTHEIGHT * MANTDEPTH] =
	{
	/*----- bitmap : w = 16, h = 34 ------ */
		{
		/*------ plane # 0: --------*/
		0x0000, 
		0x0000, 
		0x0C00, 
		0x1000, 
		0x0000, 
		0x0000, 
		0x0800, 
		0x0400, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x1C00, 
		0x0E00, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400,
		0x0000, 
		0x0000, 
		0x0000, 
		/*------ plane # 1: --------*/
		0x1800, 
		0x2400, 
		0x4200, 
		0x4600, 
		0x4200, 
		0x8200, 
		0x8200, 
		0x8000, 
		0x8200, 
		0xBE00, 
		0x8000, 
		0x9C00, 
		0x8E00, 
		0x8E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00,
		0x0000, 
		0x0000, 
		0x0000 
		},
	/*----- bitmap : w = 16, h = 28 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000, 
		0x0000, 
		0x0C00, 
		0x1000, 
		0x0000, 
		0x0000, 
		0x0800, 
		0x0400, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x3800, 
		0x3800, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x1000, 
		0x2000, 
		0x2000, 
		0x2000, 
		0x2000, 
		0x2000,
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		/*------ plane # 1: --------*/
		0x1800, 
		0x2400, 
		0x4200, 
		0x4600, 
		0x4200, 
		0x8200, 
		0x8200, 
		0x8000, 
		0x8200, 
		0xBE00, 
		0x8000, 
		0xB800, 
		0xB800, 
		0xB800, 
		0x3800, 
		0x3800, 
		0x3800, 
		0x3800, 
		0x3800, 
		0x3800, 
		0x3800, 
		0x3800, 
		0x7800, 
		0x7800, 
		0x7000, 
		0x7000, 
		0x7000, 
		0x7000,
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000 
		},
	/*----- bitmap : w = 16, h = 28 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000, 
		0x0000, 
		0x0C00, 
		0x1000, 
		0x0000, 
		0x0000, 
		0x0800, 
		0x0400, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x1C00, 
		0x1C00, 
		0x0800, 
		0x0800, 
		0x0800, 
		0x0800, 
		0x0800, 
		0x0800, 
		0x0800, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0200, 
		0x0200,
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		/*------ plane # 1: --------*/
		0x1800, 
		0x2400, 
		0x4200, 
		0x4600, 
		0x4200, 
		0x8200, 
		0x8200, 
		0x8000, 
		0x8200, 
		0xBE00, 
		0x8000, 
		0x9C00, 
		0x9C00, 
		0x9C00, 
		0x1C00, 
		0x1C00, 
		0x1C00, 
		0x1C00, 
		0x1C00, 
		0x1E00, 
		0x1E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0F00, 
		0x0F00, 
		0x0700,
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x0000 
		},
	/*----- bitmap : w = 16, h = 34 ------ */
		{ 
		/*------ plane # 0: --------*/
		0x0000, 
		0x0000, 
		0x0C00, 
		0x1000, 
		0x0000, 
		0x0000, 
		0x0800, 
		0x0400, 
		0x0000, 
		0x0000, 
		0x0000, 
		0x1C00, 
		0x0E00, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0400, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0200, 
		0x0100, 
		0x0100,
		/*------ plane # 1: --------*/
		0x1800, 
		0x2400, 
		0x4200, 
		0x4600, 
		0x4200, 
		0x8200, 
		0x8200, 
		0x8000, 
		0x8200, 
		0xBE00, 
		0x8000, 
		0x9C00, 
		0x8E00, 
		0x8E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0E00, 
		0x0F00, 
		0x0F00, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0700, 
		0x0780, 
		0x0780, 
		0x0380
		}
	};

SHORT manATimes[MANACOUNT] =
	{
	1, 1, 1, 1, 1, 1, 1, 1
	};
SHORT manAYTranses[MANACOUNT] =
	{
	18<<ANFS,20<<ANFS,16<<ANFS,11<<ANFS,
	18<<ANFS,20<<ANFS,15<<ANFS,11<<ANFS
	};
SHORT manAXTranses[MANACOUNT] =
	{
	-3<<ANFS, 7<<ANFS,20<<ANFS,31<<ANFS,
	4<<ANFS,11<<ANFS,13<<ANFS,19<<ANFS
	};

/* APTR manACRoutines[MANACOUNT] */
WORD (*manACRoutines[MANACOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	};

UWORD chip manAImage[MANACOUNT][MANAWWIDTH * MANAHEIGHT * MANADEPTH] =
	{
		{
		/*----- bitmap : w = 32, h = 22 ------ */
		/*------ plane # 0: --------*/
		0x0,   0x0, 
		0x0100,   0x0, 
		0x0200,   0x0, 
		0x0400,   0x0, 
		0x0400,   0x0, 
		0x0800,   0x0, 
		0x1000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x0000,   0x0, 
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0,
		/*------ plane # 1: --------*/
		0x0380,   0x0, 
		0x0780,   0x0, 
		0x0F80,   0x0, 
		0x0F00,   0x0, 
		0x1E00,   0x0, 
		0x3E00,   0x0, 
		0x7C00,   0x0, 
		0x7800,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0x7000,   0x0, 
		0x7000,   0x0, 
		0x7800,   0x0, 
		0x7800,   0x0, 
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0
		},

	/*----- bitmap : w = 32, h = 21 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,   0x0, 
		0x0200,   0x0, 
		0x0400,   0x0, 
		0x0400,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0, 
		0x1000,   0x0, 
		0x1000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x0800,   0x0, 
		0x0400,   0x0, 
		0x0400,   0x0, 
		0x0080,   0x0, 
		0x01C0,   0x0, 
		0x03A0,   0x0, 
		0x0110,   0x0,
		0x0,      0x0,
		/*------ plane # 1: --------*/
		0x0700,   0x0, 
		0x0F00,   0x0, 
		0x0F00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0x3C00,   0x0, 
		0x3C00,   0x0, 
		0x7800,   0x0, 
		0x7800,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0x7800,   0x0, 
		0x7C00,   0x0, 
		0x3E00,   0x0, 
		0x1E00,   0x0, 
		0x0F00,   0x0, 
		0x0F80,   0x0, 
		0x07C0,   0x0, 
		0x03A0,   0x0, 
		0x0110,   0x0,
		0x0,      0x0
		},

	/*----- bitmap : w = 32, h = 13 ------ */
		{
		/*------ plane # 0: --------*/
		0x0000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0, 
		0x0400,   0x0, 
		0x0400,   0x0, 
		0x0380,   0x0, 
		0x007E,   0x7C00, 
		0x0001,   0x7000, 
		0x0000,   0x7000,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		/*------ plane # 1: --------*/
		0xE000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0x7800,   0x0, 
		0x7C00,   0x0, 
		0x3C00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0x0FC0,   0x0, 
		0x0FFF,   0x0, 
		0x07FF,   0xFC00, 
		0x00FF,   0xF000, 
		0x0003,   0xF000,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0
		},

	/*----- bitmap : w = 32, h = 13 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,   0x100, 
		0x0000,   0x200, 
		0x0000,   0x400, 
		0x6000,   0xE00, 
		0x1800,   0x700, 
		0x0400,   0x200, 
		0x0300,   0x800, 
		0x0080,   0x1000, 
		0x0060,   0x2000, 
		0x0018,   0x4000, 
		0x0006,   0x4000, 
		0x0001,   0x8000, 
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		/*------ plane # 1: --------*/
		0x0,   0x100, 
		0x0000,   0x200, 
		0xF000,   0x400, 
		0xFC00,   0xE00, 
		0xFE00,   0x1F00, 
		0x3F80,   0x1E00, 
		0x0FC0,   0x3C00, 
		0x07F0,   0x7C00, 
		0x01FC,   0xF800, 
		0x00FF,   0xF000, 
		0x003F,   0xE000, 
		0x000F,   0xE000, 
		0x0003,   0xC000,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0
		},

	/*----- bitmap : w = 32, h = 12 ------ */
		{
		/*------ plane # 0: --------*/
		0x0000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0, 
		0x0400,   0x0, 
		0x0400,   0x7C00, 
		0x03FF,   0x7000, 
		0x0000,   0x7000,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		/*------ plane # 1: --------*/
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0x7800,   0x0, 
		0x7C00,   0x0, 
		0x3C00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0x0FFF,   0xFC00, 
		0x0FFF,   0xF000, 
		0x07FF,   0xF000,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0
		},

	/*----- bitmap : w = 32, h = 17 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,   0x0, 
		0x1000,   0x0, 
		0x1000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x3000,   0x0, 
		0x0C00,   0x0, 
		0x0200,   0x0, 
		0x0120,   0x0, 
		0x0078,   0x0, 
		0x00E6,   0x0, 
		0x0040,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		/*------ plane # 1: --------*/
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x7800,   0x0, 
		0x7800,   0x0, 
		0x7000,   0x0, 
		0x7000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xE000,   0x0, 
		0xF800,   0x0, 
		0xFE00,   0x0, 
		0x7F00,   0x0, 
		0x1FC0,   0x0, 
		0x07E0,   0x0, 
		0x03F8,   0x0, 
		0x00E6,   0x0, 
		0x0040,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0
		},

	/*----- bitmap : w = 32, h = 18 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,   0x0, 
		0x0200,   0x0, 
		0x0200,   0x0, 
		0x0400,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0, 
		0x1000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x0800,   0x0, 
		0x0800,   0x0, 
		0x0100,   0x0, 
		0x0380,   0x0, 
		0x0740,   0x0, 
		0x0220,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		/*------ plane # 1: --------*/
		0x0700,   0x0, 
		0x0700,   0x0, 
		0x0F00,   0x0, 
		0x1F00,   0x0, 
		0x1E00,   0x0, 
		0x3C00,   0x0, 
		0x7C00,   0x0, 
		0x7800,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF800,   0x0, 
		0x7C00,   0x0, 
		0x3C00,   0x0, 
		0x1E00,   0x0, 
		0x1F00,   0x0, 
		0x0F80,   0x0, 
		0x0740,   0x0, 
		0x0220,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0,
		0x0000,   0x0
		},

	/*----- bitmap : w = 32, h = 22 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,   0x0, 
		0x0010,   0x0, 
		0x0020,   0x0, 
		0x00C0,   0x0, 
		0x0100,   0x0, 
		0x0200,   0x0, 
		0x0400,   0x0, 
		0x1800,   0x0, 
		0x2000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x0000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0,
		/*------ plane # 1: --------*/
		0x0038,   0x0, 
		0x0078,   0x0, 
		0x01F8,   0x0, 
		0x03F0,   0x0, 
		0x07E0,   0x0, 
		0x0F80,   0x0, 
		0x3F00,   0x0, 
		0x7E00,   0x0, 
		0xFC00,   0x0, 
		0xF000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0
		}
	};

SHORT manLTimes[MANLCOUNT] =
	{
	1, 1, 1, 1, 1, 1, 1, 1
	};
SHORT manLYTranses[MANLCOUNT] =
	{
	31<<ANFS,31<<ANFS,31<<ANFS,31<<ANFS,
	31<<ANFS,31<<ANFS,31<<ANFS,31<<ANFS
	};
SHORT manLXTranses[MANLCOUNT] =
	{
	  4<<ANFS, 4<<ANFS, 5<<ANFS,10<<ANFS,
	-16<<ANFS,-6<<ANFS,21<<ANFS,32<<ANFS
	};

/* APTR manLCRoutines[MANLCOUNT] */
WORD (*manLCRoutines[MANLCOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	};

UWORD chip manLImage[MANLCOUNT][MANLWWIDTH * MANLHEIGHT * MANLDEPTH] =
	{
	/*----- bitmap : w = 32, h = 24 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x1000,   0x0, 
		0x1000,   0x0, 
		0x1000,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x400,   0x0, 
		0x400,   0x0, 
		0x400,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x0,   0x0, 
		0x3800,   0x0, 
		0x7800,   0x0, 
		0xDFF0,   0x0, 
		0xCFF0,   0x0, 
		0x7FF0,   0x0,
		/*------ plane # 1: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF800,   0x0, 
		0x7800,   0x0, 
		0x3800,   0x0, 
		0x3800,   0x0, 
		0x3C00,   0x0, 
		0x3C00,   0x0, 
		0x1C00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0xE00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0x1C00,   0x0, 
		0x3C00,   0x0, 
		0x400,   0x0, 
		0x0,   0x0, 
		0x2780,   0x0, 
		0x3000,   0x0, 
		0x2AA0,   0x0
		},

	/*----- bitmap : w = 32, h = 27 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x40,   0x0, 
		0x40,   0x0, 
		0x40,   0x0, 
		0x40,   0x0, 
		0x40,   0x0, 
		0x40,   0x0, 
		0x80,   0x0, 
		0x80,   0x0, 
		0x80,   0x0, 
		0x80,   0x0, 
		0x100,   0x0, 
		0x100,   0x0, 
		0x100,   0x0, 
		0x200,   0x0, 
		0x200,   0x0, 
		0x200,   0x0, 
		0x400,   0x0, 
		0x400,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x0,   0x0, 
		0x3800,   0x0, 
		0x7800,   0x0, 
		0xDFF0,   0x0, 
		0xCFF0,   0x0, 
		0x7FF0,   0x0,
		/*------ plane # 1: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0xE0,   0x0, 
		0xE0,   0x0, 
		0xF0,   0x0, 
		0xF0,   0x0, 
		0xF0,   0x0, 
		0x1E0,   0x0, 
		0x1E0,   0x0, 
		0x1C0,   0x0, 
		0x1C0,   0x0, 
		0x3C0,   0x0, 
		0x3C0,   0x0, 
		0x380,   0x0, 
		0x780,   0x0, 
		0x780,   0x0, 
		0x700,   0x0, 
		0xF00,   0x0, 
		0xF00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0x1C00,   0x0, 
		0x3C00,   0x0, 
		0x3C00,   0x0, 
		0x0,   0x0, 
		0x0,   0x0, 
		0x2780,   0x0, 
		0x3000,   0x0, 
		0x2AA0,   0x0
		},

	/*----- bitmap : w = 32, h = 30 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,   0x4000, 
		0x0,   0x4000, 
		0x0,   0x2000, 
		0x0,   0x2000, 
		0x0,   0x2000, 
		0x0,   0x4000, 
		0x0,   0x8000, 
		0x1,   0x0, 
		0x1,   0x0, 
		0x2,   0x0, 
		0x4,   0x0, 
		0x8,   0x0, 
		0x10,   0x0, 
		0x20,   0x0, 
		0x20,   0x0, 
		0x40,   0x0, 
		0x80,   0x0, 
		0x80,   0x0, 
		0x100,   0x0, 
		0x200,   0x0, 
		0x400,   0x0, 
		0x3000,   0x0, 
		0x7800,   0x0, 
		0xD800,   0x0, 
		0xB800,   0x0, 
		0x5C00,   0x0, 
		0x3E00,   0x0, 
		0x1FC0,   0x0, 
		0xFC0,   0x0, 
		0x7C0,   0x0,
		/*------ plane # 1: --------*/
		0x0,   0xE000, 
		0x0,   0xF000, 
		0x0,   0xF800, 
		0x0,   0x7800, 
		0x0,   0xF800, 
		0x1,   0xF000, 
		0x3,   0xE000, 
		0x3,   0xC000, 
		0x7,   0x8000, 
		0xF,   0x8000, 
		0x1F,   0x0, 
		0x3E,   0x0, 
		0x7C,   0x0, 
		0x78,   0x0, 
		0xF0,   0x0, 
		0x1F0,   0x0, 
		0x1E0,   0x0, 
		0x3C0,   0x0, 
		0x7C0,   0x0, 
		0xF80,   0x0, 
		0x1F00,   0x0, 
		0xE00,   0x0, 
		0x400,   0x0, 
		0x2000,   0x0, 
		0x4800,   0x0, 
		0x2400,   0x0, 
		0x2200,   0x0, 
		0x1000,   0x0, 
		0x800,   0x0, 
		0x280,   0x0
		},

	/*----- bitmap : w = 32, h = 27 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,   0x100, 
		0x0,   0x100, 
		0x0,   0x100, 
		0x0,   0x100, 
		0x0,   0x100, 
		0x0,   0x200, 
		0x0,   0x400, 
		0x0,   0x1800, 
		0x0,   0x2000, 
		0x0,   0x4000, 
		0x1,   0x8000, 
		0x2,   0x0, 
		0x4,   0x0, 
		0x18,   0x0, 
		0x60,   0x0, 
		0x980,   0x0, 
		0xFA00,   0x0, 
		0x9800,   0x0, 
		0xBC00,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF800,   0x0, 
		0xF800,   0x0, 
		0x7800,   0x0,
		/*------ plane # 1: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,   0x380, 
		0x0,   0x380, 
		0x0,   0x3C0, 
		0x0,   0x3C0, 
		0x0,   0x7C0, 
		0x0,   0xF80, 
		0x0,   0x3F00, 
		0x0,   0x7E00, 
		0x0,   0xFC00, 
		0x3,   0xF000, 
		0x7,   0xE000, 
		0xF,   0xC000, 
		0x3F,   0x0, 
		0xFE,   0x0, 
		0x3FC,   0x0, 
		0x7F0,   0x0, 
		0x7C0,   0x0, 
		0x6700,   0x0, 
		0x4000,   0x0, 
		0x9000,   0x0, 
		0x1000,   0x0, 
		0x9000,   0x0, 
		0x1000,   0x0, 
		0x8000,   0x0, 
		0x0,   0x0, 
		0x8000,   0x0, 
		0x2000,   0x0
		},

	/*----- bitmap : w = 32, h = 23 ------ */
		{
		/* ------ plane # 0: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,   0x400, 
		0x0,   0x400, 
		0x0,   0x400, 
		0x0,   0x400, 
		0x0,   0x400, 
		0x0,   0x800, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x2000, 
		0x0,   0x4000, 
		0x0,   0x8000, 
		0x0,   0x8000, 
		0xF01,   0x0, 
		0x1E7E,   0x0, 
		0x1280,   0x0, 
		0x3600,   0x0, 
		0x3C00,   0x0, 
		0x7800,   0x0, 
		0x7800,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xE000,   0x0, 
		0xE000,   0x0,
		0x0,      0x0,
		/*------ plane # 1: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,   0xE00, 
		0x0,   0xE00, 
		0x0,   0xF00, 
		0x0,   0xF00, 
		0x0,   0x1F00, 
		0x0,   0x3E00, 
		0x0,   0x3C00, 
		0x0,   0x7800, 
		0x0,   0xF800, 
		0x1,   0xF000, 
		0x1,   0xE000, 
		0x3,   0xC000, 
		0xFF,   0xC000, 
		0x11FF,   0x8000, 
		0xDFF,   0x0, 
		0x29C0,   0x0, 
		0x400,   0x0, 
		0x4800,   0x0, 
		0x800,   0x0, 
		0x9000,   0x0, 
		0x0,   0x0, 
		0x8000,   0x0, 
		0x0,   0x0,
		0x0,      0x0
		},

	/*----- bitmap : w = 32, h = 24 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0x0,   0x1000, 
		0xC00,   0xF000, 
		0x1E3F,   0x0, 
		0x16C0,   0x0, 
		0x2A00,   0x0, 
		0x3E00,   0x0, 
		0x7C00,   0x0, 
		0x7800,   0x0, 
		0xF800,   0x0, 
		0xF000,   0x0, 
		0xE000,   0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		/*------ plane # 1: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3C00, 
		0x0,   0x3C00, 
		0x0,   0x3C00, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x0,   0x3800, 
		0x1,   0xF800, 
		0x87F,   0xF800, 
		0x1FF,   0xF800, 
		0x19FF,   0x8000, 
		0x15E0,   0x0, 
		0x2400,   0x0, 
		0x400,   0x0, 
		0x4800,   0x0, 
		0x800,   0x0, 
		0x8000,   0x0, 
		0x0,   0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0
		},

	/*----- bitmap : w = 32, h = 24 ------ */
		{
		/*------ plane # 0: --------*/
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0xC00,   0x0, 
		0x300,   0x0, 
		0x80,   0x0, 
		0x60,   0x0, 
		0x10,   0x0, 
		0x8,   0x0, 
		0x10,   0x0, 
		0x20,   0x0, 
		0xC0,   0x0, 
		0x100,   0x0, 
		0xC00,   0x0, 
		0x1B00,   0x0, 
		0x3700,   0x0, 
		0x1BC0,   0x0, 
		0x7F0,   0x0, 
		0x3F8,   0x0, 
		0xF8,   0x0, 
		0x38,   0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		/*------ plane # 1: --------*/
		0xE000,   0x0, 
		0xF000,   0x0, 
		0xF800,   0x0, 
		0x7800,   0x0, 
		0x7800,   0x0, 
		0x7E00,   0x0, 
		0x3F80,   0x0, 
		0x1FC0,   0x0, 
		0x7F0,   0x0, 
		0x1F8,   0x0, 
		0xFC,   0x0, 
		0x3C,   0x0, 
		0x7C,   0x0, 
		0x1F8,   0x0, 
		0x3F0,   0x0, 
		0x7E0,   0x0, 
		0x380,   0x0, 
		0x400,   0x0, 
		0x900,   0x0, 
		0x14C0,   0x0, 
		0x420,   0x0, 
		0x200,   0x0, 
		0x80,   0x0, 
		0x20,   0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0
		},

	/*----- bitmap : w = 32, h = 25 ------ */
		{
		/*------ plane # 0: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x4000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x2000,   0x0, 
		0x1000,   0x0, 
		0x1000,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x800,   0x0, 
		0x400,   0x0, 
		0x400,   0x0, 
		0x403,   0x0, 
		0x207,   0x8000, 
		0x20F,   0x0, 
		0x11E,   0x0, 
		0xBC,   0x0, 
		0x3FC,   0x0, 
		0x358,   0x0, 
		0x1B0,   0x0, 
		0xE0,   0x0,
		0x0,      0x0,
		0x0,      0x0,
		/*------ plane # 1: --------*/
		0x0,      0x0,
		0x0,      0x0,
		0x0,      0x0,
		0xE000,   0x0, 
		0xE000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0xF000,   0x0, 
		0x7000,   0x0, 
		0x7800,   0x0, 
		0x7800,   0x0, 
		0x3C00,   0x0, 
		0x3C00,   0x0, 
		0x1C00,   0x0, 
		0x1E00,   0x0, 
		0x1E00,   0x0, 
		0xE00,   0x0, 
		0xF00,   0x0, 
		0xF00,   0x8000, 
		0x788,   0x0, 
		0x792,   0x0, 
		0x320,   0x0, 
		0x44,   0x0, 
		0xA0,   0x0, 
		0x50,   0x0, 
		0x40,   0x0,
		0x0,      0x0,
		0x0,      0x0
		}
	};
/*


/*
** Constants for a three plane boing(tm) ball and
** a two plane satellite.
*/

#define BNG3RINGY		0
#define BNG3RINGX		0
#define BNG3COUNT		6
#define BNG3HEIGHT		25
#define BNG3WIDTH		29
#define BNG3DEPTH		3
#define BNG3WWIDTH		((BNG3WIDTH + 15) / 16)

#define SATCOUNT		16
#define SATHEIGHT		5
#define SATWIDTH		5
#define SATDEPTH		2
#define SATWWIDTH		((SATWIDTH + 15) / 16)


SHORT boing3Times[BNG3COUNT] = { 1, 1, 1, 1, 1, 1 };
SHORT boing3YTranses[BNG3COUNT] = { 0, 0, 0, 0, 0, 0 };
SHORT boing3XTranses[BNG3COUNT] = { 0, 0, 0, 0, 0, 0 };

/* APTR boing3CRoutines[BNG3COUNT] */
WORD (*boing3CRoutines[BNG3COUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL
	};

UWORD chip boing3Image[BNG3COUNT][BNG3WWIDTH * BNG3HEIGHT * BNG3DEPTH] =
	{
	/*----- bitmap Boing-A w = 32, h = 25 ------ */
		{
		/*------ plane # 0: --------*/
		0x0023,   0x0000, 
		0x004E,   0x3000, 
		0x00E3,   0x3A00, 
		0x03C3,   0xC900, 
		0x0787,   0x8780, 
		0x108F,   0x8700, 
		0x31F7,   0x8790, 
		0x61F0,   0x4790, 
		0x63E0,   0xFB90, 
		0x43E0,   0xF848, 
		0x3BC0,   0xF870, 
		0x3801,   0xF870, 
		0x383D,   0xF070, 
		0x387E,   0x1070, 
		0x387C,   0x0EE0, 
		0xD87C,   0x1F10, 
		0x467C,   0x1E10, 
		0x479C,   0x1E30, 
		0x6787,   0x3E20, 
		0x0787,   0xCC60, 
		0x0F0F,   0x8700, 
		0x048F,   0x0E00, 
		0x0277,   0x1C00, 
		0x0161,   0xD800, 
		0x0027,   0x2000,
		/*------ plane # 1: --------*/
		0x003C,   0x2000, 
		0x0030,   0x0C00, 
		0x001F,   0x0700, 
		0x083F,   0xF780, 
		0x007F,   0xF8C0, 
		0x2FFF,   0xF8E0, 
		0x0FFF,   0xF870, 
		0x1FFF,   0xF870, 
		0x1FFF,   0xF870, 
		0x3FFF,   0xF878, 
		0x07FF,   0xF878, 
		0x07FF,   0xF878, 
		0x07FF,   0xF078, 
		0x07FF,   0xF078, 
		0x07FF,   0xF0F8, 
		0x07FF,   0xE0F8, 
		0x01FF,   0xE1F0, 
		0x001F,   0xE1F0, 
		0x0000,   0xC1E0, 
		0x2000,   0x03E0, 
		0x1000,   0x07C0, 
		0x0B00,   0x0F80, 
		0x0588,   0x1E00, 
		0x009E,   0x1C00, 
		0x0018,   0xE000,
		/*------ plane # 2: --------*/
		0x0003,   0xC000, 
		0x01CF,   0xF000, 
		0x03FF,   0xF800, 
		0x07FF,   0xF800, 
		0x1FFF,   0xFF00, 
		0x1FFF,   0xFF00, 
		0x3FFF,   0xFF80, 
		0x7FFF,   0xFF80, 
		0x7FFF,   0xFF80, 
		0xFFFF,   0xFF80, 
		0xFFFF,   0xFF80, 
		0xFFFF,   0xFF80, 
		0xFFFF,   0xFF80, 
		0xFFFF,   0xFF80, 
		0xFFFF,   0xFF00, 
		0xFFFF,   0xFF00, 
		0x7FFF,   0xFE00, 
		0x7FFF,   0xFE00, 
		0x7FFF,   0xFE00, 
		0x1FFF,   0xFC00, 
		0x0FFF,   0xF800, 
		0x04FF,   0xF000, 
		0x0277,   0xE000, 
		0x0161,   0xE000, 
		0x0027,   0x0000
		},
	/*----- bitmap Boing-B w = 32, h = 25 ------ */
		{
		/*------ plane # 0: --------*/
		0x0031,   0x8000, 
		0x0107,   0x1800, 
		0x00F0,   0x1900, 
		0x09E1,   0xEC80, 
		0x13C1,   0xE340, 
		0x1803,   0xE380, 
		0x387B,   0xC390, 
		0x30F8,   0x01D0, 
		0x70F8,   0x3DC0, 
		0xE1F0,   0x3E08, 
		0x9DF0,   0x7C30, 
		0x9E30,   0x7C30, 
		0x9E1C,   0x7C30, 
		0x1C1F,   0x9C30, 
		0x1C1F,   0x0630, 
		0x7C1F,   0x0780, 
		0x623F,   0x0798, 
		0x63DE,   0x0F10, 
		0x23C1,   0x0F20, 
		0x33C3,   0xEE20, 
		0x0BC3,   0xC380, 
		0x0647,   0xC700, 
		0x023F,   0x8E00, 
		0x0130,   0xF800, 
		0x0033,   0x8000,
		/*------ plane # 1: --------*/
		0x0000,   0x2000, 
		0x0000,   0x0400, 
		0x00FF,   0x0700, 
		0x01FF,   0xE380, 
		0x03FF,   0xE0C0, 
		0x27FF,   0xE060, 
		0x07FF,   0xC070, 
		0x4FFF,   0xC030, 
		0x8FFF,   0xC030, 
		0x1FFF,   0xC038, 
		0x1FFF,   0x8038, 
		0x1FFF,   0x8038, 
		0x1FFF,   0x8038, 
		0x1FFF,   0x8038, 
		0x1FFF,   0x0638, 
		0x9FFF,   0x07F8, 
		0x01FF,   0x07F8, 
		0x001E,   0x0FF0, 
		0x4000,   0x0FE0, 
		0x0000,   0x1FE0, 
		0x1000,   0x3FC0, 
		0x0980,   0x3F80, 
		0x05C0,   0x7E00, 
		0x00CF,   0xFC00, 
		0x000F,   0xE000,
		/*------ plane # 2: --------*/
		0x003F,   0xC000, 
		0x01FF,   0xF800, 
		0x03FF,   0xF800, 
		0x0FFF,   0xFC00, 
		0x1FFF,   0xFF00, 
		0x1FFF,   0xFF80, 
		0x3FFF,   0xFF80, 
		0x3FFF,   0xFFC0, 
		0x7FFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xF9C0, 
		0x7FFF,   0xF800, 
		0x7FFF,   0xF800, 
		0x7FFF,   0xF000, 
		0x3FFF,   0xF000, 
		0x3FFF,   0xE000, 
		0x0FFF,   0xC000, 
		0x067F,   0xC000, 
		0x023F,   0x8000, 
		0x0130,   0x0000, 
		0x0030,   0x0000
		},
	/*----- bitmap Boing-C w = 32, h = 25 ------ */
		{
		/*------ plane # 0: --------*/
		0x0019,   0xC000, 
		0x0103,   0x8800, 
		0x0278,   0x8D00, 
		0x0CF0,   0xFE80, 
		0x11F0,   0xF140, 
		0x0E60,   0xF1E0, 
		0x1C39,   0xF0C0, 
		0x1C3E,   0x30C0, 
		0x387E,   0x0CE0, 
		0xF87C,   0x1F28, 
		0x8C7C,   0x1F18, 
		0x8F3C,   0x1F18, 
		0x8F06,   0x1E18, 
		0x8F07,   0xDE18, 
		0x8F07,   0xC018, 
		0x6E0F,   0xC1C0, 
		0x300F,   0x83C8, 
		0x31EF,   0x8390, 
		0x31F0,   0x8780, 
		0x11E0,   0xF720, 
		0x11E1,   0xF1C0, 
		0x0B61,   0xE300, 
		0x071B,   0xC600, 
		0x0138,   0x6C00, 
		0x0031,   0x8000,
		/*------ plane # 1: --------*/
		0x0020,   0x2000, 
		0x0000,   0x0400, 
		0x007F,   0x0300, 
		0x00FF,   0xF180, 
		0x01FF,   0xF0C0, 
		0x0FFF,   0xF020, 
		0x1FFF,   0xF030, 
		0x1FFF,   0xF030, 
		0x3FFF,   0xF010, 
		0x7FFF,   0xE018, 
		0x0FFF,   0xE018, 
		0x0FFF,   0xE018, 
		0x0FF9,   0xE018, 
		0x0FF8,   0x0018, 
		0x0FF8,   0x0018, 
		0x8FF0,   0x01F8, 
		0x41F0,   0x03F8, 
		0x4010,   0x03F0, 
		0x4000,   0x87E0, 
		0x2000,   0xF7E0, 
		0x0801,   0xFFC0, 
		0x0481,   0xFF80, 
		0x00E3,   0xFE00, 
		0x00C7,   0xFC00, 
		0x000F,   0xE000,
		/*------ plane # 2: --------*/
		0x001F,   0xC000, 
		0x01FF,   0xF800, 
		0x03FF,   0xFC00, 
		0x0FFF,   0xFE00, 
		0x1FFF,   0xFF00, 
		0x3FFF,   0xFFC0, 
		0x3FFF,   0xFFC0, 
		0x7FFF,   0xFFC0, 
		0x7FFF,   0xFFE0, 
		0xFFFF,   0xFFE0, 
		0xFFFF,   0xFFE0, 
		0xFFFF,   0xFFE0, 
		0xFFFF,   0xFFE0, 
		0xFFFF,   0xFFE0, 
		0xFFFF,   0xFFE0, 
		0x7FFF,   0xFE00, 
		0x3FFF,   0xFC00, 
		0x3FFF,   0xFC00, 
		0x3FFF,   0x7800, 
		0x1FFF,   0x0800, 
		0x17FE,   0x0000, 
		0x0B7E,   0x0000, 
		0x071C,   0x0000, 
		0x0138,   0x0000, 
		0x0030,   0x0000
		},
	/*----- bitmap : w = 32, h = 25 ------ */
		{
		/*------ plane Boing-D 0: --------*/
		0x001C,   0xE000, 
		0x01B1,   0xCC00, 
		0x031C,   0xC500, 
		0x0C3C,   0x3680, 
		0x1878,   0x7840, 
		0x2F70,   0x78E0, 
		0x0E08,   0x7860, 
		0x1E0F,   0xB860, 
		0x1C1F,   0x0460, 
		0xBC1F,   0x07B0, 
		0xC43F,   0x0788, 
		0xC7FE,   0x0788, 
		0xC7C0,   0x0F88, 
		0xC781,   0xEF88, 
		0xC783,   0xF118, 
		0x2783,   0xE0E8, 
		0x3983,   0xE1E0, 
		0x3863,   0xE1C0, 
		0x1878,   0xC1C0, 
		0x3878,   0x3380, 
		0x10F0,   0x78C0, 
		0x0B70,   0xF180, 
		0x0588,   0xE200, 
		0x009E,   0x2400, 
		0x0018,   0xC000,
		/*------ plane # 1: --------*/
		0x0000,   0xE000, 
		0x0040,   0x0C00, 
		0x00FF,   0x0700, 
		0x03FF,   0xC780, 
		0x07FF,   0x80C0, 
		0x0FFF,   0x80E0, 
		0x0FFF,   0x8070, 
		0x1FFF,   0xC070, 
		0x1FFF,   0xF870, 
		0x3FFF,   0xF838, 
		0x3FFF,   0xF808, 
		0x3FFF,   0xF808, 
		0x3FFF,   0xF008, 
		0x3FFE,   0x1008, 
		0x3FFC,   0x0018, 
		0xDFFC,   0x00F8, 
		0x41FC,   0x01F0, 
		0x401C,   0x01F0, 
		0x6000,   0x01E0, 
		0x2000,   0x33E0, 
		0x1800,   0x7FC0, 
		0x0F80,   0xFF80, 
		0x07F8,   0xFE00, 
		0x01FF,   0xFC00, 
		0x003F,   0xE000,
		/*------ plane # 2: --------*/
		0x003F,   0x0000, 
		0x01FF,   0xF000, 
		0x03FF,   0xF800, 
		0x0FFF,   0xF800, 
		0x1FFF,   0xFF00, 
		0x3FFF,   0xFF00, 
		0x3FFF,   0xFF80, 
		0x7FFF,   0xFF80, 
		0x7FFF,   0xFF80, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFF0, 
		0xFFFF,   0xFFF0, 
		0xFFFF,   0xFFF0, 
		0xFFFF,   0xFFF0, 
		0xFFFF,   0xFFE0, 
		0x3FFF,   0xFF00, 
		0x3FFF,   0xFE00, 
		0x3FFF,   0xFE00, 
		0x1FFF,   0xFE00, 
		0x1FFF,   0xCC00, 
		0x07FF,   0x8000, 
		0x007F,   0x0000, 
		0x0007,   0x0000, 
		0x0000,   0x0000, 
		0x0000,   0x0000
		},
	/*----- bitmap : w = 32, h = 25 ------ */
		{
		/*------ plane Boing-E 0: --------*/
		0x000E,   0x6000, 
		0x00F8,   0xE400, 
		0x030F,   0xE600, 
		0x061E,   0x1300, 
		0x0C3E,   0x1C80, 
		0x27FC,   0x1C60, 
		0x0784,   0x3C60, 
		0x4F07,   0xFE20, 
		0x8F07,   0xC230, 
		0x1E0F,   0xC1F0, 
		0x620F,   0x83C8, 
		0x61CF,   0x83C8, 
		0x61E1,   0x83C8, 
		0x63E0,   0x63C8, 
		0x63E0,   0xF9C8, 
		0x03E0,   0xF878, 
		0x1DC0,   0xF860, 
		0x1C21,   0xF0E0, 
		0x5C3E,   0xF0C0, 
		0x0C3C,   0x11C0, 
		0x143C,   0x3C40, 
		0x09B8,   0x3880, 
		0x05C0,   0x7000, 
		0x00CF,   0x0400, 
		0x000C,   0x6000,
		/*------ plane # 1: --------*/
		0x0000,   0x2000, 
		0x0000,   0x0400, 
		0x00FF,   0x0700, 
		0x01FF,   0xE380, 
		0x03FF,   0xE0C0, 
		0x07FF,   0xE060, 
		0x07FF,   0xC070, 
		0x0FFF,   0xC030, 
		0x0FFF,   0xFC30, 
		0x1FFF,   0xFE38, 
		0x1FFF,   0xFC38, 
		0x1FFF,   0xFC38, 
		0x1FFF,   0xFC38, 
		0x1FFF,   0x9C38, 
		0x1FFF,   0x0038, 
		0x7FFF,   0x0078, 
		0x61FF,   0x0078, 
		0x601E,   0x00F0, 
		0x2000,   0x00E0, 
		0x3000,   0x11E0, 
		0x0800,   0x3FC0, 
		0x0780,   0x3F80, 
		0x03F8,   0x7E00, 
		0x01FF,   0xFC00, 
		0x003F,   0xE000,
		/*------ plane # 2: --------*/
		0x003F,   0xC000, 
		0x01FF,   0xF800, 
		0x03FF,   0xF800, 
		0x0FFF,   0xFC00, 
		0x1FFF,   0xFF00, 
		0x3FFF,   0xFF80, 
		0x3FFF,   0xFF80, 
		0x7FFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0xFFFF,   0xFFC0, 
		0x9FFF,   0xFF80, 
		0x1FFF,   0xFF80, 
		0x1FFF,   0xFF00, 
		0x5FFF,   0xFF00, 
		0x0FFF,   0xEE00, 
		0x17FF,   0xC000, 
		0x087F,   0xC000, 
		0x0407,   0x8000, 
		0x0000,   0x0000, 
		0x0000,   0x0000
		},
	/*----- bitmap : w = 32, h = 25 ------ */
		{
		/*------ plane Boing-F 0: --------*/
		0x0026,   0x2000, 
		0x00FC,   0x7400, 
		0x0187,   0x7200, 
		0x030F,   0x0100, 
		0x0E0F,   0x0E80, 
		0x319F,   0x0E00, 
		0x23C6,   0x0F30, 
		0x63C1,   0xCF30, 
		0x4781,   0xF310, 
		0x0783,   0xE0D0, 
		0x7383,   0xE0E0, 
		0x70C3,   0xE0E0, 
		0x70F9,   0xE1E0, 
		0x70F8,   0x21E0, 
		0x70F8,   0x3FE0, 
		0x91F0,   0x3E38, 
		0x4FF0,   0x7C30, 
		0x4E10,   0x7C60, 
		0x4E0F,   0x7860, 
		0x2E1F,   0x08C0, 
		0x0E1E,   0x0E00, 
		0x049E,   0x1C80, 
		0x00E4,   0x3800, 
		0x00C7,   0x9000, 
		0x000E,   0x6000,
		/*------ plane # 1: --------*/
		0x0000,   0x2000, 
		0x0000,   0x0400, 
		0x007F,   0x0300, 
		0x00FF,   0xF180, 
		0x01FF,   0xF1C0, 
		0x01FF,   0xF1E0, 
		0x03FF,   0xF0F0, 
		0x03FF,   0xF0F0, 
		0x07FF,   0xF0F0, 
		0x07FF,   0xE0F8, 
		0x0FFF,   0xE0F8, 
		0x0FFF,   0xE0F8, 
		0x0FFF,   0xE1F8, 
		0x0FFF,   0xC1F8, 
		0x0FFF,   0xC1F8, 
		0x0FFF,   0xC038, 
		0x01FF,   0x8038, 
		0x001F,   0x8070, 
		0x0000,   0x8060, 
		0x0000,   0x08E0, 
		0x1000,   0x0FC0, 
		0x0B80,   0x1F80, 
		0x07FC,   0x3E00, 
		0x01FF,   0xFC00, 
		0x003F,   0xE000,
		/*------ plane # 2: --------*/
		0x003F,   0xC000, 
		0x01FF,   0xF800, 
		0x03FF,   0xFC00, 
		0x0FFF,   0xFE00, 
		0x1FFF,   0xFE00, 
		0x3FFF,   0xFE00, 
		0x3FFF,   0xFF00, 
		0x7FFF,   0xFF00, 
		0x7FFF,   0xFF00, 
		0xFFFF,   0xFF00, 
		0xFFFF,   0xFF00, 
		0xFFFF,   0xFF00, 
		0xFFFF,   0xFE00, 
		0xFFFF,   0xFE00, 
		0xFFFF,   0xFE00, 
		0xFFFF,   0xFFC0, 
		0x7FFF,   0xFFC0, 
		0x7FFF,   0xFF80, 
		0x7FFF,   0xFF80, 
		0x3FFF,   0xF700, 
		0x0FFF,   0xF000, 
		0x047F,   0xE000, 
		0x0003,   0xC000, 
		0x0000,   0x0000, 
		0x0000,   0x0000
		}
	};

/*
** Orbit  goes from far top -> mid l  -> near bot -> mid right
*/

/*-----------------------------------------------------------------*/
SHORT satTimes[SATCOUNT] =
	{
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
	};

/* APTR satACRoutines[SATCOUNT] */
WORD (*satACRoutines[SATCOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	};

SHORT satAYTranses[SATCOUNT] =
	{
	( 18<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 17<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 15<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 11<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(  0<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-11<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-15<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-17<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-18<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-17<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-15<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-11<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(  0<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 11<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 15<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 17<<BNFS)+((BNG3HEIGHT/2)<<ANFS)
	};

SHORT satAXTranses[SATCOUNT] =
	{
	(  0<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 22<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 45<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 66<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 80<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 66<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 45<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 22<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(  0<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-22<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-45<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-66<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-80<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-66<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-45<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-22<<BNFS)+((BNG3WIDTH/2)<<ANFS)
	};

/* APTR satBCRoutines[SATCOUNT] */
WORD (*satBCRoutines[SATCOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	};

/*----- bitmap : w = 5, h = 5 ------ */
SHORT satBYTranses[SATCOUNT] =
	{
	(-57<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-40<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-23<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( -6<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 13<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 27<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 41<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 53<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 57<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 40<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 22<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(  4<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-13<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-28<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-43<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-55<<BNFS)+((BNG3HEIGHT/2)<<ANFS)
	};

SHORT satBXTranses[SATCOUNT] =
	{
	(-57<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-53<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-41<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-27<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-13<<BNFS)+((BNG3WIDTH/2)<<ANFS),(  6<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 23<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 40<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 57<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 55<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 43<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 28<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 13<<BNFS)+((BNG3WIDTH/2)<<ANFS),( -4<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-22<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-40<<BNFS)+((BNG3WIDTH/2)<<ANFS)
	};

/* APTR satCCRoutines[SATCOUNT] */
WORD (*satCCRoutines[SATCOUNT])(struct AnimComp *) =
	{
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	};

/*----- bitmap : w = 5, h = 5 ------ */
SHORT satCYTranses[SATCOUNT] =
	{
	(-13<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(  4<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 22<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 40<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 57<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 53<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 41<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( 27<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	( 13<<BNFS)+((BNG3HEIGHT/2)<<ANFS),( -6<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-23<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-40<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-57<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-55<<BNFS)+((BNG3HEIGHT/2)<<ANFS),
	(-43<<BNFS)+((BNG3HEIGHT/2)<<ANFS),(-28<<BNFS)+((BNG3HEIGHT/2)<<ANFS)
	};

SHORT satCXTranses[SATCOUNT] =
	{
	(-13<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-28<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-43<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-55<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-57<<BNFS)+((BNG3WIDTH/2)<<ANFS),(-40<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	(-23<<BNFS)+((BNG3WIDTH/2)<<ANFS),( -6<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 13<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 27<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 41<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 53<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 57<<BNFS)+((BNG3WIDTH/2)<<ANFS),( 40<<BNFS)+((BNG3WIDTH/2)<<ANFS),
	( 22<<BNFS)+((BNG3WIDTH/2)<<ANFS),(  4<<BNFS)+((BNG3WIDTH/2)<<ANFS)
	};

/*-----------------------------------------------------------------*/
/*----- bitmap : w = 5, h = 5 ------ */
UWORD chip satImage[1][SATWWIDTH * SATHEIGHT * SATDEPTH] =
	{ 
		{
		0x5000,  0xE800,  0x4800,  0x9800,  0x7000,
		0x6000,  0xF000,  0xF000,  0x6000,  0x0000
		},
	};
