/***********************************************************************
 *                                                                     *
 *                            COPYRIGHTS                               *
 *                                                                     *
 *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.   *
 *                                                                     *
 **********************************************************************/

/*
 * Code test test AppMenu feature of Workbench
 */


#include <intuition/intuition.h>
#include <exec/memory.h>
#include <workbench/startup.h>
#include <workbench/workbench.h>

#include <stdio.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/icon_protos.h>
#include <clib/wb_protos.h>
#include <clib/dos_protos.h>

struct IntuitionBase *IntuitionBase;
struct WorkbenchBase *WorkbenchBase;
struct IconBase *IconBase;

void            main(void);

void
main(void)
{
  struct MsgPort *msgport;
  struct Window  *win;
  struct AppMenuItem *ami1, *ami2;
  struct IntuiMessage *imsg;
  struct AppMessage *amsg;
  struct WBArg   *argptr;

  ULONG           id = 1, userdata = 0;
  BOOL            done = FALSE;
  int             i;

  printf("am: enter\n");

  if (IntuitionBase = OpenLibrary("intuition.library", 36)) {
    if (WorkbenchBase = OpenLibrary("workbench.library", 36)) {
      if (IconBase = OpenLibrary("icon.library", 36)) {
	if (msgport = CreateMsgPort()) {
	  if (win = OpenWindowTags(NULL,
				   WA_Left, 0,
				   WA_Top, 1,
				   WA_Width, 160,
				   WA_Height, 50,
				   WA_IDCMP, CLOSEWINDOW,
				   WA_Flags, WINDOWCLOSE | WINDOWDRAG,
				   WA_Title, "AppMenu",
				   TAG_END)) {

	    printf("am: calling AddAppMenuItem for ami1...\n");
	    if (ami1 = AddAppMenuItem(id, userdata, "appmenuitem1", msgport, NULL)) {
              printf("am: calling AddAppMenuItem for ami2...\n");
	      if (ami2 = AddAppMenuItem(85, 55, "appmenuitem2", msgport, NULL)) {
		printf("ami: ok, ami1 %lx, ami2 %lx, going to sleep...\n", ami1, ami2);
		do {
		  Wait(1 << win->UserPort->mp_SigBit | 1 << msgport->mp_SigBit);
		  while (imsg = (struct IntuiMessage *) GetMsg(win->UserPort)) {
		    if (imsg->Class = CLOSEWINDOW)
		      done = TRUE;
		    ReplyMsg((struct Message *) imsg);
		  }
		  while (amsg = (struct AppMessage *) GetMsg(msgport)) {
		    printf("am: appmsg=%lx, Type=%ld, ID=%ld, UserData=%ld, NumArgs=%ld\n", amsg, amsg->am_Type, amsg->am_ID, amsg->am_UserData, amsg->am_NumArgs);
		    argptr = amsg->am_ArgList;
		    for (i = 0; i < amsg->am_NumArgs; i++) {
		      printf("\targ(%ld): Name='%s', Lock=%lx\n", i, argptr->wa_Name, argptr->wa_Lock);
		      argptr++;
		    }
		    ReplyMsg((struct Message *) amsg);
		  }
		} while (!done);

		printf("ami: calling RemoveAddMenuItem for ami2\n");
		RemoveAppMenuItem(ami2);
	      } else		/* !ami2 */
		printf("Couldn't AddAppMenuItem ami2\n");
	      printf("ami: calling RemoveAddMenuItem for ami1\n");
	      RemoveAppMenuItem(ami1);
	    } else		/* !ami1 */
	      printf("Couldn't AddAppMenuItem ami1\n");
	    CloseWindow(win);
	  } else		/* !win */
	    printf("Couldn't open window\n");
          /* Make sure there are no more outstanding messages */
          while(amsg = (struct AppMessage *)GetMsg(msgport))
            ReplyMsg((struct Message *)amsg);
	  DeleteMsgPort(msgport);
	} else			/* !msgport */
	  printf("Coulnd't create messageport\n");
	CloseLibrary(IconBase);
      } else			/* !IconBase */
	printf("Couldn't open icon.library\n");
      CloseLibrary(WorkbenchBase);
    } else			/* !WorkbenchBase */
      printf("Couldn't open workbench.library\n");
    CloseLibrary(IntuitionBase);
  } else			/* !IntuitionBase */
    printf("Couldn't open intuition.library\n");
  printf("am: done\n");
}

