/***********************************************************************
 *                                                                     *
 *                            COPYRIGHTS                               *
 *                                                                     *
 *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.   *
 *                                                                     *
 **********************************************************************/

/*
 * Code to test AppIcon feature of Workbench
 */

#include <intuition/intuition.h>
#include <exec/memory.h>
#include <workbench/startup.h>
#include <workbench/workbench.h>

#include <stdio.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/icon_protos.h>
#include <clib/wb_protos.h>
#include <clib/dos_protos.h>


#include "appicon.image"

struct IntuitionBase *IntuitionBase;
struct WorkbenchBase *WorkbenchBase;
struct IconBase *IconBase;

void            main(void);

void 
main(void)
{
  struct MsgPort *msgport;
  struct Window  *win;
  struct AppIcon *ai;
  struct IntuiMessage *imsg;
  struct AppMessage *amsg;
  struct WBArg   *argptr;
  struct DiskObject *dobj;

  ULONG           id = 1, userdata = 0;
  BOOL            done = FALSE;
  int             i, imagememsize = 0;

  printf("ai: enter\n");

  if (IntuitionBase = OpenLibrary("intuition.library", 36)) {
    if (WorkbenchBase = OpenLibrary("workbench.library", 36)) {
      if (IconBase = OpenLibrary("icon.library", 36)) {
	if (msgport = CreateMsgPort()) {
	  if (win = OpenWindowTags(NULL,
				   WA_Left, 0,
				   WA_Top, 1,
				   WA_Width, 160,
				   WA_Height, 50,
				   WA_IDCMP, CLOSEWINDOW,
				   WA_Flags, WINDOWCLOSE | WINDOWDRAG,
				   WA_Title, "AppIcon",
				   TAG_END)) {
	    if (dobj = GetDiskObject(NULL)) {
	      dobj->do_Gadget.Width = image1.Width;
	      dobj->do_Gadget.Height = image1.Height;
	      dobj->do_Gadget.GadgetRender = &image1;
	      imagememsize = (image1.Width * image1.Height * image1.Depth) / 8;
	      if (image1.ImageData = (USHORT *) AllocMem(imagememsize, MEMF_CHIP)) {
		CopyMem(imageData1, image1.ImageData, imagememsize);
                printf("ai: calling AddAppIcon...\n");
		if (ai = AddAppIcon(id, userdata, "AppIcon", msgport, NULL, dobj, NULL)) {
                  printf("ai: ok, ai = %lx, going to sleep\n", ai);
		  do {
		    Wait(1 << win->UserPort->mp_SigBit | 1 << msgport->mp_SigBit);
		    while (imsg = (struct IntuiMessage *) GetMsg(win->UserPort)) {
		      if (imsg->Class = CLOSEWINDOW)
			done = TRUE;
		      ReplyMsg((struct Message *) imsg);
		    }
		    while (amsg = (struct AppMessage *) GetMsg(msgport)) {
		      printf("ai: appmsg=%lx, Type=%ld, ID=%ld, UserData=%ld, NumArgs=%ld\n", amsg, amsg->am_Type, amsg->am_ID, amsg->am_UserData, amsg->am_NumArgs);
		      argptr = amsg->am_ArgList;
		      for (i = 0; i < amsg->am_NumArgs; i++) {
			printf("\targ(%ld): Name='%s', Lock=%lx\n", i, argptr->wa_Name, argptr->wa_Lock);
			argptr++;
		      }
		      ReplyMsg((struct Message *) amsg);
		    }
		  } while (!done);
		  RemoveAppIcon(ai);
		} else		/* !ai */
		  printf("Couldn't AddAppIcon\n");
		FreeMem(image1.ImageData, imagememsize);
	      } else		/* !image1.ImageData */
		printf("Couldn't get memory for imagedata\n");
	      FreeDiskObject(dobj);
	    } else		/* !dobj */
	      printf("Couldn't get DiskObject(NULL)");
	    CloseWindow(win);
	  } else		/* !win */
	    printf("Couldn't open window\n");
          /* Make sure there are no more outstanding messages */
          while(amsg = (struct AppMessage *)GetMsg(msgport))
            ReplyMsg((struct Message *)amsg);
	  DeleteMsgPort(msgport);
	} else			/* !msgport */
	  printf("Couldn't create messageport\n");
	CloseLibrary(IconBase);
      } else			/* !IconBase */
	printf("Couldn't open icon.library\n");
      CloseLibrary(WorkbenchBase);
    } else			/* !WorkbenchBase */
      printf("Couldn't open workbench.library\n");
    CloseLibrary(IntuitionBase);
  } else			/* !IntuitionBase */
    printf("Couldn't open intuition.library\n");
  printf("ai: done\n");
}
