/* commgad.c -- create command gadgets */

/*
Copyright (c) 1989 Commodore-Amiga, Inc.

Executables based on this information may be used in software
for Commodore Amiga computers. All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include "sysall.h"

#define D(x)	;

static struct Image *cImage = NULL;	/* shared Image */
static	UWORD		*cMask;

struct Image	*CreateImage();
struct Image	*makeCommandImage();
struct Gadget	*CreateBoolGadget();
struct RastPort	*CreateImageRPort();

/*
 *	creates linked list of "command" gadgets, with sequential
 *	GadgetID values.
 */
struct Gadget	*
commandGadgets( rp, argv, numgad, id )
struct RastPort *rp;
char	**argv;
{
	int					num;
	char				**a;
	struct Rectangle	textent;
	struct Gadget		*glist = NULL;
	struct Gadget		*g;

	g = (struct Gadget *) &glist;

	textListExtent( rp, argv, numgad, &textent );

	if ( makeCommandImage( &textent ) )
	{

		/* make gadget for each line of text */
		for ( a = argv, num = numgad; num; ++a, --num )
		{

			if ( g->NextGadget = CreateBoolGadget( cImage, cMask, id++, *a ) )
			{
				g = g->NextGadget;
				D( printf("cG: gadget: %lx\n", g ) );

				/* position gadget text */
				g->GadgetText->LeftEdge = (g->Width - textLength(rp, *a))/2;
				g->GadgetText->TopEdge = (g->Height - rp->TxHeight)/2;
					/*rp->TxBaseline + (g->Height - rp->TxHeight)/2;*/

				/* set gadget flags */
				g->Activation |= RELVERIFY;
			}
			else
			{
				FreeGadgets( glist );
				glist = NULL;
				freeCommandImage();
				break;
			}
		}
	}
	D( printf("cG return: %lx\n", glist ) );
	return ( glist );
}

cleanupCommGadgets()
{
	freeCommandImage();
}

/*
 * returns pointer to static command image, or NULL
 */
struct Image	*
makeCommandImage( extent )
struct Rectangle	*extent;
{
	struct RastPort	*rp;
	int	width, height;
	UWORD			*ImagePlane();

	width = extent->MaxX - extent->MinX + 1;
	height = extent->MaxY - extent->MinY + 1;

	/* add some margin	*/
	width	+= 16;			/* scale by resolution soon	*/
	height	+= 6;

	if ( !cImage )
	{
		if ( cImage = CreateImage( width, height, 3 ) )
		{


			if ( rp = CreateImageRPort( cImage ) )
			{
				drawBox( rp, width, height, 6, 3, 2, 1 );
				DeleteImageRPort( rp );

				/* use third plane for mask	*/
				cMask = ImagePlane( cImage, 2 );
				cImage->Depth = 2;	/* Do this AFTER ImageRPort! */
			}
			else
			{
				freeCommandImage();		/* nulls out cImage */
			}
		}
	}

	D( printf("mCI returning %lx\n", cImage ) );
	return ( cImage );
}

freeCommandImage()
{
	if ( cImage ) DeleteImage( cImage );
	cImage = NULL;
}



