
   /***********************************************************************
   *                                                                      *
   *                            COPYRIGHTS                                *
   *                                                                      *
   *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.    *
   *                                                                      *
   ***********************************************************************/

#include "app.h"

/* An input expression to match any RAWMOUSE event with the
 * MBUTTON qualifier bit set
 */
IX middleix = {
   IX_VERSION,             /* required                      */
   IECLASS_RAWMOUSE,
                                                            
                           /* debug: am i listening right?  */
   IECODE_MBUTTON,         /* Code   */
   ~IECODE_UP_PREFIX,      /* CodeMask   */

   0,                      /* qualifier I am interested in  */
   0,
   0                       /* synonyms irrelevant           */
};

BOOL setupMBA(void);
void middlebaction(struct CxMsg *,CxObj *);

BOOL setupMBA()
{
   CxObj   *mfilter;

   /* *** middle button trap   ***   */
   mfilter = CxFilter(NULL);
   if (!mfilter)
   {
      return(0);
   }
   SetFilterIX(mfilter, &middleix);
   D( AttachCxObj(mfilter, CxDebug( 0xDEADFACE)) ); /** DEBUG **/
   AttachCxObj(mfilter, CxCustom( middlebaction, 0L));
   if (CxObjError(mfilter))
   {
      D( printf("nocapslock: filter error %lx\n", CxObjError(mfilter) ) );
      DeleteCxObjAll(mfilter);
      return(0);
   }
   AttachCxObj(broker, mfilter);
   D( printf("middle button trap OK\n") );

   return(TRUE);
}
void middlebaction(cxm,co)
register struct CxMsg *cxm;
CxObj *co;
{
   register struct InputEvent *ie;

   ie = (struct InputEvent *) CxMsgData(cxm);

#if 1
   /* i KNOW that all messages getting this far are CXM_IEVENT   */
   /* convert middle button into shift left   */
   ie->ie_Code = (ie->ie_Code & IECODE_UP_PREFIX) | IECODE_LBUTTON;
   ie->ie_Qualifier |= IEQUALIFIER_LSHIFT;
   D( kprintf("middlebaction\n") );
#else
   D( kprintf("leftbaction\n") );
   D( kprintf("code: %x\n", ie->ie_Code ) );
#endif

}
VOID handleCustomCXCommand(id)
ULONG id;
{
   switch(id)
   {
      case 0:
      default:
            break;
   }
}
