
   /***********************************************************************
   *                                                                      *
   *                            COPYRIGHTS                                *
   *                                                                      *
   *   Copyright (c) 1990  Commodore-Amiga, Inc.  All Rights Reserved.    *
   *                                                                      *
   ***********************************************************************/

#include "app.h"
#include <graphics/gfxmacros.h>
#include <hardware/custom.h>
#include <hardware/dmabits.h>
#include <intuition/gadgetclass.h>

extern struct Custom custom;

ULONG timeout = 0L;
ULONG blanked = 0L;
ULONG seconds = 10L;
struct Gadget *secgad;

struct Screen *s = NULL;
struct Window *w = NULL;

LONG   BlankerCommand;
#define BLANK   1L
#define UNBLANK 2L

USHORT chip SpriteData[] = {
               0,0,
               0,0,
               0,0 };

BOOL setupBlanker(void);
VOID BlankerAction(struct CxMsg *cxm,CxObj *co);
VOID Blank(VOID);
VOID UnBlank(VOID);
VOID mysetupCustomGadgets(struct Gadget **gad);
VOID myHandleGadget(ULONG gad,ULONG code);
VOID MyHandleCustomSignal(VOID);

BOOL setupBlanker(VOID)
{
   CxObj   *objectlist;

   seconds = ArgInt( ttypes, "SECONDS", 60 );

   objectlist=CxCustom( BlankerAction, 0L);

   if (CxObjError(objectlist))
   {
      D( printf("nocapslock: filter error %lx\n", CxObjError(objectlist) ) );
      DeleteCxObjAll(objectlist);
      return(0);
   }

   AttachCxObj(broker, objectlist);
   return(TRUE);
}
VOID BlankerAction(struct CxMsg *cxm,CxObj *co)
{
   register struct InputEvent *ie;

   /* D( kprintf("BlankerAction\n") ); */

   /* i KNOW that all messages getting this far are CXM_IEVENT   */
   ie = (struct InputEvent *) CxMsgData((CxMsg *)cxm);


   if(ie->ie_Class==IECLASS_TIMER)
   {
      /* D( printf("IECLASS_TIMER\n"); ) */
      if(! blanked)
      {
         /*D( printf("blanked=0x%lx Bump timeout=%ld\n",blanked,timeout);)*/
         if(++timeout >= ((ULONG)(seconds*10L)))
         {
            D( printf("########Blank Screen\n"); )
            /* Blank(); */
            BlankerCommand=BLANK;
            Signal(maintask,csigflag);
            blanked=TRUE;
         }
      }
   } else {
      if(ie->ie_Class!=IECLASS_TIMER)
      {
         D( printf("########UnBlank\n"); )
         /* UnBlank(); */
         BlankerCommand=UNBLANK;
         Signal(maintask,csigflag);
         timeout=0L;
         blanked=FALSE;
      }
   }

}
VOID Blank(VOID)
{
   struct NewScreen ns = {
      0,0,
      320,200,
      1,
      0,0,
      0,
      CUSTOMSCREEN,
      0,
      0,
      0,
      0
      };

   struct NewWindow nw = {
      0,0,
      320,200,
      1,0,
      0,
      SIMPLE_REFRESH | BACKDROP | BORDERLESS | ACTIVATE,
      0,
      0,
      0,
      0,
      0,
      0,0,0,0,
      CUSTOMSCREEN
      };

   if( ! s)
   {
      s=OpenScreen(&ns);
      SetRGB4(&s->ViewPort,0,0,0,0);
      if( ! w)
      {
         nw.Screen=s;
         w = OpenWindow(&nw);
      }
      if(w)
         SetPointer(w,SpriteData,1,1,0,0);
   }
}
VOID UnBlank(VOID)
{
   if(w)
   {
      ClearPointer(w);
      CloseWindow(w);
      w=NULL;
   }
   if(s)
   {
      CloseScreen(s);
      s=NULL;
   }
}
VOID mysetupCustomGadgets(struct Gadget **gad)
{
   struct NewGadget ng;

   ng.ng_VisualInfo=vi;

   ng.ng_TopEdge    = topborder+25;
   ng.ng_LeftEdge   = 10;
   ng.ng_Width      = 40;
   ng.ng_Height     = 12;
   ng.ng_GadgetText = "Hide";
   ng.ng_TextAttr   = &mydesiredfont;
   ng.ng_GadgetID   = GAD_HIDE;
   ng.ng_Flags      = NULL;
   ng.ng_VisualInfo = vi;
   *gad = CreateGadget(BUTTON_KIND,*gad, &ng,TAG_DONE);

   ng.ng_TopEdge    = topborder+25;
   ng.ng_LeftEdge   = 60;
   ng.ng_Width      = 40;
   ng.ng_Height     = 12;
   ng.ng_GadgetText = "Quit";
   ng.ng_TextAttr   = &mydesiredfont;
   ng.ng_GadgetID   = GAD_DIE;
   ng.ng_Flags      = NULL;
   ng.ng_VisualInfo = vi;
   *gad = CreateGadget(BUTTON_KIND,*gad, &ng,TAG_DONE);

   ng.ng_TopEdge    = topborder+5;
   ng.ng_LeftEdge   = 100;
   ng.ng_Width      = 60;
   ng.ng_Height     = 14;
   ng.ng_GadgetText = "Seconds";
   ng.ng_TextAttr   = &mydesiredfont;
   ng.ng_GadgetID   = GAD_SECS;
   ng.ng_Flags      = NULL;
   ng.ng_VisualInfo = vi;
   secgad = *gad = CreateGadget(INTEGER_KIND,*gad, &ng,GTIN_Number,seconds,GTIN_MaxChars,4,STRINGA_Justification,STRINGRIGHT,TAG_DONE);
}
VOID myHandleGadget(ULONG gad,ULONG code)
{
   D( kprintf("custom: HandleGadget(%lx)\n",gad); )
   switch(gad)
   {
      case GAD_HIDE:
            D( kprintf("custom: HandleGadget() GAD_HIDE\n"); )
            shutdownWindow();
            break;
      case GAD_DIE:
            D( kprintf("custom: HandleGadget() GAD_DIE\n"); )
            terminate();
      case GAD_SECS:
            D( kprintf("custom: HandleGadget() GAD_SECS\n"); )
            seconds=((struct StringInfo *)secgad->SpecialInfo)->LongInt;
   }
}
VOID MyHandleCustomSignal(VOID)
{
   D( kprintf("custom: MyHandleCustomSignal() enter\n"); )
   if(BlankerCommand==BLANK)
      Blank();
   else
      if(BlankerCommand==UNBLANK)
         UnBlank();
}
