/*\
 *  This function converts any FD file into a Library offset file
 *  for Kiskometer.
\*/

parse arg source " " dest " " libname
	ec=0;

	if open(infile,source,'r') then do
		if open(outfile,dest,'w') then do
			call writeln(outfile,"LIBRARYOFFSETFILE")
			call writeln(outfile,libname)
			privatefunc=1;
			liboffs=0;
			do while ~eof(infile)
				line=readln(infile)
				if left(line,1)~=='*' then do							/* No comment line */
					if left(line,2)=='##' then do
						if left(line,8)=='##public' then
							privatefunc=0
						else if left(line,9)=='##private' then
							privatefunc=1
						else if left(line,5)=='##end' then
							leave
						else if left(line,7)=='##bias ' then do
							newoffs=strip(substr(line,8))
							do while liboffs<newoffs
								if liboffs=6 then
									call writeln(outfile,"Lib_Open")
								else if liboffs=12 then
									call writeln(outfile,"Lib_Close")
								else if liboffs=18 then
									call writeln(outfile,"Lib_Expunge")
								else if liboffs=24 then
									call writeln(outfile,"Lib_Null")
								else if liboffs~=0 then do
									printed=0;
									if right(libname,7)==".device" then do
										printed=1
										if liboffs=30 then
											call writeln(outfile,"Lib_BeginIO")
										else if liboffs=36 then
											call writeln(outfile,"Lib_AbortIO")
										else
											printed=0
									end
									if printed=0 then
										call writeln(outfile,"Lib_Offs_"||liboffs)
								end
								liboffs=liboffs+6
							end
						end
					end
					else do													/* Function description */
						parse var line funcname "("
						call writeln(outfile,funcname)
						liboffs=liboffs+6
					end
				end
			end
			call close(outfile)
		end
		else do
			say "Could not open "||dest||" to write."
			ec=10
		end
		call close(infile)
	end
	else do
		say "Could not open "||source||" to read."
		ec=10
	end

exit ec
