
/*------- Good.c --------------------------------------------------------*
 *
 *  This program does the same as the "Bad" program, but IS compatible
 *  with future OS-Releases, because it does not use reserved fields!
 *  ==> FCS does not display any message.
 *
 *  Bug in "Bad"
 *  ------------
 *  AppWindow = AddAppWindowA(id, userdata, window, msgport, taglist)
 *  D0                        D0  D1        A0      A1       A2
 *
 *  The TagList (A2) is a reserved field and MUST be set to NULL for
 *  future compatibility!
 *  ==> Documented in the Amiga Autodocs,  Commodore-Amiga Inc.
 *
 *  In the "Bad" program the TagList points to the tags
 *  of the OpenWindowTagList, which is illegal and dangerous!
 *
 *
 *  Author:   Marcel Hofstetter
 *  Compiler: SAS/C 6.3
 *
 *-----------------------------------------------------------------------*/


/* Function Prototypes */

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/wb.h>
#include <proto/intuition.h>


/* Standard Amiga Version-String
   $VER: name ver.rev (dd.mm.yy) */

static const UBYTE version[] = "$VER: Good 37.1 (14.2.94)";


void main(void)
{

/* Library Bases */

struct DosLibrary *DOSBase;
struct Library *WorkbenchBase;
struct IntuitionBase *IntuitionBase;


struct MsgPort *mymsgport;
struct Window *mywindow;
struct AppWindow *myappwindow;
struct Message *msg;
struct TagItem tags[3];

ULONG id=1, user=0;


    if (DOSBase = (struct DosLibrary *) OpenLibrary(DOSNAME,37)) {

        if (WorkbenchBase = OldOpenLibrary(WORKBENCH_NAME)) {
			
            if (IntuitionBase = (struct IntuitionBase *)
                OldOpenLibrary("intuition.library")) {
					
                if (mymsgport = CreateMsgPort()) {

                    tags[0].ti_Tag  = WA_Width;
                    tags[0].ti_Data = 100;
                    tags[1].ti_Tag  = WA_Height;
                    tags[1].ti_Data = 50;
                    tags[2].ti_Tag  = TAG_DONE;

                    if (mywindow = OpenWindowTagList(NULL,tags)) {

                        if (myappwindow = AddAppWindowA(id,user,mywindow,
                            mymsgport,NULL)) {

                    /* For future compatibility the TagList MUST BE NULL */

                            Delay(5*50);    /* wait 5 seconds */

                            RemoveAppWindow(myappwindow);
                        }
                        CloseWindow(mywindow);
                    }
                    /* Reply all messages before deleting the port */
                    while (msg = GetMsg(mymsgport)) {
                        ReplyMsg(msg);
                    }
                    DeleteMsgPort(mymsgport);
                }
                CloseLibrary( (struct Library *) IntuitionBase);
            }
            CloseLibrary(WorkbenchBase);
        }
        CloseLibrary( (struct Library *) DOSBase);
    }
}
