;***********************************************************
;*							   *
;*    'FCS'            40.1    /    Release   7.12.1993    *
;*							   *
;*     Future_Compatibility_Supervisor			   *
;*							   *
;*---------------------------------------------------------*
;*							   *
;*							   *
;*		 THIS PROGRAM IS FREEWARE		   *
;*		 ^^^^^^^^^^^^^^^^^^^^^^^^		   *
;*							   *
;*							   *
;*     Copyright  1993   by	Marcel Hofstetter	   *
;*				Bogenstrasse 29 	   *
;*				CH-9230 Flawil		   *
;*				SWITZERLAND		   *
;*							   *
;*							   *
;*---------------------------------------------------------*
;*							   *
;*     Kickstart-Version  :  2.04 (Libs: V37)  or higher   *
;*							   *
;*---------------------------------------------------------*
;*							   *
;*     Assembler  :   A68k    Ver. 2.71 		   *
;*     Linker	  :   Blink				   *
;*							   *
;***********************************************************



;	#####################
;	#		    #
;	#   INCLUDE-FILES #
;	#		    #
;	#####################


	INCLUDE MAHO/68000.macros
	INCLUDE MAHO/AMIGA.i

	INCLUDE LVOS/EXEC_LVO.i
	INCLUDE LVOS/INTUITION_LVO.i
	INCLUDE LVOS/GADTOOLS_LVO.i
	INCLUDE LVOS/DOS_LVO.i
	INCLUDE LVOS/WORKBENCH_LVO.i
	INCLUDE LVOS/UTILITY_LVO.i
	INCLUDE LVOS/LAYERS_LVO.i
	INCLUDE LVOS/ICON_LVO.i
	INCLUDE LVOS/COMMODITIES_LVO.i
	INCLUDE LVOS/LOCALE_LVO.i
	INCLUDE LVOS/DATATYPES_LVO.i
	INCLUDE LVOS/AMIGAGUIDE_LVO.i

INTUI_V36_NAMES_ONLY	SET	1

	INCLUDE exec/alerts.i
	INCLUDE exec/memory.i
	INCLUDE dos/dosextens.i
	INCLUDE dos/notify.i
	INCLUDE intuition/intuition.i
	INCLUDE intuition/sghooks.i
	INCLUDE workbench/workbench.i
	INCLUDE utility/utility.i
	INCLUDE utility/name.i
	INCLUDE libraries/commodities.i
	INCLUDE libraries/locale.i
	INCLUDE libraries/amigaguide.i



;	#################
;	#		#
;	#   CONSTANTS	#
;	#		#
;	#################


BSS		EQUR A4 	; Pointer to BSS-Section
DATA		EQUR A5 	; Pointer to DATA-Section


FCS_VERSION	EQU 40		; Program- / OS-Version


 STRUCTURE	Message,MN_SIZE
	APTR	MyErrorString
	STRUCT	BuggyTaskName,32
	LABEL	Message_SIZEOF



;	#####################
;	#		    #
;	#   BSS-STRUCTURE   #
;	#		    #
;	#####################


 STRUCTURE	BSSstruct,0


	; LibraryBases
	; ------------
	APTR	EXECBase
	APTR	INTBase
	APTR	GADTLBase
	APTR	DOSBase
	APTR	WORKBENCHBase
	APTR	UTILITYBase
	APTR	LAYBase
	APTR	ICONBase
	APTR	COMBase
	APTR	LOCALEBase
	APTR	DATATYPESBase
	APTR	AMIGAGUIDEBase


	; Original-Library-Functions (42)
	; -------------------------------
	APTR	AG_AddAmigaGuideHostA
	APTR	AG_OpenAmigaGuideA
	APTR	AG_OpenAmigaGuideAsyncA
	APTR	AG_RemoveAmigaGuideHostA
	APTR	AG_SendAmigaGuideContextA
	APTR	AG_SetAmigaGuideContextA

	APTR	CO_CxBroker

	APTR	DT_AddDTObject
	APTR	DT_ObtainDataTypeA
	APTR	DT_RefreshDTObjectA

	APTR	DO_EndNotify
	APTR	DO_NewLoadSeg
	APTR	DO_StartNotify

	APTR	GT_GetVisualInfoA
	APTR	GT_GT_RefreshWindow
	APTR	GT_GT_SetGadgetAttrsA
	APTR	GT_GT_GetGadgetAttrsA	; (V39)

	APTR	IC_PutDefDiskObject
	APTR	IC_PutDiskObject

	APTR	IN_AddGadget
	APTR	IN_AddGList
	APTR	IN_BuildEasyRequestArgs
	APTR	IN_EasyRequestArgs
	APTR	IN_MakeClass
	APTR	IN_OpenScreen
	APTR	IN_OpenScreenTagList
	APTR	IN_OpenWindow
	APTR	IN_OpenWindowTagList
	APTR	IN_Request
	APTR	IN_ScreenDepth		; (V39)

	APTR	LY_BehindLayer
	APTR	LY_DeleteLayer
	APTR	LY_LockLayer
	APTR	LY_MoveLayer
	APTR	LY_ScrollLayer
	APTR	LY_SizeLayer
	APTR	LY_UpfrontLayer

	APTR	LO_OpenCatalogA

	APTR	UT_AllocNamedObjectA	; (V39)

	APTR	WB_AddAppIconA
	APTR	WB_AddAppMenuItemA
	APTR	WB_AddAppWindowA


	; Commodity
	; ---------
	APTR	broker			; <= CxBroker()

	LABEL	commodity_active	; TRUE / FALSE
	LONG	broker_error		; <= CxBroker()


	; Misc
	; ----
	APTR	WorkbenchMsg		; Startup-Message

	ULONG	signals 		; => Wait()

	APTR	msgport 		; Compatibility - MsgPort
	BPTR	filehandle		; Output-Window (CON:)

	LABEL	printf_argv		; => VFPrintf()
	APTR	argv_taskname
	APTR	argv_errorstring

	ULONG	execution_count 	; <= FUNC_ / exit_clean


	LABEL	BSSstruct_SIZEOF



;	######################
;	#		     #
;	#   DATA-STRUCTURE   #
;	#		     #
;	######################


 STRUCTURE	DATAstruct,0


	ULONG	return_code			; Default: RETURN_FAIL (20)

	STRUCT	easyrequester,es_SIZEOF 	; Error-Requester (OK)
	STRUCT	newbroker,NewBroker_SIZEOF	; => CxBroker()


	LABEL	DATAstruct_SIZEOF



;	###############
;	#	      #
;	#   STARTUP   #
;	#	      #
;	###############


 SECTION "CODE+DATA",code


	bra.s startup

; ------------------------------------------------------------------------

	dc.b '$VER: Future_Compatibility_Supervisor 40.1 (7.12.93)',0
	even

; ------------------------------------------------------------------------


startup lea BSS_Label,BSS
	lea DATA_Label,DATA
	GET_EXEC


	CLRA	 a1			; own Task
	CALLEXEC FindTask
	move.l	 d0,A2

	move.l	 A2,a1
	moveq	 #-20,d0		; Priority (slow)
	CALLSAME SetTaskPri

	tst.l	 pr_CLI(A2)             ; from CLI ?
	bne.s	 cli			; YES

	lea	 pr_MsgPort(A2),a0      ; from WB
	CALLSAME WaitPort
	lea	 pr_MsgPort(A2),a0
	CALLSAME GetMsg
	move.l d0,WorkbenchMsg(BSS)     ; save Startup-Message

cli	bsr.s	 start			; Program-Call

	move.l	 WorkbenchMsg(BSS),D0   ; is there a WB-Message ?       1)
	beq.s	 exit			; NO

	CALLEXEC Forbid
	move.l	 D0,a1			;				1)
	CALLSAME ReplyMsg		; reply Startup-Message

exit	move.l return_code(DATA),d0
	rts



;	###############
;	#	      #
;	#   PROGRAM   #
;	#	      #
;	###############


	; +----------------+
	; | ***  INIT  *** |
	; +----------------+


	; Kickstart 37.x (Release 2.04)
	; -----------------------------
start	cmp.w #37,LIB_VERSION(A6)       ; Exec < 37 ?
	bcs noKick2_0			; YES => DISPLAY-ALERT


	; ROM - Libraries
	; ---------------
	OPEN_INT 0			; Intuition-Library
	beq noINT			; 0 => ALERT

	OPEN_GADTL 0			; GadTools-Library
	beq noGADTL			; 0 => ALERT

	OPEN_DOS 0			; Dos-Library
	beq noDOS			; 0 => ALERT

	OPEN_WB 0			; Workbench-Library
	beq noWB			; 0 => ALERT

	OPEN_UTY 39			; Utility-Library

	OPEN_LAY 0			; Layers-Library
	beq noLAY			; 0 => ALERT

	OPEN_ICON 0			; Icon-Library
	beq noICON			; 0 => ALERT


	; DISK - Libraries
	; ----------------
	OPEN_COM 37			; Commodities-Library
	beq noCOM			; 0 => REQUESTER

	OPEN_LOC 38			; Locale-Library

	OPEN_DT 39			; DataTypes-Library

	OPEN_AMG 34			; AmigaGuide-Library


	; Check OS-Version
	; ----------------
	cmp.w #FCS_VERSION,LIB_VERSION(A6)  ; Exec > FCS-Version ?
	bhi obsolete_version		    ; YES => REQUESTER



	; CON-Window
	; ----------
	lea con_name(PC),a0
	move.l a0,d1			; File-Name
	move.l #MODE_NEWFILE,d2 	; Mode
	CALLDOS Open
	move.l d0,filehandle(BSS)       ; successful?
	beq noCON			; NO => ALERT


	; Create MsgPort's
	; ----------------
	CALLEXEC CreateMsgPort
	move.l d0,msgport(BSS)          ; successful ?
	beq noMsgPort			; NO => ALERT
	move.l d0,a0
	move.b MP_SIGBIT(a0),d1         ; Signal-Bit-Number
	MOVE_Q 0,D2
	bset d1,D2			;				1)

	CALLSAME CreateMsgPort
	move.l d0,newbroker+nb_Port(DATA) ; successful ?
	beq noMsgPort			; NO => ALERT
	move.l d0,a0
	move.b MP_SIGBIT(a0),d1         ; Signal-Bit-Number
	bset d1,D2			;				1)

	or.l #SIGBREAKF_CTRL_C,D2	; CTRL-C
	move.l D2,signals(BSS)          ; Signals to Wait()


	; Create Commodity
	; ----------------
	lea newbroker(DATA),a0
	lea broker_error(BSS),a1
	move.l a1,d0			; error
	CALLCOM CxBroker
	move.l d0,broker(BSS)           ; successful ?                  2)
	bne.s activate_commodity	; YES


	; Is FCS already running?
	; -----------------------
	cmp.l #CBERR_DUP,broker_error(BSS)
	bne noBroker			; NO => ALERT

	move.l #0,return_code(DATA)     ; ... not failed
	bra Quit_Pgm


	; Activate Broker
	; ---------------
activate_commodity
	move.l d0,a0			; Broker			2)
;	MOVE_Q TRUE,d0			; Active = NOT FALSE = <> 0
	CALLSAME ActivateCxObj
	move.b #TRUE,commodity_active(BSS)



	; +-----------------------------+
	; | ***  INSTALL FUNCTIONS  *** |
	; +-----------------------------+


	CALLEXEC Forbid
;	+-------------------------------+


	; "amigaguide.library"
	; --------------------
amigaguide_functions
	move.l AMIGAGUIDEBase(BSS),d1           ; amigaguide.library open?
	beq commodities_functions		; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; AmigaGuideBase > FCS ?
	bhi.s commodities_functions		; YES

	lea FUNC_AddAmigaGuideHostA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAmigaGuideHostA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,AG_AddAmigaGuideHostA(BSS)    ; Old Function

	lea FUNC_OpenAmigaGuideA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenAmigaGuideA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,AG_OpenAmigaGuideA(BSS)       ; Old Function

	lea FUNC_OpenAmigaGuideAsyncA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenAmigaGuideAsyncA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,AG_OpenAmigaGuideAsyncA(BSS)  ; Old Function

	lea FUNC_RemoveAmigaGuideHostA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVORemoveAmigaGuideHostA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,AG_RemoveAmigaGuideHostA(BSS) ; Old Function

	lea FUNC_SendAmigaGuideContextA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOSendAmigaGuideContextA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,AG_SendAmigaGuideContextA(BSS) ; Old Function

	lea FUNC_SetAmigaGuideContextA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOSetAmigaGuideContextA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,AG_SetAmigaGuideContextA(BSS) ; Old Function


	; "commodities.library"
	; ---------------------
commodities_functions
	move.l COMBase(BSS),a1                  ; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(a1)      ; CommoditiesBase > FCS ?
	bhi.s datatypes_functions		; YES

	lea FUNC_CxBroker(PC),a0
	move.l a0,d0				; New Function
	move.w #_LVOCxBroker,a0 		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,CO_CxBroker(BSS)              ; Old Function


	; "datatypes.library"
	; -------------------
datatypes_functions
	move.l DATATYPESBase(BSS),d1            ; datatypes.library open ?
	beq.s dos_functions			; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; DataTypesBase > FCS ?
	bhi.s dos_functions			; YES

	lea FUNC_AddDTObject(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddDTObject,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,DT_AddDTObject(BSS)           ; Old Function

	lea FUNC_ObtainDataTypeA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOObtainDataTypeA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,DT_ObtainDataTypeA(BSS)       ; Old Function

	lea FUNC_RefreshDTObjectA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVORefreshDTObjectA,a0 	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,DT_RefreshDTObjectA(BSS)      ; Old Function


	; "dos.library"
	; -------------
dos_functions
	move.l DOSBase(BSS),A2

	lea FUNC_EndNotify(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOEndNotify,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,DO_EndNotify(BSS)             ; Old Function

	lea FUNC_NewLoadSeg(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVONewLoadSeg,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,DO_NewLoadSeg(BSS)            ; Old Function

	lea FUNC_StartNotify(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOStartNotify,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,DO_StartNotify(BSS)           ; Old Function


	; "gadtools.library"
	; ------------------
gadtools_functions
	move.l GADTLBase(BSS),A2

	lea FUNC_GetVisualInfoA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGetVisualInfoA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,GT_GetVisualInfoA(BSS)        ; Old Function

	lea FUNC_GT_RefreshWindow(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGT_RefreshWindow,a0 	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,GT_GT_RefreshWindow(BSS)      ; Old Function

	lea FUNC_GT_SetGadgetAttrsA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGT_SetGadgetAttrsA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,GT_GT_SetGadgetAttrsA(BSS)    ; Old Function

	; New in V39

	cmp.w #39,LIB_VERSION(A2)               ; GadToolsBase >= 39 ?
	bcs.s icon_functions			; NO

	lea FUNC_GT_GetGadgetAttrsA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGT_GetGadgetAttrsA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,GT_GT_GetGadgetAttrsA(BSS)    ; Old Function


	; "icon.library"
	; --------------
icon_functions
	move.l ICONBase(BSS),A2

	lea FUNC_PutDefDiskObject(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOPutDefDiskObject,a0 	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IC_PutDefDiskObject(BSS)      ; Old Function

	lea FUNC_PutDiskObject(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOPutDiskObject,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IC_PutDiskObject(BSS)         ; Old Function


	; "intuition.library"
	; -------------------
intuition_functions
	move.l INTBase(BSS),A2

	lea FUNC_AddGadget(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddGadget,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_AddGadget(BSS)             ; Old Function

	lea FUNC_AddGList(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddGList,a0 		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_AddGList(BSS)              ; Old Function

	lea FUNC_BuildEasyRequestArgs(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOBuildEasyRequestArgs,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_BuildEasyRequestArgs(BSS)  ; Old Function

	lea FUNC_EasyRequestArgs(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOEasyRequestArgs,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_EasyRequestArgs(BSS)       ; Old Function

	lea FUNC_MakeClass(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOMakeClass,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_MakeClass(BSS)             ; Old Function

	lea FUNC_OpenScreen(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenScreen,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_OpenScreen(BSS)            ; Old Function

	lea FUNC_OpenScreenTagList(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenScreenTagList,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_OpenScreenTagList(BSS)     ; Old Function

	lea FUNC_OpenWindow(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenWindow,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_OpenWindow(BSS)            ; Old Function

	lea FUNC_OpenWindowTagList(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenWindowTagList,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_OpenWindowTagList(BSS)     ; Old Function

	lea FUNC_Request(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVORequest,a0			; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_Request(BSS)               ; Old Function

	; New in V39

	cmp.w #39,LIB_VERSION(A2)               ; IntuitionBase >= 39 ?
	bcs.s layers_functions			; NO

	lea FUNC_ScreenDepth(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOScreenDepth,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,IN_ScreenDepth(BSS)           ; Old Function


	; "layers.library"
	; ----------------
layers_functions
	move.l LAYBase(BSS),A2

	lea FUNC_BehindLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOBehindLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_BehindLayer(BSS)           ; Old Function

	lea FUNC_DeleteLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVODeleteLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_DeleteLayer(BSS)           ; Old Function

	lea FUNC_LockLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOLockLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_LockLayer(BSS)             ; Old Function

	lea FUNC_MoveLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOMoveLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_MoveLayer(BSS)             ; Old Function

	lea FUNC_ScrollLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOScrollLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_ScrollLayer(BSS)           ; Old Function

	lea FUNC_SizeLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOSizeLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_SizeLayer(BSS)             ; Old Function

	lea FUNC_UpfrontLayer(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOUpfrontLayer,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LY_UpfrontLayer(BSS)          ; Old Function


	; "locale.library"
	; ----------------
locale_functions
	move.l LOCALEBase(BSS),d1               ; locale.library open ?
	beq.s utility_functions 		; NO

	move.l d1,a1				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(a1)      ; LocaleBase > FCS ?
	bhi.s utility_functions 		; YES

	lea FUNC_OpenCatalogA(PC),a0
	move.l a0,d0				; New Function
	move.w #_LVOOpenCatalogA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,LO_OpenCatalogA(BSS)          ; Old Function


	; "utility.library"
	; -----------------
utility_functions
	move.l UTILITYBase(BSS),D1              ; utility.library (V39) open?
	beq.s workbench_functions		; NO

	lea FUNC_AllocNamedObjectA(PC),a0
	move.l a0,d0				; New Function
	move.l D1,a1				; LibraryBase
	move.w #_LVOAllocNamedObjectA,a0	; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,UT_AllocNamedObjectA(BSS)     ; Old Function


	; "workbench.library"
	; -------------------
workbench_functions
	move.l WORKBENCHBase(BSS),A2

	lea FUNC_AddAppIconA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAppIconA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,WB_AddAppIconA(BSS)           ; Old Function

	lea FUNC_AddAppMenuItemA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAppMenuItemA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,WB_AddAppMenuItemA(BSS)       ; Old Function

	lea FUNC_AddAppWindowA(PC),a0
	move.l a0,d0				; New Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAppWindowA,a0		; Offset (LVO)
	CALLSAME SetFunction
	move.l d0,WB_AddAppWindowA(BSS)         ; Old Function


;	+-------------------------------+
	CALLSAME Permit



	; +----------------------------+
	; | ***  MESSAGE-HANDLING  *** |
	; +----------------------------+

main_loop
	move.l signals(BSS),d0          ; 2 MsgPorts / CTRL-C
	CALLEXEC Wait
	and.l #SIGBREAKF_CTRL_C,d0
	cmp.l #SIGBREAKF_CTRL_C,d0	; CTRL-C ?
	beq exit_clean			; YES


	; ----------------------
	;  Commodity - Messages
	; ----------------------
get_cxmsg
	move.l newbroker+nb_Port(DATA),a0
	CALLEXEC GetMsg
	tst.l d0			; Message arrived ?
	beq get_msg			; NO

	move.l d0,A2			; CxMessage			3)
	move.l d0,a0
	CALLCOM CxMsgType
	cmp.l #CXM_COMMAND,d0		; Command from Exchange (User) ?
	bne.s cxmsg_reply		; NO


	; Exchange - Commands
	; -------------------
	move.l A2,a0			; CxMessage			3)
	CALLSAME CxMsgID
	cmp.l #CXCMD_DISABLE,d0
	bne.s cxmsg_Enable		; NO

	move.l broker(BSS),a0           ; CxObject
	MOVE_Q FALSE,d0 		; Inactive
	CALLSAME ActivateCxObj
	move.b #FALSE,commodity_active(BSS)
	bra.s cxmsg_reply


cxmsg_Enable
	cmp.l #CXCMD_ENABLE,d0
	bne.s cxmsg_Kill		; NO

	move.l broker(BSS),a0           ; CxObject
;	MOVE_Q TRUE,d0			; Active = NOT FALSE = <> 0
	CALLSAME ActivateCxObj
	move.b #TRUE,commodity_active(BSS)
	bra.s cxmsg_reply


cxmsg_Kill
	cmp.l #CXCMD_KILL,d0
	beq.s cxmsg_Kill_Yes		; YES

	cmp.l #CXCMD_UNIQUE,d0		; Is FCS running twice?
	bne.s cxmsg_reply		; NO

cxmsg_Kill_Yes
	move.l A2,a1			; Message			3)
	CALLEXEC ReplyMsg
	bra exit_clean

cxmsg_reply
	move.l A2,a1			; Message			3)
	CALLEXEC ReplyMsg
	bra get_cxmsg			; next Message...


	; --------------------------
	;  Compatibility - Messages
	; --------------------------
get_msg
	move.l msgport(BSS),a0
	CALLSAME GetMsg
	tst.l d0			; Message arrived ?
	beq main_loop			; NO


	; Print Compatibility-Message
	; ---------------------------
	move.l d0,A2			; Message			4)
	move.l MyErrorString(A2),argv_errorstring(BSS)
	lea BuggyTaskName(A2),a0
	move.l a0,argv_taskname(BSS)

	move.l filehandle(BSS),d1
	lea printf_fmt(PC),a0
	move.l a0,d2			; Printf-String
	lea printf_argv(BSS),a0
	move.l a0,d3			; Arguments (TaskName,ErrorString)
	CALLDOS VFPrintf		; buffered
	cmp.l #-1,d0			; successful ?
					; Because Bug in V37 Flush()
	beq.s free_msg			; NO

	move.l filehandle(BSS),d1
	CALLSAME Flush


	; Free Message-Memory (Allocated in Library-Function)
	; ---------------------------------------------------
free_msg
	move.l A2,a1			; MemoryBlock (Message)         4)
	MOVE_Q Message_SIZEOF,d0	; Bytes
	CALLEXEC FreeMem
	bra.s get_msg			; next Message...



	; ---------------
	;  Clean Exit...
	; ---------------
exit_clean

	CALLEXEC Forbid
;	+-------------------------------+

	; +-----------------------------------+
	; | ***  CHECK: Function = LVO ?  *** |
	; +-----------------------------------+
	; LVO => 6 Bytes => $4EF9 (JMP) $FFFFFFFF (Address)

	; "amigaguide.library"
	; --------------------
amigaguide_check
	move.l AMIGAGUIDEBase(BSS),d1           ; amigaguide.library open?
	beq.s commodities_check 		; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; AmigaGuideBase > FCS ?
	bhi.s commodities_check 		; YES

	lea FUNC_AddAmigaGuideHostA(PC),a0
	move.l _LVOAddAmigaGuideHostA+2(A2),d0  ; JMP-Address
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_OpenAmigaGuideA(PC),a0
	move.l _LVOOpenAmigaGuideA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_OpenAmigaGuideAsyncA(PC),a0
	move.l _LVOOpenAmigaGuideAsyncA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_RemoveAmigaGuideHostA(PC),a0
	move.l _LVORemoveAmigaGuideHostA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_SendAmigaGuideContextA(PC),a0
	move.l _LVOSendAmigaGuideContextA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_SetAmigaGuideContextA(PC),a0
	move.l _LVOSetAmigaGuideContextA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "commodities.library"
	; ---------------------
commodities_check
	move.l COMBase(BSS),A2                  ; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; CommoditiesBase > FCS ?
	bhi.s datatypes_check			; YES

	lea FUNC_CxBroker(PC),a0
	move.l _LVOCxBroker+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "datatypes.library"
	; -------------------
datatypes_check
	move.l DATATYPESBase(BSS),d1            ; datatypes.library open ?
	beq.s dos_check 			; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; DataTypesBase > FCS ?
	bhi.s dos_check 			; YES

	lea FUNC_AddDTObject(PC),a0
	move.l _LVOAddDTObject+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_ObtainDataTypeA(PC),a0
	move.l _LVOObtainDataTypeA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_RefreshDTObjectA(PC),a0
	move.l _LVORefreshDTObjectA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "dos.library"
	; -------------
dos_check
	move.l DOSBase(BSS),A2

	lea FUNC_EndNotify(PC),a0
	move.l _LVOEndNotify+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_NewLoadSeg(PC),a0
	move.l _LVONewLoadSeg+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_StartNotify(PC),a0
	move.l _LVOStartNotify+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "gadtools.library"
	; ------------------
gadtools_check
	move.l GADTLBase(BSS),A2

	lea FUNC_GetVisualInfoA(PC),a0
	move.l _LVOGetVisualInfoA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_GT_RefreshWindow(PC),a0
	move.l _LVOGT_RefreshWindow+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_GT_SetGadgetAttrsA(PC),a0
	move.l _LVOGT_SetGadgetAttrsA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	; New in V39

	cmp.w #39,LIB_VERSION(A2)               ; GadToolsBase >= 39 ?
	bcs.s icon_check			; NO

	lea FUNC_GT_GetGadgetAttrsA(PC),a0
	move.l _LVOGT_GetGadgetAttrsA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "icon.library"
	; --------------
icon_check
	move.l ICONBase(BSS),A2

	lea FUNC_PutDefDiskObject(PC),a0
	move.l _LVOPutDefDiskObject+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_PutDiskObject(PC),a0
	move.l _LVOPutDiskObject+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "intuition.library"
	; -------------------
intuition_check
	move.l INTBase(BSS),A2

	lea FUNC_AddGadget(PC),a0
	move.l _LVOAddGadget+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_AddGList(PC),a0
	move.l _LVOAddGList+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_BuildEasyRequestArgs(PC),a0
	move.l _LVOBuildEasyRequestArgs+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_EasyRequestArgs(PC),a0
	move.l _LVOEasyRequestArgs+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_MakeClass(PC),a0
	move.l _LVOMakeClass+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_OpenScreen(PC),a0
	move.l _LVOOpenScreen+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_OpenScreenTagList(PC),a0
	move.l _LVOOpenScreenTagList+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_OpenWindow(PC),a0
	move.l _LVOOpenWindow+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_OpenWindowTagList(PC),a0
	move.l _LVOOpenWindowTagList+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_Request(PC),a0
	move.l _LVORequest+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	; New in V39

	cmp.w #39,LIB_VERSION(A2)               ; IntuitionBase >= 39 ?
	bcs.s layers_check			; NO

	lea FUNC_ScreenDepth(PC),a0
	move.l _LVOScreenDepth+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "layers.library"
	; ----------------
layers_check
	move.l LAYBase(BSS),A2

	lea FUNC_BehindLayer(PC),a0
	move.l _LVOBehindLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_DeleteLayer(PC),a0
	move.l _LVODeleteLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_LockLayer(PC),a0
	move.l _LVOLockLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_MoveLayer(PC),a0
	move.l _LVOMoveLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_ScrollLayer(PC),a0
	move.l _LVOScrollLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_SizeLayer(PC),a0
	move.l _LVOSizeLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_UpfrontLayer(PC),a0
	move.l _LVOUpfrontLayer+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "locale.library"
	; ----------------
locale_check
	move.l LOCALEBase(BSS),d1               ; locale.library open ?
	beq.s utility_check			; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; LocaleBase > FCS ?
	bhi.s utility_check			; YES

	lea FUNC_OpenCatalogA(PC),a0
	move.l _LVOOpenCatalogA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "utility.library"
	; -----------------
utility_check
	move.l UTILITYBase(BSS),d1              ; utility.library (V39) open?
	beq.s workbench_check			; NO

	move.l d1,A2				; LibraryBase

	lea FUNC_AllocNamedObjectA(PC),a0
	move.l _LVOAllocNamedObjectA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; "workbench.library"
	; -------------------
workbench_check
	move.l WORKBENCHBase(BSS),A2

	lea FUNC_AddAppIconA(PC),a0
	move.l _LVOAddAppIconA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_AddAppMenuItemA(PC),a0
	move.l _LVOAddAppMenuItemA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO

	lea FUNC_AddAppWindowA(PC),a0
	move.l _LVOAddAppWindowA+2(A2),d0
	cmp.l a0,d0				; Function = LVO ?
	bne exit_requester			; NO


	; +---------------------------+
	; | ***  RESET FUNCTIONS  *** |
	; +---------------------------+

	; "amigaguide.library"
	; --------------------
amigaguide_reset
	move.l AMIGAGUIDEBase(BSS),d1           ; amigaguide.library open?
	beq.s commodities_reset 		; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; AmigaGuideBase > FCS ?
	bhi.s commodities_reset 		; YES

	move.l AG_AddAmigaGuideHostA(BSS),d0    ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAmigaGuideHostA,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l AG_OpenAmigaGuideA(BSS),d0       ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenAmigaGuideA,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l AG_OpenAmigaGuideAsyncA(BSS),d0  ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenAmigaGuideAsyncA,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l AG_RemoveAmigaGuideHostA(BSS),d0 ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVORemoveAmigaGuideHostA,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l AG_SendAmigaGuideContextA(BSS),d0 ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOSendAmigaGuideContextA,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l AG_SetAmigaGuideContextA(BSS),d0 ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOSetAmigaGuideContextA,a0	; Offset (LVO)
	CALLSAME SetFunction


	; "commodities.library"
	; ---------------------
commodities_reset
	move.l COMBase(BSS),a1                  ; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(a1)      ; CommoditiesBase > FCS ?
	bhi.s datatypes_reset			; YES

	move.l CO_CxBroker(BSS),d0              ; Old Function
	move.w #_LVOCxBroker,a0 		; Offset (LVO)
	CALLSAME SetFunction


	; "datatypes.library"
	; -------------------
datatypes_reset
	move.l DATATYPESBase(BSS),d1            ; datatypes.library open ?
	beq.s dos_reset 			; NO

	move.l d1,A2				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(A2)      ; DataTypesBase > FCS ?
	bhi.s dos_reset 			; YES

	move.l DT_AddDTObject(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddDTObject,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l DT_ObtainDataTypeA(BSS),d0       ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOObtainDataTypeA,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l DT_RefreshDTObjectA(BSS),d0      ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVORefreshDTObjectA,a0 	; Offset (LVO)
	CALLSAME SetFunction


	; "dos.library"
	; -------------
dos_reset
	move.l DOSBase(BSS),A2

	move.l DO_EndNotify(BSS),d0             ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOEndNotify,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l DO_NewLoadSeg(BSS),d0            ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVONewLoadSeg,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l DO_StartNotify(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOStartNotify,a0		; Offset (LVO)
	CALLSAME SetFunction


	; "gadtools.library"
	; ------------------
gadtools_reset
	move.l GADTLBase(BSS),A2

	move.l GT_GetVisualInfoA(BSS),d0        ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGetVisualInfoA,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l GT_GT_RefreshWindow(BSS),d0      ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGT_RefreshWindow,a0 	; Offset (LVO)
	CALLSAME SetFunction

	move.l GT_GT_SetGadgetAttrsA(BSS),d0    ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGT_SetGadgetAttrsA,a0	; Offset (LVO)
	CALLSAME SetFunction

	; New in V39

	cmp.w #39,LIB_VERSION(A2)               ; GadToolsBase >= 39 ?
	bcs.s icon_reset			; NO

	move.l GT_GT_GetGadgetAttrsA(BSS),d0    ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOGT_GetGadgetAttrsA,a0	; Offset (LVO)
	CALLSAME SetFunction


	; "icon.library"
	; --------------
icon_reset
	move.l ICONBase(BSS),A2

	move.l IC_PutDefDiskObject(BSS),d0      ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOPutDefDiskObject,a0 	; Offset (LVO)
	CALLSAME SetFunction

	move.l IC_PutDiskObject(BSS),d0         ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOPutDiskObject,a0		; Offset (LVO)
	CALLSAME SetFunction


	; "intuition.library"
	; -------------------
intuition_reset
	move.l INTBase(BSS),A2

	move.l IN_AddGadget(BSS),d0             ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddGadget,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_AddGList(BSS),d0              ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddGList,a0 		; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_BuildEasyRequestArgs(BSS),d0  ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOBuildEasyRequestArgs,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_EasyRequestArgs(BSS),d0       ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOEasyRequestArgs,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_MakeClass(BSS),d0             ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOMakeClass,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_OpenScreen(BSS),d0            ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenScreen,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_OpenScreenTagList(BSS),d0     ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenScreenTagList,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_OpenWindow(BSS),d0            ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenWindow,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_OpenWindowTagList(BSS),d0     ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOOpenWindowTagList,a0	; Offset (LVO)
	CALLSAME SetFunction

	move.l IN_Request(BSS),d0               ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVORequest,a0			; Offset (LVO)
	CALLSAME SetFunction

	; New in V39

	cmp.w #39,LIB_VERSION(A2)               ; IntuitionBase >= 39 ?
	bcs.s layers_reset			; NO

	move.l IN_ScreenDepth(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOScreenDepth,a0		; Offset (LVO)
	CALLSAME SetFunction


	; "layers.library"
	; ----------------
layers_reset
	move.l LAYBase(BSS),A2

	move.l LY_BehindLayer(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOBehindLayer,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l LY_DeleteLayer(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVODeleteLayer,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l LY_LockLayer(BSS),d0             ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOLockLayer,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l LY_MoveLayer(BSS),d0             ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOMoveLayer,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l LY_ScrollLayer(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOScrollLayer,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l LY_SizeLayer(BSS),d0             ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOSizeLayer,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l LY_UpfrontLayer(BSS),d0          ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOUpfrontLayer,a0		; Offset (LVO)
	CALLSAME SetFunction


	; "locale.library"
	; ----------------
locale_reset
	move.l LOCALEBase(BSS),d1               ; locale.library open ?
	beq.s utility_reset			; NO

	move.l d1,a1				; LibraryBase
	cmp.w #FCS_VERSION,LIB_VERSION(a1)      ; LocaleBase > FCS ?
	bhi.s utility_reset			; YES

	move.l LO_OpenCatalogA(BSS),d0          ; Old Function
	move.w #_LVOOpenCatalogA,a0		; Offset (LVO)
	CALLSAME SetFunction


	; "utility.library"
	; -----------------
utility_reset
	move.l UTILITYBase(BSS),D1              ; utility.library (V39) open?
	beq.s workbench_reset			; NO

	move.l UT_AllocNamedObjectA(BSS),d0     ; Old Function
	move.l D1,a1				; LibraryBase
	move.w #_LVOAllocNamedObjectA,a0	; Offset (LVO)
	CALLSAME SetFunction


	; "workbench.library"
	; -------------------
workbench_reset
	move.l WORKBENCHBase(BSS),A2

	move.l WB_AddAppIconA(BSS),d0           ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAppIconA,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l WB_AddAppMenuItemA(BSS),d0       ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAppMenuItemA,a0		; Offset (LVO)
	CALLSAME SetFunction

	move.l WB_AddAppWindowA(BSS),d0         ; Old Function
	move.l A2,a1				; LibraryBase
	move.w #_LVOAddAppWindowA,a0		; Offset (LVO)
	CALLSAME SetFunction

;	+-------------------------------+
	CALLSAME Permit


	; Let other Tasks finish our Functions...
	; ---------------------------------------
	moveq #25,d1				; 1/2 second
	CALLDOS Delay

	move.l #0,return_code(DATA)             ; ... not failed

exit_clean_loop
	tst.l execution_count(BSS)              ; 0 ?
	beq.s Quit_Pgm				; YES

	moveq #50,d1				; 1 second
	CALLSAME Delay
	bra.s exit_clean_loop


	; +-------------------------------+
	; | ***  SORRY! CAN'T EXIT... *** |
	; +-------------------------------+

exit_requester
	CALLSAME Permit

	lea easyrequester(DATA),a1
	lea exit_error(PC),a0
	move.l a0,es_TextFormat(a1)
	bsr SR_EasyReq			; a1 = EasyStruct
	bra get_cxmsg			; next messages...



;	###################
;	#		  #
;	#   PROGRAM-END   #
;	#		  #
;	###################


Quit_Pgm
	; Remove Commodity
	; ----------------
	move.l broker(BSS),a0           ; NULL is save
	CALLCOM DeleteCxObj


	; Remove CxPort
	; -------------
	move.l newbroker+nb_Port(DATA),D2 ; exist MsgPort ?             1)
	beq.s Quit_Pgm_RemMsgPort	; NO

Quit_Pgm_ReplyCxMsg
	move.l D2,a0			;				1)
	CALLEXEC GetMsg
	tst.l d0			; Message present ?
	beq.s Quit_Pgm_RemoveCxPort	; NO

	move.l d0,a1
	CALLSAME ReplyMsg
	bra.s Quit_Pgm_ReplyCxMsg

Quit_Pgm_RemoveCxPort
	move.l D2,a0			;				1)
	CALLSAME DeleteMsgPort


	; Remove MsgPort
	; --------------
Quit_Pgm_RemMsgPort
	move.l msgport(BSS),D2          ; exist MsgPort ?               2)
	beq.s Quit_Pgm_CloseFH		; NO

Quit_Pgm_FreeMsg
	move.l D2,a0			;				2)
	CALLEXEC GetMsg
	tst.l d0			; Message present ?
	beq.s Quit_Pgm_RemoveMsgPort	; NO

	move.l d0,a1			; MemoryBlock
	MOVE_Q Message_SIZEOF,d0	; Bytes
	CALLSAME FreeMem
	bra.s Quit_Pgm_FreeMsg

Quit_Pgm_RemoveMsgPort
	move.l D2,a0			;				2)
	CALLSAME DeleteMsgPort


	; Close CON-FileHandle
	; --------------------
Quit_Pgm_CloseFH
	move.l filehandle(BSS),d1       ; ... is open !!!
	CALLDOS Close


CloseLIBS
	CLOSE_AMG			; NULL is save

	CLOSE_DT			; NULL is save

	CLOSE_LOC			; NULL is save

	CLOSE_COM


CloICON CLOSE_ICON

CloLAY	CLOSE_LAY

CloUTY	CLOSE_UTY			; NULL is save

	CLOSE_WB

CloDOS	CLOSE_DOS

CloGADTL CLOSE_GADTL

CloINT	CLOSE_INT

	rts



;	######################
;	#		     #
;	#   ERROR-HANDLING   #
;	#		     #
;	######################


noBroker
	lea broker_alert(PC),a0
	bsr SR_DisplayAlert
	bra Quit_Pgm

noMsgPort
	lea msgport_alert(PC),a0
	bsr SR_DisplayAlert
	bra Quit_Pgm

noCON
	lea con_alert(PC),a0
	bsr SR_DisplayAlert
	bra CloseLIBS

obsolete_version
	lea easyrequester(DATA),a1
	lea version_error(PC),a0
	move.l a0,es_TextFormat(a1)
	bsr SR_EasyReq			; a1 = EasyStruct
	bra CloseLIBS


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


noCOM	lea easyrequester(DATA),a1
	lea commodities_error(PC),a0
	move.l a0,es_TextFormat(a1)
	bsr.s SR_EasyReq		; a1 = EasyStruct
	bra CloICON

noICON	move.l #AN_Unknown!AG_OpenLib!AO_IconLib,d7
	CALLSAME Alert
	bra CloLAY

noLAY	move.l #AN_Unknown!AG_OpenLib!AO_LayersLib,d7
	CALLSAME Alert
	bra CloUTY

noWB	move.l #AN_Unknown!AG_OpenLib!AO_Workbench,d7
	CALLSAME Alert
	bra CloDOS

noDOS	move.l #AN_Unknown!AG_OpenLib!AO_DOSLib,d7
	CALLSAME Alert
	bra CloGADTL

noGADTL move.l #AN_Unknown!AG_OpenLib!AO_GadTools,d7
	CALLSAME Alert
	bra CloINT

noINT	move.l #AN_Unknown!AG_OpenLib!AO_Intuition,d7
	CALLSAME Alert
	rts


noKick2_0
	OPEN_INT 0			; Intuition-Library
	beq.s noINT			; 0 => ALERT

	lea Kick2_0_alert(PC),a0
	bsr.s SR_DisplayAlert
	bra CloINT



; ------------------------------------------------------------------------



;	####################
;	#		   #
;	#   SUB-ROUTINES   #
;	#		   #
;	####################


SR_DisplayAlert

;	INPUTS
;		a0 = AlertText	(APTR)


	MOVE_Q AT_Recovery,d0		; AlertNumber
	MOVE_Q 30,d1			; Height
	CALLINT DisplayAlert
	rts


; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


SR_EasyReq

;	INPUTS
;		a1 = EasyStruct (APTR)


	CLRA a0 		; Window (0 => DefPubScreen)
	CLRA a2 		; IDCMP
	CLRA a3 		; ArgList
	CALLINT EasyRequestArgs
	rts



; ------------------------------------------------------------------------
; ------------------------------------------------------------------------



;	##############################
;	#			     #
;	#   FUNCTIONS (RE-ENTRANT)   #
;	#			     #
;	##############################


	; +----------------------+
	; | "amigaguide.library" |
	; +----------------------+

FUNC_AddAmigaGuideHostA

;	CHECK
;		A1 = Attrs		None are defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	---------------------------------------------------------
;	 bra.s FUNC_AddAmigaGuideHostA_PutMsg	  ; Function-Test
;	---------------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_AddAmigaGuideHostA_Call

	tst.l ti_Tag(A1)                ; TAG_END = 0
	beq.s FUNC_AddAmigaGuideHostA_Call

FUNC_AddAmigaGuideHostA_PutMsg
	PUT_STACK A2
	lea MSG_AddAmigaGuideHostA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_AddAmigaGuideHostA_Call
	PUT_STACK A5
	move.l BSS_Label+AG_AddAmigaGuideHostA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_OpenAmigaGuideA

;	CHECK
;		A0 = NewAmigaGuide	Field:	nag_Client


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------------
;	 bra.s FUNC_OpenAmigaGuideA_PutMsg     ; Function-Test
;	------------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_OpenAmigaGuideA_Call

	tst.l nag_Client(A0)
	beq.s FUNC_OpenAmigaGuideA_Call

FUNC_OpenAmigaGuideA_PutMsg
	PUT_STACK A2
	lea MSG_OpenAmigaGuideA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_OpenAmigaGuideA_Call
	PUT_STACK A5
	move.l BSS_Label+AG_OpenAmigaGuideA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_OpenAmigaGuideAsyncA

;	CHECK
;		A0 = NewAmigaGuide	Field:	nag_Client


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-----------------------------------------------------------
;	 bra.s FUNC_OpenAmigaGuideAsyncA_PutMsg     ; Function-Test
;	-----------------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_OpenAmigaGuideAsyncA_Call

	tst.l nag_Client(A0)
	beq.s FUNC_OpenAmigaGuideAsyncA_Call

FUNC_OpenAmigaGuideAsyncA_PutMsg
	PUT_STACK A2
	lea MSG_OpenAmigaGuideAsyncA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_OpenAmigaGuideAsyncA_Call
	PUT_STACK A5
	move.l BSS_Label+AG_OpenAmigaGuideAsyncA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_RemoveAmigaGuideHostA

;	CHECK
;		A1 = Attrs		None are defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------------------
;	 bra.s FUNC_RemoveAmigaGuideHostA_PutMsg     ; Function-Test
;	------------------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_RemoveAmigaGuideHostA_Call

	tst.l ti_Tag(A1)                ; TAG_END = 0
	beq.s FUNC_RemoveAmigaGuideHostA_Call

FUNC_RemoveAmigaGuideHostA_PutMsg
	PUT_STACK A2
	lea MSG_RemoveAmigaGuideHostA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_RemoveAmigaGuideHostA_Call
	PUT_STACK A5
	move.l BSS_Label+AG_RemoveAmigaGuideHostA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_SendAmigaGuideContextA

;	CHECK
;		D0 = Attrs		Future Expansion

;	NOTES
;		a1 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-------------------------------------------------------------
;	 bra.s FUNC_SendAmigaGuideContextA_PutMsg     ; Function-Test
;	-------------------------------------------------------------

	tst.l D0
	beq.s FUNC_SendAmigaGuideContextA_Call

	move.l D0,a1
	tst.l ti_Tag(a1)                ; TAG_END = 0
	beq.s FUNC_SendAmigaGuideContextA_Call

FUNC_SendAmigaGuideContextA_PutMsg
	PUT_STACK A2
	lea MSG_SendAmigaGuideContextA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_SendAmigaGuideContextA_Call
	PUT_STACK A5
	move.l BSS_Label+AG_SendAmigaGuideContextA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_SetAmigaGuideContextA

;	CHECK
;		D1 = Attrs		Future Expansion

;	NOTES
;		a1 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------------------
;	 bra.s FUNC_SetAmigaGuideContextA_PutMsg     ; Function-Test
;	------------------------------------------------------------

	tst.l D1
	beq.s FUNC_SetAmigaGuideContextA_Call

	move.l D1,a1
	tst.l ti_Tag(a1)                ; TAG_END = 0
	beq.s FUNC_SetAmigaGuideContextA_Call

FUNC_SetAmigaGuideContextA_PutMsg
	PUT_STACK A2
	lea MSG_SetAmigaGuideContextA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_SetAmigaGuideContextA_Call
	PUT_STACK A5
	move.l BSS_Label+AG_SetAmigaGuideContextA,A5
	bra FUNC__CallFunction


	; +-----------------------+
	; | "commodities.library" |
	; +-----------------------+

FUNC_CxBroker

;	CHECK
;		A0 = NewBroker		Field:	nb_ReservedChannel


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-----------------------------------------------
;	 bra.s FUNC_CxBroker_PutMsg	; Function-Test
;	-----------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_CxBroker_Call

	tst.w nb_ReservedChannel(A0)
	beq.s FUNC_CxBroker_Call

FUNC_CxBroker_PutMsg
	PUT_STACK A2
	lea MSG_CxBroker(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_CxBroker_Call
	PUT_STACK A5
	move.l BSS_Label+CO_CxBroker,A5
	bra FUNC__CallFunction


	; +---------------------+
	; | "datatypes.library" |
	; +---------------------+

FUNC_AddDTObject

;	CHECK
;		A1 = Requester


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-------------------------------------------------
;	 bra.s FUNC_AddDTObject_PutMsg	  ; Function-Test
;	-------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_AddDTObject_Call

FUNC_AddDTObject_PutMsg
	PUT_STACK A2
	lea MSG_AddDTObject(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_AddDTObject_Call
	PUT_STACK A5
	move.l BSS_Label+DT_AddDTObject,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_ObtainDataTypeA

;	CHECK
;		A1 = Attrs		Currently none are defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-----------------------------------------------------
;	 bra.s FUNC_ObtainDataTypeA_PutMsg    ; Function-Test
;	-----------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_ObtainDataTypeA_Call

	tst.l ti_Tag(A1)                ; TAG_END = 0
	beq.s FUNC_ObtainDataTypeA_Call

FUNC_ObtainDataTypeA_PutMsg
	PUT_STACK A2
	lea MSG_ObtainDataTypeA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_ObtainDataTypeA_Call
	PUT_STACK A5
	move.l BSS_Label+DT_ObtainDataTypeA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_RefreshDTObjectA

;	CHECK
;		A2 = Requester
;		A3 = Attrs		Currently none are defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------------
;	 bra.s FUNC_RefreshDTObjectA_PutMsg    ; Function-Test
;	------------------------------------------------------

	cmp.l #0,A2
	bne.s FUNC_RefreshDTObjectA_PutMsg

	cmp.l #0,A3
	beq.s FUNC_RefreshDTObjectA_Call

	tst.l ti_Tag(A3)                ; TAG_END = 0
	beq.s FUNC_RefreshDTObjectA_Call

FUNC_RefreshDTObjectA_PutMsg
	PUT_STACK A2
	lea MSG_RefreshDTObjectA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_RefreshDTObjectA_Call
	PUT_STACK A5
	move.l BSS_Label+DT_RefreshDTObjectA,A5
	bra FUNC__CallFunction


	; +---------------+
	; | "dos.library" |
	; +---------------+

FUNC_EndNotify

;	CHECK
;		D1 = NotifyRequest	Field:	nr_Reserved[16]

;	NOTES
;		a0 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------
;	 bra.s FUNC_EndNotify_PutMsg	 ; Function-Test
;	------------------------------------------------

	tst.l D1
	beq.s FUNC_EndNotify_Call

	move.l D1,a0
	tst.l nr_Reserved(a0)
	bne.s FUNC_EndNotify_PutMsg

	tst.l nr_Reserved+4(a0)
	bne.s FUNC_EndNotify_PutMsg

	tst.l nr_Reserved+8(a0)
	bne.s FUNC_EndNotify_PutMsg

	tst.l nr_Reserved+12(a0)
	beq.s FUNC_EndNotify_Call

FUNC_EndNotify_PutMsg
	PUT_STACK A2
	lea MSG_EndNotify(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_EndNotify_Call
	PUT_STACK A5
	move.l BSS_Label+DO_EndNotify,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_NewLoadSeg

;	CHECK
;		D2 = Tags		No Tags defined

;	NOTES
;		a0 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-------------------------------------------------
;	 bra.s FUNC_NewLoadSeg_PutMsg	  ; Function-Test
;	-------------------------------------------------

	tst.l D2
	beq.s FUNC_NewLoadSeg_Call

	move.l D2,a0
	tst.l ti_Tag(a0)                ; TAG_END = 0
	beq.s FUNC_NewLoadSeg_Call

FUNC_NewLoadSeg_PutMsg
	PUT_STACK A2
	lea MSG_NewLoadSeg(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_NewLoadSeg_Call
	PUT_STACK A5
	move.l BSS_Label+DO_NewLoadSeg,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_StartNotify

;	CHECK
;		D1 = NotifyRequest	Field:	nr_Reserved[16]

;	NOTES
;		a0 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------
;	 bra.s FUNC_StartNotify_PutMsg	   ; Function-Test
;	--------------------------------------------------

	tst.l D1
	beq.s FUNC_StartNotify_Call

	move.l D1,a0
	tst.l nr_Reserved(a0)
	bne.s FUNC_StartNotify_PutMsg

	tst.l nr_Reserved+4(a0)
	bne.s FUNC_StartNotify_PutMsg

	tst.l nr_Reserved+8(a0)
	bne.s FUNC_StartNotify_PutMsg

	tst.l nr_Reserved+12(a0)
	beq.s FUNC_StartNotify_Call

FUNC_StartNotify_PutMsg
	PUT_STACK A2
	lea MSG_StartNotify(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_StartNotify_Call
	PUT_STACK A5
	move.l BSS_Label+DO_StartNotify,A5
	bra FUNC__CallFunction


	; +--------------------+
	; | "gadtools.library" |
	; +--------------------+

FUNC_GetVisualInfoA

;	CHECK
;		A1 = TagList		No Tags defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-----------------------------------------------------
;	 bra.s FUNC_GetVisualInfoA_PutMsg     ; Function-Test
;	-----------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_GetVisualInfoA_Call

	tst.l ti_Tag(A1)                ; TAG_END = 0
	beq.s FUNC_GetVisualInfoA_Call

FUNC_GetVisualInfoA_PutMsg
	PUT_STACK A2
	lea MSG_GetVisualInfoA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_GetVisualInfoA_Call
	PUT_STACK A5
	move.l BSS_Label+GT_GetVisualInfoA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_GT_RefreshWindow

;	CHECK
;		A1 = Requester		Reserved for future use


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-------------------------------------------------------
;	 bra.s FUNC_GT_RefreshWindow_PutMsg	; Function-Test
;	-------------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_GT_RefreshWindow_Call

FUNC_GT_RefreshWindow_PutMsg
	PUT_STACK A2
	lea MSG_GT_RefreshWindow(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_GT_RefreshWindow_Call
	PUT_STACK A5
	move.l BSS_Label+GT_GT_RefreshWindow,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_GT_SetGadgetAttrsA

;	CHECK
;		A2 = Requester		Reserved for future use


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	---------------------------------------------------------
;	 bra.s FUNC_GT_SetGadgetAttrsA_PutMsg	  ; Function-Test
;	---------------------------------------------------------

	cmp.l #0,A2
	beq.s FUNC_GT_SetGadgetAttrsA_Call

FUNC_GT_SetGadgetAttrsA_PutMsg
	PUT_STACK A2
	lea MSG_GT_SetGadgetAttrsA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_GT_SetGadgetAttrsA_Call
	PUT_STACK A5
	move.l BSS_Label+GT_GT_SetGadgetAttrsA,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_GT_GetGadgetAttrsA 		; (V39)

;	CHECK
;		A2 = Requester		Reserved for future use


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	---------------------------------------------------------
;	 bra.s FUNC_GT_GetGadgetAttrsA_PutMsg	  ; Function-Test
;	---------------------------------------------------------

	cmp.l #0,A2
	beq.s FUNC_GT_GetGadgetAttrsA_Call

FUNC_GT_GetGadgetAttrsA_PutMsg
	PUT_STACK A2
	lea MSG_GT_GetGadgetAttrsA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_GT_GetGadgetAttrsA_Call
	PUT_STACK A5
	move.l BSS_Label+GT_GT_GetGadgetAttrsA,A5
	bra FUNC__CallFunction


	; +----------------+
	; | "icon.library" |
	; +----------------+

FUNC_PutDefDiskObject

;	CHECK
;		A0 = DiskObject 	Field:	do_ToolWindow


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-------------------------------------------------------
;	 bra.s FUNC_PutDefDiskObject_PutMsg	; Function-Test
;	-------------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_PutDefDiskObject_Call

	tst.l do_ToolWindow(A0)
	beq.s FUNC_PutDefDiskObject_Call

FUNC_PutDefDiskObject_PutMsg
	PUT_STACK A2
	lea MSG_PutDefDiskObject(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_PutDefDiskObject_Call
	PUT_STACK A5
	move.l BSS_Label+IC_PutDefDiskObject,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_PutDiskObject

;	CHECK
;		A1 = DiskObject 	Field:	do_ToolWindow


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	----------------------------------------------------
;	 bra.s FUNC_PutDiskObject_PutMsg     ; Function-Test
;	----------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_PutDiskObject_Call

	tst.l do_ToolWindow(A1)
	beq.s FUNC_PutDiskObject_Call

FUNC_PutDiskObject_PutMsg
	PUT_STACK A2
	lea MSG_PutDiskObject(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_PutDiskObject_Call
	PUT_STACK A5
	move.l BSS_Label+IC_PutDiskObject,A5
	bra FUNC__CallFunction


	; +---------------------+
	; | "intuition.library" |
	; +---------------------+

FUNC_AddGadget

;	CHECK
;		A1 = Gadget		=> FUNC__CheckGadgets


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!

	PUT_STACK A2
					; a1 = FirstGadget (NULL is save)
	lea MSG_AddGadget(PC),A2
	bsr FUNC__CheckGadgets
	GET_STACK A2

	PUT_STACK A5
	move.l BSS_Label+IN_AddGadget,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_AddGList

;	CHECK
;		A1 = Gadget		=> FUNC__CheckGadgets


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!

	PUT_STACK A2
					; a1 = FirstGadget (NULL is save)
	lea MSG_AddGList(PC),A2
	bsr FUNC__CheckGadgets
	GET_STACK A2

	PUT_STACK A5
	move.l BSS_Label+IN_AddGList,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_BuildEasyRequestArgs

;	CHECK
;		A1 = EasyStruct 	Field:	es_Flags


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-----------------------------------------------------------
;	 bra.s FUNC_BuildEasyRequestArgs_PutMsg     ; Function-Test
;	-----------------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_BuildEasyRequestArgs_Call

	tst.l es_Flags(A1)
	beq.s FUNC_BuildEasyRequestArgs_Call

FUNC_BuildEasyRequestArgs_PutMsg
	PUT_STACK A2
	lea MSG_BuildEasyRequestArgs(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_BuildEasyRequestArgs_Call
	PUT_STACK A5
	move.l BSS_Label+IN_BuildEasyRequestArgs,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_EasyRequestArgs

;	CHECK
;		A1 = EasyStruct 	Field:	es_Flags


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------------
;	 bra.s FUNC_EasyRequestArgs_PutMsg     ; Function-Test
;	------------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_EasyRequestArgs_Call

	tst.l es_Flags(A1)
	beq.s FUNC_EasyRequestArgs_Call

FUNC_EasyRequestArgs_PutMsg
	PUT_STACK A2
	lea MSG_EasyRequestArgs(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_EasyRequestArgs_Call
	PUT_STACK A5
	move.l BSS_Label+IN_EasyRequestArgs,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_MakeClass

;	CHECK
;		D1 = Flags		For future enhancement


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------
;	 bra.s FUNC_MakeClass_PutMsg	 ; Function-Test
;	------------------------------------------------

	tst.l D1
	beq.s FUNC_MakeClass_Call

FUNC_MakeClass_PutMsg
	PUT_STACK A2
	lea MSG_MakeClass(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_MakeClass_Call
	PUT_STACK A5
	move.l BSS_Label+IN_MakeClass,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_OpenScreen

;	CHECK
;		A0 = NewScreen		Field:	ns_Gadgets


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	-------------------------------------------------
;	 bra.s FUNC_OpenScreen_PutMsg	  ; Function-Test
;	-------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_OpenScreen_Call

	tst.l ns_Gadgets(A0)
	beq.s FUNC_OpenScreen_Call

FUNC_OpenScreen_PutMsg
	PUT_STACK A2
	lea MSG_OpenScreen(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_OpenScreen_Call
	PUT_STACK A5
	move.l BSS_Label+IN_OpenScreen,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_OpenScreenTagList

;	CHECK
;		A0 = NewScreen		Field:	ns_Gadgets


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------------
;	 bra.s FUNC_OpenScreenTagList_PutMsg	 ; Function-Test
;	--------------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_OpenScreenTagList_Call

	tst.l ns_Gadgets(A0)
	beq.s FUNC_OpenScreenTagList_Call

FUNC_OpenScreenTagList_PutMsg
	PUT_STACK A2
	lea MSG_OpenScreenTagList(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_OpenScreenTagList_Call
	PUT_STACK A5
	move.l BSS_Label+IN_OpenScreenTagList,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_OpenWindow

;	CHECK
;		A0 = NewWindow		Field:	nw_FirstGadget
;					=> FUNC__CheckGadgets

;	NOTES
;		a1 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!

	cmp.l #0,A0
	beq.s FUNC_OpenWindow_Call

	PUT_STACK A2
	move.l nw_FirstGadget(A0),a1    ; FirstGadget (NULL is save)
	lea MSG_OpenWindow(PC),A2
	bsr FUNC__CheckGadgets
	GET_STACK A2

FUNC_OpenWindow_Call
	PUT_STACK A5
	move.l BSS_Label+IN_OpenWindow,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_OpenWindowTagList

;	CHECK
;		A0 = NewWindow		Field:	nw_FirstGadget
;					=> FUNC__CheckGadgets
;
;		A1 = TagItems		Tag:	WA_Gadgets
;					=> FUNC__CheckGadgets


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!

	PUT_STACK A5

	cmp.l #0,A0
	beq.s FUNC_OpenWindowTagList_TagList

	PUT_STACK A1/A2
	move.l nw_FirstGadget(A0),a1    ; FirstGadget (NULL is save)
	lea MSG_OpenWindowTagList(PC),A2
	bsr FUNC__CheckGadgets
	GET_STACK A1/A2

FUNC_OpenWindowTagList_TagList
	cmp.l #0,A1
	beq.s FUNC_OpenWindowTagList_Call

	move.l A1,A5

FUNC_OpenWindowTagList_Loop
	tst.l ti_Tag(A5)                ; TAG_DONE = 0
	beq.s FUNC_OpenWindowTagList_Call

	cmp.l #WA_Gadgets,ti_Tag(A5)
	beq.s FUNC_OpenWindowTagList_Check

	addq.l #ti_SIZEOF,A5
	bra.s FUNC_OpenWindowTagList_Loop

FUNC_OpenWindowTagList_Check
	PUT_STACK A1/A2
	move.l ti_Data(A5),a1           ; FirstGadget (NULL is save)
	lea MSG_OpenWindowTagList(PC),A2
	bsr FUNC__CheckGadgets
	GET_STACK A1/A2

FUNC_OpenWindowTagList_Call
	move.l BSS_Label+IN_OpenWindowTagList,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_Request

;	CHECK
;		A0 = Requester		Field:	rq_OlderRequest


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	----------------------------------------------
;	 bra.s FUNC_Request_PutMsg     ; Function-Test
;	----------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_Request_Call

	tst.l rq_OlderRequest(A0)
	beq.s FUNC_Request_Call

FUNC_Request_PutMsg
	PUT_STACK A2
	lea MSG_Request(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_Request_Call
	PUT_STACK A5
	move.l BSS_Label+IN_Request,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_ScreenDepth			; (V39)

;	CHECK
;		A1 = reserved		NULL-APTR


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------
;	 bra.s FUNC_ScreenDepth_PutMsg	   ; Function-Test
;	--------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_ScreenDepth_Call

FUNC_ScreenDepth_PutMsg
	PUT_STACK A2
	lea MSG_ScreenDepth(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_ScreenDepth_Call
	PUT_STACK A5
	move.l BSS_Label+IN_ScreenDepth,A5
	bra FUNC__CallFunction


	; +------------------+
	; | "layers.library" |
	; +------------------+

FUNC_BehindLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------
;	 bra.s FUNC_BehindLayer_PutMsg	   ; Function-Test
;	--------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_BehindLayer_Call

FUNC_BehindLayer_PutMsg
	PUT_STACK A2
	lea MSG_BehindLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_BehindLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_BehindLayer,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_DeleteLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------
;	 bra.s FUNC_DeleteLayer_PutMsg	   ; Function-Test
;	--------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_DeleteLayer_Call

FUNC_DeleteLayer_PutMsg
	PUT_STACK A2
	lea MSG_DeleteLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_DeleteLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_DeleteLayer,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_LockLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------
;	 bra.s FUNC_LockLayer_PutMsg	 ; Function-Test
;	------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_LockLayer_Call

FUNC_LockLayer_PutMsg
	PUT_STACK A2
	lea MSG_LockLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_LockLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_LockLayer,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_MoveLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------
;	 bra.s FUNC_MoveLayer_PutMsg	 ; Function-Test
;	------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_MoveLayer_Call

FUNC_MoveLayer_PutMsg
	PUT_STACK A2
	lea MSG_MoveLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_MoveLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_MoveLayer,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_ScrollLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------
;	 bra.s FUNC_ScrollLayer_PutMsg	   ; Function-Test
;	--------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_ScrollLayer_Call

FUNC_ScrollLayer_PutMsg
	PUT_STACK A2
	lea MSG_ScrollLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_ScrollLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_ScrollLayer,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_SizeLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------
;	 bra.s FUNC_SizeLayer_PutMsg	 ; Function-Test
;	------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_SizeLayer_Call

FUNC_SizeLayer_PutMsg
	PUT_STACK A2
	lea MSG_SizeLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_SizeLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_SizeLayer,A5
	bra FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_UpfrontLayer

;	CHECK
;		A0 = Dummy		Unused


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	---------------------------------------------------
;	 bra.s FUNC_UpfrontLayer_PutMsg     ; Function-Test
;	---------------------------------------------------

	cmp.l #0,A0
	beq.s FUNC_UpfrontLayer_Call

FUNC_UpfrontLayer_PutMsg
	PUT_STACK A2
	lea MSG_UpfrontLayer(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_UpfrontLayer_Call
	PUT_STACK A5
	move.l BSS_Label+LY_UpfrontLayer,A5
	bra FUNC__CallFunction


	; +------------------+
	; | "locale.library" |
	; +------------------+

FUNC_OpenCatalogA

;	CHECK
;		A2 = TagList		Tag:	OC_BuiltInCodeSet



	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
	PUT_STACK A5

;	---------------------------------------------------
;	 bra.s FUNC_OpenCatalogA_PutMsg     ; Function-Test
;	---------------------------------------------------

	cmp.l #0,A2
	beq.s FUNC_OpenCatalogA_Call

	move.l A2,A5

FUNC_OpenCatalogA_Loop
	tst.l ti_Tag(A5)                ; TAG_DONE = 0
	beq.s FUNC_OpenCatalogA_Call

	cmp.l #OC_BuiltInCodeSet,ti_Tag(A5)
	beq.s FUNC_OpenCatalogA_Check

	addq.l #ti_SIZEOF,A5
	bra.s FUNC_OpenCatalogA_Loop

FUNC_OpenCatalogA_Check
	tst.l ti_Data(A5)
	beq.s FUNC_OpenCatalogA_Call

FUNC_OpenCatalogA_PutMsg
	PUT_STACK A2
	lea MSG_OpenCatalogA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_OpenCatalogA_Call
	move.l BSS_Label+LO_OpenCatalogA,A5
	bra FUNC__CallFunction


	; +-------------------+
	; | "utility.library" |
	; +-------------------+

FUNC_AllocNamedObjectA			; (V39)

;	CHECK
;		A1 = TagList		Tag:	ANO_Flags

;	NOTES
;		d1 is scratch-register


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
	PUT_STACK A5

;	--------------------------------------------------------
;	 bra.s FUNC_AllocNamedObjectA_PutMsg	 ; Function-Test
;	--------------------------------------------------------

	cmp.l #0,A1
	beq.s FUNC_AllocNamedObjectA_Call

	move.l A1,A5

FUNC_AllocNamedObjectA_Loop
	tst.l ti_Tag(A5)                ; TAG_DONE = 0
	beq.s FUNC_AllocNamedObjectA_Call

	cmp.l #ANO_Flags,ti_Tag(A5)
	beq.s FUNC_AllocNamedObjectA_Check

	addq.l #ti_SIZEOF,A5
	bra.s FUNC_AllocNamedObjectA_Loop

FUNC_AllocNamedObjectA_Check
	move.l ti_Data(A5),d1           ; NSF_NODUPS / NSF_CASE
	and.l #%11111111111111111111111111111100,d1
	beq.s FUNC_AllocNamedObjectA_Call

FUNC_AllocNamedObjectA_PutMsg
	PUT_STACK A2
	lea MSG_AllocNamedObjectA(PC),A2
	bsr FUNC__PutMessage
	GET_STACK A2

FUNC_AllocNamedObjectA_Call
	move.l BSS_Label+UT_AllocNamedObjectA,A5
	bra.s FUNC__CallFunction


	; +---------------------+
	; | "workbench.library" |
	; +---------------------+

FUNC_AddAppIconA

;	CHECK
;		A2 = Lock		Currently unused
;		A4 = TagList		No Tags defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	--------------------------------------------------
;	 bra.s FUNC_AddAppIconA_PutMsg	   ; Function-Test
;	--------------------------------------------------

	cmp.l #0,A2
	bne.s FUNC_AddAppIconA_PutMsg

	cmp.l #0,A4
	beq.s FUNC_AddAppIconA_Call

	tst.l ti_Tag(A4)                ; TAG_END = 0
	beq.s FUNC_AddAppIconA_Call

FUNC_AddAppIconA_PutMsg
	PUT_STACK A2
	lea MSG_AddAppIconA(PC),A2
	bsr.s FUNC__PutMessage
	GET_STACK A2

FUNC_AddAppIconA_Call
	PUT_STACK A5
	move.l BSS_Label+WB_AddAppIconA,A5
	bra.s FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_AddAppMenuItemA

;	CHECK
;		A2 = TagList		No Tags defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	------------------------------------------------------
;	 bra.s FUNC_AddAppMenuItemA_PutMsg     ; Function-Test
;	------------------------------------------------------

	cmp.l #0,A2
	beq.s FUNC_AddAppMenuItemA_Call

	tst.l ti_Tag(A2)                ; TAG_END = 0
	beq.s FUNC_AddAppMenuItemA_Call

FUNC_AddAppMenuItemA_PutMsg
	PUT_STACK A2
	lea MSG_AddAppMenuItemA(PC),A2
	bsr.s FUNC__PutMessage
	GET_STACK A2

FUNC_AddAppMenuItemA_Call
	PUT_STACK A5
	move.l BSS_Label+WB_AddAppMenuItemA,A5
	bra.s FUNC__CallFunction

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC_AddAppWindowA

;	CHECK
;		A2 = TagList		No Tags defined


	addq.l #1,BSS_Label+execution_count	; => exit_clean !!!
;	----------------------------------------------------
;	 bra.s FUNC_AddAppWindowA_PutMsg     ; Function-Test
;	----------------------------------------------------

	cmp.l #0,A2
	beq.s FUNC_AddAppWindowA_Call

	tst.l ti_Tag(A2)                ; TAG_END = 0
	beq.s FUNC_AddAppWindowA_Call

FUNC_AddAppWindowA_PutMsg
	PUT_STACK A2
	lea MSG_AddAppWindowA(PC),A2
	bsr.s FUNC__PutMessage
	GET_STACK A2

FUNC_AddAppWindowA_Call
	PUT_STACK A5
	move.l BSS_Label+WB_AddAppWindowA,A5
;	 bra.s FUNC__CallFunction


; ------------------------------------------------------------------------


FUNC__CallFunction

;	INPUTS
;		A5 = Function-Vector	(APTR)

	jsr (A5)
	GET_STACK A5
	subq.l #1,BSS_Label+execution_count	; => exit_clean !!!
	rts

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC__PutMessage
	; +--------------------------------------------------+
	; |						     |
	; | This Function sends a Message to the FCS-Process |
	; |						     |
	; | It contains:				     |
	; |	- ErrorString		(APTR)               |
	; |	- BuggyTaskName 	(STRING)             |
	; |						     |
	; +--------------------------------------------------+

;	INPUTS
;		A2 = ErrorString	(APTR)

;	NOTES
;		This call is guaranteed to preserve all registers.
;		(Except A2)


	PUT_STACK D0-D1/A0-A1/A6

	; Commodity active ?
	; ------------------
	tst.b BSS_Label+commodity_active ; TRUE ?
	beq FUNC__PutMessage_END	 ; NO

	; Alloc Message-Memory
	; --------------------
	MOVE_Q Message_SIZEOF,D0	; Bytes
	move.l #MEMF_ANY!MEMF_PUBLIC!MEMF_CLEAR,D1 ; Attributes
	move.l 4,A6
	CALLSAME AllocMem
	tst.l D0
	beq.s FUNC__PutMessage_END	; not enough Memory...

	move.l D0,A1
	move.w #Message_SIZEOF,MN_LENGTH(A1)
	move.l A2,MyErrorString(A1)     ; <= INPUTS
	move.l A1,A2			; Message			5)

	CLRA A1 			; own Task
	CALLSAME FindTask
	move.l D0,A0

	lea BuggyTaskName(A2),A1        ;                               5)

	cmp.b #NT_PROCESS,LN_TYPE(A0)   ; DOS-Process ?
	bne.s FUNC__PutMessage_Task	; NO

	tst.l pr_CLI(A0)                ; CLI-Process ?
	beq.s FUNC__PutMessage_Task	; NO


	; Process-Name
	; ------------
	move.l pr_CLI(A0),D0            ; BPTR
	lsl.l #2,D0			; * 4 => APTR
	move.l D0,A0
	move.l cli_CommandName(A0),D0   ; BSTR
	lsl.l #2,D0			; * 4 => APTR

	move.l D0,A0			; CLI-Command-Name
	MOVE_Q 0,D0
	move.b (A0)+,D0                 ; number of chars in BCPL-string
	subq.b #1,D0			; -1 (dbra)
	cmp.b #29,D0			; more than 30 chars ?
	bls.s FUNC__PutMessage_CopyProcessName ; NO

	MOVE_Q 29,D0			; 30 chars is max.

FUNC__PutMessage_CopyProcessName
	move.b (A0)+,(A1)+              ; Name => Message.BuggyTaskName
	dbra D0,FUNC__PutMessage_CopyProcessName
	bra.s FUNC__PutMessage_PutMsg


	; Task-Name
	; ---------
FUNC__PutMessage_Task
	move.l LN_NAME(A0),A0           ; Task-Name
	cmp.l #0,A0			; NULL-APTR ?
	beq.s FUNC__PutMessage_PutMsg	; YES (=> empty string)

	MOVE_Q 29,D0			; 30 chars is max.

FUNC__PutMessage_CopyTaskName		; StringCopy
	move.b (A0)+,(A1)+              ; Name => Message.BuggyTaskName
	dbeq D0,FUNC__PutMessage_CopyTaskName


	; 'Send' Message to FCS-Process
	; -----------------------------
FUNC__PutMessage_PutMsg
	move.l BSS_Label+msgport,A0
	move.l A2,A1			; Message			5)
	CALLSAME PutMsg

FUNC__PutMessage_END
	GET_STACK D0-D1/A0-A1/A6
	rts

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FUNC__CheckGadgets

;	INPUTS
;		A1 = FirstGadget	(APTR)
;		A2 = ErrorString	(APTR)

;	NOTES
;		This call is guaranteed to preserve all registers.


;	CHECK
;		A1 = Gadget	gg_SpecialInfo.bi_Reserved
;				gg_SpecialInfo.si_Extension.sex_Reserved

	PUT_STACK D0/A0-A2

;	----------------------------------------------------
;	 bra.s FUNC__CheckGadgets_PutMsg     ; Function-Test
;	----------------------------------------------------

FUNC__CheckGadgets_Loop
	cmp.l #0,a1
	beq.s FUNC__CheckGadgets_End

	tst.l gg_SpecialInfo(a1)
	beq.s FUNC__CheckGadgets_NextGadget

	cmp.w #GTYP_BOOLGADGET,gg_GadgetType(a1)
	bne.s FUNC__CheckGadgets_StringGadget

	; Boolean Gadget
	; --------------
	move.w gg_Activation(a1),d0
	and.w #GACT_BOOLEXTEND,d0
	beq.s FUNC__CheckGadgets_NextGadget

	move.l gg_SpecialInfo(a1),a0            ; => BoolInfo
	tst.l bi_Reserved(a0)
	beq.s FUNC__CheckGadgets_NextGadget
	bra.s FUNC__CheckGadgets_PutMsg

FUNC__CheckGadgets_StringGadget
	cmp.w #GTYP_STRGADGET,gg_GadgetType(a1)
	bne.s FUNC__CheckGadgets_NextGadget

	; String Gadget
	; -------------
	move.l gg_SpecialInfo(a1),a0            ; => StringInfo
	tst.l si_Extension(a0)
	beq.s FUNC__CheckGadgets_NextGadget

	move.w gg_Activation(a1),d0
	and.w #GACT_STRINGEXTEND,d0
	bne.s FUNC__CheckGadgets_StringGadget_Check	; YES

	move.w gg_Flags(a1),d0
	and.w #GFLG_STRINGEXTEND,d0
	beq.s FUNC__CheckGadgets_NextGadget		; NO

FUNC__CheckGadgets_StringGadget_Check
	move.l si_Extension(a0),a0

	tst.l sex_Reserved(a0)
	bne.s FUNC__CheckGadgets_PutMsg

	tst.l sex_Reserved+4(a0)
	bne.s FUNC__CheckGadgets_PutMsg

	tst.l sex_Reserved+8(a0)
	bne.s FUNC__CheckGadgets_PutMsg

	tst.l sex_Reserved+12(a0)
	bne.s FUNC__CheckGadgets_PutMsg

FUNC__CheckGadgets_NextGadget
	move.l gg_NextGadget(a1),a1
	bra.s FUNC__CheckGadgets_Loop

FUNC__CheckGadgets_PutMsg
	bsr FUNC__PutMessage			; a2 = ErrorString

FUNC__CheckGadgets_End
	GET_STACK D0/A0-A2
	rts



; ------------------------------------------------------------------------
; ------------------------------------------------------------------------



;	##############
;	#	     #
;	#   MEMORY   #
;	#	     #
;	##############


;	+---------------------+
;	| ***  CODE-HUNK  *** |
;	+---------------------+


		; Library-Names
		; -------------

intname 	INTNAME

gadtoolsname	GADTOOLSNAME

dosname 	DOSNAME

workbench_name	WORKBENCH_NAME

utility_name	UTILITYNAME

layersname	LAYERSNAME

iconname	dc.b 'icon.library',0
		even

comname 	dc.b 'commodities.library',0
		even

localename	LOCALENAME

datatypesname	DATATYPESNAME

amigaguidename	AMIGAGUIDENAME


		; Alert/Error-Messages
		; --------------------

Kick2_0_alert	dc.w 30 	; X-Koord.
		dc.b 17 	; Y-Koord.
		dc.b 'FCS requires Amiga Release 2.04 - Kickstart 37.x',0
		dc.b 0		; no other text
		even


con_alert	dc.w 30 	; X-Koord.
		dc.b 17 	; Y-Koord.
		dc.b 'FCS can''t open CONSOLE-Window',0
		dc.b 0		; no other text
		even

msgport_alert	dc.w 30 	; X-Koord.
		dc.b 17 	; Y-Koord.
		dc.b 'FCS can''t create Message-Port',0
		dc.b 0		; no other text
		even

broker_alert	dc.w 30 	; X-Koord.
		dc.b 17 	; Y-Koord.
		dc.b 'FCS can''t create Commodity-Broker',0
		dc.b 0		; no other text
		even

version_error	dc.b 'This version of FCS is obsolete! Get a new one...',0
		even

commodities_error
		dc.b 'FCS requires "commodities.library" V37 or higher',0
		even

exit_error	dc.b 'Sorry! FCS can''t exit because another',$A
		dc.b 'Debugger/Patch requires FCS.',$A,$A

		dc.b 'Please, finish all Patches you''ve',$A
		dc.b 'started after FCS, then try again!',0
		even


		; Compatibility - Messages
		; ------------------------

		; *** amigaguide.library ***

MSG_AddAmigaGuideHostA
		dc.b 'AddAmigaGuideHostA() - Attrs (A1) must be NULL',0
		even

MSG_OpenAmigaGuideA
		dc.b 'OpenAmigaGuideA() - NewAmigaGuide (A0)',$A
		dc.b '                    nag_Client must be NULL',0
		even

MSG_OpenAmigaGuideAsyncA
		dc.b 'OpenAmigaGuideAsyncA() - NewAmigaGuide (A0)',$A
		dc.b '                         nag_Client must be NULL',0
		even

MSG_RemoveAmigaGuideHostA
		dc.b 'RemoveAmigaGuideHostA() -'
		dc.b ' Attrs (A1) must be NULL',0
		even

MSG_SendAmigaGuideContextA
		dc.b 'SendAmigaGuideContextA() -'
		dc.b ' Attrs (D0) must be NULL',0
		even

MSG_SetAmigaGuideContextA
		dc.b 'SetAmigaGuideContextA() -'
		dc.b ' Attrs (D1) must be NULL',0
		even


		; *** commodities.library ***

MSG_CxBroker	dc.b 'CxBroker() - NewBroker (A0)',$A
		dc.b '             nb_ReservedChannel must be NULL',0
		even


		; *** datatypes.library ***

MSG_AddDTObject dc.b 'AddDTObject() - Requester (A1) must be NULL',0
		even

MSG_ObtainDataTypeA
		dc.b 'ObtainDataTypeA() - Attrs (A1) must be NULL',0
		even

MSG_RefreshDTObjectA
		dc.b 'RefreshDTObjectA() - Requester (A2) must be NULL',$A
		dc.b '                     Attrs (A3) must be NULL',0
		even


		; *** dos.library ***

MSG_EndNotify	dc.b 'EndNotify() - NotifyRequest (D1)',$A
		dc.b '              nr_Reserved must be NULL',0
		even

MSG_NewLoadSeg	dc.b 'NewLoadSeg() - Tags (D2) must be NULL',0
		even

MSG_StartNotify dc.b 'StartNotify() - NotifyRequest (D1)',$A
		dc.b '                nr_Reserved must be NULL',0
		even


		; *** gadtools.library ***

MSG_GetVisualInfoA
		dc.b 'GetVisualInfoA() - TagList (A1) must be NULL',0
		even

MSG_GT_RefreshWindow
		dc.b 'GT_RefreshWindow() - Requester (A1) must be NULL',0
		even

MSG_GT_SetGadgetAttrsA
		dc.b 'GT_SetGadgetAttrsA() -'
		dc.b ' Requester (A2) must be NULL',0
		even

MSG_GT_GetGadgetAttrsA
		dc.b 'GT_GetGadgetAttrsA() -'
		dc.b ' Requester (A2) must be NULL',0
		even


		; *** icon.library ***

MSG_PutDefDiskObject
		dc.b 'PutDefDiskObject() - DiskObject (A0)',$A
		dc.b '                     do_ToolWindow must be NULL',0
		even

MSG_PutDiskObject
		dc.b 'PutDiskObject() - DiskObject (A1)',$A
		dc.b '                  do_ToolWindow must be NULL',0
		even


		; *** intuition.library ***

MSG_AddGadget	dc.b 'AddGadget() - Gadget (A1)',$A
		dc.b '              bi_Reserved must be NULL',$A
		dc.b '              sex_Reserved must be NULL',0
		even

MSG_AddGList	dc.b 'AddGList() - Gadget (A1)',$A
		dc.b '             bi_Reserved must be NULL',$A
		dc.b '             sex_Reserved must be NULL',0
		even

MSG_BuildEasyRequestArgs
		dc.b 'BuildEasyRequestArgs() - EasyStruct (A1)',$A
		dc.b '                         es_Flags must be NULL',0
		even

MSG_EasyRequestArgs
		dc.b 'EasyRequestArgs() - EasyStruct (A1)',$A
		dc.b '                    es_Flags must be NULL',0
		even

MSG_MakeClass	dc.b 'MakeClass() - Flags (D1) must be NULL',0
		even

MSG_OpenScreen	dc.b 'OpenScreen() - NewScreen (A0)',$A
		dc.b '               ns_Gadgets must be NULL',0
		even

MSG_OpenScreenTagList
		dc.b 'OpenScreenTagList() - NewScreen (A0)',$A
		dc.b '                      ns_Gadgets must be NULL',0
		even

MSG_OpenWindow	dc.b 'OpenWindow() - NewWindow (A0)',$A
		dc.b '               nw_FirstGadget =>',$A
		dc.b '               bi_Reserved must be NULL',$A
		dc.b '               sex_Reserved must be NULL',0
		even

MSG_OpenWindowTagList
		dc.b 'OpenWindowTagList() - NewWindow (A0)',$A
		dc.b '                      nw_FirstGadget =>',$A
		dc.b '                    - TagItems (A1)',$A
		dc.b '                      WA_Gadgets =>',$A,$A

		dc.b '                      bi_Reserved must be NULL',$A
		dc.b '                      sex_Reserved must be NULL',0
		even

MSG_Request	dc.b 'Request() - Requester (A0)',$A
		dc.b '            rq_OlderRequest must be NULL',0
		even

MSG_ScreenDepth dc.b 'ScreenDepth() - reserved (A1) must be NULL',0
		even


		; *** layers.library ***

MSG_BehindLayer dc.b 'BehindLayer() - Dummy (A0) must be NULL',0
		even

MSG_DeleteLayer dc.b 'DeleteLayer() - Dummy (A0) must be NULL',0
		even

MSG_LockLayer	dc.b 'LockLayer() - Dummy (A0) must be NULL',0
		even

MSG_MoveLayer	dc.b 'MoveLayer() - Dummy (A0) must be NULL',0
		even

MSG_ScrollLayer dc.b 'ScrollLayer() - Dummy (A0) must be NULL',0
		even

MSG_SizeLayer	dc.b 'SizeLayer() - Dummy (A0) must be NULL',0
		even

MSG_UpfrontLayer
		dc.b 'UpfrontLayer() - Dummy (A0) must be NULL',0
		even


		; *** locale.library ***

MSG_OpenCatalogA
		dc.b 'OpenCatalogA() - TagList (A2)',$A
		dc.b '                 OC_BuiltInCodeSet must be NULL',0
		even


		; *** utility.library ***

MSG_AllocNamedObjectA
		dc.b 'AllocNamedObjectA() - TagList (A1)',$A
		dc.b '                      ANO_Flags =>'
		dc.b ' Only 2 Flags are defined',$A
		dc.b '                      (NSF_NODUPS / NSF_CASE)',0
		even


		; *** workbench.library ***

MSG_AddAppIconA dc.b 'AddAppIconA() - Lock (A2) must be NULL',$A
		dc.b '                TagList (A4) must be NULL',0
		even

MSG_AddAppMenuItemA
		dc.b 'AddAppMenuItemA() - TagList (A2) must be NULL',0
		even

MSG_AddAppWindowA
		dc.b 'AddAppWindowA() - TagList (A2) must be NULL',0
		even


		; Misc
		; ----

req_title
broker_name	dc.b 'FC Supervisor',0          ; UNIQUE !!!
		even

broker_title	dc.b 'Future Compatibility Supervisor 40.1',0
		even

broker_descr	dc.b 'written by Marcel Hofstetter',0
		even

con_name	dc.b 'CON:/1//150/Future Compatibility Supervisor 40.1'
		dc.b '  by Marcel Hofstetter/CLOSE/WAIT/AUTO',0
		even

printf_fmt	dc.b 'Name: "%s"',$A
		dc.b '%s',$A,$A,0
		even

req_OK		dc.b 'OK',0
		even


;	+---------------------+
;	| ***  DATA-HUNK  *** |
;	+---------------------+


 SECTION "DATA",data

DATA_Label

		; Return-Code
		; -----------
		dc.l RETURN_FAIL


		; *** EasyRequester (es_) ***

		dc.l es_SIZEOF		; Size
		dc.l 0			; Flags
		dc.l req_title		; RequesterWindow-Title
		dc.l 0			; <= Requester-Text
		dc.l req_OK		; RequesterGadget-Text


		; *** NewBroker (nb_) ***

		dc.b 5			; Version (NB_VERSION - V37)
		dc.b 0			; Reserved 1
		dc.l broker_name	; Name
		dc.l broker_title	; Title
		dc.l broker_descr	; Description
		dc.w NBU_UNIQUE!NBU_NOTIFY ; Unique
		dc.w 0			; Flags
		dc.b -100		; Priority (very low)
		dc.b 0			; Reserved 2
		dc.l 0			; Port <= CreateMsgPort()
		dc.w 0			; ReservedChannel


DATA_LabelEND


 IFNE (DATA_LabelEND-DATA_Label)-DATAstruct_SIZEOF

  ERROR :  +++	 DATAStruct-Problem   +++

 ENDC



;	+--------------------+
;	| ***  BSS-HUNK  *** |
;	+--------------------+


 SECTION "BSS",bss

BSS_Label	ds.b BSSstruct_SIZEOF


 END

