/*

    Examine stats for all AutoConfig(tm) boards in the system

    Bryce Nesbitt Sunday 01-Jan-89 18:29:57

 */
#include "exec/types.h"
#include "libraries/configvars.h"
#include "proto/expansion.h"

struct Library *OpenLibrary();
struct ConfigDev *FindConfigDev();

struct Library *ExpansionBase;

void main()
{
struct ConfigDev *myCD=0;
static int sizearray[8]={128,1,2,4,8,16,32,64};

    ExpansionBase=OpenLibrary("expansion.library",0L);
    while(myCD=FindConfigDev(myCD,-1L,-1L)) /* find all ConfigDev's */
	{
	printf("\n---ConfigDev structure found at location $%lx---\n",myCD);
	printf("Node                    =");
	printf("$%lx",myCD->cd_Node.ln_Succ);
	printf(",$%lx",myCD->cd_Node.ln_Pred);
	printf(",$%x",myCD->cd_Node.ln_Type);
	printf(",$%x",myCD->cd_Node.ln_Pri);
	printf(",$%lx\n",myCD->cd_Node.ln_Name);
	printf("cd_Flags                =$%X\n",myCD->cd_Flags);
	    printf("1  : ConfigMe!          =%d\n",((myCD->cd_Flags) >> 1 )&1);
	    printf("0  : Have been shutup?  =%d\n",myCD->cd_Flags&1);
	printf("cd_Pad                  =$%X\n",myCD->cd_Pad);
	printf("cd_BoardAddr            =$%lX\n",myCD->cd_BoardAddr);
	printf("cd_BoardSize            =$%lX (%ldK)\n",myCD->cd_BoardSize,((ULONG)myCD->cd_BoardSize)/1024);
	printf("cd_SlotAddr (private)   =%d\n",myCD->cd_SlotAddr);
	printf("cd_SlotSize (private)   =%d\n",myCD->cd_SlotSize);
	printf("cd_Driver               =$%lX\n",myCD->cd_Driver);
	printf("cd_NextCD               =$%lX\n",myCD->cd_NextCD);
	printf("cd_Unused               =");
	    printf("$%lX",myCD->cd_Unused[0]);
	    printf(",$%lX",myCD->cd_Unused[1]);
	    printf(",$%lX",myCD->cd_Unused[2]);
	    printf(",$%lX\n",myCD->cd_Unused[3]);
	printf("er_Type                 =");
	    printf("%d,",myCD->cd_Rom.er_Type);
	    printf("$%x\n",myCD->cd_Rom.er_Type);
	    printf("7-6: Board Style        =%d\n",(myCD->cd_Rom.er_Type >> 6 )&3);
	    printf("5  : Link to memlist?   =%d\n",(myCD->cd_Rom.er_Type >> 5 )&1);
	    printf("4  : InitDiag valid?    =%d\n",(myCD->cd_Rom.er_Type >> 4 )&1);
	    printf("3  : Chained config?    =%d\n",(myCD->cd_Rom.er_Type >> 4 )&1);
	    printf("2-0: Space needed...    =%d",myCD->cd_Rom.er_Type & 7);
	    printf(" (%ldK)\n",sizearray[(myCD->cd_Rom.er_Type & 7)]*64L);
	printf("er_Product              =");
	    printf("%d,",myCD->cd_Rom.er_Product);
	    printf("$%x\n",myCD->cd_Rom.er_Product);
	printf("er_Flags                =");
	    printf("%d,",myCD->cd_Rom.er_Flags);
	    printf("$%x\n",myCD->cd_Rom.er_Flags);
	    printf("7  : 8 meg space        =%d\n",((myCD->cd_Rom.er_Flags) >> 7 )&1);
	    printf("6  : Shutupable?        =%d\n",((myCD->cd_Rom.er_Flags) >> 6 )&1);
	printf("er_Reserved03           =");
	    printf("%d,",myCD->cd_Rom.er_Reserved03);
	    printf("$%x\n",myCD->cd_Rom.er_Reserved03);
	printf("er_Manufacturer         =");
	    printf("%d,",myCD->cd_Rom.er_Manufacturer);
	    printf("$%x,",myCD->cd_Rom.er_Manufacturer);
	    printf("(~$%4x)\n",~myCD->cd_Rom.er_Manufacturer);
	printf("er_SerialNumber         =");
	    printf("%d,",myCD->cd_Rom.er_SerialNumber);
	    printf("$%x\n",myCD->cd_Rom.er_SerialNumber);
	printf("er_InitDiagVec          =");
	    printf("%d,",myCD->cd_Rom.er_InitDiagVec);
	    printf("$%x\n",myCD->cd_Rom.er_InitDiagVec);
	printf("er_Reserved[0c-0f]      ="); /* read 4 bytes at once */
	    printf("$%X",myCD->cd_Rom.er_Reserved0c);
	    printf(",$%X",myCD->cd_Rom.er_Reserved0d);
	    printf(",$%X",myCD->cd_Rom.er_Reserved0e);
	    printf(",$%X\n",myCD->cd_Rom.er_Reserved0f);
	}
    CloseLibrary(ExpansionBase);
}
