*************************************************************************
* samplelib_stubs.asm
*         
* Copyright 1988 Commodore-Amiga, Inc.
*
* Stubs that match this .fd file:
*
*	##base _SampleBase
*	##bias 30
*	##public
*	Double(n1)(D0)
*	AddThese(n1,n2)(D0,D1)
*	##end
*
* After assembling,
*   JOIN samplelib_stubs.o samplelib_lvos.o AS sample.lib
*
* LINK with LIBRARY sample.lib when calling sample.library functions
*
*************************************************************************
   INCLUDE  "exec/types.i"
   INCLUDE  "exec/libraries.i"

          SECTION CSTUB

            CODE

*------ Caller declares and initializes SampleBase in their C code

            XREF        _SampleBase

*------ Must externally reference the _LVO labels defined in samplelib_lvos

            XREF        _LVODouble
            XREF        _LVOAddThese

*------ Make C function stubs available to caller

            XDEF        _Double
            XDEF        _AddThese

*------- These stubs move C args from stack to appropriate registers,
*------- call the library function, and return result in d0

_Double:
            MOVE.L      A6,-(SP)           ;Save register(s)
            MOVE.L      8(SP),D0           ;Copy param to register
            MOVE.L      _SampleBase,A6     ;Library base to A6
            JSR         _LVODouble(A6)     ;Go to real routine
            MOVE.L      (SP)+,A6           ;Restore register(s)
            RTS

_AddThese:
            MOVE.L      A6,-(SP)           ;Save register(s)
            MOVEM.L     8(SP),D0/D1        ;Copy params to registers
					   ;8(SP)  goes into D0
					   ;12(SP) goes into D1
            MOVE.L      _SampleBase,A6     ;Library base to A6
            JSR         _LVOAddThese(A6)   ;Go to real routine
            MOVE.L      (SP)+,A6           ;Restore register(s)
            RTS

          END

