/*
 * SetPot.c   C. Scheppner  CBM  01/89
 * Sets right joyport PotX and PotY pins (pins 5 and 9) to 0 and 1
 */

#include <exec/types.h>
#include <libraries/dos.h>
#include <resources/potgo.h>


#define V1_POINT_2   33

/* potgo bits */
#define START_B      0   
#define START_F      (1L << START_B)
#define OUTRY_B      15
#define OUTRY_F      (1L << OUTRY_B)
#define DATRY_B      14
#define DATRY_F      (1L << DATRY_B)
#define OUTRX_B      13
#define OUTRX_F      (1L << OUTRX_B)
#define DATRX_B      12
#define DATRX_F      (1L << DATRX_B)

/* We want the right port PotX and PotY direction and data bits */
#define OURBITS    (OUTRY_F|DATRY_F|OUTRX_F|DATRX_F)

/* Mask and bit combinations for setting and clearing the X and Y pots 
 * For mask,  affect both the direction and data bits  
 * For data,  CLR = (direction out,data 0)    SET = (direction out,data 1)
 */
#define POTRX_MSK  (OUTRX_F|DATRX_F)
#define POTRX_CLR  (OUTRX_F)
#define POTRX_SET  (OUTRX_F|DATRX_F)

#define POTRY_MSK  (OUTRY_F|DATRY_F)
#define POTRY_CLR  (OUTRY_F)
#define POTRY_SET  (OUTRY_F|DATRY_F)

struct PotgoBase *PotgoBase = NULL;

UWORD  ourpotbits = NULL; 

main(argc,argv)
int argc;
char **argv;
   {
   ULONG delay = 500;

   if(argc > 1)
      {
      if(argv[1][0]=='?')
         cleanexit("USAGE: SetPot  (demos setting of right joyport potx/y)\n");
      }

   if(!(PotgoBase=
     (struct PotgoBase *)OpenResource(POTGONAME,V1_POINT_2)))
       cleanexit("Can't open potgo\n",RETURN_FAIL);

   ourpotbits = AllocPotBits(OURBITS);
   if(ourpotbits != OURBITS)   cleanexit("Can't alloc potbits\n,RETURN_FAIL");

   /* We got our bits... Loop until done */
   printf("SetPot sets the right port POTX and POTY pins (5,9) to 0 and 1\n");
   printf("Use CTRL/C to exit...\n");
   while(!(SetSignal(0,0) & SIGBREAKF_CTRL_C))
      {
      /* We are setting both pots, so we use both X and Y, masks and data */
      printf("\nSetting right Potx and Poty to 0...  ");
      WritePotgo(POTRX_CLR|POTRY_CLR, POTRX_MSK|POTRY_MSK);
      Delay(delay);

      printf("Setting right Potx and Poty to 1...  ");
      WritePotgo(POTRX_SET|POTRY_SET, POTRX_MSK|POTRY_MSK);
      Delay(delay);
      }

   printf("\n");
   cleanup();
   exit(0);
   }

cleanexit(s,n)
char *s;
int n;
   {
   if(*s)  printf(s);
   cleanup();
   exit(n);
   }

cleanup()
   {
   if(ourpotbits)   FreePotBits(ourpotbits);
   }

/* end */
